/*###############################################################################
# Linux Management Providers (LMP), EthernetPort provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "EthernetPort_Common.h"

int CF_getCapabilities(vector<unsigned short>& capabilities,vector<unsigned short>& enabledCapabilities,const string& deviceid,string& errorMessage)
{
	string cmd;
	vector<string> cmdoutput;

	capabilities.clear();
	enabledCapabilities.clear();

	// Lokking for Wake on LAN capability
	cmd ="ethtool ";
	cmd+=deviceid;
	cmd+=" | grep Wake | awk -F Wake-on: '{print $2;}'";
	CF_assert(CF_runCommandToLines(cmd,cmdoutput,0,errorMessage));

	if(cmdoutput.size()>0)
	{
		if(cmdoutput[0].find('d',0)==string::npos)
			capabilities.push_back(WAKE_ON_LAN);
		if(cmdoutput[1].find('d',0)==string::npos)
			enabledCapabilities.push_back(WAKE_ON_LAN);
	}

	// Can not determine the following capabilities:
	// - Alert on LAN
	// - Failover
	// - Load Balancing

	if(!capabilities.size())
		capabilities.push_back(UNKNOWN);
	if(!enabledCapabilities.size())
		enabledCapabilities.push_back(UNKNOWN);

	return OK;
}

int CF_getHWaddress(const string& ifName, string& hwaddr, string& errorMessage)
{
	string erroutput;
	string ifcfg_cmd("/sbin/ifconfig ");
	ifcfg_cmd += ifName;
	ifcfg_cmd += " | awk '/HWaddr/ {for(i=1;i<=NF;++i) {if ($i == \"HWaddr\") {print $(i+1); exit; } } }'";

	hwaddr.clear();

	CF_assert(CF_runCommand(ifcfg_cmd, hwaddr, erroutput, errorMessage));

	return OK;
}

int CF_getEthEnabledState(const string& ifName, unsigned int& enabledState ,string& errorMessage)
{
	string value;
	string stderr;
	CF_assert( CF_runCommand("/sbin/ifconfig " + ifName, value, stderr, errorMessage));

	if(value.find("UP")!=string::npos)
	{
		if(value.find("RUNNING")!=string::npos)
			enabledState=ES_ENABLE;
		else
			enabledState=ES_ENABLED_OFFLINE;
	}
	else
		enabledState=ES_DISABLE;

	return OK;
}
