/*###############################################################################
# Linux Management Providers (LMP), EthernetPort provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef ETHERNETPORT_COMMON_H_
#define ETHERNETPORT_COMMON_H_

#include <Common.h>

// Define constants for the Link Technology
#define LT_UNKNOWN		0
#define LT_OTHER		1
#define LT_ETHERNET 	2
#define LT_IB			3 // InfiniBand
#define LT_FC			4 // Fibre Channel
#define LT_FDDI			5 // Fiber Distributed Data Interface
#define LT_ATM			6 // Asynchronous Transfer Mode
#define LT_TOKEN_RING	7
#define LT_FRAME_RELAY	8
#define LT_INFRARED		9
#define LT_BLUETOOTH	10
#define LT_WIRELESS_LAN	11

// Define EnabledState Constants
#define ES_UNKNOWN			0
#define ES_ENABLE			2
#define ES_DISABLE			3
#define ES_NOT_APPLICABLE	5
#define ES_ENABLED_OFFLINE	6

// Define RequestedState Constants
#define RS_UNKNOWN			0
#define RS_NO_CHANGE		5
#define RS_NOT_APPLICABLE	12

// Define constants for LANEndpoint's LANType
#define LEPT_UNKNOWN	0
#define LEPT_OTHER		1
#define LEPT_ETHERNET	2
#define LEPT_TOKEN_RING	3
#define LEPT_FDDI		4

// Define constants for Protocol Interface Type
#define LEPIT_OTHER			1
#define LEPIT_ETHERNET		6
#define LEPIT_TOKEN_RING	9
#define LEPIT_FDDI			15

// Define constants for the Capabilities and EnabledCapabilities
#define UNKNOWN			0
#define OTHER			1
#define ALERT_ON_LAN	2
#define WAKE_ON_LAN		3
#define FAILOVER		4
#define LOAD_BALANCING	5

// Define constants for Port Type
#define PT_UNKNOWN		0
#define PT_OTHER		1
#define PT_10BASET		50
#define PT_10_100BASET	51
#define PT_100BASET		52
#define PT_1000BASET	53
#define PT_2500BASET	54
#define PT_10GBASET		55
#define PT_10GBASE_CX4	56
#define PT_100BASE_FX	100
#define PT_100BASE_SX	101
#define PT_1000BASE_SX	102
#define PT_1000BASE_LX	103
#define PT_1000BASE_CX	104
#define PT_10GBASE_SR	105
#define PT_10GBASE_SW	106
#define PT_10GBASE_LX4	107
#define PT_10GBASE_LR	108
#define PT_10GBASE_LW	109
#define PT_10GBASE_ER	110
#define PT_10GBASE_EW	111

static const string DEVICE_BASE_PATH = "/etc/sysconfig/network-scripts/";

int CF_getCapabilities(vector<unsigned short>& capabilities,vector<unsigned short>& enabledCapabilities,const string& deviceid,string& errorMessage);

int CF_getHWaddress(const string& ifName, string& hwaddr, string& errorMessage);

int CF_getEthEnabledState(const string& ifName, unsigned int& enabledState ,string& errorMessage);

#endif /*ETHERNETPORT_COMMON_H_*/
