/*###############################################################################
# Linux Management Providers (LMP), Power Management provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "cmpiOpenDRIM_PowerManagementCapabilities.h"

CMPIObjectPath* PowerManagement_OpenDRIM_PowerManagementCapabilities_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_PowerManagementCapabilities& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_PowerManagementCapabilities_classnames[0], OpenDRIM_PowerManagementCapabilities_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* PowerManagement_OpenDRIM_PowerManagementCapabilities_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_PowerManagementCapabilities& instance) {
	_E_;
	Objectpath op(broker, PowerManagement_OpenDRIM_PowerManagementCapabilities_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.PowerCapabilities_isNULL)
		ci.setProperty("PowerCapabilities", instance.PowerCapabilities);

	if (!instance.OtherPowerCapabilitiesDescriptions_isNULL)
		ci.setProperty("OtherPowerCapabilitiesDescriptions", instance.OtherPowerCapabilitiesDescriptions);

	if (!instance.PowerStatesSupported_isNULL)
		ci.setProperty("PowerStatesSupported", instance.PowerStatesSupported);

	if (!instance.PowerChangeCapabilities_isNULL)
		ci.setProperty("PowerChangeCapabilities", instance.PowerChangeCapabilities);

	if (!instance.OtherPowerChangeCapabilities_isNULL)
		ci.setProperty("OtherPowerChangeCapabilities", instance.OtherPowerChangeCapabilities);

	if (!instance.RequestedPowerStatesSupported_isNULL)
		ci.setProperty("RequestedPowerStatesSupported", instance.RequestedPowerStatesSupported);

	_L_;
	return ci.getHdl();
}

void PowerManagement_OpenDRIM_PowerManagementCapabilities_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_PowerManagementCapabilities& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void PowerManagement_OpenDRIM_PowerManagementCapabilities_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_PowerManagementCapabilities& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("PowerCapabilities", instance.PowerCapabilities) == OK)
		instance.PowerCapabilities_isNULL = false;

	if (inst.getProperty("OtherPowerCapabilitiesDescriptions", instance.OtherPowerCapabilitiesDescriptions) == OK)
		instance.OtherPowerCapabilitiesDescriptions_isNULL = false;

	if (inst.getProperty("PowerStatesSupported", instance.PowerStatesSupported) == OK)
		instance.PowerStatesSupported_isNULL = false;

	if (inst.getProperty("PowerChangeCapabilities", instance.PowerChangeCapabilities) == OK)
		instance.PowerChangeCapabilities_isNULL = false;

	if (inst.getProperty("OtherPowerChangeCapabilities", instance.OtherPowerChangeCapabilities) == OK)
		instance.OtherPowerChangeCapabilities_isNULL = false;

	if (inst.getProperty("RequestedPowerStatesSupported", instance.RequestedPowerStatesSupported) == OK)
		instance.RequestedPowerStatesSupported_isNULL = false;

	_L_;
}

