/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_RECORDLOGACCESS_H_
#define OPENDRIM_RECORDLOGACCESS_H_

#include "OpenDRIM_RecordLogPackage_Common.h"

#include "OpenDRIM_RecordLog.h"

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_load(const CMPIBroker* broker, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_unload(string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RecordLog>& instances, const char** properties, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RecordLog& instance, const char** properties, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLog& newInstance, const OpenDRIM_RecordLog& oldInstance, const char** properties, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLog& instance, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLog& instance, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLog& instance, unsigned int& returnValue, const OpenDRIM_RecordLog_RequestStateChange_In& in, OpenDRIM_RecordLog_RequestStateChange_Out& out, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_ClearLog(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLog& instance, unsigned int& returnValue, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLog_populate(OpenDRIM_RecordLog& instance, vector<string>& lines, string& errorMessage);

#endif /*OPENDRIM_RECORDLOGACCESS_H_*/
