/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_GROUP_H_
#define OPENDRIM_GROUP_H_

#include <Instance.h>

const static char* OpenDRIM_Group_classnames[] = {"OpenDRIM_Group"};
static string OpenDRIM_Group_NAMESPACE = _NAMESPACE;

class OpenDRIM_Group {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string CreationClassName;
	bool CreationClassName_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	string BusinessCategory;
	bool BusinessCategory_isNULL;
	
	string CommonName;
	bool CommonName_isNULL;
	
	string GroupID;
	bool GroupID_isNULL;
	
	vector<string> Members;
	
	OpenDRIM_Group() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		CreationClassName_isNULL = true;
		Name_isNULL = true;
		BusinessCategory_isNULL = true;
		CommonName_isNULL = true;
		GroupID_isNULL = true;
	}
	
	~OpenDRIM_Group() {}
	
	string getKeys() const {
		return CF_toLowCase(".CreationClassName=\"" + CF_quoteString(CreationClassName) + "\""".Name=\"" + CF_quoteString(Name) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getCreationClassName(string& value) const {
		if (CreationClassName_isNULL==true)
			return NOT_FOUND;
		value = CreationClassName;
		return OK;
	}
	
	int setCreationClassName(const string& newValue) {
		CreationClassName = newValue;
		CreationClassName_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getBusinessCategory(string& value) const {
		if (BusinessCategory_isNULL==true)
			return NOT_FOUND;
		value = BusinessCategory;
		return OK;
	}
	
	int setBusinessCategory(const string& newValue) {
		BusinessCategory = newValue;
		BusinessCategory_isNULL = false;
		return OK;
	}

	int getCommonName(string& value) const {
		if (CommonName_isNULL==true)
			return NOT_FOUND;
		value = CommonName;
		return OK;
	}
	
	int setCommonName(const string& newValue) {
		CommonName = newValue;
		CommonName_isNULL = false;
		return OK;
	}

	int getGroupID(string& value) const {
		if (GroupID_isNULL==true)
			return NOT_FOUND;
		value = GroupID;
		return OK;
	}
	
	int setGroupID(const string& newValue) {
		GroupID = newValue;
		GroupID_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_GROUP_H_*/
