/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#include "cmpiOpenDRIM_Group.h"

CMPIObjectPath* Simple_Identity_Management_OpenDRIM_Group_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_Group& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_Group_classnames[0], OpenDRIM_Group_NAMESPACE);

	if (!instance.CreationClassName_isNULL)
		op.addKey("CreationClassName", instance.CreationClassName);

	if (!instance.Name_isNULL)
		op.addKey("Name", instance.Name);

	_L_;
	return op.getHdl();
}

CMPIInstance* Simple_Identity_Management_OpenDRIM_Group_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_Group& instance) {
	_E_;
	Objectpath op(broker, Simple_Identity_Management_OpenDRIM_Group_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.BusinessCategory_isNULL)
		ci.setProperty("BusinessCategory", instance.BusinessCategory);

	if (!instance.CommonName_isNULL)
		ci.setProperty("CommonName", instance.CommonName);

	if (!instance.GroupID_isNULL)
		ci.setProperty("GroupID", instance.GroupID);

	_L_;
	return ci.getHdl();
}

void Simple_Identity_Management_OpenDRIM_Group_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_Group& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (op.getKey("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	_L_;
}

void Simple_Identity_Management_OpenDRIM_Group_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_Group& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("CreationClassName", instance.CreationClassName) == OK)
		instance.CreationClassName_isNULL = false;

	if (inst.getProperty("Name", instance.Name) == OK)
		instance.Name_isNULL = false;

	if (inst.getProperty("BusinessCategory", instance.BusinessCategory) == OK)
		instance.BusinessCategory_isNULL = false;

	if (inst.getProperty("CommonName", instance.CommonName) == OK)
		instance.CommonName_isNULL = false;

	if (inst.getProperty("GroupID", instance.GroupID) == OK)
		instance.GroupID_isNULL = false;

	_L_;
}

