/*###############################################################################
# Linux Management Providers (LMP), Software Inventory provider package
# Copyright (C) 2009 Nazarov Nodir, TUIT <nazarov.nodir@gmail.com, nodir2000@yahoo.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#ifndef OPENDRIM_SOFTWAREIDENTITYRESOURCEACCESS_H_
#define OPENDRIM_SOFTWAREIDENTITYRESOURCEACCESS_H_

#include "SoftwareInventory_Common.h"

#include "OpenDRIM_SoftwareIdentityResource.h"

int SoftwareInventory_OpenDRIM_SoftwareIdentityResource_load(const CMPIBroker* broker, string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityResource_unload(string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityResource_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SoftwareIdentityResource>& instances, const char** properties, string& errorMessage, const string& discriminant);

int SoftwareInventory_OpenDRIM_SoftwareIdentityResource_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SoftwareIdentityResource& instance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityResource_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareIdentityResource& newInstance, const OpenDRIM_SoftwareIdentityResource& oldInstance, const char** properties, string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityResource_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareIdentityResource& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityResource_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareIdentityResource& instance, string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityResource_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SoftwareIdentityResource& instance, unsigned int& returnValue, const OpenDRIM_SoftwareIdentityResource_RequestStateChange_In& in, OpenDRIM_SoftwareIdentityResource_RequestStateChange_Out& out, string& errorMessage);

int SoftwareInventory_OpenDRIM_SoftwareIdentityResource_populate(OpenDRIM_SoftwareIdentityResource& instance, string& errorMessage);

#endif /*OPENDRIM_SOFTWAREIDENTITYRESOURCEACCESS_H_*/
