/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.ShapePoint;
import org.stathissideris.ascii2image.text.CellSet;
import org.stathissideris.ascii2image.text.TextGrid;

public abstract class DiagramComponent {
    private static final boolean DEBUG = false;

    protected static ShapePoint makePointForCell(TextGrid.Cell cell, TextGrid textGrid, int n, int n2, boolean bl) {
        if (textGrid.isCorner(cell) && bl) {
            return new ShapePoint(cell.x * n + n / 2, cell.y * n2 + n2 / 2, 1);
        }
        if (textGrid.isNormalCorner(cell)) {
            return new ShapePoint(cell.x * n + n / 2, cell.y * n2 + n2 / 2, 0);
        }
        if (textGrid.isRoundCorner(cell)) {
            return new ShapePoint(cell.x * n + n / 2, cell.y * n2 + n2 / 2, 1);
        }
        if (textGrid.isLinesEnd(cell)) {
            return new ShapePoint(cell.x * n + n / 2, cell.y * n2 + n2 / 2, 0);
        }
        if (textGrid.isIntersection(cell)) {
            return new ShapePoint(cell.x * n + n / 2, cell.y * n2 + n2 / 2, 0);
        }
        throw new RuntimeException("Cannot make point for cell " + cell);
    }

    public static DiagramComponent createClosedFromBoundaryCells(TextGrid textGrid, CellSet cellSet, int n, int n2) {
        return DiagramComponent.createClosedFromBoundaryCells(textGrid, cellSet, n, n2, false);
    }

    public static DiagramComponent createClosedFromBoundaryCells(TextGrid textGrid, CellSet cellSet, int n, int n2, boolean bl) {
        if (cellSet.getType(textGrid) == 1) {
            throw new IllegalArgumentException("CellSet is closed and cannot be handled by this method");
        }
        if (cellSet.size() < 2) {
            return null;
        }
        DiagramShape diagramShape = new DiagramShape();
        diagramShape.setClosed(true);
        if (textGrid.containsAtLeastOneDashedLine(cellSet)) {
            diagramShape.setStrokeDashed(true);
        }
        TextGrid textGrid2 = new TextGrid(textGrid.getWidth(), textGrid.getHeight());
        textGrid.copyCellsTo(cellSet, textGrid2);
        TextGrid.Cell cell = cellSet.getFirst();
        if (textGrid2.isCorner(cell)) {
            diagramShape.addToPoints(DiagramComponent.makePointForCell(cell, textGrid2, n, n2, bl));
        }
        TextGrid.Cell cell2 = cell;
        TextGrid.Cell cell3 = null;
        CellSet cellSet2 = textGrid2.followCell(cell2);
        if (cellSet2.size() == 0) {
            return null;
        }
        cell3 = cellSet2.getFirst();
        if (textGrid2.isCorner(cell3)) {
            diagramShape.addToPoints(DiagramComponent.makePointForCell(cell3, textGrid2, n, n2, bl));
        }
        while (!cell3.equals(cell)) {
            cellSet2 = textGrid2.followCell(cell3, cell2);
            if (cellSet2.size() == 1) {
                cell2 = cell3;
                cell3 = cellSet2.getFirst();
                if (cell3.equals(cell) || !textGrid2.isCorner(cell3)) continue;
                diagramShape.addToPoints(DiagramComponent.makePointForCell(cell3, textGrid2, n, n2, bl));
                continue;
            }
            if (cellSet2.size() <= 1) continue;
            return null;
        }
        return diagramShape;
    }
}

