#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Syberia: The World Before
# send your bug reports to contact@dotslashplay.it
###

script_version=20240808.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='syberia-the-world-before'
GAME_NAME='Syberia: The World Before'

GAME_ID_PROLOGUE="${GAME_ID}-prologue"
GAME_NAME_PROLOGUE="$GAME_NAME - Prologue"

ARCHIVE_BASE_PROLOGUE_0_NAME='setup_syberia_the_world_before_prologue_1.0_(43455).exe'
ARCHIVE_BASE_PROLOGUE_0_MD5='22bd7e18e7cd06ddfbe94d262cef6cd9'
ARCHIVE_BASE_PROLOGUE_0_TYPE='innosetup'
ARCHIVE_BASE_PROLOGUE_0_PART1_NAME='setup_syberia_the_world_before_prologue_1.0_(43455)-1.bin'
ARCHIVE_BASE_PROLOGUE_0_PART1_MD5='153581ebbcce0a4608c7b700e9f1093c'
ARCHIVE_BASE_PROLOGUE_0_SIZE='3400000'
ARCHIVE_BASE_PROLOGUE_0_VERSION='1.0-gog43455'
ARCHIVE_BASE_PROLOGUE_0_URL='https://www.gog.com/game/syberia_the_world_before_demo'

UNITY3D_NAME='syberiatwbp'

CONTENT_PATH_DEFAULT='.'

WINE_DIRECT3D_RENDERER='dxvk'
WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/SyberiaTWBP'

USER_PERSISTENT_FILES="
${UNITY3D_NAME}_data/streamingassets/config.bin"

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
## Ensure easy upgrades from packages generated with pre-20240808.1 game scripts
PKG_BIN_PROVIDES="${PKG_BIN_PROVIDES:-}
syberia-the-world-before-demo"

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_ID_PROLOGUE="${GAME_ID_PROLOGUE}-data"
PKG_DATA_DESCRIPTION='data'
## Ensure easy upgrades from packages generated with pre-20240808.1 game scripts
PKG_DATA_PROVIDES="${PKG_DATA_PROVIDES:-}
syberia-the-world-before-demo-data"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
