#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2021 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Shivah
# send your bug reports to contact@dotslashplay.it
###

script_version=20240915.2

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='the-shivah'
GAME_NAME='The Shivah'

ARCHIVE_BASE_1_NAME='the_shivah_3_0_66477.sh'
ARCHIVE_BASE_1_MD5='350e0e292792b1e44df1f54276843f4d'
ARCHIVE_BASE_1_SIZE='170000'
ARCHIVE_BASE_1_VERSION='3.0-gog66477'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/the_shivah'

ARCHIVE_BASE_0_NAME='the_shivah_2_0_53607.sh'
ARCHIVE_BASE_0_MD5='da6d89db273313fe00a680c52554aea3'
ARCHIVE_BASE_0_SIZE='170000'
ARCHIVE_BASE_0_VERSION='2.0-gog53607'

## Optional icons pack
ARCHIVE_OPTIONAL_ICONS_NAME='the-shivah_icons.tar.gz'
ARCHIVE_OPTIONAL_ICONS_MD5='76cb6554e1c09596842391a71e696ded'
ARCHIVE_OPTIONAL_ICONS_URL='https://downloads.dotslashplay.it/games/the-shivah/'
CONTENT_ICONS_PATH='.'
CONTENT_ICONS_FILES='
16x16
24x24
32x32
48x48
256x256'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
ENGV.tmp
Music
Sounds
*.ags
*.cfg
*.exe
*.ogv
*.tra
*.vox'
CONTENT_DOC_MAIN_FILES='
licenses'

## TODO: Check if "ags:shivahkosher" should be used instead.
APP_MAIN_SCUMMID='ags:shivah'
APP_MAIN_ICON='../support/icon.png'
APP_MAIN_ICON_0='Shivah.exe'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons
content_inclusion_default

# Write launchers

launchers_generation

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
