#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# The Interactive Adventures of Dog Mendonça and Pizzaboy
# send your bug reports to contact@dotslashplay.it
###

script_version=20240621.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID='the-interactive-adventures-of-dog-mendonca-and-pizzaboy'
GAME_NAME='The Interactive Adventures of Dog Mendonça and Pizzaboy'

ARCHIVE_BASE_0_NAME='gog_the_interactive_adventures_of_dog_mendon_a_and_pizzaboy_2.0.0.1.sh'
ARCHIVE_BASE_0_MD5='88c5bb7a410fbf2eb0cc124c3ce06fa0'
ARCHIVE_BASE_0_SIZE='496599'
ARCHIVE_BASE_0_VERSION='1.0-gog2.0.0.1'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/the_interactive_adventures_of_dog_mendonca_and_pizzaboy'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN64_FILES='
godot.x11.opt.64'
CONTENT_GAME_BIN32_FILES='
godot.x11.opt.32'
CONTENT_GAME_DATA_FILES='
data.pck'

APP_MAIN_EXE_BIN64='godot.x11.opt.64'
APP_MAIN_EXE_BIN32='godot.x11.opt.32'
APP_MAIN_ICON='../support/icon.png'

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN64_DEPS="$PKG_BIN_DEPS"
PKG_BIN32_DEPS="$PKG_BIN_DEPS"
## Not dependencies on native libraries are set, as this game ships static binaries only.

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
