#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Grim Legends series:
# - Grim Legends 1
# - Grim Legends 2
# - Grim Legends 3
# send your bug reports to contact@dotslashplay.it
###

script_version=20240603.1

PLAYIT_COMPATIBILITY_LEVEL='2.29'

GAME_ID_BRIDE='grim-legends-1'
GAME_NAME_BRIDE='Grim Legends: The Forsaken Bride'

GAME_ID_SWAN='grim-legends-2'
GAME_NAME_SWAN='Grim Legends 2: Song of the Dark Swan'

GAME_ID_CITY='grim-legends-3'
GAME_NAME_CITY='Grim Legends 3: The Dark City'

# Archives

## Grim Legends 1

ARCHIVE_BASE_BRIDE_0_NAME='grim_legends_the_forsaken_bride_gog_1_25983.sh'
ARCHIVE_BASE_BRIDE_0_MD5='3200efbc08fd59726bf9cedaadc8dee4'
ARCHIVE_BASE_BRIDE_0_SIZE='2600000'
ARCHIVE_BASE_BRIDE_0_VERSION='1.0-gog25983'
ARCHIVE_BASE_BRIDE_0_URL='https://www.gog.com/game/grim_legends_the_forsaken_bride'

## Grim Legends 2

ARCHIVE_BASE_SWAN_0_NAME='grim_legends_2_song_of_the_dark_swan_gog_1_25983.sh'
ARCHIVE_BASE_SWAN_0_MD5='6add597284fece79a12410cd50c914d8'
ARCHIVE_BASE_SWAN_0_SIZE='2600000'
ARCHIVE_BASE_SWAN_0_VERSION='1.0-gog25983'
ARCHIVE_BASE_SWAN_0_URL='https://www.gog.com/game/grim_legends_2_song_of_the_dark_swan'

## Grim Legends 3

ARCHIVE_BASE_CITY_0_NAME='grim_legends_3_the_dark_city_gog_1_25984.sh'
ARCHIVE_BASE_CITY_0_MD5='57cb3309f7207a6d2a1a7db811d63117'
ARCHIVE_BASE_CITY_0_SIZE='1200000'
ARCHIVE_BASE_CITY_0_VERSION='1.0-gog25984'
ARCHIVE_BASE_CITY_0_URL='https://www.gog.com/game/grim_legends_3_the_dark_city'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN64_FILES='
*_amd64'
CONTENT_GAME_BIN32_FILES='
*_i386'
CONTENT_GAME_DATA_FILES='
Game
*.cub
*.json'

# Applications

FAKE_HOME_PERSISTENT_DIRECTORIES='
.Artifex Mundi'

APP_MAIN_ICON='../support/icon.png'

## Grim Legends 1

APP_MAIN_EXE_BIN64_BRIDE='GrimLegends_TheForsakenBride_amd64'
APP_MAIN_EXE_BIN32_BRIDE='GrimLegends_TheForsakenBride_i386'

## Grim Legends 2

APP_MAIN_EXE_BIN64_SWAN='GrimLegends_SongOfTheDarkSwan_amd64'
APP_MAIN_EXE_BIN32_SWAN='GrimLegends_SongOfTheDarkSwan_i386'

## Grim Legends 3

APP_MAIN_EXE_BIN64_CITY='DarkCity_amd64'
APP_MAIN_EXE_BIN32_CITY='DarkCity_i386'

# Packages

PACKAGES_LIST='
PKG_BIN64
PKG_BIN32
PKG_DATA'

PKG_DATA_DESCRIPTION='data'

PKG_BIN64_ARCH='64'
PKG_BIN32_ARCH='32'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXext.so.6
libXinerama.so.1'
PKG_BIN64_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"
PKG_BIN32_DEPENDENCIES_LIBRARIES="$PKG_BIN_DEPENDENCIES_LIBRARIES"

## Grim Legends 1

PKG_DATA_ID_BRIDE="${GAME_ID_BRIDE}-data"

PKG_BIN_DEPS_BRIDE="$PKG_DATA_ID_BRIDE"
PKG_BIN64_DEPS_BRIDE="$PKG_BIN_DEPS_BRIDE"
PKG_BIN32_DEPS_BRIDE="$PKG_BIN_DEPS_BRIDE"

## Grim Legends 2

PKG_DATA_ID_SWAN="${GAME_ID_SWAN}-data"

PKG_BIN_DEPS_SWAN="$PKG_DATA_ID_SWAN"
PKG_BIN64_DEPS_SWAN="$PKG_BIN_DEPS_SWAN"
PKG_BIN32_DEPS_SWAN="$PKG_BIN_DEPS_SWAN"

## Grim Legends 3

PKG_DATA_ID_CITY="${GAME_ID_CITY}-data"

PKG_BIN_DEPS_CITY="$PKG_DATA_ID_CITY"
PKG_BIN64_DEPS_CITY="$PKG_BIN_DEPS_CITY"
PKG_BIN32_DEPS_CITY="$PKG_BIN_DEPS_CITY"
PKG_BIN_DEPENDENCIES_LIBRARIES_CITY="$PKG_BIN_DEPENDENCIES_LIBRARIES
libidn.so.11"
PKG_BIN64_DEPENDENCIES_LIBRARIES_CITY="$PKG_BIN_DEPENDENCIES_LIBRARIES_CITY"
PKG_BIN32_DEPENDENCIES_LIBRARIES_CITY="$PKG_BIN_DEPENDENCIES_LIBRARIES_CITY"

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

APP_MAIN_EXE_BIN64=$(context_value 'APP_MAIN_EXE_BIN64')
APP_MAIN_EXE_BIN32=$(context_value 'APP_MAIN_EXE_BIN32')
launchers_generation 'PKG_BIN64'
launchers_generation 'PKG_BIN32'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
