#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Shadow Tactics
###

script_version=20240711.1

PLAYIT_COMPATIBILITY_LEVEL='2.30'

GAME_ID='shadow-tactics'
GAME_NAME='Shadow Tactics: Blades of the Shogun'

ARCHIVE_BASE_1_NAME='shadow_tactics_blades_of_the_shogun_en_2_2_10_f_21297.sh'
ARCHIVE_BASE_1_MD5='e7772e7a5f4fee760e9311a9a899dbb3'
ARCHIVE_BASE_1_SIZE='7642154'
ARCHIVE_BASE_1_VERSION='2.2.10.f-gog21297'
ARCHIVE_BASE_1_URL='https://www.gog.com/game/shadow_tactics_blades_of_the_shogun'

ARCHIVE_BASE_0_NAME='shadow_tactics_blades_of_the_shogun_en_1_4_4_f_14723.sh'
ARCHIVE_BASE_0_MD5='93faa090d5bcaa22f0faabd1e32c5909'
ARCHIVE_BASE_0_SIZE='9600000'
ARCHIVE_BASE_0_VERSION='1.4.4.f-gog14723'

UNITY3D_NAME='Shadow Tactics'
UNITY3D_PLUGINS='
libRenderingPlugin.so
ScreenSelector.so'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_LIGHTING_FILES="
${UNITY3D_NAME}_Data/GI"

PACKAGES_LIST='
PKG_BIN
PKG_LIGHTING
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_LIGHTING
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libgdk_pixbuf-2.0.so.0
libglib-2.0.so.0
libGL.so.1
libgobject-2.0.so.0
libgtk-x11-2.0.so.0
libm.so.6
libpthread.so.0
librt.so.1
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libXrandr.so.2'

PKG_LIGHTING_ID="${GAME_ID}-lighting"
PKG_LIGHTING_DESCRIPTION='lighting'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Link libRenderingPlugin.so to the harcoded path the game engine expects to find it.

file_name='libRenderingPlugin.so'
file_source="$(path_libraries)/${file_name}"
file_destination="$(package_path 'PKG_BIN')$(path_game_data)/$(unity3d_name)_Data/Plugins/x86/${file_name}"
mkdir --parents "$(dirname "$file_destination")"
ln --symbolic "$file_source" "$file_destination"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
