#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Stellaris expansions (extra content):
# - Arachnoid Portrait Pack
# - Horizon Signal
# - Anniversary Portraits
###

script_version=20241215.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='stellaris'
GAME_NAME='Stellaris'

EXPANSION_ID_ARACHNOID='arachnoid'
EXPANSION_NAME_ARACHNOID='Arachnoid Portrait Pack'

EXPANSION_ID_HORIZONSIGNAL='horizon-signal'
EXPANSION_NAME_HORIZONSIGNAL='Horizon Signal'

EXPANSION_ID_ANNIVERSARY='anniversary'
EXPANSION_NAME_ANNIVERSARY='Anniversary Portraits'

# Archives

## Arachnoid Portrait Pack

ARCHIVE_BASE_ARACHNOID_63_NAME='stellaris_arachnoid_portrait_pack_3_14_15926_78464.sh'
ARCHIVE_BASE_ARACHNOID_63_MD5='9da0b12f862958f4af43ae7612445adb'
ARCHIVE_BASE_ARACHNOID_63_SIZE='817'
ARCHIVE_BASE_ARACHNOID_63_VERSION='3.14.15926-gog78464'
ARCHIVE_BASE_ARACHNOID_63_URL='https://www.gog.com/game/stellaris_galaxy_edition_upgrade_pack'

ARCHIVE_BASE_ARACHNOID_62_NAME='stellaris_arachnoid_portrait_pack_3_13_2_0_76713.sh'
ARCHIVE_BASE_ARACHNOID_62_MD5='6584255df86295e64f59c6e9c1b69503'
ARCHIVE_BASE_ARACHNOID_62_SIZE='817'
ARCHIVE_BASE_ARACHNOID_62_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_ARACHNOID_59_NAME='stellaris_arachnoid_portrait_pack_3_12_5_74193.sh'
ARCHIVE_BASE_ARACHNOID_59_MD5='f753906a3ff33592d853b6634d14cfb9'
ARCHIVE_BASE_ARACHNOID_59_SIZE='817'
ARCHIVE_BASE_ARACHNOID_59_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_ARACHNOID_55_NAME='stellaris_arachnoid_portrait_pack_3_11_3_0_72561.sh'
ARCHIVE_BASE_ARACHNOID_55_MD5='5e073b99755aa71fa8b4063e53b4335c'
ARCHIVE_BASE_ARACHNOID_55_SIZE='817'
ARCHIVE_BASE_ARACHNOID_55_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_ARACHNOID_52_NAME='stellaris_arachnoid_portrait_pack_3_10_4_70670.sh'
ARCHIVE_BASE_ARACHNOID_52_MD5='a1adad0576df7d51e3035c0f1ad23c1b'
ARCHIVE_BASE_ARACHNOID_52_SIZE='817'
ARCHIVE_BASE_ARACHNOID_52_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_ARACHNOID_46_NAME='stellaris_arachnoid_portrait_pack_3_9_3_68314.sh'
ARCHIVE_BASE_ARACHNOID_46_MD5='7e9c3036c905d049728186576f8a56eb'
ARCHIVE_BASE_ARACHNOID_46_SIZE='1136'
ARCHIVE_BASE_ARACHNOID_46_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_ARACHNOID_43_NAME='stellaris_arachnoid_portrait_pack_3_8_4_1_65337.sh'
ARCHIVE_BASE_ARACHNOID_43_MD5='3c4a57c69955b4b7fc63e46ea06684a5'
ARCHIVE_BASE_ARACHNOID_43_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_43_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_ARACHNOID_39_NAME='stellaris_arachnoid_portrait_pack_3_7_4_63489.sh'
ARCHIVE_BASE_ARACHNOID_39_MD5='e4d76799d90bf18a2666460bae14db93'
ARCHIVE_BASE_ARACHNOID_39_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_39_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_ARACHNOID_36_NAME='stellaris_arachnoid_portrait_pack_3_6_1_60754.sh'
ARCHIVE_BASE_ARACHNOID_36_MD5='41240ed75d7100557b57914ee66c1f49'
ARCHIVE_BASE_ARACHNOID_36_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_36_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_ARACHNOID_34_NAME='stellaris_arachnoid_portrait_pack_3_5_3_59410.sh'
ARCHIVE_BASE_ARACHNOID_34_MD5='6aff6463161944a265b502f434577fc9'
ARCHIVE_BASE_ARACHNOID_34_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_34_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_ARACHNOID_32_NAME='stellaris_arachnoid_portrait_pack_3_4_5_56913.sh'
ARCHIVE_BASE_ARACHNOID_32_MD5='ace768013cc7aaa46182586349432ddf'
ARCHIVE_BASE_ARACHNOID_32_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_32_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_ARACHNOID_28_NAME='stellaris_arachnoid_portrait_pack_3_3_4_54421.sh'
ARCHIVE_BASE_ARACHNOID_28_MD5='2d7bd0d2246fcec48ca8bbf8cdb456e8'
ARCHIVE_BASE_ARACHNOID_28_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_28_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_ARACHNOID_24_NAME='stellaris_arachnoid_portrait_pack_3_2_1_1_51520.sh'
ARCHIVE_BASE_ARACHNOID_24_MD5='fab840f6c4a70dcb7c19c913d711af20'
ARCHIVE_BASE_ARACHNOID_24_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_24_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_ARACHNOID_23_NAME='stellaris_arachnoid_portrait_pack_3_1_1_50008.sh'
ARCHIVE_BASE_ARACHNOID_23_MD5='0ccdf6386dc2b9c062e9d272550392a1'
ARCHIVE_BASE_ARACHNOID_23_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_23_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_ARACHNOID_22_NAME='stellaris_arachnoid_portrait_pack_3_0_3_47193.sh'
ARCHIVE_BASE_ARACHNOID_22_MD5='d9619c256ed79a50cce26398b9ac8c11'
ARCHIVE_BASE_ARACHNOID_22_SIZE='1200'
ARCHIVE_BASE_ARACHNOID_22_VERSION='3.0.3-gog47193'

## Horizon Signal

ARCHIVE_BASE_HORIZONSIGNAL_63_NAME='stellaris_horizon_signal_3_14_15926_78464.sh'
ARCHIVE_BASE_HORIZONSIGNAL_63_MD5='2e1dd57ce9e7f96216b7afd9ac2ad81b'
ARCHIVE_BASE_HORIZONSIGNAL_63_SIZE='817'
ARCHIVE_BASE_HORIZONSIGNAL_63_VERSION='3.14.15926-gog78464'
ARCHIVE_BASE_HORIZONSIGNAL_63_URL='https://www.gog.com/game/stellaris_horizon_signal'

ARCHIVE_BASE_HORIZONSIGNAL_62_NAME='stellaris_horizon_signal_3_13_2_0_76713.sh'
ARCHIVE_BASE_HORIZONSIGNAL_62_MD5='9719994a74b4778c50a5a9a0a1390d4a'
ARCHIVE_BASE_HORIZONSIGNAL_62_SIZE='817'
ARCHIVE_BASE_HORIZONSIGNAL_62_VERSION='3.13.2-gog76713'

ARCHIVE_BASE_HORIZONSIGNAL_59_NAME='stellaris_horizon_signal_3_12_5_74193.sh'
ARCHIVE_BASE_HORIZONSIGNAL_59_MD5='e0f7d5e0308ee01cd9fd4f3bc787e1b9'
ARCHIVE_BASE_HORIZONSIGNAL_59_SIZE='817'
ARCHIVE_BASE_HORIZONSIGNAL_59_VERSION='3.12.5-gog74193'

ARCHIVE_BASE_HORIZONSIGNAL_55_NAME='stellaris_horizon_signal_3_11_3_0_72561.sh'
ARCHIVE_BASE_HORIZONSIGNAL_55_MD5='d9074aa886455537cbeffb4364164b10'
ARCHIVE_BASE_HORIZONSIGNAL_55_SIZE='817'
ARCHIVE_BASE_HORIZONSIGNAL_55_VERSION='3.11.3-gog72561'

ARCHIVE_BASE_HORIZONSIGNAL_52_NAME='stellaris_horizon_signal_3_10_4_70670.sh'
ARCHIVE_BASE_HORIZONSIGNAL_52_MD5='d81d5a8fcf2a2d406d9670530e80c4ea'
ARCHIVE_BASE_HORIZONSIGNAL_52_SIZE='817'
ARCHIVE_BASE_HORIZONSIGNAL_52_VERSION='3.10.4-gog70670'

ARCHIVE_BASE_HORIZONSIGNAL_46_NAME='stellaris_horizon_signal_3_9_3_68314.sh'
ARCHIVE_BASE_HORIZONSIGNAL_46_MD5='b3b8eb00b7ca9c70445bf8b13641ae5e'
ARCHIVE_BASE_HORIZONSIGNAL_46_SIZE='1136'
ARCHIVE_BASE_HORIZONSIGNAL_46_VERSION='3.9.3-gog68314'

ARCHIVE_BASE_HORIZONSIGNAL_43_NAME='stellaris_horizon_signal_3_8_4_1_65337.sh'
ARCHIVE_BASE_HORIZONSIGNAL_43_MD5='97befa175f3b19a1bb0457ef9342b477'
ARCHIVE_BASE_HORIZONSIGNAL_43_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_43_VERSION='3.8.4.1-gog65337'

ARCHIVE_BASE_HORIZONSIGNAL_39_NAME='stellaris_horizon_signal_3_7_4_63489.sh'
ARCHIVE_BASE_HORIZONSIGNAL_39_MD5='2c110df9fde65ba833611299f9089f11'
ARCHIVE_BASE_HORIZONSIGNAL_39_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_39_VERSION='3.7.4-gog63489'

ARCHIVE_BASE_HORIZONSIGNAL_36_NAME='stellaris_horizon_signal_3_6_1_60754.sh'
ARCHIVE_BASE_HORIZONSIGNAL_36_MD5='2aa466583664f7849a8887288cc11c64'
ARCHIVE_BASE_HORIZONSIGNAL_36_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_36_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_HORIZONSIGNAL_34_NAME='stellaris_horizon_signal_3_5_3_59410.sh'
ARCHIVE_BASE_HORIZONSIGNAL_34_MD5='d8ed88b305b2b59eff219050dfefaaeb'
ARCHIVE_BASE_HORIZONSIGNAL_34_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_34_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_HORIZONSIGNAL_32_NAME='stellaris_horizon_signal_3_4_5_56913.sh'
ARCHIVE_BASE_HORIZONSIGNAL_32_MD5='6799f7b49323c768c3db7a2744e07e09'
ARCHIVE_BASE_HORIZONSIGNAL_32_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_32_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_HORIZONSIGNAL_28_NAME='stellaris_horizon_signal_3_3_4_54421.sh'
ARCHIVE_BASE_HORIZONSIGNAL_28_MD5='80c81dc86845976789437875b8fd3b2e'
ARCHIVE_BASE_HORIZONSIGNAL_28_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_28_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_HORIZONSIGNAL_24_NAME='stellaris_horizon_signal_3_2_1_1_51520.sh'
ARCHIVE_BASE_HORIZONSIGNAL_24_MD5='d9153fc1cf20a225e55cb001aa6b8c51'
ARCHIVE_BASE_HORIZONSIGNAL_24_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_24_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_HORIZONSIGNAL_23_NAME='stellaris_horizon_signal_3_1_1_50008.sh'
ARCHIVE_BASE_HORIZONSIGNAL_23_MD5='5c64e490ee6ac5e72816be2530e90f2b'
ARCHIVE_BASE_HORIZONSIGNAL_23_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_23_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_HORIZONSIGNAL_22_NAME='stellaris_horizon_signal_3_0_3_47193.sh'
ARCHIVE_BASE_HORIZONSIGNAL_22_MD5='40ddcd078680c3ab2bb5e98d7658bfa9'
ARCHIVE_BASE_HORIZONSIGNAL_22_SIZE='1200'
ARCHIVE_BASE_HORIZONSIGNAL_22_VERSION='3.0.3-gog47193'

## Anniversary Portraits

### Starting with game release 3.7.2,
### this expansion is included in the base game.

ARCHIVE_BASE_ANNIVERSARY_35_NAME='stellaris_anniversary_portraits_3_6_1_60754.sh'
ARCHIVE_BASE_ANNIVERSARY_35_MD5='13d5ed75ed18ae47fd8377a3c0f58eec'
ARCHIVE_BASE_ANNIVERSARY_35_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_35_VERSION='3.6.1-gog60754'

ARCHIVE_BASE_ANNIVERSARY_33_NAME='stellaris_anniversary_portraits_3_5_3_59410.sh'
ARCHIVE_BASE_ANNIVERSARY_33_MD5='7fb42ed038df8658a160a1a575e92ca4'
ARCHIVE_BASE_ANNIVERSARY_33_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_33_VERSION='3.5.3-gog59410'

ARCHIVE_BASE_ANNIVERSARY_31_NAME='stellaris_anniversary_portraits_3_4_5_56913.sh'
ARCHIVE_BASE_ANNIVERSARY_31_MD5='3e31e34d9abb5118a704b904275a14c5'
ARCHIVE_BASE_ANNIVERSARY_31_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_31_VERSION='3.4.5-gog56913'

ARCHIVE_BASE_ANNIVERSARY_27_NAME='stellaris_anniversary_portraits_3_3_4_54421.sh'
ARCHIVE_BASE_ANNIVERSARY_27_MD5='d61fc4a3daaebdfa73b002e1865d65f8'
ARCHIVE_BASE_ANNIVERSARY_27_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_27_VERSION='3.3.4-gog54421'

ARCHIVE_BASE_ANNIVERSARY_23_NAME='stellaris_anniversary_portraits_3_2_1_1_51520.sh'
ARCHIVE_BASE_ANNIVERSARY_23_MD5='8ef72fb6a3a0f648d5c484bad729194c'
ARCHIVE_BASE_ANNIVERSARY_23_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_23_VERSION='3.2.1.1-gog51520'

ARCHIVE_BASE_ANNIVERSARY_22_NAME='stellaris_anniversary_portraits_3_1_1_50008.sh'
ARCHIVE_BASE_ANNIVERSARY_22_MD5='d6a97a96a73effc93e41f247b86db8e3'
ARCHIVE_BASE_ANNIVERSARY_22_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_22_VERSION='3.1.1-gog50008'

ARCHIVE_BASE_ANNIVERSARY_21_NAME='stellaris_anniversary_portraits_3_0_3_47193.sh'
ARCHIVE_BASE_ANNIVERSARY_21_MD5='53b0dd554774acd8aa821b5be741b4d8'
ARCHIVE_BASE_ANNIVERSARY_21_SIZE='1200'
ARCHIVE_BASE_ANNIVERSARY_21_VERSION='3.0.3-gog47193'


CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_MAIN_FILES='
dlc'

PKG_PARENT_ID="$GAME_ID"

PKG_MAIN_DEPENDENCIES_SIBLINGS='
PKG_PARENT'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_default

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
