#!/bin/sh

oneTimeSetUp() {
	# Load the ./play.it library
	export LIB_ONLY=1
	. lib/libplayit2.sh
}

test_compatibility_level() {
	local compatibility_level PLAYIT_COMPATIBILITY_LEVEL target_version LIBRARY_VERSION

	LIBRARY_VERSION='1.42'
	compatibility_level=$(compatibility_level)
	assertEquals '1.42' "$compatibility_level"

	target_version='2.21'
	compatibility_level=$(compatibility_level)
	assertEquals '2.21' "$compatibility_level"

	PLAYIT_COMPATIBILITY_LEVEL='2.22'
	compatibility_level=$(compatibility_level)
	assertEquals '2.22' "$compatibility_level"
}

test_compatibility_level_is_at_least() {
	local PLAYIT_COMPATIBILITY_LEVEL

	PLAYIT_COMPATIBILITY_LEVEL='2.21'
	assertTrue 'compatibility_level_is_at_least "1.0"'
	assertTrue 'compatibility_level_is_at_least "2.0"'
	assertTrue 'compatibility_level_is_at_least "2.21"'
	assertFalse 'compatibility_level_is_at_least "2.42"'
	assertFalse 'compatibility_level_is_at_least "3.0"'
}
