/* $Id: Hygon_C86_7185_32_core.h $ */
/** @file
 * CPU database entry "Hygon C86 7185 32-core".
 * Generated at 2019-09-25T11:07:33Z by VBoxCpuReport v6.1.0_BETA1r80830 on linux.amd64.
 */

/*
 * Copyright (C) 2013-2020 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 */

#ifndef VBOX_CPUDB_Hygon_C86_7185_32_core_h
#define VBOX_CPUDB_Hygon_C86_7185_32_core_h
#ifndef RT_WITHOUT_PRAGMA_ONCE
# pragma once
#endif


#ifndef CPUM_DB_STANDALONE
/**
 * CPUID leaves for Hygon C86 7185 32-core Processor.
 */
static CPUMCPUIDLEAF const g_aCpuIdLeaves_Hygon_C86_7185_32_core[] =
{
    { 0x00000000, 0x00000000, 0x00000000, 0x0000000d, 0x6f677948, 0x656e6975, 0x6e65476e, 0 },
    { 0x00000001, 0x00000000, 0x00000000, 0x00900f01, 0x3b400800, 0x7cd83209, 0x178bfbff, 0 | CPUMCPUIDLEAF_F_CONTAINS_APIC_ID | CPUMCPUIDLEAF_F_CONTAINS_APIC },
    { 0x00000002, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x00000004, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x00000005, 0x00000000, 0x00000000, 0x00000040, 0x00000040, 0x00000003, 0x00000011, 0 },
    { 0x00000006, 0x00000000, 0x00000000, 0x00000004, 0x00000000, 0x00000001, 0x00000000, 0 },
    { 0x00000007, 0x00000000, UINT32_MAX, 0x00000000, 0x009c01a9, 0x00000000, 0x00000000, 0 },
    { 0x00000007, 0x00000001, UINT32_MAX, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x00000008, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x00000009, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x0000000a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x0000000b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x0000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x0000000d, 0x00000000, UINT32_MAX, 0x00000007, 0x00000340, 0x00000340, 0x00000000, 0 },
    { 0x0000000d, 0x00000001, UINT32_MAX, 0x0000000f, 0x00000340, 0x00000000, 0x00000000, 0 },
    { 0x0000000d, 0x00000002, UINT32_MAX, 0x00000100, 0x00000240, 0x00000000, 0x00000000, 0 },
    { 0x0000000d, 0x00000003, UINT32_MAX, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x80000000, 0x00000000, 0x00000000, 0x8000001f, 0x6f677948, 0x656e6975, 0x6e65476e, 0 },
    { 0x80000001, 0x00000000, 0x00000000, 0x00900f01, 0x40000000, 0x35c233ff, 0x2fd3fbff, 0 | CPUMCPUIDLEAF_F_CONTAINS_APIC },
    { 0x80000002, 0x00000000, 0x00000000, 0x6f677948, 0x3843206e, 0x31372036, 0x33203538, 0 },
    { 0x80000003, 0x00000000, 0x00000000, 0x6f632d32, 0x50206572, 0x65636f72, 0x726f7373, 0 },
    { 0x80000004, 0x00000000, 0x00000000, 0x20202020, 0x20202020, 0x20202020, 0x00202020, 0 },
    { 0x80000005, 0x00000000, 0x00000000, 0xff40ff40, 0xff40ff40, 0x20080140, 0x40040140, 0 },
    { 0x80000006, 0x00000000, 0x00000000, 0x36006400, 0x56006400, 0x02006140, 0x0200c140, 0 },
    { 0x80000007, 0x00000000, 0x00000000, 0x00000000, 0x0000001b, 0x00000000, 0x00006599, 0 },
    { 0x80000008, 0x00000000, 0x00000000, 0x00003030, 0x00001007, 0x0000603f, 0x00000000, 0 },
    { 0x80000009, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x8000000a, 0x00000000, 0x00000000, 0x00000001, 0x00008000, 0x00000000, 0x0001bcff, 0 },
    { 0x8000000b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x8000000c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x8000000d, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x8000000e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x8000000f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x80000010, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x80000011, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x80000012, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x80000013, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x80000014, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x80000015, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x80000016, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x80000017, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x80000018, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x80000019, 0x00000000, 0x00000000, 0xf040f040, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x8000001a, 0x00000000, 0x00000000, 0x00000003, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x8000001b, 0x00000000, 0x00000000, 0x000003ff, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x8000001c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x8000001d, 0x00000000, UINT32_MAX, 0x00004121, 0x01c0003f, 0x0000003f, 0x00000000, 0 },
    { 0x8000001d, 0x00000001, UINT32_MAX, 0x00004122, 0x00c0003f, 0x000000ff, 0x00000000, 0 },
    { 0x8000001d, 0x00000002, UINT32_MAX, 0x00004143, 0x01c0003f, 0x000003ff, 0x00000002, 0 },
    { 0x8000001d, 0x00000003, UINT32_MAX, 0x0001c163, 0x03c0003f, 0x00001fff, 0x00000001, 0 },
    { 0x8000001d, 0x00000004, UINT32_MAX, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
    { 0x8000001e, 0x00000000, 0x00000000, 0x0000003b, 0x0000011d, 0x00000303, 0x00000000, 0 | CPUMCPUIDLEAF_F_CONTAINS_APIC_ID },
    { 0x8000001f, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0 },
};
#endif /* !CPUM_DB_STANDALONE */


#ifndef CPUM_DB_STANDALONE
/**
 * MSR ranges for Hygon C86 7185 32-core Processor.
 */
static CPUMMSRRANGE const g_aMsrRanges_Hygon_C86_7185_32_core[] =
{
    MAL(0x00000000, "IA32_P5_MC_ADDR", 0x00000402),
    MAL(0x00000001, "IA32_P5_MC_TYPE", 0x00000401),
    MFN(0x00000010, "IA32_TIME_STAMP_COUNTER", Ia32TimestampCounter, Ia32TimestampCounter), /* Villain? value=0x1284`714a5328 */
    MFX(0x0000001b, "IA32_APIC_BASE", Ia32ApicBase, Ia32ApicBase, UINT32_C(0xfee00800), 0, UINT64_C(0xffff0000000006ff)),
    MFX(0x0000002a, "EBL_CR_POWERON", IntelEblCrPowerOn, ReadOnly, 0, 0, 0), /* value=0x0 */
    MFN(0x00000049, "MSR_LASTBRANCH_9", WriteOnly, IgnoreWrite),
    MFO(0x0000008b, "AMD_K8_PATCH_LEVEL", AmdK8PatchLevel), /* value=0x900006 */
    MFN(0x000000e7, "IA32_MPERF", Ia32MPerf, Ia32MPerf), /* value=0x11c5`3efacda4 */
    MFN(0x000000e8, "IA32_APERF", Ia32APerf, Ia32APerf), /* value=0x2e`1e9ecd0c */
    MFX(0x000000fe, "IA32_MTRRCAP", Ia32MtrrCap, ReadOnly, 0x508, 0, 0), /* value=0x508 */
    MFX(0x00000174, "IA32_SYSENTER_CS", Ia32SysEnterCs, Ia32SysEnterCs, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x10 */
    MFX(0x00000175, "IA32_SYSENTER_ESP", Ia32SysEnterEsp, Ia32SysEnterEsp, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x0 */
    MFX(0x00000176, "IA32_SYSENTER_EIP", Ia32SysEnterEip, Ia32SysEnterEip, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x9e578a50 */
    MFX(0x00000179, "IA32_MCG_CAP", Ia32McgCap, ReadOnly, 0x117, 0, 0), /* value=0x117 */
    MFX(0x0000017a, "IA32_MCG_STATUS", Ia32McgStatus, Ia32McgStatus, 0, UINT64_C(0xfffffffffffffff8), 0), /* value=0x0 */
    MFX(0x0000017b, "IA32_MCG_CTL", Ia32McgCtl, Ia32McgCtl, 0, 0x10, 0), /* value=0xffffffff`ffffffef */
    MFX(0x000001d9, "IA32_DEBUGCTL", Ia32DebugCtl, Ia32DebugCtl, 0, UINT64_C(0xffffffffffffff80), 0x40), /* value=0x0 */
    MFO(0x000001db, "P6_LAST_BRANCH_FROM_IP", P6LastBranchFromIp), /* value=0x0 */
    MFO(0x000001dc, "P6_LAST_BRANCH_TO_IP", P6LastBranchToIp), /* value=0x0 */
    MFO(0x000001dd, "P6_LAST_INT_FROM_IP", P6LastIntFromIp), /* value=0x0 */
    MFO(0x000001de, "P6_LAST_INT_TO_IP", P6LastIntToIp), /* value=0x0 */
    MFX(0x00000200, "IA32_MTRR_PHYS_BASE0", Ia32MtrrPhysBaseN, Ia32MtrrPhysBaseN, 0x0, 0, UINT64_C(0xffff000000000ff8)), /* value=0x6 */
    MFX(0x00000201, "IA32_MTRR_PHYS_MASK0", Ia32MtrrPhysMaskN, Ia32MtrrPhysMaskN, 0x0, 0, UINT64_C(0xffff0000000007ff)), /* value=0xffff`80000800 */
    MFX(0x00000202, "IA32_MTRR_PHYS_BASE1", Ia32MtrrPhysBaseN, Ia32MtrrPhysBaseN, 0x1, 0, UINT64_C(0xffff000000000ff8)), /* value=0x7c000000 */
    MFX(0x00000203, "IA32_MTRR_PHYS_MASK1", Ia32MtrrPhysMaskN, Ia32MtrrPhysMaskN, 0x1, 0, UINT64_C(0xffff0000000007ff)), /* value=0xffff`fc000800 */
    MFX(0x00000204, "IA32_MTRR_PHYS_BASE2", Ia32MtrrPhysBaseN, Ia32MtrrPhysBaseN, 0x2, 0, UINT64_C(0xffff000000000ff8)), /* value=0x0 */
    MFX(0x00000205, "IA32_MTRR_PHYS_MASK2", Ia32MtrrPhysMaskN, Ia32MtrrPhysMaskN, 0x2, 0, UINT64_C(0xffff0000000007ff)), /* value=0x0 */
    MFX(0x00000206, "IA32_MTRR_PHYS_BASE3", Ia32MtrrPhysBaseN, Ia32MtrrPhysBaseN, 0x3, 0, UINT64_C(0xffff000000000ff8)), /* value=0x0 */
    MFX(0x00000207, "IA32_MTRR_PHYS_MASK3", Ia32MtrrPhysMaskN, Ia32MtrrPhysMaskN, 0x3, 0, UINT64_C(0xffff0000000007ff)), /* value=0x0 */
    MFX(0x00000208, "IA32_MTRR_PHYS_BASE4", Ia32MtrrPhysBaseN, Ia32MtrrPhysBaseN, 0x4, 0, UINT64_C(0xffff000000000ff8)), /* value=0x0 */
    MFX(0x00000209, "IA32_MTRR_PHYS_MASK4", Ia32MtrrPhysMaskN, Ia32MtrrPhysMaskN, 0x4, 0, UINT64_C(0xffff0000000007ff)), /* value=0x0 */
    MFX(0x0000020a, "IA32_MTRR_PHYS_BASE5", Ia32MtrrPhysBaseN, Ia32MtrrPhysBaseN, 0x5, 0, UINT64_C(0xffff000000000ff8)), /* value=0x0 */
    MFX(0x0000020b, "IA32_MTRR_PHYS_MASK5", Ia32MtrrPhysMaskN, Ia32MtrrPhysMaskN, 0x5, 0, UINT64_C(0xffff0000000007ff)), /* value=0x0 */
    MFX(0x0000020c, "IA32_MTRR_PHYS_BASE6", Ia32MtrrPhysBaseN, Ia32MtrrPhysBaseN, 0x6, 0, UINT64_C(0xffff000000000ff8)), /* value=0x0 */
    MFX(0x0000020d, "IA32_MTRR_PHYS_MASK6", Ia32MtrrPhysMaskN, Ia32MtrrPhysMaskN, 0x6, 0, UINT64_C(0xffff0000000007ff)), /* value=0x0 */
    MFX(0x0000020e, "IA32_MTRR_PHYS_BASE7", Ia32MtrrPhysBaseN, Ia32MtrrPhysBaseN, 0x7, 0, UINT64_C(0xffff000000000ff8)), /* value=0x0 */
    MFX(0x0000020f, "IA32_MTRR_PHYS_MASK7", Ia32MtrrPhysMaskN, Ia32MtrrPhysMaskN, 0x7, 0, UINT64_C(0xffff0000000007ff)), /* value=0x0 */
    MFS(0x00000250, "IA32_MTRR_FIX64K_00000", Ia32MtrrFixed, Ia32MtrrFixed, GuestMsrs.msr.MtrrFix64K_00000),
    MFS(0x00000258, "IA32_MTRR_FIX16K_80000", Ia32MtrrFixed, Ia32MtrrFixed, GuestMsrs.msr.MtrrFix16K_80000),
    MFS(0x00000259, "IA32_MTRR_FIX16K_A0000", Ia32MtrrFixed, Ia32MtrrFixed, GuestMsrs.msr.MtrrFix16K_A0000),
    MFS(0x00000268, "IA32_MTRR_FIX4K_C0000", Ia32MtrrFixed, Ia32MtrrFixed, GuestMsrs.msr.MtrrFix4K_C0000),
    MFS(0x00000269, "IA32_MTRR_FIX4K_C8000", Ia32MtrrFixed, Ia32MtrrFixed, GuestMsrs.msr.MtrrFix4K_C8000),
    MFS(0x0000026a, "IA32_MTRR_FIX4K_D0000", Ia32MtrrFixed, Ia32MtrrFixed, GuestMsrs.msr.MtrrFix4K_D0000),
    MFS(0x0000026b, "IA32_MTRR_FIX4K_D8000", Ia32MtrrFixed, Ia32MtrrFixed, GuestMsrs.msr.MtrrFix4K_D8000),
    MFS(0x0000026c, "IA32_MTRR_FIX4K_E0000", Ia32MtrrFixed, Ia32MtrrFixed, GuestMsrs.msr.MtrrFix4K_E0000),
    MFS(0x0000026d, "IA32_MTRR_FIX4K_E8000", Ia32MtrrFixed, Ia32MtrrFixed, GuestMsrs.msr.MtrrFix4K_E8000),
    MFS(0x0000026e, "IA32_MTRR_FIX4K_F0000", Ia32MtrrFixed, Ia32MtrrFixed, GuestMsrs.msr.MtrrFix4K_F0000),
    MFS(0x0000026f, "IA32_MTRR_FIX4K_F8000", Ia32MtrrFixed, Ia32MtrrFixed, GuestMsrs.msr.MtrrFix4K_F8000),
    MFS(0x00000277, "IA32_PAT", Ia32Pat, Ia32Pat, Guest.msrPAT),
    MFZ(0x000002ff, "IA32_MTRR_DEF_TYPE", Ia32MtrrDefType, Ia32MtrrDefType, GuestMsrs.msr.MtrrDefType, 0, UINT64_C(0xfffffffffffff3f8)),
    RFN(0x00000400, 0x0000041b, "IA32_MCi_CTL_STATUS_ADDR_MISC", Ia32McCtlStatusAddrMiscN, Ia32McCtlStatusAddrMiscN),
    MVX(0x00000da0, "TODO_0000_0da0", 0, 0, UINT64_MAX),
    MFX(0xc0000080, "AMD64_EFER", Amd64Efer, Amd64Efer, 0xd01, 0xfe, UINT64_C(0xffffffffffff0200)),
    MFN(0xc0000081, "AMD64_STAR", Amd64SyscallTarget, Amd64SyscallTarget), /* Might bite. value=0x230010`00000000 */
    MFN(0xc0000082, "AMD64_STAR64", Amd64LongSyscallTarget, Amd64LongSyscallTarget), /* Might bite. value=0xffffffff`9e574c70 */
    MFN(0xc0000083, "AMD64_STARCOMPAT", Amd64CompSyscallTarget, Amd64CompSyscallTarget), /* Might bite. value=0xffffffff`9e578de0 */
    MFN(0xc0000084, "AMD64_SYSCALL_FLAG_MASK", Amd64SyscallFlagMask, Amd64SyscallFlagMask), /* Might bite. value=0x43700 */
    MVO(0xc00000e7, "TODO_c000_00e7", UINT64_C(0x11c7b9402a58)),
    MVO(0xc00000e8, "TODO_c000_00e8", UINT64_C(0x2f70233a93)),
    MVO(0xc00000e9, "TODO_c000_00e9", 0),
    MFN(0xc0000100, "AMD64_FS_BASE", Amd64FsBase, Amd64FsBase), /* Might bite. value=0x7f4f`f293d700 */
    MFN(0xc0000101, "AMD64_GS_BASE", Amd64GsBase, Amd64GsBase), /* Might bite. value=0xffff8a48`dd400000 */
    MFN(0xc0000102, "AMD64_KERNEL_GS_BASE", Amd64KernelGsBase, Amd64KernelGsBase), /* Might bite. value=0x0 */
    MFX(0xc0000103, "AMD64_TSC_AUX", Amd64TscAux, Amd64TscAux, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x0 */
    MFX(0xc0000104, "AMD_15H_TSC_RATE", AmdFam15hTscRate, AmdFam15hTscRate, 0, 0, UINT64_C(0xffffff0000000000)), /* value=0x1`00000000 */
    RVI(0xc0000408, 0xc000040f, "AMD_10H_MC4_MISCn", 0),
    MVX(0xc0000410, "TODO_c000_0410", 0x100102a, UINT64_C(0xfffffffffe000f01), 0),
    MVX(0xc0002000, "TODO_c000_2000", 0x1fffff, UINT64_C(0xffffffffffe00000), 0),
    MVX(0xc0002001, "TODO_c000_2001", 0, 0, UINT64_MAX),
    MVX(0xc0002002, "TODO_c000_2002", 0, 0, 0),
    MVX(0xc0002003, "TODO_c000_2003", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002004, "TODO_c000_2004", UINT64_C(0x2300000035), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002005, "TODO_c000_2005", UINT64_C(0xb000000000), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002006, "TODO_c000_2006", 0, UINT64_C(0xffffff8000000000), 0),
    MVI(0xc0002007, "TODO_c000_2007", 0),
    MVX(0xc0002008, "TODO_c000_2008", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc0002009, "TODO_c000_2009", 0, 0, 0),
    MVI(0xc000200a, "TODO_c000_200a", 0),
    MVI(0xc000200b, "TODO_c000_200b", 0),
    MVI(0xc000200c, "TODO_c000_200c", 0),
    MVI(0xc000200d, "TODO_c000_200d", 0),
    MVI(0xc000200e, "TODO_c000_200e", 0),
    MVI(0xc000200f, "TODO_c000_200f", 0),
    MVX(0xc0002010, "TODO_c000_2010", 0x3fff, UINT64_C(0xffffffffffffc000), 0),
    MVX(0xc0002011, "TODO_c000_2011", 0, 0, UINT64_MAX),
    MVX(0xc0002012, "TODO_c000_2012", 0, 0, 0),
    MVX(0xc0002013, "TODO_c000_2013", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002014, "TODO_c000_2014", UINT64_C(0x2300000031), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002015, "TODO_c000_2015", UINT64_C(0x100b000000000), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002016, "TODO_c000_2016", 0, UINT64_C(0xfffffffe00000000), 0),
    MVI(0xc0002017, "TODO_c000_2017", 0),
    MVI(0xc0002018, "TODO_c000_2018", 0),
    MVI(0xc0002019, "TODO_c000_2019", 0),
    MVI(0xc000201a, "TODO_c000_201a", 0),
    MVI(0xc000201b, "TODO_c000_201b", 0),
    MVI(0xc000201c, "TODO_c000_201c", 0),
    MVI(0xc000201d, "TODO_c000_201d", 0),
    MVI(0xc000201e, "TODO_c000_201e", 0),
    MVI(0xc000201f, "TODO_c000_201f", 0),
    MVX(0xc0002020, "TODO_c000_2020", 0xf, UINT64_C(0xfffffffffffffff0), 0),
    MVX(0xc0002021, "TODO_c000_2021", 0, 0, UINT64_MAX),
    MVX(0xc0002022, "TODO_c000_2022", 0, 0, 0),
    MVX(0xc0002023, "TODO_c000_2023", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002024, "TODO_c000_2024", UINT64_C(0x2100000037), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002025, "TODO_c000_2025", UINT64_C(0x200b000000000), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002026, "TODO_c000_2026", 0, UINT64_C(0xfffe000000000000), 0),
    MVI(0xc0002027, "TODO_c000_2027", 0),
    MVX(0xc0002028, "TODO_c000_2028", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc0002029, "TODO_c000_2029", 0, 0, 0),
    MVI(0xc000202a, "TODO_c000_202a", 0),
    MVI(0xc000202b, "TODO_c000_202b", 0),
    MVI(0xc000202c, "TODO_c000_202c", 0),
    MVI(0xc000202d, "TODO_c000_202d", 0),
    MVI(0xc000202e, "TODO_c000_202e", 0),
    MVI(0xc000202f, "TODO_c000_202f", 0),
    MVX(0xc0002030, "TODO_c000_2030", 0x1ff, UINT64_C(0xfffffffffffffe00), 0),
    MVX(0xc0002031, "TODO_c000_2031", 0, 0, UINT64_MAX),
    MVX(0xc0002032, "TODO_c000_2032", 0, 0, 0),
    MVX(0xc0002033, "TODO_c000_2033", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002034, "TODO_c000_2034", UINT64_C(0x2300000031), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002035, "TODO_c000_2035", UINT64_C(0x300b000000000), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002036, "TODO_c000_2036", 0, UINT64_C(0xfffffffe00000000), 0),
    MVI(0xc0002037, "TODO_c000_2037", 0),
    MVI(0xc0002038, "TODO_c000_2038", 0),
    MVI(0xc0002039, "TODO_c000_2039", 0),
    MVI(0xc000203a, "TODO_c000_203a", 0),
    MVI(0xc000203b, "TODO_c000_203b", 0),
    MVI(0xc000203c, "TODO_c000_203c", 0),
    MVI(0xc000203d, "TODO_c000_203d", 0),
    MVI(0xc000203e, "TODO_c000_203e", 0),
    MVI(0xc000203f, "TODO_c000_203f", 0),
    MVI(0xc0002040, "TODO_c000_2040", 0),
    MVX(0xc0002041, "TODO_c000_2041", 0, 0, UINT64_MAX),
    MVI(0xc0002042, "TODO_c000_2042", 0),
    MVI(0xc0002043, "TODO_c000_2043", 0),
    MVI(0xc0002044, "TODO_c000_2044", 0),
    MVI(0xc0002045, "TODO_c000_2045", 0),
    MVI(0xc0002046, "TODO_c000_2046", 0),
    MVI(0xc0002047, "TODO_c000_2047", 0),
    MVI(0xc0002048, "TODO_c000_2048", 0),
    MVI(0xc0002049, "TODO_c000_2049", 0),
    MVI(0xc000204a, "TODO_c000_204a", 0),
    MVI(0xc000204b, "TODO_c000_204b", 0),
    MVI(0xc000204c, "TODO_c000_204c", 0),
    MVI(0xc000204d, "TODO_c000_204d", 0),
    MVI(0xc000204e, "TODO_c000_204e", 0),
    MVI(0xc000204f, "TODO_c000_204f", 0),
    MVX(0xc0002050, "TODO_c000_2050", 0x7ff, UINT64_C(0xfffffffffffff800), 0),
    MVX(0xc0002051, "TODO_c000_2051", 0, 0, UINT64_MAX),
    MVX(0xc0002052, "TODO_c000_2052", 0, 0, 0),
    MVX(0xc0002053, "TODO_c000_2053", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002054, "TODO_c000_2054", UINT64_C(0x2300000031), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002055, "TODO_c000_2055", UINT64_C(0x500b000000000), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002056, "TODO_c000_2056", 0, UINT64_C(0xfffffffe00000000), 0),
    MVI(0xc0002057, "TODO_c000_2057", 0),
    MVI(0xc0002058, "TODO_c000_2058", 0),
    MVI(0xc0002059, "TODO_c000_2059", 0),
    MVI(0xc000205a, "TODO_c000_205a", 0),
    MVI(0xc000205b, "TODO_c000_205b", 0),
    MVI(0xc000205c, "TODO_c000_205c", 0),
    MVI(0xc000205d, "TODO_c000_205d", 0),
    MVI(0xc000205e, "TODO_c000_205e", 0),
    MVI(0xc000205f, "TODO_c000_205f", 0),
    MVX(0xc0002060, "TODO_c000_2060", 0x7f, UINT64_C(0xffffffffffffff80), 0),
    MVX(0xc0002061, "TODO_c000_2061", 0, 0, UINT64_MAX),
    MVI(0xc0002062, "TODO_c000_2062", 0),
    MVX(0xc0002063, "TODO_c000_2063", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002064, "TODO_c000_2064", UINT64_C(0x2300000031), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002065, "TODO_c000_2065", UINT64_C(0x600b000000000), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002066, "TODO_c000_2066", 0, UINT64_C(0xfffffffe00000000), 0),
    MVI(0xc0002067, "TODO_c000_2067", 0),
    MVI(0xc0002068, "TODO_c000_2068", 0),
    MVI(0xc0002069, "TODO_c000_2069", 0),
    MVI(0xc000206a, "TODO_c000_206a", 0),
    MVI(0xc000206b, "TODO_c000_206b", 0),
    MVI(0xc000206c, "TODO_c000_206c", 0),
    MVI(0xc000206d, "TODO_c000_206d", 0),
    MVI(0xc000206e, "TODO_c000_206e", 0),
    MVI(0xc000206f, "TODO_c000_206f", 0),
    MVX(0xc0002070, "TODO_c000_2070", 0xff, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc0002071, "TODO_c000_2071", 0, 0, UINT64_MAX),
    MVX(0xc0002072, "TODO_c000_2072", 0, 0, 0),
    MVX(0xc0002073, "TODO_c000_2073", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002074, "TODO_c000_2074", UINT64_C(0x2100000037), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002075, "TODO_c000_2075", UINT64_C(0x700b018090100), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002076, "TODO_c000_2076", 0, UINT64_C(0xfffe000000000000), 0),
    MVI(0xc0002077, "TODO_c000_2077", 0),
    MVX(0xc0002078, "TODO_c000_2078", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc0002079, "TODO_c000_2079", 0, 0, 0),
    MVI(0xc000207a, "TODO_c000_207a", 0),
    MVI(0xc000207b, "TODO_c000_207b", 0),
    MVI(0xc000207c, "TODO_c000_207c", 0),
    MVI(0xc000207d, "TODO_c000_207d", 0),
    MVI(0xc000207e, "TODO_c000_207e", 0),
    MVI(0xc000207f, "TODO_c000_207f", 0),
    MVX(0xc0002080, "TODO_c000_2080", 0xff, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc0002081, "TODO_c000_2081", 0, 0, UINT64_MAX),
    MVX(0xc0002082, "TODO_c000_2082", 0, 0, 0),
    MVX(0xc0002083, "TODO_c000_2083", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002084, "TODO_c000_2084", UINT64_C(0x2100000037), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002085, "TODO_c000_2085", UINT64_C(0x700b018090200), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002086, "TODO_c000_2086", 0, UINT64_C(0xfffe000000000000), 0),
    MVI(0xc0002087, "TODO_c000_2087", 0),
    MVX(0xc0002088, "TODO_c000_2088", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc0002089, "TODO_c000_2089", 0, 0, 0),
    MVI(0xc000208a, "TODO_c000_208a", 0),
    MVI(0xc000208b, "TODO_c000_208b", 0),
    MVI(0xc000208c, "TODO_c000_208c", 0),
    MVI(0xc000208d, "TODO_c000_208d", 0),
    MVI(0xc000208e, "TODO_c000_208e", 0),
    MVI(0xc000208f, "TODO_c000_208f", 0),
    MVX(0xc0002090, "TODO_c000_2090", 0xff, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc0002091, "TODO_c000_2091", 0, 0, UINT64_MAX),
    MVX(0xc0002092, "TODO_c000_2092", 0, 0, 0),
    MVX(0xc0002093, "TODO_c000_2093", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002094, "TODO_c000_2094", UINT64_C(0x2100000037), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002095, "TODO_c000_2095", UINT64_C(0x700b018090300), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002096, "TODO_c000_2096", 0, UINT64_C(0xfffe000000000000), 0),
    MVI(0xc0002097, "TODO_c000_2097", 0),
    MVX(0xc0002098, "TODO_c000_2098", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc0002099, "TODO_c000_2099", 0, 0, 0),
    MVI(0xc000209a, "TODO_c000_209a", 0),
    MVI(0xc000209b, "TODO_c000_209b", 0),
    MVI(0xc000209c, "TODO_c000_209c", 0),
    MVI(0xc000209d, "TODO_c000_209d", 0),
    MVI(0xc000209e, "TODO_c000_209e", 0),
    MVI(0xc000209f, "TODO_c000_209f", 0),
    MVX(0xc00020a0, "TODO_c000_20a0", 0xff, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc00020a1, "TODO_c000_20a1", 0, 0, UINT64_MAX),
    MVX(0xc00020a2, "TODO_c000_20a2", 0, 0, 0),
    MVX(0xc00020a3, "TODO_c000_20a3", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc00020a4, "TODO_c000_20a4", UINT64_C(0x2100000037), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc00020a5, "TODO_c000_20a5", UINT64_C(0x700b018090400), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc00020a6, "TODO_c000_20a6", 0, UINT64_C(0xfffe000000000000), 0),
    MVI(0xc00020a7, "TODO_c000_20a7", 0),
    MVX(0xc00020a8, "TODO_c000_20a8", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc00020a9, "TODO_c000_20a9", 0, 0, 0),
    MVI(0xc00020aa, "TODO_c000_20aa", 0),
    MVI(0xc00020ab, "TODO_c000_20ab", 0),
    MVI(0xc00020ac, "TODO_c000_20ac", 0),
    MVI(0xc00020ad, "TODO_c000_20ad", 0),
    MVI(0xc00020ae, "TODO_c000_20ae", 0),
    MVI(0xc00020af, "TODO_c000_20af", 0),
    MVX(0xc00020b0, "TODO_c000_20b0", 0xff, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc00020b1, "TODO_c000_20b1", 0, 0, UINT64_MAX),
    MVX(0xc00020b2, "TODO_c000_20b2", 0, 0, 0),
    MVX(0xc00020b3, "TODO_c000_20b3", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc00020b4, "TODO_c000_20b4", UINT64_C(0x2100000037), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc00020b5, "TODO_c000_20b5", UINT64_C(0x700b018490100), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc00020b6, "TODO_c000_20b6", 0, UINT64_C(0xfffe000000000000), 0),
    MVI(0xc00020b7, "TODO_c000_20b7", 0),
    MVX(0xc00020b8, "TODO_c000_20b8", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc00020b9, "TODO_c000_20b9", 0, 0, 0),
    MVI(0xc00020ba, "TODO_c000_20ba", 0),
    MVI(0xc00020bb, "TODO_c000_20bb", 0),
    MVI(0xc00020bc, "TODO_c000_20bc", 0),
    MVI(0xc00020bd, "TODO_c000_20bd", 0),
    MVI(0xc00020be, "TODO_c000_20be", 0),
    MVI(0xc00020bf, "TODO_c000_20bf", 0),
    MVX(0xc00020c0, "TODO_c000_20c0", 0xff, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc00020c1, "TODO_c000_20c1", 0, 0, UINT64_MAX),
    MVX(0xc00020c2, "TODO_c000_20c2", 0, 0, 0),
    MVX(0xc00020c3, "TODO_c000_20c3", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc00020c4, "TODO_c000_20c4", UINT64_C(0x2100000037), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc00020c5, "TODO_c000_20c5", UINT64_C(0x700b018490200), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc00020c6, "TODO_c000_20c6", 0, UINT64_C(0xfffe000000000000), 0),
    MVI(0xc00020c7, "TODO_c000_20c7", 0),
    MVX(0xc00020c8, "TODO_c000_20c8", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc00020c9, "TODO_c000_20c9", 0, 0, 0),
    MVI(0xc00020ca, "TODO_c000_20ca", 0),
    MVI(0xc00020cb, "TODO_c000_20cb", 0),
    MVI(0xc00020cc, "TODO_c000_20cc", 0),
    MVI(0xc00020cd, "TODO_c000_20cd", 0),
    MVI(0xc00020ce, "TODO_c000_20ce", 0),
    MVI(0xc00020cf, "TODO_c000_20cf", 0),
    MVX(0xc00020d0, "TODO_c000_20d0", 0xff, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc00020d1, "TODO_c000_20d1", 0, 0, UINT64_MAX),
    MVX(0xc00020d2, "TODO_c000_20d2", 0, 0, 0),
    MVX(0xc00020d3, "TODO_c000_20d3", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc00020d4, "TODO_c000_20d4", UINT64_C(0x2100000037), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc00020d5, "TODO_c000_20d5", UINT64_C(0x700b018490300), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc00020d6, "TODO_c000_20d6", 0, UINT64_C(0xfffe000000000000), 0),
    MVI(0xc00020d7, "TODO_c000_20d7", 0),
    MVX(0xc00020d8, "TODO_c000_20d8", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc00020d9, "TODO_c000_20d9", 0, 0, 0),
    MVI(0xc00020da, "TODO_c000_20da", 0),
    MVI(0xc00020db, "TODO_c000_20db", 0),
    MVI(0xc00020dc, "TODO_c000_20dc", 0),
    MVI(0xc00020dd, "TODO_c000_20dd", 0),
    MVI(0xc00020de, "TODO_c000_20de", 0),
    MVI(0xc00020df, "TODO_c000_20df", 0),
    MVX(0xc00020e0, "TODO_c000_20e0", 0xff, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc00020e1, "TODO_c000_20e1", 0, 0, UINT64_MAX),
    MVX(0xc00020e2, "TODO_c000_20e2", 0, 0, 0),
    MVX(0xc00020e3, "TODO_c000_20e3", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc00020e4, "TODO_c000_20e4", UINT64_C(0x2100000037), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc00020e5, "TODO_c000_20e5", UINT64_C(0x700b018490400), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc00020e6, "TODO_c000_20e6", 0, UINT64_C(0xfffe000000000000), 0),
    MVI(0xc00020e7, "TODO_c000_20e7", 0),
    MVX(0xc00020e8, "TODO_c000_20e8", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc00020e9, "TODO_c000_20e9", 0, 0, 0),
    MVI(0xc00020ea, "TODO_c000_20ea", 0),
    MVI(0xc00020eb, "TODO_c000_20eb", 0),
    MVI(0xc00020ec, "TODO_c000_20ec", 0),
    MVI(0xc00020ed, "TODO_c000_20ed", 0),
    MVI(0xc00020ee, "TODO_c000_20ee", 0),
    MVI(0xc00020ef, "TODO_c000_20ef", 0),
    MVX(0xc00020f0, "TODO_c000_20f0", 0x3f, UINT64_C(0xffffffffffffffc0), 0),
    MVX(0xc00020f1, "TODO_c000_20f1", 0, 0, UINT64_MAX),
    MVX(0xc00020f2, "TODO_c000_20f2", 0, 0, 0),
    MVX(0xc00020f3, "TODO_c000_20f3", UINT64_C(0xd01a000001000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc00020f4, "TODO_c000_20f4", UINT64_C(0x2300000035), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc00020f5, "TODO_c000_20f5", UINT64_C(0x9600050f00), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc00020f6, "TODO_c000_20f6", 0, UINT64_C(0xffff000000000000), 0),
    MVI(0xc00020f7, "TODO_c000_20f7", 0),
    MVX(0xc00020f8, "TODO_c000_20f8", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc00020f9, "TODO_c000_20f9", 0, 0, 0),
    MVX(0xc00020fa, "TODO_c000_20fa", UINT64_C(0xd00a000000000000), UINT64_C(0xff0f00000ffffff), 0),
    MVI(0xc00020fb, "TODO_c000_20fb", 0),
    MVI(0xc00020fc, "TODO_c000_20fc", 0),
    MVI(0xc00020fd, "TODO_c000_20fd", 0),
    MVI(0xc00020fe, "TODO_c000_20fe", 0),
    MVI(0xc00020ff, "TODO_c000_20ff", 0),
    MVX(0xc0002100, "TODO_c000_2100", 0x3f, UINT64_C(0xffffffffffffffc0), 0),
    MVX(0xc0002101, "TODO_c000_2101", 0, 0, UINT64_MAX),
    MVX(0xc0002102, "TODO_c000_2102", 0, 0, 0),
    MVX(0xc0002103, "TODO_c000_2103", UINT64_C(0xd01a000001000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002104, "TODO_c000_2104", UINT64_C(0x2300000035), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002105, "TODO_c000_2105", UINT64_C(0x9600150f00), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002106, "TODO_c000_2106", 0, UINT64_C(0xffff000000000000), 0),
    MVI(0xc0002107, "TODO_c000_2107", 0),
    MVX(0xc0002108, "TODO_c000_2108", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc0002109, "TODO_c000_2109", 0, 0, 0),
    MVX(0xc000210a, "TODO_c000_210a", UINT64_C(0xd00a000000000000), UINT64_C(0xff0f00000ffffff), 0),
    MVI(0xc000210b, "TODO_c000_210b", 0),
    MVI(0xc000210c, "TODO_c000_210c", 0),
    MVI(0xc000210d, "TODO_c000_210d", 0),
    MVI(0xc000210e, "TODO_c000_210e", 0),
    MVI(0xc000210f, "TODO_c000_210f", 0),
    MVX(0xc0002110, "TODO_c000_2110", 0x1, UINT64_C(0xfffffffffffffffe), 0),
    MVX(0xc0002111, "TODO_c000_2111", 0, 0, UINT64_MAX),
    MVI(0xc0002112, "TODO_c000_2112", 0),
    MVX(0xc0002113, "TODO_c000_2113", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002114, "TODO_c000_2114", UINT64_C(0x2300000031), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002115, "TODO_c000_2115", UINT64_C(0x103b30400), ~(uint64_t)UINT32_MAX, 0),
    MVI(0xc0002116, "TODO_c000_2116", 0),
    MVI(0xc0002117, "TODO_c000_2117", 0),
    MVI(0xc0002118, "TODO_c000_2118", 0),
    MVI(0xc0002119, "TODO_c000_2119", 0),
    MVI(0xc000211a, "TODO_c000_211a", 0),
    MVI(0xc000211b, "TODO_c000_211b", 0),
    MVI(0xc000211c, "TODO_c000_211c", 0),
    MVI(0xc000211d, "TODO_c000_211d", 0),
    MVI(0xc000211e, "TODO_c000_211e", 0),
    MVI(0xc000211f, "TODO_c000_211f", 0),
    MVX(0xc0002120, "TODO_c000_2120", 0x1, UINT64_C(0xfffffffffffffffe), 0),
    MVX(0xc0002121, "TODO_c000_2121", 0, 0, UINT64_MAX),
    MVI(0xc0002122, "TODO_c000_2122", 0),
    MVX(0xc0002123, "TODO_c000_2123", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002124, "TODO_c000_2124", UINT64_C(0x2300000031), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002125, "TODO_c000_2125", UINT64_C(0xff03830400), ~(uint64_t)UINT32_MAX, 0),
    MVI(0xc0002126, "TODO_c000_2126", 0),
    MVI(0xc0002127, "TODO_c000_2127", 0),
    MVI(0xc0002128, "TODO_c000_2128", 0),
    MVI(0xc0002129, "TODO_c000_2129", 0),
    MVI(0xc000212a, "TODO_c000_212a", 0),
    MVI(0xc000212b, "TODO_c000_212b", 0),
    MVI(0xc000212c, "TODO_c000_212c", 0),
    MVI(0xc000212d, "TODO_c000_212d", 0),
    MVI(0xc000212e, "TODO_c000_212e", 0),
    MVI(0xc000212f, "TODO_c000_212f", 0),
    MVX(0xc0002130, "TODO_c000_2130", 0x1, UINT64_C(0xfffffffffffffffe), 0),
    MVX(0xc0002131, "TODO_c000_2131", 0, 0, UINT64_MAX),
    MVI(0xc0002132, "TODO_c000_2132", 0),
    MVX(0xc0002133, "TODO_c000_2133", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002134, "TODO_c000_2134", UINT64_C(0x2300000031), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002135, "TODO_c000_2135", UINT64_C(0x500000000), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002136, "TODO_c000_2136", 0, UINT64_C(0xfffffffe00000000), 0),
    MVI(0xc0002137, "TODO_c000_2137", 0),
    MVI(0xc0002138, "TODO_c000_2138", 0),
    MVI(0xc0002139, "TODO_c000_2139", 0),
    MVI(0xc000213a, "TODO_c000_213a", 0),
    MVI(0xc000213b, "TODO_c000_213b", 0),
    MVI(0xc000213c, "TODO_c000_213c", 0),
    MVI(0xc000213d, "TODO_c000_213d", 0),
    MVI(0xc000213e, "TODO_c000_213e", 0),
    MVI(0xc000213f, "TODO_c000_213f", 0),
    MVX(0xc0002140, "TODO_c000_2140", 0x1ff, UINT64_C(0xfffffffffffffe00), 0),
    MVX(0xc0002141, "TODO_c000_2141", 0, 0, UINT64_MAX),
    MVX(0xc0002142, "TODO_c000_2142", 0, 0, 0),
    MVX(0xc0002143, "TODO_c000_2143", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002144, "TODO_c000_2144", UINT64_C(0x2100000037), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002145, "TODO_c000_2145", UINT64_C(0x2e00000000), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002146, "TODO_c000_2146", 0, UINT64_C(0xfffffe0000000000), 0),
    MVI(0xc0002147, "TODO_c000_2147", 0),
    MVX(0xc0002148, "TODO_c000_2148", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc0002149, "TODO_c000_2149", 0, 0, 0),
    MVI(0xc000214a, "TODO_c000_214a", 0),
    MVI(0xc000214b, "TODO_c000_214b", 0),
    MVI(0xc000214c, "TODO_c000_214c", 0),
    MVI(0xc000214d, "TODO_c000_214d", 0),
    MVI(0xc000214e, "TODO_c000_214e", 0),
    MVI(0xc000214f, "TODO_c000_214f", 0),
    MVX(0xc0002150, "TODO_c000_2150", 0x1ff, UINT64_C(0xfffffffffffffe00), 0),
    MVX(0xc0002151, "TODO_c000_2151", 0, 0, UINT64_MAX),
    MVX(0xc0002152, "TODO_c000_2152", 0, 0, 0),
    MVX(0xc0002153, "TODO_c000_2153", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002154, "TODO_c000_2154", UINT64_C(0x2100000037), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002155, "TODO_c000_2155", UINT64_C(0x2e00000001), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002156, "TODO_c000_2156", 0, UINT64_C(0xfffffe0000000000), 0),
    MVI(0xc0002157, "TODO_c000_2157", 0),
    MVX(0xc0002158, "TODO_c000_2158", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVX(0xc0002159, "TODO_c000_2159", 0, 0, 0),
    MVI(0xc000215a, "TODO_c000_215a", 0),
    MVI(0xc000215b, "TODO_c000_215b", 0),
    MVI(0xc000215c, "TODO_c000_215c", 0),
    MVI(0xc000215d, "TODO_c000_215d", 0),
    MVI(0xc000215e, "TODO_c000_215e", 0),
    MVI(0xc000215f, "TODO_c000_215f", 0),
    MVX(0xc0002160, "TODO_c000_2160", 0xf, UINT64_C(0xfffffffffffffff0), 0),
    MVX(0xc0002161, "TODO_c000_2161", 0, 0, UINT64_MAX),
    MVI(0xc0002162, "TODO_c000_2162", 0),
    MVX(0xc0002163, "TODO_c000_2163", UINT64_C(0xd01a000000000000), UINT64_C(0xef00f00000ffffff), 0),
    MVX(0xc0002164, "TODO_c000_2164", UINT64_C(0x2300000035), UINT64_C(0xffffff80ffffffff), 0),
    MVX(0xc0002165, "TODO_c000_2165", UINT64_C(0x1002e00000002), ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0002166, "TODO_c000_2166", 0, UINT64_C(0xfffffffe00000000), 0),
    MVI(0xc0002167, "TODO_c000_2167", 0),
    MVX(0xc0002168, "TODO_c000_2168", 0, UINT64_C(0x3bdfefffffffffff), 0),
    MVI(0xc0002169, "TODO_c000_2169", 0),
    MVI(0xc000216a, "TODO_c000_216a", 0),
    MVI(0xc000216b, "TODO_c000_216b", 0),
    MVI(0xc000216c, "TODO_c000_216c", 0),
    MVI(0xc000216d, "TODO_c000_216d", 0),
    MVI(0xc000216e, "TODO_c000_216e", 0),
    MVI(0xc000216f, "TODO_c000_216f", 0),
    MVI(0xc0002170, "TODO_c000_2170", 0),
    MVI(0xc0002171, "TODO_c000_2171", 0),
    MVI(0xc0002172, "TODO_c000_2172", 0),
    MVI(0xc0002173, "TODO_c000_2173", 0),
    MVI(0xc0002174, "TODO_c000_2174", 0),
    MVI(0xc0002175, "TODO_c000_2175", 0),
    MVI(0xc0002176, "TODO_c000_2176", 0),
    MVI(0xc0002177, "TODO_c000_2177", 0),
    MVI(0xc0002178, "TODO_c000_2178", 0),
    MVI(0xc0002179, "TODO_c000_2179", 0),
    MVI(0xc000217a, "TODO_c000_217a", 0),
    MVI(0xc000217b, "TODO_c000_217b", 0),
    MVI(0xc000217c, "TODO_c000_217c", 0),
    MVI(0xc000217d, "TODO_c000_217d", 0),
    MVI(0xc000217e, "TODO_c000_217e", 0),
    MVI(0xc000217f, "TODO_c000_217f", 0),
    MVI(0xc0002180, "TODO_c000_2180", 0),
    MVI(0xc0002181, "TODO_c000_2181", 0),
    MVI(0xc0002182, "TODO_c000_2182", 0),
    MVI(0xc0002183, "TODO_c000_2183", 0),
    MVI(0xc0002184, "TODO_c000_2184", 0),
    MVI(0xc0002185, "TODO_c000_2185", 0),
    MVI(0xc0002186, "TODO_c000_2186", 0),
    MVI(0xc0002187, "TODO_c000_2187", 0),
    MVI(0xc0002188, "TODO_c000_2188", 0),
    MVI(0xc0002189, "TODO_c000_2189", 0),
    MVI(0xc000218a, "TODO_c000_218a", 0),
    MVI(0xc000218b, "TODO_c000_218b", 0),
    MVI(0xc000218c, "TODO_c000_218c", 0),
    MVI(0xc000218d, "TODO_c000_218d", 0),
    MVI(0xc000218e, "TODO_c000_218e", 0),
    MVI(0xc000218f, "TODO_c000_218f", 0),
    MVI(0xc0002190, "TODO_c000_2190", 0),
    MVI(0xc0002191, "TODO_c000_2191", 0),
    MVI(0xc0002192, "TODO_c000_2192", 0),
    MVI(0xc0002193, "TODO_c000_2193", 0),
    MVI(0xc0002194, "TODO_c000_2194", 0),
    MVI(0xc0002195, "TODO_c000_2195", 0),
    MVI(0xc0002196, "TODO_c000_2196", 0),
    MVI(0xc0002197, "TODO_c000_2197", 0),
    MVI(0xc0002198, "TODO_c000_2198", 0),
    MVI(0xc0002199, "TODO_c000_2199", 0),
    MVI(0xc000219a, "TODO_c000_219a", 0),
    MVI(0xc000219b, "TODO_c000_219b", 0),
    MVI(0xc000219c, "TODO_c000_219c", 0),
    MVI(0xc000219d, "TODO_c000_219d", 0),
    MVI(0xc000219e, "TODO_c000_219e", 0),
    MVI(0xc000219f, "TODO_c000_219f", 0),
    MVI(0xc00021a0, "TODO_c000_21a0", 0),
    MVI(0xc00021a1, "TODO_c000_21a1", 0),
    MVI(0xc00021a2, "TODO_c000_21a2", 0),
    MVI(0xc00021a3, "TODO_c000_21a3", 0),
    MVI(0xc00021a4, "TODO_c000_21a4", 0),
    MVI(0xc00021a5, "TODO_c000_21a5", 0),
    MVI(0xc00021a6, "TODO_c000_21a6", 0),
    MVI(0xc00021a7, "TODO_c000_21a7", 0),
    MVI(0xc00021a8, "TODO_c000_21a8", 0),
    MVI(0xc00021a9, "TODO_c000_21a9", 0),
    MVI(0xc00021aa, "TODO_c000_21aa", 0),
    MVI(0xc00021ab, "TODO_c000_21ab", 0),
    MVI(0xc00021ac, "TODO_c000_21ac", 0),
    MVI(0xc00021ad, "TODO_c000_21ad", 0),
    MVI(0xc00021ae, "TODO_c000_21ae", 0),
    MVI(0xc00021af, "TODO_c000_21af", 0),
    MVI(0xc00021b0, "TODO_c000_21b0", 0),
    MVI(0xc00021b1, "TODO_c000_21b1", 0),
    MVI(0xc00021b2, "TODO_c000_21b2", 0),
    MVI(0xc00021b3, "TODO_c000_21b3", 0),
    MVI(0xc00021b4, "TODO_c000_21b4", 0),
    MVI(0xc00021b5, "TODO_c000_21b5", 0),
    MVI(0xc00021b6, "TODO_c000_21b6", 0),
    MVI(0xc00021b7, "TODO_c000_21b7", 0),
    MVI(0xc00021b8, "TODO_c000_21b8", 0),
    MVI(0xc00021b9, "TODO_c000_21b9", 0),
    MVI(0xc00021ba, "TODO_c000_21ba", 0),
    MVI(0xc00021bb, "TODO_c000_21bb", 0),
    MVI(0xc00021bc, "TODO_c000_21bc", 0),
    MVI(0xc00021bd, "TODO_c000_21bd", 0),
    MVI(0xc00021be, "TODO_c000_21be", 0),
    MVI(0xc00021bf, "TODO_c000_21bf", 0),
    MVI(0xc00021c0, "TODO_c000_21c0", 0),
    MVI(0xc00021c1, "TODO_c000_21c1", 0),
    MVI(0xc00021c2, "TODO_c000_21c2", 0),
    MVI(0xc00021c3, "TODO_c000_21c3", 0),
    MVI(0xc00021c4, "TODO_c000_21c4", 0),
    MVI(0xc00021c5, "TODO_c000_21c5", 0),
    MVI(0xc00021c6, "TODO_c000_21c6", 0),
    MVI(0xc00021c7, "TODO_c000_21c7", 0),
    MVI(0xc00021c8, "TODO_c000_21c8", 0),
    MVI(0xc00021c9, "TODO_c000_21c9", 0),
    MVI(0xc00021ca, "TODO_c000_21ca", 0),
    MVI(0xc00021cb, "TODO_c000_21cb", 0),
    MVI(0xc00021cc, "TODO_c000_21cc", 0),
    MVI(0xc00021cd, "TODO_c000_21cd", 0),
    MVI(0xc00021ce, "TODO_c000_21ce", 0),
    MVI(0xc00021cf, "TODO_c000_21cf", 0),
    MVI(0xc00021d0, "TODO_c000_21d0", 0),
    MVI(0xc00021d1, "TODO_c000_21d1", 0),
    MVI(0xc00021d2, "TODO_c000_21d2", 0),
    MVI(0xc00021d3, "TODO_c000_21d3", 0),
    MVI(0xc00021d4, "TODO_c000_21d4", 0),
    MVI(0xc00021d5, "TODO_c000_21d5", 0),
    MVI(0xc00021d6, "TODO_c000_21d6", 0),
    MVI(0xc00021d7, "TODO_c000_21d7", 0),
    MVI(0xc00021d8, "TODO_c000_21d8", 0),
    MVI(0xc00021d9, "TODO_c000_21d9", 0),
    MVI(0xc00021da, "TODO_c000_21da", 0),
    MVI(0xc00021db, "TODO_c000_21db", 0),
    MVI(0xc00021dc, "TODO_c000_21dc", 0),
    MVI(0xc00021dd, "TODO_c000_21dd", 0),
    MVI(0xc00021de, "TODO_c000_21de", 0),
    MVI(0xc00021df, "TODO_c000_21df", 0),
    MVI(0xc00021e0, "TODO_c000_21e0", 0),
    MVI(0xc00021e1, "TODO_c000_21e1", 0),
    MVI(0xc00021e2, "TODO_c000_21e2", 0),
    MVI(0xc00021e3, "TODO_c000_21e3", 0),
    MVI(0xc00021e4, "TODO_c000_21e4", 0),
    MVI(0xc00021e5, "TODO_c000_21e5", 0),
    MVI(0xc00021e6, "TODO_c000_21e6", 0),
    MVI(0xc00021e7, "TODO_c000_21e7", 0),
    MVI(0xc00021e8, "TODO_c000_21e8", 0),
    MVI(0xc00021e9, "TODO_c000_21e9", 0),
    MVI(0xc00021ea, "TODO_c000_21ea", 0),
    MVI(0xc00021eb, "TODO_c000_21eb", 0),
    MVI(0xc00021ec, "TODO_c000_21ec", 0),
    MVI(0xc00021ed, "TODO_c000_21ed", 0),
    MVI(0xc00021ee, "TODO_c000_21ee", 0),
    MVI(0xc00021ef, "TODO_c000_21ef", 0),
    MVI(0xc00021f0, "TODO_c000_21f0", 0),
    MVI(0xc00021f1, "TODO_c000_21f1", 0),
    MVI(0xc00021f2, "TODO_c000_21f2", 0),
    MVI(0xc00021f3, "TODO_c000_21f3", 0),
    MVI(0xc00021f4, "TODO_c000_21f4", 0),
    MVI(0xc00021f5, "TODO_c000_21f5", 0),
    MVI(0xc00021f6, "TODO_c000_21f6", 0),
    MVI(0xc00021f7, "TODO_c000_21f7", 0),
    MVI(0xc00021f8, "TODO_c000_21f8", 0),
    MVI(0xc00021f9, "TODO_c000_21f9", 0),
    MVI(0xc00021fa, "TODO_c000_21fa", 0),
    MVI(0xc00021fb, "TODO_c000_21fb", 0),
    MVI(0xc00021fc, "TODO_c000_21fc", 0),
    MVI(0xc00021fd, "TODO_c000_21fd", 0),
    MVI(0xc00021fe, "TODO_c000_21fe", 0),
    MVI(0xc00021ff, "TODO_c000_21ff", 0),
    MVI(0xc0002200, "TODO_c000_2200", 0),
    MVI(0xc0002201, "TODO_c000_2201", 0),
    MVI(0xc0002202, "TODO_c000_2202", 0),
    MVI(0xc0002203, "TODO_c000_2203", 0),
    MVI(0xc0002204, "TODO_c000_2204", 0),
    MVI(0xc0002205, "TODO_c000_2205", 0),
    MVI(0xc0002206, "TODO_c000_2206", 0),
    MVI(0xc0002207, "TODO_c000_2207", 0),
    MVI(0xc0002208, "TODO_c000_2208", 0),
    MVI(0xc0002209, "TODO_c000_2209", 0),
    MVI(0xc000220a, "TODO_c000_220a", 0),
    MVI(0xc000220b, "TODO_c000_220b", 0),
    MVI(0xc000220c, "TODO_c000_220c", 0),
    MVI(0xc000220d, "TODO_c000_220d", 0),
    MVI(0xc000220e, "TODO_c000_220e", 0),
    MVI(0xc000220f, "TODO_c000_220f", 0),
    MVI(0xc0002210, "TODO_c000_2210", 0),
    MVI(0xc0002211, "TODO_c000_2211", 0),
    MVI(0xc0002212, "TODO_c000_2212", 0),
    MVI(0xc0002213, "TODO_c000_2213", 0),
    MVI(0xc0002214, "TODO_c000_2214", 0),
    MVI(0xc0002215, "TODO_c000_2215", 0),
    MVI(0xc0002216, "TODO_c000_2216", 0),
    MVI(0xc0002217, "TODO_c000_2217", 0),
    MVI(0xc0002218, "TODO_c000_2218", 0),
    MVI(0xc0002219, "TODO_c000_2219", 0),
    MVI(0xc000221a, "TODO_c000_221a", 0),
    MVI(0xc000221b, "TODO_c000_221b", 0),
    MVI(0xc000221c, "TODO_c000_221c", 0),
    MVI(0xc000221d, "TODO_c000_221d", 0),
    MVI(0xc000221e, "TODO_c000_221e", 0),
    MVI(0xc000221f, "TODO_c000_221f", 0),
    MVI(0xc0002220, "TODO_c000_2220", 0),
    MVI(0xc0002221, "TODO_c000_2221", 0),
    MVI(0xc0002222, "TODO_c000_2222", 0),
    MVI(0xc0002223, "TODO_c000_2223", 0),
    MVI(0xc0002224, "TODO_c000_2224", 0),
    MVI(0xc0002225, "TODO_c000_2225", 0),
    MVI(0xc0002226, "TODO_c000_2226", 0),
    MVI(0xc0002227, "TODO_c000_2227", 0),
    MVI(0xc0002228, "TODO_c000_2228", 0),
    MVI(0xc0002229, "TODO_c000_2229", 0),
    MVI(0xc000222a, "TODO_c000_222a", 0),
    MVI(0xc000222b, "TODO_c000_222b", 0),
    MVI(0xc000222c, "TODO_c000_222c", 0),
    MVI(0xc000222d, "TODO_c000_222d", 0),
    MVI(0xc000222e, "TODO_c000_222e", 0),
    MVI(0xc000222f, "TODO_c000_222f", 0),
    MVI(0xc0002230, "TODO_c000_2230", 0),
    MVI(0xc0002231, "TODO_c000_2231", 0),
    MVI(0xc0002232, "TODO_c000_2232", 0),
    MVI(0xc0002233, "TODO_c000_2233", 0),
    MVI(0xc0002234, "TODO_c000_2234", 0),
    MVI(0xc0002235, "TODO_c000_2235", 0),
    MVI(0xc0002236, "TODO_c000_2236", 0),
    MVI(0xc0002237, "TODO_c000_2237", 0),
    MVI(0xc0002238, "TODO_c000_2238", 0),
    MVI(0xc0002239, "TODO_c000_2239", 0),
    MVI(0xc000223a, "TODO_c000_223a", 0),
    MVI(0xc000223b, "TODO_c000_223b", 0),
    MVI(0xc000223c, "TODO_c000_223c", 0),
    MVI(0xc000223d, "TODO_c000_223d", 0),
    MVI(0xc000223e, "TODO_c000_223e", 0),
    MVI(0xc000223f, "TODO_c000_223f", 0),
    MVI(0xc0002240, "TODO_c000_2240", 0),
    MVI(0xc0002241, "TODO_c000_2241", 0),
    MVI(0xc0002242, "TODO_c000_2242", 0),
    MVI(0xc0002243, "TODO_c000_2243", 0),
    MVI(0xc0002244, "TODO_c000_2244", 0),
    MVI(0xc0002245, "TODO_c000_2245", 0),
    MVI(0xc0002246, "TODO_c000_2246", 0),
    MVI(0xc0002247, "TODO_c000_2247", 0),
    MVI(0xc0002248, "TODO_c000_2248", 0),
    MVI(0xc0002249, "TODO_c000_2249", 0),
    MVI(0xc000224a, "TODO_c000_224a", 0),
    MVI(0xc000224b, "TODO_c000_224b", 0),
    MVI(0xc000224c, "TODO_c000_224c", 0),
    MVI(0xc000224d, "TODO_c000_224d", 0),
    MVI(0xc000224e, "TODO_c000_224e", 0),
    MVI(0xc000224f, "TODO_c000_224f", 0),
    MVI(0xc0002250, "TODO_c000_2250", 0),
    MVI(0xc0002251, "TODO_c000_2251", 0),
    MVI(0xc0002252, "TODO_c000_2252", 0),
    MVI(0xc0002253, "TODO_c000_2253", 0),
    MVI(0xc0002254, "TODO_c000_2254", 0),
    MVI(0xc0002255, "TODO_c000_2255", 0),
    MVI(0xc0002256, "TODO_c000_2256", 0),
    MVI(0xc0002257, "TODO_c000_2257", 0),
    MVI(0xc0002258, "TODO_c000_2258", 0),
    MVI(0xc0002259, "TODO_c000_2259", 0),
    MVI(0xc000225a, "TODO_c000_225a", 0),
    MVI(0xc000225b, "TODO_c000_225b", 0),
    MVI(0xc000225c, "TODO_c000_225c", 0),
    MVI(0xc000225d, "TODO_c000_225d", 0),
    MVI(0xc000225e, "TODO_c000_225e", 0),
    MVI(0xc000225f, "TODO_c000_225f", 0),
    MVI(0xc0002260, "TODO_c000_2260", 0),
    MVI(0xc0002261, "TODO_c000_2261", 0),
    MVI(0xc0002262, "TODO_c000_2262", 0),
    MVI(0xc0002263, "TODO_c000_2263", 0),
    MVI(0xc0002264, "TODO_c000_2264", 0),
    MVI(0xc0002265, "TODO_c000_2265", 0),
    MVI(0xc0002266, "TODO_c000_2266", 0),
    MVI(0xc0002267, "TODO_c000_2267", 0),
    MVI(0xc0002268, "TODO_c000_2268", 0),
    MVI(0xc0002269, "TODO_c000_2269", 0),
    MVI(0xc000226a, "TODO_c000_226a", 0),
    MVI(0xc000226b, "TODO_c000_226b", 0),
    MVI(0xc000226c, "TODO_c000_226c", 0),
    MVI(0xc000226d, "TODO_c000_226d", 0),
    MVI(0xc000226e, "TODO_c000_226e", 0),
    MVI(0xc000226f, "TODO_c000_226f", 0),
    MVI(0xc0002270, "TODO_c000_2270", 0),
    MVI(0xc0002271, "TODO_c000_2271", 0),
    MVI(0xc0002272, "TODO_c000_2272", 0),
    MVI(0xc0002273, "TODO_c000_2273", 0),
    MVI(0xc0002274, "TODO_c000_2274", 0),
    MVI(0xc0002275, "TODO_c000_2275", 0),
    MVI(0xc0002276, "TODO_c000_2276", 0),
    MVI(0xc0002277, "TODO_c000_2277", 0),
    MVI(0xc0002278, "TODO_c000_2278", 0),
    MVI(0xc0002279, "TODO_c000_2279", 0),
    MVI(0xc000227a, "TODO_c000_227a", 0),
    MVI(0xc000227b, "TODO_c000_227b", 0),
    MVI(0xc000227c, "TODO_c000_227c", 0),
    MVI(0xc000227d, "TODO_c000_227d", 0),
    MVI(0xc000227e, "TODO_c000_227e", 0),
    MVI(0xc000227f, "TODO_c000_227f", 0),
    MVI(0xc0002280, "TODO_c000_2280", 0),
    MVI(0xc0002281, "TODO_c000_2281", 0),
    MVI(0xc0002282, "TODO_c000_2282", 0),
    MVI(0xc0002283, "TODO_c000_2283", 0),
    MVI(0xc0002284, "TODO_c000_2284", 0),
    MVI(0xc0002285, "TODO_c000_2285", 0),
    MVI(0xc0002286, "TODO_c000_2286", 0),
    MVI(0xc0002287, "TODO_c000_2287", 0),
    MVI(0xc0002288, "TODO_c000_2288", 0),
    MVI(0xc0002289, "TODO_c000_2289", 0),
    MVI(0xc000228a, "TODO_c000_228a", 0),
    MVI(0xc000228b, "TODO_c000_228b", 0),
    MVI(0xc000228c, "TODO_c000_228c", 0),
    MVI(0xc000228d, "TODO_c000_228d", 0),
    MVI(0xc000228e, "TODO_c000_228e", 0),
    MVI(0xc000228f, "TODO_c000_228f", 0),
    MVI(0xc0002290, "TODO_c000_2290", 0),
    MVI(0xc0002291, "TODO_c000_2291", 0),
    MVI(0xc0002292, "TODO_c000_2292", 0),
    MVI(0xc0002293, "TODO_c000_2293", 0),
    MVI(0xc0002294, "TODO_c000_2294", 0),
    MVI(0xc0002295, "TODO_c000_2295", 0),
    MVI(0xc0002296, "TODO_c000_2296", 0),
    MVI(0xc0002297, "TODO_c000_2297", 0),
    MVI(0xc0002298, "TODO_c000_2298", 0),
    MVI(0xc0002299, "TODO_c000_2299", 0),
    MVI(0xc000229a, "TODO_c000_229a", 0),
    MVI(0xc000229b, "TODO_c000_229b", 0),
    MVI(0xc000229c, "TODO_c000_229c", 0),
    MVI(0xc000229d, "TODO_c000_229d", 0),
    MVI(0xc000229e, "TODO_c000_229e", 0),
    MVI(0xc000229f, "TODO_c000_229f", 0),
    MVI(0xc00022a0, "TODO_c000_22a0", 0),
    MVI(0xc00022a1, "TODO_c000_22a1", 0),
    MVI(0xc00022a2, "TODO_c000_22a2", 0),
    MVI(0xc00022a3, "TODO_c000_22a3", 0),
    MVI(0xc00022a4, "TODO_c000_22a4", 0),
    MVI(0xc00022a5, "TODO_c000_22a5", 0),
    MVI(0xc00022a6, "TODO_c000_22a6", 0),
    MVI(0xc00022a7, "TODO_c000_22a7", 0),
    MVI(0xc00022a8, "TODO_c000_22a8", 0),
    MVI(0xc00022a9, "TODO_c000_22a9", 0),
    MVI(0xc00022aa, "TODO_c000_22aa", 0),
    MVI(0xc00022ab, "TODO_c000_22ab", 0),
    MVI(0xc00022ac, "TODO_c000_22ac", 0),
    MVI(0xc00022ad, "TODO_c000_22ad", 0),
    MVI(0xc00022ae, "TODO_c000_22ae", 0),
    MVI(0xc00022af, "TODO_c000_22af", 0),
    MVI(0xc00022b0, "TODO_c000_22b0", 0),
    MVI(0xc00022b1, "TODO_c000_22b1", 0),
    MVI(0xc00022b2, "TODO_c000_22b2", 0),
    MVI(0xc00022b3, "TODO_c000_22b3", 0),
    MVI(0xc00022b4, "TODO_c000_22b4", 0),
    MVI(0xc00022b5, "TODO_c000_22b5", 0),
    MVI(0xc00022b6, "TODO_c000_22b6", 0),
    MVI(0xc00022b7, "TODO_c000_22b7", 0),
    MVI(0xc00022b8, "TODO_c000_22b8", 0),
    MVI(0xc00022b9, "TODO_c000_22b9", 0),
    MVI(0xc00022ba, "TODO_c000_22ba", 0),
    MVI(0xc00022bb, "TODO_c000_22bb", 0),
    MVI(0xc00022bc, "TODO_c000_22bc", 0),
    MVI(0xc00022bd, "TODO_c000_22bd", 0),
    MVI(0xc00022be, "TODO_c000_22be", 0),
    MVI(0xc00022bf, "TODO_c000_22bf", 0),
    MVI(0xc00022c0, "TODO_c000_22c0", 0),
    MVI(0xc00022c1, "TODO_c000_22c1", 0),
    MVI(0xc00022c2, "TODO_c000_22c2", 0),
    MVI(0xc00022c3, "TODO_c000_22c3", 0),
    MVI(0xc00022c4, "TODO_c000_22c4", 0),
    MVI(0xc00022c5, "TODO_c000_22c5", 0),
    MVI(0xc00022c6, "TODO_c000_22c6", 0),
    MVI(0xc00022c7, "TODO_c000_22c7", 0),
    MVI(0xc00022c8, "TODO_c000_22c8", 0),
    MVI(0xc00022c9, "TODO_c000_22c9", 0),
    MVI(0xc00022ca, "TODO_c000_22ca", 0),
    MVI(0xc00022cb, "TODO_c000_22cb", 0),
    MVI(0xc00022cc, "TODO_c000_22cc", 0),
    MVI(0xc00022cd, "TODO_c000_22cd", 0),
    MVI(0xc00022ce, "TODO_c000_22ce", 0),
    MVI(0xc00022cf, "TODO_c000_22cf", 0),
    MVI(0xc00022d0, "TODO_c000_22d0", 0),
    MVI(0xc00022d1, "TODO_c000_22d1", 0),
    MVI(0xc00022d2, "TODO_c000_22d2", 0),
    MVI(0xc00022d3, "TODO_c000_22d3", 0),
    MVI(0xc00022d4, "TODO_c000_22d4", 0),
    MVI(0xc00022d5, "TODO_c000_22d5", 0),
    MVI(0xc00022d6, "TODO_c000_22d6", 0),
    MVI(0xc00022d7, "TODO_c000_22d7", 0),
    MVI(0xc00022d8, "TODO_c000_22d8", 0),
    MVI(0xc00022d9, "TODO_c000_22d9", 0),
    MVI(0xc00022da, "TODO_c000_22da", 0),
    MVI(0xc00022db, "TODO_c000_22db", 0),
    MVI(0xc00022dc, "TODO_c000_22dc", 0),
    MVI(0xc00022dd, "TODO_c000_22dd", 0),
    MVI(0xc00022de, "TODO_c000_22de", 0),
    MVI(0xc00022df, "TODO_c000_22df", 0),
    MVI(0xc00022e0, "TODO_c000_22e0", 0),
    MVI(0xc00022e1, "TODO_c000_22e1", 0),
    MVI(0xc00022e2, "TODO_c000_22e2", 0),
    MVI(0xc00022e3, "TODO_c000_22e3", 0),
    MVI(0xc00022e4, "TODO_c000_22e4", 0),
    MVI(0xc00022e5, "TODO_c000_22e5", 0),
    MVI(0xc00022e6, "TODO_c000_22e6", 0),
    MVI(0xc00022e7, "TODO_c000_22e7", 0),
    MVI(0xc00022e8, "TODO_c000_22e8", 0),
    MVI(0xc00022e9, "TODO_c000_22e9", 0),
    MVI(0xc00022ea, "TODO_c000_22ea", 0),
    MVI(0xc00022eb, "TODO_c000_22eb", 0),
    MVI(0xc00022ec, "TODO_c000_22ec", 0),
    MVI(0xc00022ed, "TODO_c000_22ed", 0),
    MVI(0xc00022ee, "TODO_c000_22ee", 0),
    MVI(0xc00022ef, "TODO_c000_22ef", 0),
    MVI(0xc00022f0, "TODO_c000_22f0", 0),
    MVI(0xc00022f1, "TODO_c000_22f1", 0),
    MVI(0xc00022f2, "TODO_c000_22f2", 0),
    MVI(0xc00022f3, "TODO_c000_22f3", 0),
    MVI(0xc00022f4, "TODO_c000_22f4", 0),
    MVI(0xc00022f5, "TODO_c000_22f5", 0),
    MVI(0xc00022f6, "TODO_c000_22f6", 0),
    MVI(0xc00022f7, "TODO_c000_22f7", 0),
    MVI(0xc00022f8, "TODO_c000_22f8", 0),
    MVI(0xc00022f9, "TODO_c000_22f9", 0),
    MVI(0xc00022fa, "TODO_c000_22fa", 0),
    MVI(0xc00022fb, "TODO_c000_22fb", 0),
    MVI(0xc00022fc, "TODO_c000_22fc", 0),
    MVI(0xc00022fd, "TODO_c000_22fd", 0),
    MVI(0xc00022fe, "TODO_c000_22fe", 0),
    MVI(0xc00022ff, "TODO_c000_22ff", 0),
    MVI(0xc0002300, "TODO_c000_2300", 0),
    MVI(0xc0002301, "TODO_c000_2301", 0),
    MVI(0xc0002302, "TODO_c000_2302", 0),
    MVI(0xc0002303, "TODO_c000_2303", 0),
    MVI(0xc0002304, "TODO_c000_2304", 0),
    MVI(0xc0002305, "TODO_c000_2305", 0),
    MVI(0xc0002306, "TODO_c000_2306", 0),
    MVI(0xc0002307, "TODO_c000_2307", 0),
    MVI(0xc0002308, "TODO_c000_2308", 0),
    MVI(0xc0002309, "TODO_c000_2309", 0),
    MVI(0xc000230a, "TODO_c000_230a", 0),
    MVI(0xc000230b, "TODO_c000_230b", 0),
    MVI(0xc000230c, "TODO_c000_230c", 0),
    MVI(0xc000230d, "TODO_c000_230d", 0),
    MVI(0xc000230e, "TODO_c000_230e", 0),
    MVI(0xc000230f, "TODO_c000_230f", 0),
    MVI(0xc0002310, "TODO_c000_2310", 0),
    MVI(0xc0002311, "TODO_c000_2311", 0),
    MVI(0xc0002312, "TODO_c000_2312", 0),
    MVI(0xc0002313, "TODO_c000_2313", 0),
    MVI(0xc0002314, "TODO_c000_2314", 0),
    MVI(0xc0002315, "TODO_c000_2315", 0),
    MVI(0xc0002316, "TODO_c000_2316", 0),
    MVI(0xc0002317, "TODO_c000_2317", 0),
    MVI(0xc0002318, "TODO_c000_2318", 0),
    MVI(0xc0002319, "TODO_c000_2319", 0),
    MVI(0xc000231a, "TODO_c000_231a", 0),
    MVI(0xc000231b, "TODO_c000_231b", 0),
    MVI(0xc000231c, "TODO_c000_231c", 0),
    MVI(0xc000231d, "TODO_c000_231d", 0),
    MVI(0xc000231e, "TODO_c000_231e", 0),
    MVI(0xc000231f, "TODO_c000_231f", 0),
    MVI(0xc0002320, "TODO_c000_2320", 0),
    MVI(0xc0002321, "TODO_c000_2321", 0),
    MVI(0xc0002322, "TODO_c000_2322", 0),
    MVI(0xc0002323, "TODO_c000_2323", 0),
    MVI(0xc0002324, "TODO_c000_2324", 0),
    MVI(0xc0002325, "TODO_c000_2325", 0),
    MVI(0xc0002326, "TODO_c000_2326", 0),
    MVI(0xc0002327, "TODO_c000_2327", 0),
    MVI(0xc0002328, "TODO_c000_2328", 0),
    MVI(0xc0002329, "TODO_c000_2329", 0),
    MVI(0xc000232a, "TODO_c000_232a", 0),
    MVI(0xc000232b, "TODO_c000_232b", 0),
    MVI(0xc000232c, "TODO_c000_232c", 0),
    MVI(0xc000232d, "TODO_c000_232d", 0),
    MVI(0xc000232e, "TODO_c000_232e", 0),
    MVI(0xc000232f, "TODO_c000_232f", 0),
    MVI(0xc0002330, "TODO_c000_2330", 0),
    MVI(0xc0002331, "TODO_c000_2331", 0),
    MVI(0xc0002332, "TODO_c000_2332", 0),
    MVI(0xc0002333, "TODO_c000_2333", 0),
    MVI(0xc0002334, "TODO_c000_2334", 0),
    MVI(0xc0002335, "TODO_c000_2335", 0),
    MVI(0xc0002336, "TODO_c000_2336", 0),
    MVI(0xc0002337, "TODO_c000_2337", 0),
    MVI(0xc0002338, "TODO_c000_2338", 0),
    MVI(0xc0002339, "TODO_c000_2339", 0),
    MVI(0xc000233a, "TODO_c000_233a", 0),
    MVI(0xc000233b, "TODO_c000_233b", 0),
    MVI(0xc000233c, "TODO_c000_233c", 0),
    MVI(0xc000233d, "TODO_c000_233d", 0),
    MVI(0xc000233e, "TODO_c000_233e", 0),
    MVI(0xc000233f, "TODO_c000_233f", 0),
    MVI(0xc0002340, "TODO_c000_2340", 0),
    MVI(0xc0002341, "TODO_c000_2341", 0),
    MVI(0xc0002342, "TODO_c000_2342", 0),
    MVI(0xc0002343, "TODO_c000_2343", 0),
    MVI(0xc0002344, "TODO_c000_2344", 0),
    MVI(0xc0002345, "TODO_c000_2345", 0),
    MVI(0xc0002346, "TODO_c000_2346", 0),
    MVI(0xc0002347, "TODO_c000_2347", 0),
    MVI(0xc0002348, "TODO_c000_2348", 0),
    MVI(0xc0002349, "TODO_c000_2349", 0),
    MVI(0xc000234a, "TODO_c000_234a", 0),
    MVI(0xc000234b, "TODO_c000_234b", 0),
    MVI(0xc000234c, "TODO_c000_234c", 0),
    MVI(0xc000234d, "TODO_c000_234d", 0),
    MVI(0xc000234e, "TODO_c000_234e", 0),
    MVI(0xc000234f, "TODO_c000_234f", 0),
    MVI(0xc0002350, "TODO_c000_2350", 0),
    MVI(0xc0002351, "TODO_c000_2351", 0),
    MVI(0xc0002352, "TODO_c000_2352", 0),
    MVI(0xc0002353, "TODO_c000_2353", 0),
    MVI(0xc0002354, "TODO_c000_2354", 0),
    MVI(0xc0002355, "TODO_c000_2355", 0),
    MVI(0xc0002356, "TODO_c000_2356", 0),
    MVI(0xc0002357, "TODO_c000_2357", 0),
    MVI(0xc0002358, "TODO_c000_2358", 0),
    MVI(0xc0002359, "TODO_c000_2359", 0),
    MVI(0xc000235a, "TODO_c000_235a", 0),
    MVI(0xc000235b, "TODO_c000_235b", 0),
    MVI(0xc000235c, "TODO_c000_235c", 0),
    MVI(0xc000235d, "TODO_c000_235d", 0),
    MVI(0xc000235e, "TODO_c000_235e", 0),
    MVI(0xc000235f, "TODO_c000_235f", 0),
    MVI(0xc0002360, "TODO_c000_2360", 0),
    MVI(0xc0002361, "TODO_c000_2361", 0),
    MVI(0xc0002362, "TODO_c000_2362", 0),
    MVI(0xc0002363, "TODO_c000_2363", 0),
    MVI(0xc0002364, "TODO_c000_2364", 0),
    MVI(0xc0002365, "TODO_c000_2365", 0),
    MVI(0xc0002366, "TODO_c000_2366", 0),
    MVI(0xc0002367, "TODO_c000_2367", 0),
    MVI(0xc0002368, "TODO_c000_2368", 0),
    MVI(0xc0002369, "TODO_c000_2369", 0),
    MVI(0xc000236a, "TODO_c000_236a", 0),
    MVI(0xc000236b, "TODO_c000_236b", 0),
    MVI(0xc000236c, "TODO_c000_236c", 0),
    MVI(0xc000236d, "TODO_c000_236d", 0),
    MVI(0xc000236e, "TODO_c000_236e", 0),
    MVI(0xc000236f, "TODO_c000_236f", 0),
    MVI(0xc0002370, "TODO_c000_2370", 0),
    MVI(0xc0002371, "TODO_c000_2371", 0),
    MVI(0xc0002372, "TODO_c000_2372", 0),
    MVI(0xc0002373, "TODO_c000_2373", 0),
    MVI(0xc0002374, "TODO_c000_2374", 0),
    MVI(0xc0002375, "TODO_c000_2375", 0),
    MVI(0xc0002376, "TODO_c000_2376", 0),
    MVI(0xc0002377, "TODO_c000_2377", 0),
    MVI(0xc0002378, "TODO_c000_2378", 0),
    MVI(0xc0002379, "TODO_c000_2379", 0),
    MVI(0xc000237a, "TODO_c000_237a", 0),
    MVI(0xc000237b, "TODO_c000_237b", 0),
    MVI(0xc000237c, "TODO_c000_237c", 0),
    MVI(0xc000237d, "TODO_c000_237d", 0),
    MVI(0xc000237e, "TODO_c000_237e", 0),
    MVI(0xc000237f, "TODO_c000_237f", 0),
    MVI(0xc0002380, "TODO_c000_2380", 0),
    MVI(0xc0002381, "TODO_c000_2381", 0),
    MVI(0xc0002382, "TODO_c000_2382", 0),
    MVI(0xc0002383, "TODO_c000_2383", 0),
    MVI(0xc0002384, "TODO_c000_2384", 0),
    MVI(0xc0002385, "TODO_c000_2385", 0),
    MVI(0xc0002386, "TODO_c000_2386", 0),
    MVI(0xc0002387, "TODO_c000_2387", 0),
    MVI(0xc0002388, "TODO_c000_2388", 0),
    MVI(0xc0002389, "TODO_c000_2389", 0),
    MVI(0xc000238a, "TODO_c000_238a", 0),
    MVI(0xc000238b, "TODO_c000_238b", 0),
    MVI(0xc000238c, "TODO_c000_238c", 0),
    MVI(0xc000238d, "TODO_c000_238d", 0),
    MVI(0xc000238e, "TODO_c000_238e", 0),
    MVI(0xc000238f, "TODO_c000_238f", 0),
    MVI(0xc0002390, "TODO_c000_2390", 0),
    MVI(0xc0002391, "TODO_c000_2391", 0),
    MVI(0xc0002392, "TODO_c000_2392", 0),
    MVI(0xc0002393, "TODO_c000_2393", 0),
    MVI(0xc0002394, "TODO_c000_2394", 0),
    MVI(0xc0002395, "TODO_c000_2395", 0),
    MVI(0xc0002396, "TODO_c000_2396", 0),
    MVI(0xc0002397, "TODO_c000_2397", 0),
    MVI(0xc0002398, "TODO_c000_2398", 0),
    MVI(0xc0002399, "TODO_c000_2399", 0),
    MVI(0xc000239a, "TODO_c000_239a", 0),
    MVI(0xc000239b, "TODO_c000_239b", 0),
    MVI(0xc000239c, "TODO_c000_239c", 0),
    MVI(0xc000239d, "TODO_c000_239d", 0),
    MVI(0xc000239e, "TODO_c000_239e", 0),
    MVI(0xc000239f, "TODO_c000_239f", 0),
    MVI(0xc00023a0, "TODO_c000_23a0", 0),
    MVI(0xc00023a1, "TODO_c000_23a1", 0),
    MVI(0xc00023a2, "TODO_c000_23a2", 0),
    MVI(0xc00023a3, "TODO_c000_23a3", 0),
    MVI(0xc00023a4, "TODO_c000_23a4", 0),
    MVI(0xc00023a5, "TODO_c000_23a5", 0),
    MVI(0xc00023a6, "TODO_c000_23a6", 0),
    MVI(0xc00023a7, "TODO_c000_23a7", 0),
    MVI(0xc00023a8, "TODO_c000_23a8", 0),
    MVI(0xc00023a9, "TODO_c000_23a9", 0),
    MVI(0xc00023aa, "TODO_c000_23aa", 0),
    MVI(0xc00023ab, "TODO_c000_23ab", 0),
    MVI(0xc00023ac, "TODO_c000_23ac", 0),
    MVI(0xc00023ad, "TODO_c000_23ad", 0),
    MVI(0xc00023ae, "TODO_c000_23ae", 0),
    MVI(0xc00023af, "TODO_c000_23af", 0),
    MVI(0xc00023b0, "TODO_c000_23b0", 0),
    MVI(0xc00023b1, "TODO_c000_23b1", 0),
    MVI(0xc00023b2, "TODO_c000_23b2", 0),
    MVI(0xc00023b3, "TODO_c000_23b3", 0),
    MVI(0xc00023b4, "TODO_c000_23b4", 0),
    MVI(0xc00023b5, "TODO_c000_23b5", 0),
    MVI(0xc00023b6, "TODO_c000_23b6", 0),
    MVI(0xc00023b7, "TODO_c000_23b7", 0),
    MVI(0xc00023b8, "TODO_c000_23b8", 0),
    MVI(0xc00023b9, "TODO_c000_23b9", 0),
    MVI(0xc00023ba, "TODO_c000_23ba", 0),
    MVI(0xc00023bb, "TODO_c000_23bb", 0),
    MVI(0xc00023bc, "TODO_c000_23bc", 0),
    MVI(0xc00023bd, "TODO_c000_23bd", 0),
    MVI(0xc00023be, "TODO_c000_23be", 0),
    MVI(0xc00023bf, "TODO_c000_23bf", 0),
    MVI(0xc00023c0, "TODO_c000_23c0", 0),
    MVI(0xc00023c1, "TODO_c000_23c1", 0),
    MVI(0xc00023c2, "TODO_c000_23c2", 0),
    MVI(0xc00023c3, "TODO_c000_23c3", 0),
    MVI(0xc00023c4, "TODO_c000_23c4", 0),
    MVI(0xc00023c5, "TODO_c000_23c5", 0),
    MVI(0xc00023c6, "TODO_c000_23c6", 0),
    MVI(0xc00023c7, "TODO_c000_23c7", 0),
    MVI(0xc00023c8, "TODO_c000_23c8", 0),
    MVI(0xc00023c9, "TODO_c000_23c9", 0),
    MVI(0xc00023ca, "TODO_c000_23ca", 0),
    MVI(0xc00023cb, "TODO_c000_23cb", 0),
    MVI(0xc00023cc, "TODO_c000_23cc", 0),
    MVI(0xc00023cd, "TODO_c000_23cd", 0),
    MVI(0xc00023ce, "TODO_c000_23ce", 0),
    MVI(0xc00023cf, "TODO_c000_23cf", 0),
    MVI(0xc00023d0, "TODO_c000_23d0", 0),
    MVI(0xc00023d1, "TODO_c000_23d1", 0),
    MVI(0xc00023d2, "TODO_c000_23d2", 0),
    MVI(0xc00023d3, "TODO_c000_23d3", 0),
    MVI(0xc00023d4, "TODO_c000_23d4", 0),
    MVI(0xc00023d5, "TODO_c000_23d5", 0),
    MVI(0xc00023d6, "TODO_c000_23d6", 0),
    MVI(0xc00023d7, "TODO_c000_23d7", 0),
    MVI(0xc00023d8, "TODO_c000_23d8", 0),
    MVI(0xc00023d9, "TODO_c000_23d9", 0),
    MVI(0xc00023da, "TODO_c000_23da", 0),
    MVI(0xc00023db, "TODO_c000_23db", 0),
    MVI(0xc00023dc, "TODO_c000_23dc", 0),
    MVI(0xc00023dd, "TODO_c000_23dd", 0),
    MVI(0xc00023de, "TODO_c000_23de", 0),
    MVI(0xc00023df, "TODO_c000_23df", 0),
    MVI(0xc00023e0, "TODO_c000_23e0", 0),
    MVI(0xc00023e1, "TODO_c000_23e1", 0),
    MVI(0xc00023e2, "TODO_c000_23e2", 0),
    MVI(0xc00023e3, "TODO_c000_23e3", 0),
    MVI(0xc00023e4, "TODO_c000_23e4", 0),
    MVI(0xc00023e5, "TODO_c000_23e5", 0),
    MVI(0xc00023e6, "TODO_c000_23e6", 0),
    MVI(0xc00023e7, "TODO_c000_23e7", 0),
    MVI(0xc00023e8, "TODO_c000_23e8", 0),
    MVI(0xc00023e9, "TODO_c000_23e9", 0),
    MVI(0xc00023ea, "TODO_c000_23ea", 0),
    MVI(0xc00023eb, "TODO_c000_23eb", 0),
    MVI(0xc00023ec, "TODO_c000_23ec", 0),
    MVI(0xc00023ed, "TODO_c000_23ed", 0),
    MVI(0xc00023ee, "TODO_c000_23ee", 0),
    MVI(0xc00023ef, "TODO_c000_23ef", 0),
    MVI(0xc00023f0, "TODO_c000_23f0", 0),
    MVI(0xc00023f1, "TODO_c000_23f1", 0),
    MVI(0xc00023f2, "TODO_c000_23f2", 0),
    MVI(0xc00023f3, "TODO_c000_23f3", 0),
    MVI(0xc00023f4, "TODO_c000_23f4", 0),
    MVI(0xc00023f5, "TODO_c000_23f5", 0),
    MVI(0xc00023f6, "TODO_c000_23f6", 0),
    MVI(0xc00023f7, "TODO_c000_23f7", 0),
    MVI(0xc00023f8, "TODO_c000_23f8", 0),
    MVI(0xc00023f9, "TODO_c000_23f9", 0),
    MVI(0xc00023fa, "TODO_c000_23fa", 0),
    MVI(0xc00023fb, "TODO_c000_23fb", 0),
    MVI(0xc00023fc, "TODO_c000_23fc", 0),
    MVI(0xc00023fd, "TODO_c000_23fd", 0),
    MVI(0xc00023fe, "TODO_c000_23fe", 0),
    MVI(0xc00023ff, "TODO_c000_23ff", 0),
    MVI(0xc0002400, "TODO_c000_2400", 0),
    MVI(0xc0002401, "TODO_c000_2401", 0),
    MVI(0xc0002402, "TODO_c000_2402", 0),
    MVI(0xc0002403, "TODO_c000_2403", 0),
    MVI(0xc0002404, "TODO_c000_2404", 0),
    MVI(0xc0002405, "TODO_c000_2405", 0),
    MVI(0xc0002406, "TODO_c000_2406", 0),
    MVI(0xc0002407, "TODO_c000_2407", 0),
    MVI(0xc0002408, "TODO_c000_2408", 0),
    MVI(0xc0002409, "TODO_c000_2409", 0),
    MVI(0xc000240a, "TODO_c000_240a", 0),
    MVI(0xc000240b, "TODO_c000_240b", 0),
    MVI(0xc000240c, "TODO_c000_240c", 0),
    MVI(0xc000240d, "TODO_c000_240d", 0),
    MVI(0xc000240e, "TODO_c000_240e", 0),
    MVI(0xc000240f, "TODO_c000_240f", 0),
    MVI(0xc0002410, "TODO_c000_2410", 0),
    MVI(0xc0002411, "TODO_c000_2411", 0),
    MVI(0xc0002412, "TODO_c000_2412", 0),
    MVI(0xc0002413, "TODO_c000_2413", 0),
    MVI(0xc0002414, "TODO_c000_2414", 0),
    MVI(0xc0002415, "TODO_c000_2415", 0),
    MVI(0xc0002416, "TODO_c000_2416", 0),
    MVI(0xc0002417, "TODO_c000_2417", 0),
    MVI(0xc0002418, "TODO_c000_2418", 0),
    MVI(0xc0002419, "TODO_c000_2419", 0),
    MVI(0xc000241a, "TODO_c000_241a", 0),
    MVI(0xc000241b, "TODO_c000_241b", 0),
    MVI(0xc000241c, "TODO_c000_241c", 0),
    MVI(0xc000241d, "TODO_c000_241d", 0),
    MVI(0xc000241e, "TODO_c000_241e", 0),
    MVI(0xc000241f, "TODO_c000_241f", 0),
    MVI(0xc0002420, "TODO_c000_2420", 0),
    MVI(0xc0002421, "TODO_c000_2421", 0),
    MVI(0xc0002422, "TODO_c000_2422", 0),
    MVI(0xc0002423, "TODO_c000_2423", 0),
    MVI(0xc0002424, "TODO_c000_2424", 0),
    MVI(0xc0002425, "TODO_c000_2425", 0),
    MVI(0xc0002426, "TODO_c000_2426", 0),
    MVI(0xc0002427, "TODO_c000_2427", 0),
    MVI(0xc0002428, "TODO_c000_2428", 0),
    MVI(0xc0002429, "TODO_c000_2429", 0),
    MVI(0xc000242a, "TODO_c000_242a", 0),
    MVI(0xc000242b, "TODO_c000_242b", 0),
    MVI(0xc000242c, "TODO_c000_242c", 0),
    MVI(0xc000242d, "TODO_c000_242d", 0),
    MVI(0xc000242e, "TODO_c000_242e", 0),
    MVI(0xc000242f, "TODO_c000_242f", 0),
    MVI(0xc0002430, "TODO_c000_2430", 0),
    MVI(0xc0002431, "TODO_c000_2431", 0),
    MVI(0xc0002432, "TODO_c000_2432", 0),
    MVI(0xc0002433, "TODO_c000_2433", 0),
    MVI(0xc0002434, "TODO_c000_2434", 0),
    MVI(0xc0002435, "TODO_c000_2435", 0),
    MVI(0xc0002436, "TODO_c000_2436", 0),
    MVI(0xc0002437, "TODO_c000_2437", 0),
    MVI(0xc0002438, "TODO_c000_2438", 0),
    MVI(0xc0002439, "TODO_c000_2439", 0),
    MVI(0xc000243a, "TODO_c000_243a", 0),
    MVI(0xc000243b, "TODO_c000_243b", 0),
    MVI(0xc000243c, "TODO_c000_243c", 0),
    MVI(0xc000243d, "TODO_c000_243d", 0),
    MVI(0xc000243e, "TODO_c000_243e", 0),
    MVI(0xc000243f, "TODO_c000_243f", 0),
    MVI(0xc0002440, "TODO_c000_2440", 0),
    MVI(0xc0002441, "TODO_c000_2441", 0),
    MVI(0xc0002442, "TODO_c000_2442", 0),
    MVI(0xc0002443, "TODO_c000_2443", 0),
    MVI(0xc0002444, "TODO_c000_2444", 0),
    MVI(0xc0002445, "TODO_c000_2445", 0),
    MVI(0xc0002446, "TODO_c000_2446", 0),
    MVI(0xc0002447, "TODO_c000_2447", 0),
    MVI(0xc0002448, "TODO_c000_2448", 0),
    MVI(0xc0002449, "TODO_c000_2449", 0),
    MVI(0xc000244a, "TODO_c000_244a", 0),
    MVI(0xc000244b, "TODO_c000_244b", 0),
    MVI(0xc000244c, "TODO_c000_244c", 0),
    MVI(0xc000244d, "TODO_c000_244d", 0),
    MVI(0xc000244e, "TODO_c000_244e", 0),
    MVI(0xc000244f, "TODO_c000_244f", 0),
    MVI(0xc0002450, "TODO_c000_2450", 0),
    MVI(0xc0002451, "TODO_c000_2451", 0),
    MVI(0xc0002452, "TODO_c000_2452", 0),
    MVI(0xc0002453, "TODO_c000_2453", 0),
    MVI(0xc0002454, "TODO_c000_2454", 0),
    MVI(0xc0002455, "TODO_c000_2455", 0),
    MVI(0xc0002456, "TODO_c000_2456", 0),
    MVI(0xc0002457, "TODO_c000_2457", 0),
    MVI(0xc0002458, "TODO_c000_2458", 0),
    MVI(0xc0002459, "TODO_c000_2459", 0),
    MVI(0xc000245a, "TODO_c000_245a", 0),
    MVI(0xc000245b, "TODO_c000_245b", 0),
    MVI(0xc000245c, "TODO_c000_245c", 0),
    MVI(0xc000245d, "TODO_c000_245d", 0),
    MVI(0xc000245e, "TODO_c000_245e", 0),
    MVI(0xc000245f, "TODO_c000_245f", 0),
    MVI(0xc0002460, "TODO_c000_2460", 0),
    MVI(0xc0002461, "TODO_c000_2461", 0),
    MVI(0xc0002462, "TODO_c000_2462", 0),
    MVI(0xc0002463, "TODO_c000_2463", 0),
    MVI(0xc0002464, "TODO_c000_2464", 0),
    MVI(0xc0002465, "TODO_c000_2465", 0),
    MVI(0xc0002466, "TODO_c000_2466", 0),
    MVI(0xc0002467, "TODO_c000_2467", 0),
    MVI(0xc0002468, "TODO_c000_2468", 0),
    MVI(0xc0002469, "TODO_c000_2469", 0),
    MVI(0xc000246a, "TODO_c000_246a", 0),
    MVI(0xc000246b, "TODO_c000_246b", 0),
    MVI(0xc000246c, "TODO_c000_246c", 0),
    MVI(0xc000246d, "TODO_c000_246d", 0),
    MVI(0xc000246e, "TODO_c000_246e", 0),
    MVI(0xc000246f, "TODO_c000_246f", 0),
    MVI(0xc0002470, "TODO_c000_2470", 0),
    MVI(0xc0002471, "TODO_c000_2471", 0),
    MVI(0xc0002472, "TODO_c000_2472", 0),
    MVI(0xc0002473, "TODO_c000_2473", 0),
    MVI(0xc0002474, "TODO_c000_2474", 0),
    MVI(0xc0002475, "TODO_c000_2475", 0),
    MVI(0xc0002476, "TODO_c000_2476", 0),
    MVI(0xc0002477, "TODO_c000_2477", 0),
    MVI(0xc0002478, "TODO_c000_2478", 0),
    MVI(0xc0002479, "TODO_c000_2479", 0),
    MVI(0xc000247a, "TODO_c000_247a", 0),
    MVI(0xc000247b, "TODO_c000_247b", 0),
    MVI(0xc000247c, "TODO_c000_247c", 0),
    MVI(0xc000247d, "TODO_c000_247d", 0),
    MVI(0xc000247e, "TODO_c000_247e", 0),
    MVI(0xc000247f, "TODO_c000_247f", 0),
    MVI(0xc0002480, "TODO_c000_2480", 0),
    MVI(0xc0002481, "TODO_c000_2481", 0),
    MVI(0xc0002482, "TODO_c000_2482", 0),
    MVI(0xc0002483, "TODO_c000_2483", 0),
    MVI(0xc0002484, "TODO_c000_2484", 0),
    MVI(0xc0002485, "TODO_c000_2485", 0),
    MVI(0xc0002486, "TODO_c000_2486", 0),
    MVI(0xc0002487, "TODO_c000_2487", 0),
    MVI(0xc0002488, "TODO_c000_2488", 0),
    MVI(0xc0002489, "TODO_c000_2489", 0),
    MVI(0xc000248a, "TODO_c000_248a", 0),
    MVI(0xc000248b, "TODO_c000_248b", 0),
    MVI(0xc000248c, "TODO_c000_248c", 0),
    MVI(0xc000248d, "TODO_c000_248d", 0),
    MVI(0xc000248e, "TODO_c000_248e", 0),
    MVI(0xc000248f, "TODO_c000_248f", 0),
    MVI(0xc0002490, "TODO_c000_2490", 0),
    MVI(0xc0002491, "TODO_c000_2491", 0),
    MVI(0xc0002492, "TODO_c000_2492", 0),
    MVI(0xc0002493, "TODO_c000_2493", 0),
    MVI(0xc0002494, "TODO_c000_2494", 0),
    MVI(0xc0002495, "TODO_c000_2495", 0),
    MVI(0xc0002496, "TODO_c000_2496", 0),
    MVI(0xc0002497, "TODO_c000_2497", 0),
    MVI(0xc0002498, "TODO_c000_2498", 0),
    MVI(0xc0002499, "TODO_c000_2499", 0),
    MVI(0xc000249a, "TODO_c000_249a", 0),
    MVI(0xc000249b, "TODO_c000_249b", 0),
    MVI(0xc000249c, "TODO_c000_249c", 0),
    MVI(0xc000249d, "TODO_c000_249d", 0),
    MVI(0xc000249e, "TODO_c000_249e", 0),
    MVI(0xc000249f, "TODO_c000_249f", 0),
    MVI(0xc00024a0, "TODO_c000_24a0", 0),
    MVI(0xc00024a1, "TODO_c000_24a1", 0),
    MVI(0xc00024a2, "TODO_c000_24a2", 0),
    MVI(0xc00024a3, "TODO_c000_24a3", 0),
    MVI(0xc00024a4, "TODO_c000_24a4", 0),
    MVI(0xc00024a5, "TODO_c000_24a5", 0),
    MVI(0xc00024a6, "TODO_c000_24a6", 0),
    MVI(0xc00024a7, "TODO_c000_24a7", 0),
    MVI(0xc00024a8, "TODO_c000_24a8", 0),
    MVI(0xc00024a9, "TODO_c000_24a9", 0),
    MVI(0xc00024aa, "TODO_c000_24aa", 0),
    MVI(0xc00024ab, "TODO_c000_24ab", 0),
    MVI(0xc00024ac, "TODO_c000_24ac", 0),
    MVI(0xc00024ad, "TODO_c000_24ad", 0),
    MVI(0xc00024ae, "TODO_c000_24ae", 0),
    MVI(0xc00024af, "TODO_c000_24af", 0),
    MVI(0xc00024b0, "TODO_c000_24b0", 0),
    MVI(0xc00024b1, "TODO_c000_24b1", 0),
    MVI(0xc00024b2, "TODO_c000_24b2", 0),
    MVI(0xc00024b3, "TODO_c000_24b3", 0),
    MVI(0xc00024b4, "TODO_c000_24b4", 0),
    MVI(0xc00024b5, "TODO_c000_24b5", 0),
    MVI(0xc00024b6, "TODO_c000_24b6", 0),
    MVI(0xc00024b7, "TODO_c000_24b7", 0),
    MVI(0xc00024b8, "TODO_c000_24b8", 0),
    MVI(0xc00024b9, "TODO_c000_24b9", 0),
    MVI(0xc00024ba, "TODO_c000_24ba", 0),
    MVI(0xc00024bb, "TODO_c000_24bb", 0),
    MVI(0xc00024bc, "TODO_c000_24bc", 0),
    MVI(0xc00024bd, "TODO_c000_24bd", 0),
    MVI(0xc00024be, "TODO_c000_24be", 0),
    MVI(0xc00024bf, "TODO_c000_24bf", 0),
    MVI(0xc00024c0, "TODO_c000_24c0", 0),
    MVI(0xc00024c1, "TODO_c000_24c1", 0),
    MVI(0xc00024c2, "TODO_c000_24c2", 0),
    MVI(0xc00024c3, "TODO_c000_24c3", 0),
    MVI(0xc00024c4, "TODO_c000_24c4", 0),
    MVI(0xc00024c5, "TODO_c000_24c5", 0),
    MVI(0xc00024c6, "TODO_c000_24c6", 0),
    MVI(0xc00024c7, "TODO_c000_24c7", 0),
    MVI(0xc00024c8, "TODO_c000_24c8", 0),
    MVI(0xc00024c9, "TODO_c000_24c9", 0),
    MVI(0xc00024ca, "TODO_c000_24ca", 0),
    MVI(0xc00024cb, "TODO_c000_24cb", 0),
    MVI(0xc00024cc, "TODO_c000_24cc", 0),
    MVI(0xc00024cd, "TODO_c000_24cd", 0),
    MVI(0xc00024ce, "TODO_c000_24ce", 0),
    MVI(0xc00024cf, "TODO_c000_24cf", 0),
    MVI(0xc00024d0, "TODO_c000_24d0", 0),
    MVI(0xc00024d1, "TODO_c000_24d1", 0),
    MVI(0xc00024d2, "TODO_c000_24d2", 0),
    MVI(0xc00024d3, "TODO_c000_24d3", 0),
    MVI(0xc00024d4, "TODO_c000_24d4", 0),
    MVI(0xc00024d5, "TODO_c000_24d5", 0),
    MVI(0xc00024d6, "TODO_c000_24d6", 0),
    MVI(0xc00024d7, "TODO_c000_24d7", 0),
    MVI(0xc00024d8, "TODO_c000_24d8", 0),
    MVI(0xc00024d9, "TODO_c000_24d9", 0),
    MVI(0xc00024da, "TODO_c000_24da", 0),
    MVI(0xc00024db, "TODO_c000_24db", 0),
    MVI(0xc00024dc, "TODO_c000_24dc", 0),
    MVI(0xc00024dd, "TODO_c000_24dd", 0),
    MVI(0xc00024de, "TODO_c000_24de", 0),
    MVI(0xc00024df, "TODO_c000_24df", 0),
    MVI(0xc00024e0, "TODO_c000_24e0", 0),
    MVI(0xc00024e1, "TODO_c000_24e1", 0),
    MVI(0xc00024e2, "TODO_c000_24e2", 0),
    MVI(0xc00024e3, "TODO_c000_24e3", 0),
    MVI(0xc00024e4, "TODO_c000_24e4", 0),
    MVI(0xc00024e5, "TODO_c000_24e5", 0),
    MVI(0xc00024e6, "TODO_c000_24e6", 0),
    MVI(0xc00024e7, "TODO_c000_24e7", 0),
    MVI(0xc00024e8, "TODO_c000_24e8", 0),
    MVI(0xc00024e9, "TODO_c000_24e9", 0),
    MVI(0xc00024ea, "TODO_c000_24ea", 0),
    MVI(0xc00024eb, "TODO_c000_24eb", 0),
    MVI(0xc00024ec, "TODO_c000_24ec", 0),
    MVI(0xc00024ed, "TODO_c000_24ed", 0),
    MVI(0xc00024ee, "TODO_c000_24ee", 0),
    MVI(0xc00024ef, "TODO_c000_24ef", 0),
    MVI(0xc00024f0, "TODO_c000_24f0", 0),
    MVI(0xc00024f1, "TODO_c000_24f1", 0),
    MVI(0xc00024f2, "TODO_c000_24f2", 0),
    MVI(0xc00024f3, "TODO_c000_24f3", 0),
    MVI(0xc00024f4, "TODO_c000_24f4", 0),
    MVI(0xc00024f5, "TODO_c000_24f5", 0),
    MVI(0xc00024f6, "TODO_c000_24f6", 0),
    MVI(0xc00024f7, "TODO_c000_24f7", 0),
    MVI(0xc00024f8, "TODO_c000_24f8", 0),
    MVI(0xc00024f9, "TODO_c000_24f9", 0),
    MVI(0xc00024fa, "TODO_c000_24fa", 0),
    MVI(0xc00024fb, "TODO_c000_24fb", 0),
    MVI(0xc00024fc, "TODO_c000_24fc", 0),
    MVI(0xc00024fd, "TODO_c000_24fd", 0),
    MVI(0xc00024fe, "TODO_c000_24fe", 0),
    MVI(0xc00024ff, "TODO_c000_24ff", 0),
    MVI(0xc0002500, "TODO_c000_2500", 0),
    MVI(0xc0002501, "TODO_c000_2501", 0),
    MVI(0xc0002502, "TODO_c000_2502", 0),
    MVI(0xc0002503, "TODO_c000_2503", 0),
    MVI(0xc0002504, "TODO_c000_2504", 0),
    MVI(0xc0002505, "TODO_c000_2505", 0),
    MVI(0xc0002506, "TODO_c000_2506", 0),
    MVI(0xc0002507, "TODO_c000_2507", 0),
    MVI(0xc0002508, "TODO_c000_2508", 0),
    MVI(0xc0002509, "TODO_c000_2509", 0),
    MVI(0xc000250a, "TODO_c000_250a", 0),
    MVI(0xc000250b, "TODO_c000_250b", 0),
    MVI(0xc000250c, "TODO_c000_250c", 0),
    MVI(0xc000250d, "TODO_c000_250d", 0),
    MVI(0xc000250e, "TODO_c000_250e", 0),
    MVI(0xc000250f, "TODO_c000_250f", 0),
    MVI(0xc0002510, "TODO_c000_2510", 0),
    MVI(0xc0002511, "TODO_c000_2511", 0),
    MVI(0xc0002512, "TODO_c000_2512", 0),
    MVI(0xc0002513, "TODO_c000_2513", 0),
    MVI(0xc0002514, "TODO_c000_2514", 0),
    MVI(0xc0002515, "TODO_c000_2515", 0),
    MVI(0xc0002516, "TODO_c000_2516", 0),
    MVI(0xc0002517, "TODO_c000_2517", 0),
    MVI(0xc0002518, "TODO_c000_2518", 0),
    MVI(0xc0002519, "TODO_c000_2519", 0),
    MVI(0xc000251a, "TODO_c000_251a", 0),
    MVI(0xc000251b, "TODO_c000_251b", 0),
    MVI(0xc000251c, "TODO_c000_251c", 0),
    MVI(0xc000251d, "TODO_c000_251d", 0),
    MVI(0xc000251e, "TODO_c000_251e", 0),
    MVI(0xc000251f, "TODO_c000_251f", 0),
    MVI(0xc0002520, "TODO_c000_2520", 0),
    MVI(0xc0002521, "TODO_c000_2521", 0),
    MVI(0xc0002522, "TODO_c000_2522", 0),
    MVI(0xc0002523, "TODO_c000_2523", 0),
    MVI(0xc0002524, "TODO_c000_2524", 0),
    MVI(0xc0002525, "TODO_c000_2525", 0),
    MVI(0xc0002526, "TODO_c000_2526", 0),
    MVI(0xc0002527, "TODO_c000_2527", 0),
    MVI(0xc0002528, "TODO_c000_2528", 0),
    MVI(0xc0002529, "TODO_c000_2529", 0),
    MVI(0xc000252a, "TODO_c000_252a", 0),
    MVI(0xc000252b, "TODO_c000_252b", 0),
    MVI(0xc000252c, "TODO_c000_252c", 0),
    MVI(0xc000252d, "TODO_c000_252d", 0),
    MVI(0xc000252e, "TODO_c000_252e", 0),
    MVI(0xc000252f, "TODO_c000_252f", 0),
    MVI(0xc0002530, "TODO_c000_2530", 0),
    MVI(0xc0002531, "TODO_c000_2531", 0),
    MVI(0xc0002532, "TODO_c000_2532", 0),
    MVI(0xc0002533, "TODO_c000_2533", 0),
    MVI(0xc0002534, "TODO_c000_2534", 0),
    MVI(0xc0002535, "TODO_c000_2535", 0),
    MVI(0xc0002536, "TODO_c000_2536", 0),
    MVI(0xc0002537, "TODO_c000_2537", 0),
    MVI(0xc0002538, "TODO_c000_2538", 0),
    MVI(0xc0002539, "TODO_c000_2539", 0),
    MVI(0xc000253a, "TODO_c000_253a", 0),
    MVI(0xc000253b, "TODO_c000_253b", 0),
    MVI(0xc000253c, "TODO_c000_253c", 0),
    MVI(0xc000253d, "TODO_c000_253d", 0),
    MVI(0xc000253e, "TODO_c000_253e", 0),
    MVI(0xc000253f, "TODO_c000_253f", 0),
    MVI(0xc0002540, "TODO_c000_2540", 0),
    MVI(0xc0002541, "TODO_c000_2541", 0),
    MVI(0xc0002542, "TODO_c000_2542", 0),
    MVI(0xc0002543, "TODO_c000_2543", 0),
    MVI(0xc0002544, "TODO_c000_2544", 0),
    MVI(0xc0002545, "TODO_c000_2545", 0),
    MVI(0xc0002546, "TODO_c000_2546", 0),
    MVI(0xc0002547, "TODO_c000_2547", 0),
    MVI(0xc0002548, "TODO_c000_2548", 0),
    MVI(0xc0002549, "TODO_c000_2549", 0),
    MVI(0xc000254a, "TODO_c000_254a", 0),
    MVI(0xc000254b, "TODO_c000_254b", 0),
    MVI(0xc000254c, "TODO_c000_254c", 0),
    MVI(0xc000254d, "TODO_c000_254d", 0),
    MVI(0xc000254e, "TODO_c000_254e", 0),
    MVI(0xc000254f, "TODO_c000_254f", 0),
    MVI(0xc0002550, "TODO_c000_2550", 0),
    MVI(0xc0002551, "TODO_c000_2551", 0),
    MVI(0xc0002552, "TODO_c000_2552", 0),
    MVI(0xc0002553, "TODO_c000_2553", 0),
    MVI(0xc0002554, "TODO_c000_2554", 0),
    MVI(0xc0002555, "TODO_c000_2555", 0),
    MVI(0xc0002556, "TODO_c000_2556", 0),
    MVI(0xc0002557, "TODO_c000_2557", 0),
    MVI(0xc0002558, "TODO_c000_2558", 0),
    MVI(0xc0002559, "TODO_c000_2559", 0),
    MVI(0xc000255a, "TODO_c000_255a", 0),
    MVI(0xc000255b, "TODO_c000_255b", 0),
    MVI(0xc000255c, "TODO_c000_255c", 0),
    MVI(0xc000255d, "TODO_c000_255d", 0),
    MVI(0xc000255e, "TODO_c000_255e", 0),
    MVI(0xc000255f, "TODO_c000_255f", 0),
    MVI(0xc0002560, "TODO_c000_2560", 0),
    MVI(0xc0002561, "TODO_c000_2561", 0),
    MVI(0xc0002562, "TODO_c000_2562", 0),
    MVI(0xc0002563, "TODO_c000_2563", 0),
    MVI(0xc0002564, "TODO_c000_2564", 0),
    MVI(0xc0002565, "TODO_c000_2565", 0),
    MVI(0xc0002566, "TODO_c000_2566", 0),
    MVI(0xc0002567, "TODO_c000_2567", 0),
    MVI(0xc0002568, "TODO_c000_2568", 0),
    MVI(0xc0002569, "TODO_c000_2569", 0),
    MVI(0xc000256a, "TODO_c000_256a", 0),
    MVI(0xc000256b, "TODO_c000_256b", 0),
    MVI(0xc000256c, "TODO_c000_256c", 0),
    MVI(0xc000256d, "TODO_c000_256d", 0),
    MVI(0xc000256e, "TODO_c000_256e", 0),
    MVI(0xc000256f, "TODO_c000_256f", 0),
    MVI(0xc0002570, "TODO_c000_2570", 0),
    MVI(0xc0002571, "TODO_c000_2571", 0),
    MVI(0xc0002572, "TODO_c000_2572", 0),
    MVI(0xc0002573, "TODO_c000_2573", 0),
    MVI(0xc0002574, "TODO_c000_2574", 0),
    MVI(0xc0002575, "TODO_c000_2575", 0),
    MVI(0xc0002576, "TODO_c000_2576", 0),
    MVI(0xc0002577, "TODO_c000_2577", 0),
    MVI(0xc0002578, "TODO_c000_2578", 0),
    MVI(0xc0002579, "TODO_c000_2579", 0),
    MVI(0xc000257a, "TODO_c000_257a", 0),
    MVI(0xc000257b, "TODO_c000_257b", 0),
    MVI(0xc000257c, "TODO_c000_257c", 0),
    MVI(0xc000257d, "TODO_c000_257d", 0),
    MVI(0xc000257e, "TODO_c000_257e", 0),
    MVI(0xc000257f, "TODO_c000_257f", 0),
    MVI(0xc0002580, "TODO_c000_2580", 0),
    MVI(0xc0002581, "TODO_c000_2581", 0),
    MVI(0xc0002582, "TODO_c000_2582", 0),
    MVI(0xc0002583, "TODO_c000_2583", 0),
    MVI(0xc0002584, "TODO_c000_2584", 0),
    MVI(0xc0002585, "TODO_c000_2585", 0),
    MVI(0xc0002586, "TODO_c000_2586", 0),
    MVI(0xc0002587, "TODO_c000_2587", 0),
    MVI(0xc0002588, "TODO_c000_2588", 0),
    MVI(0xc0002589, "TODO_c000_2589", 0),
    MVI(0xc000258a, "TODO_c000_258a", 0),
    MVI(0xc000258b, "TODO_c000_258b", 0),
    MVI(0xc000258c, "TODO_c000_258c", 0),
    MVI(0xc000258d, "TODO_c000_258d", 0),
    MVI(0xc000258e, "TODO_c000_258e", 0),
    MVI(0xc000258f, "TODO_c000_258f", 0),
    MVI(0xc0002590, "TODO_c000_2590", 0),
    MVI(0xc0002591, "TODO_c000_2591", 0),
    MVI(0xc0002592, "TODO_c000_2592", 0),
    MVI(0xc0002593, "TODO_c000_2593", 0),
    MVI(0xc0002594, "TODO_c000_2594", 0),
    MVI(0xc0002595, "TODO_c000_2595", 0),
    MVI(0xc0002596, "TODO_c000_2596", 0),
    MVI(0xc0002597, "TODO_c000_2597", 0),
    MVI(0xc0002598, "TODO_c000_2598", 0),
    MVI(0xc0002599, "TODO_c000_2599", 0),
    MVI(0xc000259a, "TODO_c000_259a", 0),
    MVI(0xc000259b, "TODO_c000_259b", 0),
    MVI(0xc000259c, "TODO_c000_259c", 0),
    MVI(0xc000259d, "TODO_c000_259d", 0),
    MVI(0xc000259e, "TODO_c000_259e", 0),
    MVI(0xc000259f, "TODO_c000_259f", 0),
    MVI(0xc00025a0, "TODO_c000_25a0", 0),
    MVI(0xc00025a1, "TODO_c000_25a1", 0),
    MVI(0xc00025a2, "TODO_c000_25a2", 0),
    MVI(0xc00025a3, "TODO_c000_25a3", 0),
    MVI(0xc00025a4, "TODO_c000_25a4", 0),
    MVI(0xc00025a5, "TODO_c000_25a5", 0),
    MVI(0xc00025a6, "TODO_c000_25a6", 0),
    MVI(0xc00025a7, "TODO_c000_25a7", 0),
    MVI(0xc00025a8, "TODO_c000_25a8", 0),
    MVI(0xc00025a9, "TODO_c000_25a9", 0),
    MVI(0xc00025aa, "TODO_c000_25aa", 0),
    MVI(0xc00025ab, "TODO_c000_25ab", 0),
    MVI(0xc00025ac, "TODO_c000_25ac", 0),
    MVI(0xc00025ad, "TODO_c000_25ad", 0),
    MVI(0xc00025ae, "TODO_c000_25ae", 0),
    MVI(0xc00025af, "TODO_c000_25af", 0),
    MVI(0xc00025b0, "TODO_c000_25b0", 0),
    MVI(0xc00025b1, "TODO_c000_25b1", 0),
    MVI(0xc00025b2, "TODO_c000_25b2", 0),
    MVI(0xc00025b3, "TODO_c000_25b3", 0),
    MVI(0xc00025b4, "TODO_c000_25b4", 0),
    MVI(0xc00025b5, "TODO_c000_25b5", 0),
    MVI(0xc00025b6, "TODO_c000_25b6", 0),
    MVI(0xc00025b7, "TODO_c000_25b7", 0),
    MVI(0xc00025b8, "TODO_c000_25b8", 0),
    MVI(0xc00025b9, "TODO_c000_25b9", 0),
    MVI(0xc00025ba, "TODO_c000_25ba", 0),
    MVI(0xc00025bb, "TODO_c000_25bb", 0),
    MVI(0xc00025bc, "TODO_c000_25bc", 0),
    MVI(0xc00025bd, "TODO_c000_25bd", 0),
    MVI(0xc00025be, "TODO_c000_25be", 0),
    MVI(0xc00025bf, "TODO_c000_25bf", 0),
    MVI(0xc00025c0, "TODO_c000_25c0", 0),
    MVI(0xc00025c1, "TODO_c000_25c1", 0),
    MVI(0xc00025c2, "TODO_c000_25c2", 0),
    MVI(0xc00025c3, "TODO_c000_25c3", 0),
    MVI(0xc00025c4, "TODO_c000_25c4", 0),
    MVI(0xc00025c5, "TODO_c000_25c5", 0),
    MVI(0xc00025c6, "TODO_c000_25c6", 0),
    MVI(0xc00025c7, "TODO_c000_25c7", 0),
    MVI(0xc00025c8, "TODO_c000_25c8", 0),
    MVI(0xc00025c9, "TODO_c000_25c9", 0),
    MVI(0xc00025ca, "TODO_c000_25ca", 0),
    MVI(0xc00025cb, "TODO_c000_25cb", 0),
    MVI(0xc00025cc, "TODO_c000_25cc", 0),
    MVI(0xc00025cd, "TODO_c000_25cd", 0),
    MVI(0xc00025ce, "TODO_c000_25ce", 0),
    MVI(0xc00025cf, "TODO_c000_25cf", 0),
    MVI(0xc00025d0, "TODO_c000_25d0", 0),
    MVI(0xc00025d1, "TODO_c000_25d1", 0),
    MVI(0xc00025d2, "TODO_c000_25d2", 0),
    MVI(0xc00025d3, "TODO_c000_25d3", 0),
    MVI(0xc00025d4, "TODO_c000_25d4", 0),
    MVI(0xc00025d5, "TODO_c000_25d5", 0),
    MVI(0xc00025d6, "TODO_c000_25d6", 0),
    MVI(0xc00025d7, "TODO_c000_25d7", 0),
    MVI(0xc00025d8, "TODO_c000_25d8", 0),
    MVI(0xc00025d9, "TODO_c000_25d9", 0),
    MVI(0xc00025da, "TODO_c000_25da", 0),
    MVI(0xc00025db, "TODO_c000_25db", 0),
    MVI(0xc00025dc, "TODO_c000_25dc", 0),
    MVI(0xc00025dd, "TODO_c000_25dd", 0),
    MVI(0xc00025de, "TODO_c000_25de", 0),
    MVI(0xc00025df, "TODO_c000_25df", 0),
    MVI(0xc00025e0, "TODO_c000_25e0", 0),
    MVI(0xc00025e1, "TODO_c000_25e1", 0),
    MVI(0xc00025e2, "TODO_c000_25e2", 0),
    MVI(0xc00025e3, "TODO_c000_25e3", 0),
    MVI(0xc00025e4, "TODO_c000_25e4", 0),
    MVI(0xc00025e5, "TODO_c000_25e5", 0),
    MVI(0xc00025e6, "TODO_c000_25e6", 0),
    MVI(0xc00025e7, "TODO_c000_25e7", 0),
    MVI(0xc00025e8, "TODO_c000_25e8", 0),
    MVI(0xc00025e9, "TODO_c000_25e9", 0),
    MVI(0xc00025ea, "TODO_c000_25ea", 0),
    MVI(0xc00025eb, "TODO_c000_25eb", 0),
    MVI(0xc00025ec, "TODO_c000_25ec", 0),
    MVI(0xc00025ed, "TODO_c000_25ed", 0),
    MVI(0xc00025ee, "TODO_c000_25ee", 0),
    MVI(0xc00025ef, "TODO_c000_25ef", 0),
    MVI(0xc00025f0, "TODO_c000_25f0", 0),
    MVI(0xc00025f1, "TODO_c000_25f1", 0),
    MVI(0xc00025f2, "TODO_c000_25f2", 0),
    MVI(0xc00025f3, "TODO_c000_25f3", 0),
    MVI(0xc00025f4, "TODO_c000_25f4", 0),
    MVI(0xc00025f5, "TODO_c000_25f5", 0),
    MVI(0xc00025f6, "TODO_c000_25f6", 0),
    MVI(0xc00025f7, "TODO_c000_25f7", 0),
    MVI(0xc00025f8, "TODO_c000_25f8", 0),
    MVI(0xc00025f9, "TODO_c000_25f9", 0),
    MVI(0xc00025fa, "TODO_c000_25fa", 0),
    MVI(0xc00025fb, "TODO_c000_25fb", 0),
    MVI(0xc00025fc, "TODO_c000_25fc", 0),
    MVI(0xc00025fd, "TODO_c000_25fd", 0),
    MVI(0xc00025fe, "TODO_c000_25fe", 0),
    MVI(0xc00025ff, "TODO_c000_25ff", 0),
    MVI(0xc0002600, "TODO_c000_2600", 0),
    MVI(0xc0002601, "TODO_c000_2601", 0),
    MVI(0xc0002602, "TODO_c000_2602", 0),
    MVI(0xc0002603, "TODO_c000_2603", 0),
    MVI(0xc0002604, "TODO_c000_2604", 0),
    MVI(0xc0002605, "TODO_c000_2605", 0),
    MVI(0xc0002606, "TODO_c000_2606", 0),
    MVI(0xc0002607, "TODO_c000_2607", 0),
    MVI(0xc0002608, "TODO_c000_2608", 0),
    MVI(0xc0002609, "TODO_c000_2609", 0),
    MVI(0xc000260a, "TODO_c000_260a", 0),
    MVI(0xc000260b, "TODO_c000_260b", 0),
    MVI(0xc000260c, "TODO_c000_260c", 0),
    MVI(0xc000260d, "TODO_c000_260d", 0),
    MVI(0xc000260e, "TODO_c000_260e", 0),
    MVI(0xc000260f, "TODO_c000_260f", 0),
    MVI(0xc0002610, "TODO_c000_2610", 0),
    MVI(0xc0002611, "TODO_c000_2611", 0),
    MVI(0xc0002612, "TODO_c000_2612", 0),
    MVI(0xc0002613, "TODO_c000_2613", 0),
    MVI(0xc0002614, "TODO_c000_2614", 0),
    MVI(0xc0002615, "TODO_c000_2615", 0),
    MVI(0xc0002616, "TODO_c000_2616", 0),
    MVI(0xc0002617, "TODO_c000_2617", 0),
    MVI(0xc0002618, "TODO_c000_2618", 0),
    MVI(0xc0002619, "TODO_c000_2619", 0),
    MVI(0xc000261a, "TODO_c000_261a", 0),
    MVI(0xc000261b, "TODO_c000_261b", 0),
    MVI(0xc000261c, "TODO_c000_261c", 0),
    MVI(0xc000261d, "TODO_c000_261d", 0),
    MVI(0xc000261e, "TODO_c000_261e", 0),
    MVI(0xc000261f, "TODO_c000_261f", 0),
    MVI(0xc0002620, "TODO_c000_2620", 0),
    MVI(0xc0002621, "TODO_c000_2621", 0),
    MVI(0xc0002622, "TODO_c000_2622", 0),
    MVI(0xc0002623, "TODO_c000_2623", 0),
    MVI(0xc0002624, "TODO_c000_2624", 0),
    MVI(0xc0002625, "TODO_c000_2625", 0),
    MVI(0xc0002626, "TODO_c000_2626", 0),
    MVI(0xc0002627, "TODO_c000_2627", 0),
    MVI(0xc0002628, "TODO_c000_2628", 0),
    MVI(0xc0002629, "TODO_c000_2629", 0),
    MVI(0xc000262a, "TODO_c000_262a", 0),
    MVI(0xc000262b, "TODO_c000_262b", 0),
    MVI(0xc000262c, "TODO_c000_262c", 0),
    MVI(0xc000262d, "TODO_c000_262d", 0),
    MVI(0xc000262e, "TODO_c000_262e", 0),
    MVI(0xc000262f, "TODO_c000_262f", 0),
    MVI(0xc0002630, "TODO_c000_2630", 0),
    MVI(0xc0002631, "TODO_c000_2631", 0),
    MVI(0xc0002632, "TODO_c000_2632", 0),
    MVI(0xc0002633, "TODO_c000_2633", 0),
    MVI(0xc0002634, "TODO_c000_2634", 0),
    MVI(0xc0002635, "TODO_c000_2635", 0),
    MVI(0xc0002636, "TODO_c000_2636", 0),
    MVI(0xc0002637, "TODO_c000_2637", 0),
    MVI(0xc0002638, "TODO_c000_2638", 0),
    MVI(0xc0002639, "TODO_c000_2639", 0),
    MVI(0xc000263a, "TODO_c000_263a", 0),
    MVI(0xc000263b, "TODO_c000_263b", 0),
    MVI(0xc000263c, "TODO_c000_263c", 0),
    MVI(0xc000263d, "TODO_c000_263d", 0),
    MVI(0xc000263e, "TODO_c000_263e", 0),
    MVI(0xc000263f, "TODO_c000_263f", 0),
    MVI(0xc0002640, "TODO_c000_2640", 0),
    MVI(0xc0002641, "TODO_c000_2641", 0),
    MVI(0xc0002642, "TODO_c000_2642", 0),
    MVI(0xc0002643, "TODO_c000_2643", 0),
    MVI(0xc0002644, "TODO_c000_2644", 0),
    MVI(0xc0002645, "TODO_c000_2645", 0),
    MVI(0xc0002646, "TODO_c000_2646", 0),
    MVI(0xc0002647, "TODO_c000_2647", 0),
    MVI(0xc0002648, "TODO_c000_2648", 0),
    MVI(0xc0002649, "TODO_c000_2649", 0),
    MVI(0xc000264a, "TODO_c000_264a", 0),
    MVI(0xc000264b, "TODO_c000_264b", 0),
    MVI(0xc000264c, "TODO_c000_264c", 0),
    MVI(0xc000264d, "TODO_c000_264d", 0),
    MVI(0xc000264e, "TODO_c000_264e", 0),
    MVI(0xc000264f, "TODO_c000_264f", 0),
    MVI(0xc0002650, "TODO_c000_2650", 0),
    MVI(0xc0002651, "TODO_c000_2651", 0),
    MVI(0xc0002652, "TODO_c000_2652", 0),
    MVI(0xc0002653, "TODO_c000_2653", 0),
    MVI(0xc0002654, "TODO_c000_2654", 0),
    MVI(0xc0002655, "TODO_c000_2655", 0),
    MVI(0xc0002656, "TODO_c000_2656", 0),
    MVI(0xc0002657, "TODO_c000_2657", 0),
    MVI(0xc0002658, "TODO_c000_2658", 0),
    MVI(0xc0002659, "TODO_c000_2659", 0),
    MVI(0xc000265a, "TODO_c000_265a", 0),
    MVI(0xc000265b, "TODO_c000_265b", 0),
    MVI(0xc000265c, "TODO_c000_265c", 0),
    MVI(0xc000265d, "TODO_c000_265d", 0),
    MVI(0xc000265e, "TODO_c000_265e", 0),
    MVI(0xc000265f, "TODO_c000_265f", 0),
    MVI(0xc0002660, "TODO_c000_2660", 0),
    MVI(0xc0002661, "TODO_c000_2661", 0),
    MVI(0xc0002662, "TODO_c000_2662", 0),
    MVI(0xc0002663, "TODO_c000_2663", 0),
    MVI(0xc0002664, "TODO_c000_2664", 0),
    MVI(0xc0002665, "TODO_c000_2665", 0),
    MVI(0xc0002666, "TODO_c000_2666", 0),
    MVI(0xc0002667, "TODO_c000_2667", 0),
    MVI(0xc0002668, "TODO_c000_2668", 0),
    MVI(0xc0002669, "TODO_c000_2669", 0),
    MVI(0xc000266a, "TODO_c000_266a", 0),
    MVI(0xc000266b, "TODO_c000_266b", 0),
    MVI(0xc000266c, "TODO_c000_266c", 0),
    MVI(0xc000266d, "TODO_c000_266d", 0),
    MVI(0xc000266e, "TODO_c000_266e", 0),
    MVI(0xc000266f, "TODO_c000_266f", 0),
    MVI(0xc0002670, "TODO_c000_2670", 0),
    MVI(0xc0002671, "TODO_c000_2671", 0),
    MVI(0xc0002672, "TODO_c000_2672", 0),
    MVI(0xc0002673, "TODO_c000_2673", 0),
    MVI(0xc0002674, "TODO_c000_2674", 0),
    MVI(0xc0002675, "TODO_c000_2675", 0),
    MVI(0xc0002676, "TODO_c000_2676", 0),
    MVI(0xc0002677, "TODO_c000_2677", 0),
    MVI(0xc0002678, "TODO_c000_2678", 0),
    MVI(0xc0002679, "TODO_c000_2679", 0),
    MVI(0xc000267a, "TODO_c000_267a", 0),
    MVI(0xc000267b, "TODO_c000_267b", 0),
    MVI(0xc000267c, "TODO_c000_267c", 0),
    MVI(0xc000267d, "TODO_c000_267d", 0),
    MVI(0xc000267e, "TODO_c000_267e", 0),
    MVI(0xc000267f, "TODO_c000_267f", 0),
    MVI(0xc0002680, "TODO_c000_2680", 0),
    MVI(0xc0002681, "TODO_c000_2681", 0),
    MVI(0xc0002682, "TODO_c000_2682", 0),
    MVI(0xc0002683, "TODO_c000_2683", 0),
    MVI(0xc0002684, "TODO_c000_2684", 0),
    MVI(0xc0002685, "TODO_c000_2685", 0),
    MVI(0xc0002686, "TODO_c000_2686", 0),
    MVI(0xc0002687, "TODO_c000_2687", 0),
    MVI(0xc0002688, "TODO_c000_2688", 0),
    MVI(0xc0002689, "TODO_c000_2689", 0),
    MVI(0xc000268a, "TODO_c000_268a", 0),
    MVI(0xc000268b, "TODO_c000_268b", 0),
    MVI(0xc000268c, "TODO_c000_268c", 0),
    MVI(0xc000268d, "TODO_c000_268d", 0),
    MVI(0xc000268e, "TODO_c000_268e", 0),
    MVI(0xc000268f, "TODO_c000_268f", 0),
    MVI(0xc0002690, "TODO_c000_2690", 0),
    MVI(0xc0002691, "TODO_c000_2691", 0),
    MVI(0xc0002692, "TODO_c000_2692", 0),
    MVI(0xc0002693, "TODO_c000_2693", 0),
    MVI(0xc0002694, "TODO_c000_2694", 0),
    MVI(0xc0002695, "TODO_c000_2695", 0),
    MVI(0xc0002696, "TODO_c000_2696", 0),
    MVI(0xc0002697, "TODO_c000_2697", 0),
    MVI(0xc0002698, "TODO_c000_2698", 0),
    MVI(0xc0002699, "TODO_c000_2699", 0),
    MVI(0xc000269a, "TODO_c000_269a", 0),
    MVI(0xc000269b, "TODO_c000_269b", 0),
    MVI(0xc000269c, "TODO_c000_269c", 0),
    MVI(0xc000269d, "TODO_c000_269d", 0),
    MVI(0xc000269e, "TODO_c000_269e", 0),
    MVI(0xc000269f, "TODO_c000_269f", 0),
    MVI(0xc00026a0, "TODO_c000_26a0", 0),
    MVI(0xc00026a1, "TODO_c000_26a1", 0),
    MVI(0xc00026a2, "TODO_c000_26a2", 0),
    MVI(0xc00026a3, "TODO_c000_26a3", 0),
    MVI(0xc00026a4, "TODO_c000_26a4", 0),
    MVI(0xc00026a5, "TODO_c000_26a5", 0),
    MVI(0xc00026a6, "TODO_c000_26a6", 0),
    MVI(0xc00026a7, "TODO_c000_26a7", 0),
    MVI(0xc00026a8, "TODO_c000_26a8", 0),
    MVI(0xc00026a9, "TODO_c000_26a9", 0),
    MVI(0xc00026aa, "TODO_c000_26aa", 0),
    MVI(0xc00026ab, "TODO_c000_26ab", 0),
    MVI(0xc00026ac, "TODO_c000_26ac", 0),
    MVI(0xc00026ad, "TODO_c000_26ad", 0),
    MVI(0xc00026ae, "TODO_c000_26ae", 0),
    MVI(0xc00026af, "TODO_c000_26af", 0),
    MVI(0xc00026b0, "TODO_c000_26b0", 0),
    MVI(0xc00026b1, "TODO_c000_26b1", 0),
    MVI(0xc00026b2, "TODO_c000_26b2", 0),
    MVI(0xc00026b3, "TODO_c000_26b3", 0),
    MVI(0xc00026b4, "TODO_c000_26b4", 0),
    MVI(0xc00026b5, "TODO_c000_26b5", 0),
    MVI(0xc00026b6, "TODO_c000_26b6", 0),
    MVI(0xc00026b7, "TODO_c000_26b7", 0),
    MVI(0xc00026b8, "TODO_c000_26b8", 0),
    MVI(0xc00026b9, "TODO_c000_26b9", 0),
    MVI(0xc00026ba, "TODO_c000_26ba", 0),
    MVI(0xc00026bb, "TODO_c000_26bb", 0),
    MVI(0xc00026bc, "TODO_c000_26bc", 0),
    MVI(0xc00026bd, "TODO_c000_26bd", 0),
    MVI(0xc00026be, "TODO_c000_26be", 0),
    MVI(0xc00026bf, "TODO_c000_26bf", 0),
    MVI(0xc00026c0, "TODO_c000_26c0", 0),
    MVI(0xc00026c1, "TODO_c000_26c1", 0),
    MVI(0xc00026c2, "TODO_c000_26c2", 0),
    MVI(0xc00026c3, "TODO_c000_26c3", 0),
    MVI(0xc00026c4, "TODO_c000_26c4", 0),
    MVI(0xc00026c5, "TODO_c000_26c5", 0),
    MVI(0xc00026c6, "TODO_c000_26c6", 0),
    MVI(0xc00026c7, "TODO_c000_26c7", 0),
    MVI(0xc00026c8, "TODO_c000_26c8", 0),
    MVI(0xc00026c9, "TODO_c000_26c9", 0),
    MVI(0xc00026ca, "TODO_c000_26ca", 0),
    MVI(0xc00026cb, "TODO_c000_26cb", 0),
    MVI(0xc00026cc, "TODO_c000_26cc", 0),
    MVI(0xc00026cd, "TODO_c000_26cd", 0),
    MVI(0xc00026ce, "TODO_c000_26ce", 0),
    MVI(0xc00026cf, "TODO_c000_26cf", 0),
    MVI(0xc00026d0, "TODO_c000_26d0", 0),
    MVI(0xc00026d1, "TODO_c000_26d1", 0),
    MVI(0xc00026d2, "TODO_c000_26d2", 0),
    MVI(0xc00026d3, "TODO_c000_26d3", 0),
    MVI(0xc00026d4, "TODO_c000_26d4", 0),
    MVI(0xc00026d5, "TODO_c000_26d5", 0),
    MVI(0xc00026d6, "TODO_c000_26d6", 0),
    MVI(0xc00026d7, "TODO_c000_26d7", 0),
    MVI(0xc00026d8, "TODO_c000_26d8", 0),
    MVI(0xc00026d9, "TODO_c000_26d9", 0),
    MVI(0xc00026da, "TODO_c000_26da", 0),
    MVI(0xc00026db, "TODO_c000_26db", 0),
    MVI(0xc00026dc, "TODO_c000_26dc", 0),
    MVI(0xc00026dd, "TODO_c000_26dd", 0),
    MVI(0xc00026de, "TODO_c000_26de", 0),
    MVI(0xc00026df, "TODO_c000_26df", 0),
    MVI(0xc00026e0, "TODO_c000_26e0", 0),
    MVI(0xc00026e1, "TODO_c000_26e1", 0),
    MVI(0xc00026e2, "TODO_c000_26e2", 0),
    MVI(0xc00026e3, "TODO_c000_26e3", 0),
    MVI(0xc00026e4, "TODO_c000_26e4", 0),
    MVI(0xc00026e5, "TODO_c000_26e5", 0),
    MVI(0xc00026e6, "TODO_c000_26e6", 0),
    MVI(0xc00026e7, "TODO_c000_26e7", 0),
    MVI(0xc00026e8, "TODO_c000_26e8", 0),
    MVI(0xc00026e9, "TODO_c000_26e9", 0),
    MVI(0xc00026ea, "TODO_c000_26ea", 0),
    MVI(0xc00026eb, "TODO_c000_26eb", 0),
    MVI(0xc00026ec, "TODO_c000_26ec", 0),
    MVI(0xc00026ed, "TODO_c000_26ed", 0),
    MVI(0xc00026ee, "TODO_c000_26ee", 0),
    MVI(0xc00026ef, "TODO_c000_26ef", 0),
    MVI(0xc00026f0, "TODO_c000_26f0", 0),
    MVI(0xc00026f1, "TODO_c000_26f1", 0),
    MVI(0xc00026f2, "TODO_c000_26f2", 0),
    MVI(0xc00026f3, "TODO_c000_26f3", 0),
    MVI(0xc00026f4, "TODO_c000_26f4", 0),
    MVI(0xc00026f5, "TODO_c000_26f5", 0),
    MVI(0xc00026f6, "TODO_c000_26f6", 0),
    MVI(0xc00026f7, "TODO_c000_26f7", 0),
    MVI(0xc00026f8, "TODO_c000_26f8", 0),
    MVI(0xc00026f9, "TODO_c000_26f9", 0),
    MVI(0xc00026fa, "TODO_c000_26fa", 0),
    MVI(0xc00026fb, "TODO_c000_26fb", 0),
    MVI(0xc00026fc, "TODO_c000_26fc", 0),
    MVI(0xc00026fd, "TODO_c000_26fd", 0),
    MVI(0xc00026fe, "TODO_c000_26fe", 0),
    MVI(0xc00026ff, "TODO_c000_26ff", 0),
    MVI(0xc0002700, "TODO_c000_2700", 0),
    MVI(0xc0002701, "TODO_c000_2701", 0),
    MVI(0xc0002702, "TODO_c000_2702", 0),
    MVI(0xc0002703, "TODO_c000_2703", 0),
    MVI(0xc0002704, "TODO_c000_2704", 0),
    MVI(0xc0002705, "TODO_c000_2705", 0),
    MVI(0xc0002706, "TODO_c000_2706", 0),
    MVI(0xc0002707, "TODO_c000_2707", 0),
    MVI(0xc0002708, "TODO_c000_2708", 0),
    MVI(0xc0002709, "TODO_c000_2709", 0),
    MVI(0xc000270a, "TODO_c000_270a", 0),
    MVI(0xc000270b, "TODO_c000_270b", 0),
    MVI(0xc000270c, "TODO_c000_270c", 0),
    MVI(0xc000270d, "TODO_c000_270d", 0),
    MVI(0xc000270e, "TODO_c000_270e", 0),
    MVI(0xc000270f, "TODO_c000_270f", 0),
    MVI(0xc0002710, "TODO_c000_2710", 0),
    MVI(0xc0002711, "TODO_c000_2711", 0),
    MVI(0xc0002712, "TODO_c000_2712", 0),
    MVI(0xc0002713, "TODO_c000_2713", 0),
    MVI(0xc0002714, "TODO_c000_2714", 0),
    MVI(0xc0002715, "TODO_c000_2715", 0),
    MVI(0xc0002716, "TODO_c000_2716", 0),
    MVI(0xc0002717, "TODO_c000_2717", 0),
    MVI(0xc0002718, "TODO_c000_2718", 0),
    MVI(0xc0002719, "TODO_c000_2719", 0),
    MVI(0xc000271a, "TODO_c000_271a", 0),
    MVI(0xc000271b, "TODO_c000_271b", 0),
    MVI(0xc000271c, "TODO_c000_271c", 0),
    MVI(0xc000271d, "TODO_c000_271d", 0),
    MVI(0xc000271e, "TODO_c000_271e", 0),
    MVI(0xc000271f, "TODO_c000_271f", 0),
    MVI(0xc0002720, "TODO_c000_2720", 0),
    MVI(0xc0002721, "TODO_c000_2721", 0),
    MVI(0xc0002722, "TODO_c000_2722", 0),
    MVI(0xc0002723, "TODO_c000_2723", 0),
    MVI(0xc0002724, "TODO_c000_2724", 0),
    MVI(0xc0002725, "TODO_c000_2725", 0),
    MVI(0xc0002726, "TODO_c000_2726", 0),
    MVI(0xc0002727, "TODO_c000_2727", 0),
    MVI(0xc0002728, "TODO_c000_2728", 0),
    MVI(0xc0002729, "TODO_c000_2729", 0),
    MVI(0xc000272a, "TODO_c000_272a", 0),
    MVI(0xc000272b, "TODO_c000_272b", 0),
    MVI(0xc000272c, "TODO_c000_272c", 0),
    MVI(0xc000272d, "TODO_c000_272d", 0),
    MVI(0xc000272e, "TODO_c000_272e", 0),
    MVI(0xc000272f, "TODO_c000_272f", 0),
    MVI(0xc0002730, "TODO_c000_2730", 0),
    MVI(0xc0002731, "TODO_c000_2731", 0),
    MVI(0xc0002732, "TODO_c000_2732", 0),
    MVI(0xc0002733, "TODO_c000_2733", 0),
    MVI(0xc0002734, "TODO_c000_2734", 0),
    MVI(0xc0002735, "TODO_c000_2735", 0),
    MVI(0xc0002736, "TODO_c000_2736", 0),
    MVI(0xc0002737, "TODO_c000_2737", 0),
    MVI(0xc0002738, "TODO_c000_2738", 0),
    MVI(0xc0002739, "TODO_c000_2739", 0),
    MVI(0xc000273a, "TODO_c000_273a", 0),
    MVI(0xc000273b, "TODO_c000_273b", 0),
    MVI(0xc000273c, "TODO_c000_273c", 0),
    MVI(0xc000273d, "TODO_c000_273d", 0),
    MVI(0xc000273e, "TODO_c000_273e", 0),
    MVI(0xc000273f, "TODO_c000_273f", 0),
    MVI(0xc0002740, "TODO_c000_2740", 0),
    MVI(0xc0002741, "TODO_c000_2741", 0),
    MVI(0xc0002742, "TODO_c000_2742", 0),
    MVI(0xc0002743, "TODO_c000_2743", 0),
    MVI(0xc0002744, "TODO_c000_2744", 0),
    MVI(0xc0002745, "TODO_c000_2745", 0),
    MVI(0xc0002746, "TODO_c000_2746", 0),
    MVI(0xc0002747, "TODO_c000_2747", 0),
    MVI(0xc0002748, "TODO_c000_2748", 0),
    MVI(0xc0002749, "TODO_c000_2749", 0),
    MVI(0xc000274a, "TODO_c000_274a", 0),
    MVI(0xc000274b, "TODO_c000_274b", 0),
    MVI(0xc000274c, "TODO_c000_274c", 0),
    MVI(0xc000274d, "TODO_c000_274d", 0),
    MVI(0xc000274e, "TODO_c000_274e", 0),
    MVI(0xc000274f, "TODO_c000_274f", 0),
    MVI(0xc0002750, "TODO_c000_2750", 0),
    MVI(0xc0002751, "TODO_c000_2751", 0),
    MVI(0xc0002752, "TODO_c000_2752", 0),
    MVI(0xc0002753, "TODO_c000_2753", 0),
    MVI(0xc0002754, "TODO_c000_2754", 0),
    MVI(0xc0002755, "TODO_c000_2755", 0),
    MVI(0xc0002756, "TODO_c000_2756", 0),
    MVI(0xc0002757, "TODO_c000_2757", 0),
    MVI(0xc0002758, "TODO_c000_2758", 0),
    MVI(0xc0002759, "TODO_c000_2759", 0),
    MVI(0xc000275a, "TODO_c000_275a", 0),
    MVI(0xc000275b, "TODO_c000_275b", 0),
    MVI(0xc000275c, "TODO_c000_275c", 0),
    MVI(0xc000275d, "TODO_c000_275d", 0),
    MVI(0xc000275e, "TODO_c000_275e", 0),
    MVI(0xc000275f, "TODO_c000_275f", 0),
    MVI(0xc0002760, "TODO_c000_2760", 0),
    MVI(0xc0002761, "TODO_c000_2761", 0),
    MVI(0xc0002762, "TODO_c000_2762", 0),
    MVI(0xc0002763, "TODO_c000_2763", 0),
    MVI(0xc0002764, "TODO_c000_2764", 0),
    MVI(0xc0002765, "TODO_c000_2765", 0),
    MVI(0xc0002766, "TODO_c000_2766", 0),
    MVI(0xc0002767, "TODO_c000_2767", 0),
    MVI(0xc0002768, "TODO_c000_2768", 0),
    MVI(0xc0002769, "TODO_c000_2769", 0),
    MVI(0xc000276a, "TODO_c000_276a", 0),
    MVI(0xc000276b, "TODO_c000_276b", 0),
    MVI(0xc000276c, "TODO_c000_276c", 0),
    MVI(0xc000276d, "TODO_c000_276d", 0),
    MVI(0xc000276e, "TODO_c000_276e", 0),
    MVI(0xc000276f, "TODO_c000_276f", 0),
    MVI(0xc0002770, "TODO_c000_2770", 0),
    MVI(0xc0002771, "TODO_c000_2771", 0),
    MVI(0xc0002772, "TODO_c000_2772", 0),
    MVI(0xc0002773, "TODO_c000_2773", 0),
    MVI(0xc0002774, "TODO_c000_2774", 0),
    MVI(0xc0002775, "TODO_c000_2775", 0),
    MVI(0xc0002776, "TODO_c000_2776", 0),
    MVI(0xc0002777, "TODO_c000_2777", 0),
    MVI(0xc0002778, "TODO_c000_2778", 0),
    MVI(0xc0002779, "TODO_c000_2779", 0),
    MVI(0xc000277a, "TODO_c000_277a", 0),
    MVI(0xc000277b, "TODO_c000_277b", 0),
    MVI(0xc000277c, "TODO_c000_277c", 0),
    MVI(0xc000277d, "TODO_c000_277d", 0),
    MVI(0xc000277e, "TODO_c000_277e", 0),
    MVI(0xc000277f, "TODO_c000_277f", 0),
    MVI(0xc0002780, "TODO_c000_2780", 0),
    MVI(0xc0002781, "TODO_c000_2781", 0),
    MVI(0xc0002782, "TODO_c000_2782", 0),
    MVI(0xc0002783, "TODO_c000_2783", 0),
    MVI(0xc0002784, "TODO_c000_2784", 0),
    MVI(0xc0002785, "TODO_c000_2785", 0),
    MVI(0xc0002786, "TODO_c000_2786", 0),
    MVI(0xc0002787, "TODO_c000_2787", 0),
    MVI(0xc0002788, "TODO_c000_2788", 0),
    MVI(0xc0002789, "TODO_c000_2789", 0),
    MVI(0xc000278a, "TODO_c000_278a", 0),
    MVI(0xc000278b, "TODO_c000_278b", 0),
    MVI(0xc000278c, "TODO_c000_278c", 0),
    MVI(0xc000278d, "TODO_c000_278d", 0),
    MVI(0xc000278e, "TODO_c000_278e", 0),
    MVI(0xc000278f, "TODO_c000_278f", 0),
    MVI(0xc0002790, "TODO_c000_2790", 0),
    MVI(0xc0002791, "TODO_c000_2791", 0),
    MVI(0xc0002792, "TODO_c000_2792", 0),
    MVI(0xc0002793, "TODO_c000_2793", 0),
    MVI(0xc0002794, "TODO_c000_2794", 0),
    MVI(0xc0002795, "TODO_c000_2795", 0),
    MVI(0xc0002796, "TODO_c000_2796", 0),
    MVI(0xc0002797, "TODO_c000_2797", 0),
    MVI(0xc0002798, "TODO_c000_2798", 0),
    MVI(0xc0002799, "TODO_c000_2799", 0),
    MVI(0xc000279a, "TODO_c000_279a", 0),
    MVI(0xc000279b, "TODO_c000_279b", 0),
    MVI(0xc000279c, "TODO_c000_279c", 0),
    MVI(0xc000279d, "TODO_c000_279d", 0),
    MVI(0xc000279e, "TODO_c000_279e", 0),
    MVI(0xc000279f, "TODO_c000_279f", 0),
    MVI(0xc00027a0, "TODO_c000_27a0", 0),
    MVI(0xc00027a1, "TODO_c000_27a1", 0),
    MVI(0xc00027a2, "TODO_c000_27a2", 0),
    MVI(0xc00027a3, "TODO_c000_27a3", 0),
    MVI(0xc00027a4, "TODO_c000_27a4", 0),
    MVI(0xc00027a5, "TODO_c000_27a5", 0),
    MVI(0xc00027a6, "TODO_c000_27a6", 0),
    MVI(0xc00027a7, "TODO_c000_27a7", 0),
    MVI(0xc00027a8, "TODO_c000_27a8", 0),
    MVI(0xc00027a9, "TODO_c000_27a9", 0),
    MVI(0xc00027aa, "TODO_c000_27aa", 0),
    MVI(0xc00027ab, "TODO_c000_27ab", 0),
    MVI(0xc00027ac, "TODO_c000_27ac", 0),
    MVI(0xc00027ad, "TODO_c000_27ad", 0),
    MVI(0xc00027ae, "TODO_c000_27ae", 0),
    MVI(0xc00027af, "TODO_c000_27af", 0),
    MVI(0xc00027b0, "TODO_c000_27b0", 0),
    MVI(0xc00027b1, "TODO_c000_27b1", 0),
    MVI(0xc00027b2, "TODO_c000_27b2", 0),
    MVI(0xc00027b3, "TODO_c000_27b3", 0),
    MVI(0xc00027b4, "TODO_c000_27b4", 0),
    MVI(0xc00027b5, "TODO_c000_27b5", 0),
    MVI(0xc00027b6, "TODO_c000_27b6", 0),
    MVI(0xc00027b7, "TODO_c000_27b7", 0),
    MVI(0xc00027b8, "TODO_c000_27b8", 0),
    MVI(0xc00027b9, "TODO_c000_27b9", 0),
    MVI(0xc00027ba, "TODO_c000_27ba", 0),
    MVI(0xc00027bb, "TODO_c000_27bb", 0),
    MVI(0xc00027bc, "TODO_c000_27bc", 0),
    MVI(0xc00027bd, "TODO_c000_27bd", 0),
    MVI(0xc00027be, "TODO_c000_27be", 0),
    MVI(0xc00027bf, "TODO_c000_27bf", 0),
    MVI(0xc00027c0, "TODO_c000_27c0", 0),
    MVI(0xc00027c1, "TODO_c000_27c1", 0),
    MVI(0xc00027c2, "TODO_c000_27c2", 0),
    MVI(0xc00027c3, "TODO_c000_27c3", 0),
    MVI(0xc00027c4, "TODO_c000_27c4", 0),
    MVI(0xc00027c5, "TODO_c000_27c5", 0),
    MVI(0xc00027c6, "TODO_c000_27c6", 0),
    MVI(0xc00027c7, "TODO_c000_27c7", 0),
    MVI(0xc00027c8, "TODO_c000_27c8", 0),
    MVI(0xc00027c9, "TODO_c000_27c9", 0),
    MVI(0xc00027ca, "TODO_c000_27ca", 0),
    MVI(0xc00027cb, "TODO_c000_27cb", 0),
    MVI(0xc00027cc, "TODO_c000_27cc", 0),
    MVI(0xc00027cd, "TODO_c000_27cd", 0),
    MVI(0xc00027ce, "TODO_c000_27ce", 0),
    MVI(0xc00027cf, "TODO_c000_27cf", 0),
    MVI(0xc00027d0, "TODO_c000_27d0", 0),
    MVI(0xc00027d1, "TODO_c000_27d1", 0),
    MVI(0xc00027d2, "TODO_c000_27d2", 0),
    MVI(0xc00027d3, "TODO_c000_27d3", 0),
    MVI(0xc00027d4, "TODO_c000_27d4", 0),
    MVI(0xc00027d5, "TODO_c000_27d5", 0),
    MVI(0xc00027d6, "TODO_c000_27d6", 0),
    MVI(0xc00027d7, "TODO_c000_27d7", 0),
    MVI(0xc00027d8, "TODO_c000_27d8", 0),
    MVI(0xc00027d9, "TODO_c000_27d9", 0),
    MVI(0xc00027da, "TODO_c000_27da", 0),
    MVI(0xc00027db, "TODO_c000_27db", 0),
    MVI(0xc00027dc, "TODO_c000_27dc", 0),
    MVI(0xc00027dd, "TODO_c000_27dd", 0),
    MVI(0xc00027de, "TODO_c000_27de", 0),
    MVI(0xc00027df, "TODO_c000_27df", 0),
    MVI(0xc00027e0, "TODO_c000_27e0", 0),
    MVI(0xc00027e1, "TODO_c000_27e1", 0),
    MVI(0xc00027e2, "TODO_c000_27e2", 0),
    MVI(0xc00027e3, "TODO_c000_27e3", 0),
    MVI(0xc00027e4, "TODO_c000_27e4", 0),
    MVI(0xc00027e5, "TODO_c000_27e5", 0),
    MVI(0xc00027e6, "TODO_c000_27e6", 0),
    MVI(0xc00027e7, "TODO_c000_27e7", 0),
    MVI(0xc00027e8, "TODO_c000_27e8", 0),
    MVI(0xc00027e9, "TODO_c000_27e9", 0),
    MVI(0xc00027ea, "TODO_c000_27ea", 0),
    MVI(0xc00027eb, "TODO_c000_27eb", 0),
    MVI(0xc00027ec, "TODO_c000_27ec", 0),
    MVI(0xc00027ed, "TODO_c000_27ed", 0),
    MVI(0xc00027ee, "TODO_c000_27ee", 0),
    MVI(0xc00027ef, "TODO_c000_27ef", 0),
    MVI(0xc00027f0, "TODO_c000_27f0", 0),
    MVI(0xc00027f1, "TODO_c000_27f1", 0),
    MVI(0xc00027f2, "TODO_c000_27f2", 0),
    MVI(0xc00027f3, "TODO_c000_27f3", 0),
    MVI(0xc00027f4, "TODO_c000_27f4", 0),
    MVI(0xc00027f5, "TODO_c000_27f5", 0),
    MVI(0xc00027f6, "TODO_c000_27f6", 0),
    MVI(0xc00027f7, "TODO_c000_27f7", 0),
    MVI(0xc00027f8, "TODO_c000_27f8", 0),
    MVI(0xc00027f9, "TODO_c000_27f9", 0),
    MVI(0xc00027fa, "TODO_c000_27fa", 0),
    MVI(0xc00027fb, "TODO_c000_27fb", 0),
    MVI(0xc00027fc, "TODO_c000_27fc", 0),
    MVI(0xc00027fd, "TODO_c000_27fd", 0),
    MVI(0xc00027fe, "TODO_c000_27fe", 0),
    MVI(0xc00027ff, "TODO_c000_27ff", 0),
    MVI(0xc0002800, "TODO_c000_2800", 0),
    MVI(0xc0002801, "TODO_c000_2801", 0),
    MVI(0xc0002802, "TODO_c000_2802", 0),
    MVI(0xc0002803, "TODO_c000_2803", 0),
    MVI(0xc0002804, "TODO_c000_2804", 0),
    MVI(0xc0002805, "TODO_c000_2805", 0),
    MVI(0xc0002806, "TODO_c000_2806", 0),
    MVI(0xc0002807, "TODO_c000_2807", 0),
    MVI(0xc0002808, "TODO_c000_2808", 0),
    MVI(0xc0002809, "TODO_c000_2809", 0),
    MVI(0xc000280a, "TODO_c000_280a", 0),
    MVI(0xc000280b, "TODO_c000_280b", 0),
    MVI(0xc000280c, "TODO_c000_280c", 0),
    MVI(0xc000280d, "TODO_c000_280d", 0),
    MVI(0xc000280e, "TODO_c000_280e", 0),
    MVI(0xc000280f, "TODO_c000_280f", 0),
    MVI(0xc0002810, "TODO_c000_2810", 0),
    MVI(0xc0002811, "TODO_c000_2811", 0),
    MVI(0xc0002812, "TODO_c000_2812", 0),
    MVI(0xc0002813, "TODO_c000_2813", 0),
    MVI(0xc0002814, "TODO_c000_2814", 0),
    MVI(0xc0002815, "TODO_c000_2815", 0),
    MVI(0xc0002816, "TODO_c000_2816", 0),
    MVI(0xc0002817, "TODO_c000_2817", 0),
    MVI(0xc0002818, "TODO_c000_2818", 0),
    MVI(0xc0002819, "TODO_c000_2819", 0),
    MVI(0xc000281a, "TODO_c000_281a", 0),
    MVI(0xc000281b, "TODO_c000_281b", 0),
    MVI(0xc000281c, "TODO_c000_281c", 0),
    MVI(0xc000281d, "TODO_c000_281d", 0),
    MVI(0xc000281e, "TODO_c000_281e", 0),
    MVI(0xc000281f, "TODO_c000_281f", 0),
    MVI(0xc0002820, "TODO_c000_2820", 0),
    MVI(0xc0002821, "TODO_c000_2821", 0),
    MVI(0xc0002822, "TODO_c000_2822", 0),
    MVI(0xc0002823, "TODO_c000_2823", 0),
    MVI(0xc0002824, "TODO_c000_2824", 0),
    MVI(0xc0002825, "TODO_c000_2825", 0),
    MVI(0xc0002826, "TODO_c000_2826", 0),
    MVI(0xc0002827, "TODO_c000_2827", 0),
    MVI(0xc0002828, "TODO_c000_2828", 0),
    MVI(0xc0002829, "TODO_c000_2829", 0),
    MVI(0xc000282a, "TODO_c000_282a", 0),
    MVI(0xc000282b, "TODO_c000_282b", 0),
    MVI(0xc000282c, "TODO_c000_282c", 0),
    MVI(0xc000282d, "TODO_c000_282d", 0),
    MVI(0xc000282e, "TODO_c000_282e", 0),
    MVI(0xc000282f, "TODO_c000_282f", 0),
    MVI(0xc0002830, "TODO_c000_2830", 0),
    MVI(0xc0002831, "TODO_c000_2831", 0),
    MVI(0xc0002832, "TODO_c000_2832", 0),
    MVI(0xc0002833, "TODO_c000_2833", 0),
    MVI(0xc0002834, "TODO_c000_2834", 0),
    MVI(0xc0002835, "TODO_c000_2835", 0),
    MVI(0xc0002836, "TODO_c000_2836", 0),
    MVI(0xc0002837, "TODO_c000_2837", 0),
    MVI(0xc0002838, "TODO_c000_2838", 0),
    MVI(0xc0002839, "TODO_c000_2839", 0),
    MVI(0xc000283a, "TODO_c000_283a", 0),
    MVI(0xc000283b, "TODO_c000_283b", 0),
    MVI(0xc000283c, "TODO_c000_283c", 0),
    MVI(0xc000283d, "TODO_c000_283d", 0),
    MVI(0xc000283e, "TODO_c000_283e", 0),
    MVI(0xc000283f, "TODO_c000_283f", 0),
    MVI(0xc0002840, "TODO_c000_2840", 0),
    MVI(0xc0002841, "TODO_c000_2841", 0),
    MVI(0xc0002842, "TODO_c000_2842", 0),
    MVI(0xc0002843, "TODO_c000_2843", 0),
    MVI(0xc0002844, "TODO_c000_2844", 0),
    MVI(0xc0002845, "TODO_c000_2845", 0),
    MVI(0xc0002846, "TODO_c000_2846", 0),
    MVI(0xc0002847, "TODO_c000_2847", 0),
    MVI(0xc0002848, "TODO_c000_2848", 0),
    MVI(0xc0002849, "TODO_c000_2849", 0),
    MVI(0xc000284a, "TODO_c000_284a", 0),
    MVI(0xc000284b, "TODO_c000_284b", 0),
    MVI(0xc000284c, "TODO_c000_284c", 0),
    MVI(0xc000284d, "TODO_c000_284d", 0),
    MVI(0xc000284e, "TODO_c000_284e", 0),
    MVI(0xc000284f, "TODO_c000_284f", 0),
    MVI(0xc0002850, "TODO_c000_2850", 0),
    MVI(0xc0002851, "TODO_c000_2851", 0),
    MVI(0xc0002852, "TODO_c000_2852", 0),
    MVI(0xc0002853, "TODO_c000_2853", 0),
    MVI(0xc0002854, "TODO_c000_2854", 0),
    MVI(0xc0002855, "TODO_c000_2855", 0),
    MVI(0xc0002856, "TODO_c000_2856", 0),
    MVI(0xc0002857, "TODO_c000_2857", 0),
    MVI(0xc0002858, "TODO_c000_2858", 0),
    MVI(0xc0002859, "TODO_c000_2859", 0),
    MVI(0xc000285a, "TODO_c000_285a", 0),
    MVI(0xc000285b, "TODO_c000_285b", 0),
    MVI(0xc000285c, "TODO_c000_285c", 0),
    MVI(0xc000285d, "TODO_c000_285d", 0),
    MVI(0xc000285e, "TODO_c000_285e", 0),
    MVI(0xc000285f, "TODO_c000_285f", 0),
    MVI(0xc0002860, "TODO_c000_2860", 0),
    MVI(0xc0002861, "TODO_c000_2861", 0),
    MVI(0xc0002862, "TODO_c000_2862", 0),
    MVI(0xc0002863, "TODO_c000_2863", 0),
    MVI(0xc0002864, "TODO_c000_2864", 0),
    MVI(0xc0002865, "TODO_c000_2865", 0),
    MVI(0xc0002866, "TODO_c000_2866", 0),
    MVI(0xc0002867, "TODO_c000_2867", 0),
    MVI(0xc0002868, "TODO_c000_2868", 0),
    MVI(0xc0002869, "TODO_c000_2869", 0),
    MVI(0xc000286a, "TODO_c000_286a", 0),
    MVI(0xc000286b, "TODO_c000_286b", 0),
    MVI(0xc000286c, "TODO_c000_286c", 0),
    MVI(0xc000286d, "TODO_c000_286d", 0),
    MVI(0xc000286e, "TODO_c000_286e", 0),
    MVI(0xc000286f, "TODO_c000_286f", 0),
    MVI(0xc0002870, "TODO_c000_2870", 0),
    MVI(0xc0002871, "TODO_c000_2871", 0),
    MVI(0xc0002872, "TODO_c000_2872", 0),
    MVI(0xc0002873, "TODO_c000_2873", 0),
    MVI(0xc0002874, "TODO_c000_2874", 0),
    MVI(0xc0002875, "TODO_c000_2875", 0),
    MVI(0xc0002876, "TODO_c000_2876", 0),
    MVI(0xc0002877, "TODO_c000_2877", 0),
    MVI(0xc0002878, "TODO_c000_2878", 0),
    MVI(0xc0002879, "TODO_c000_2879", 0),
    MVI(0xc000287a, "TODO_c000_287a", 0),
    MVI(0xc000287b, "TODO_c000_287b", 0),
    MVI(0xc000287c, "TODO_c000_287c", 0),
    MVI(0xc000287d, "TODO_c000_287d", 0),
    MVI(0xc000287e, "TODO_c000_287e", 0),
    MVI(0xc000287f, "TODO_c000_287f", 0),
    MVI(0xc0002880, "TODO_c000_2880", 0),
    MVI(0xc0002881, "TODO_c000_2881", 0),
    MVI(0xc0002882, "TODO_c000_2882", 0),
    MVI(0xc0002883, "TODO_c000_2883", 0),
    MVI(0xc0002884, "TODO_c000_2884", 0),
    MVI(0xc0002885, "TODO_c000_2885", 0),
    MVI(0xc0002886, "TODO_c000_2886", 0),
    MVI(0xc0002887, "TODO_c000_2887", 0),
    MVI(0xc0002888, "TODO_c000_2888", 0),
    MVI(0xc0002889, "TODO_c000_2889", 0),
    MVI(0xc000288a, "TODO_c000_288a", 0),
    MVI(0xc000288b, "TODO_c000_288b", 0),
    MVI(0xc000288c, "TODO_c000_288c", 0),
    MVI(0xc000288d, "TODO_c000_288d", 0),
    MVI(0xc000288e, "TODO_c000_288e", 0),
    MVI(0xc000288f, "TODO_c000_288f", 0),
    MVI(0xc0002890, "TODO_c000_2890", 0),
    MVI(0xc0002891, "TODO_c000_2891", 0),
    MVI(0xc0002892, "TODO_c000_2892", 0),
    MVI(0xc0002893, "TODO_c000_2893", 0),
    MVI(0xc0002894, "TODO_c000_2894", 0),
    MVI(0xc0002895, "TODO_c000_2895", 0),
    MVI(0xc0002896, "TODO_c000_2896", 0),
    MVI(0xc0002897, "TODO_c000_2897", 0),
    MVI(0xc0002898, "TODO_c000_2898", 0),
    MVI(0xc0002899, "TODO_c000_2899", 0),
    MVI(0xc000289a, "TODO_c000_289a", 0),
    MVI(0xc000289b, "TODO_c000_289b", 0),
    MVI(0xc000289c, "TODO_c000_289c", 0),
    MVI(0xc000289d, "TODO_c000_289d", 0),
    MVI(0xc000289e, "TODO_c000_289e", 0),
    MVI(0xc000289f, "TODO_c000_289f", 0),
    MVI(0xc00028a0, "TODO_c000_28a0", 0),
    MVI(0xc00028a1, "TODO_c000_28a1", 0),
    MVI(0xc00028a2, "TODO_c000_28a2", 0),
    MVI(0xc00028a3, "TODO_c000_28a3", 0),
    MVI(0xc00028a4, "TODO_c000_28a4", 0),
    MVI(0xc00028a5, "TODO_c000_28a5", 0),
    MVI(0xc00028a6, "TODO_c000_28a6", 0),
    MVI(0xc00028a7, "TODO_c000_28a7", 0),
    MVI(0xc00028a8, "TODO_c000_28a8", 0),
    MVI(0xc00028a9, "TODO_c000_28a9", 0),
    MVI(0xc00028aa, "TODO_c000_28aa", 0),
    MVI(0xc00028ab, "TODO_c000_28ab", 0),
    MVI(0xc00028ac, "TODO_c000_28ac", 0),
    MVI(0xc00028ad, "TODO_c000_28ad", 0),
    MVI(0xc00028ae, "TODO_c000_28ae", 0),
    MVI(0xc00028af, "TODO_c000_28af", 0),
    MVI(0xc00028b0, "TODO_c000_28b0", 0),
    MVI(0xc00028b1, "TODO_c000_28b1", 0),
    MVI(0xc00028b2, "TODO_c000_28b2", 0),
    MVI(0xc00028b3, "TODO_c000_28b3", 0),
    MVI(0xc00028b4, "TODO_c000_28b4", 0),
    MVI(0xc00028b5, "TODO_c000_28b5", 0),
    MVI(0xc00028b6, "TODO_c000_28b6", 0),
    MVI(0xc00028b7, "TODO_c000_28b7", 0),
    MVI(0xc00028b8, "TODO_c000_28b8", 0),
    MVI(0xc00028b9, "TODO_c000_28b9", 0),
    MVI(0xc00028ba, "TODO_c000_28ba", 0),
    MVI(0xc00028bb, "TODO_c000_28bb", 0),
    MVI(0xc00028bc, "TODO_c000_28bc", 0),
    MVI(0xc00028bd, "TODO_c000_28bd", 0),
    MVI(0xc00028be, "TODO_c000_28be", 0),
    MVI(0xc00028bf, "TODO_c000_28bf", 0),
    MVI(0xc00028c0, "TODO_c000_28c0", 0),
    MVI(0xc00028c1, "TODO_c000_28c1", 0),
    MVI(0xc00028c2, "TODO_c000_28c2", 0),
    MVI(0xc00028c3, "TODO_c000_28c3", 0),
    MVI(0xc00028c4, "TODO_c000_28c4", 0),
    MVI(0xc00028c5, "TODO_c000_28c5", 0),
    MVI(0xc00028c6, "TODO_c000_28c6", 0),
    MVI(0xc00028c7, "TODO_c000_28c7", 0),
    MVI(0xc00028c8, "TODO_c000_28c8", 0),
    MVI(0xc00028c9, "TODO_c000_28c9", 0),
    MVI(0xc00028ca, "TODO_c000_28ca", 0),
    MVI(0xc00028cb, "TODO_c000_28cb", 0),
    MVI(0xc00028cc, "TODO_c000_28cc", 0),
    MVI(0xc00028cd, "TODO_c000_28cd", 0),
    MVI(0xc00028ce, "TODO_c000_28ce", 0),
    MVI(0xc00028cf, "TODO_c000_28cf", 0),
    MVI(0xc00028d0, "TODO_c000_28d0", 0),
    MVI(0xc00028d1, "TODO_c000_28d1", 0),
    MVI(0xc00028d2, "TODO_c000_28d2", 0),
    MVI(0xc00028d3, "TODO_c000_28d3", 0),
    MVI(0xc00028d4, "TODO_c000_28d4", 0),
    MVI(0xc00028d5, "TODO_c000_28d5", 0),
    MVI(0xc00028d6, "TODO_c000_28d6", 0),
    MVI(0xc00028d7, "TODO_c000_28d7", 0),
    MVI(0xc00028d8, "TODO_c000_28d8", 0),
    MVI(0xc00028d9, "TODO_c000_28d9", 0),
    MVI(0xc00028da, "TODO_c000_28da", 0),
    MVI(0xc00028db, "TODO_c000_28db", 0),
    MVI(0xc00028dc, "TODO_c000_28dc", 0),
    MVI(0xc00028dd, "TODO_c000_28dd", 0),
    MVI(0xc00028de, "TODO_c000_28de", 0),
    MVI(0xc00028df, "TODO_c000_28df", 0),
    MVI(0xc00028e0, "TODO_c000_28e0", 0),
    MVI(0xc00028e1, "TODO_c000_28e1", 0),
    MVI(0xc00028e2, "TODO_c000_28e2", 0),
    MVI(0xc00028e3, "TODO_c000_28e3", 0),
    MVI(0xc00028e4, "TODO_c000_28e4", 0),
    MVI(0xc00028e5, "TODO_c000_28e5", 0),
    MVI(0xc00028e6, "TODO_c000_28e6", 0),
    MVI(0xc00028e7, "TODO_c000_28e7", 0),
    MVI(0xc00028e8, "TODO_c000_28e8", 0),
    MVI(0xc00028e9, "TODO_c000_28e9", 0),
    MVI(0xc00028ea, "TODO_c000_28ea", 0),
    MVI(0xc00028eb, "TODO_c000_28eb", 0),
    MVI(0xc00028ec, "TODO_c000_28ec", 0),
    MVI(0xc00028ed, "TODO_c000_28ed", 0),
    MVI(0xc00028ee, "TODO_c000_28ee", 0),
    MVI(0xc00028ef, "TODO_c000_28ef", 0),
    MVI(0xc00028f0, "TODO_c000_28f0", 0),
    MVI(0xc00028f1, "TODO_c000_28f1", 0),
    MVI(0xc00028f2, "TODO_c000_28f2", 0),
    MVI(0xc00028f3, "TODO_c000_28f3", 0),
    MVI(0xc00028f4, "TODO_c000_28f4", 0),
    MVI(0xc00028f5, "TODO_c000_28f5", 0),
    MVI(0xc00028f6, "TODO_c000_28f6", 0),
    MVI(0xc00028f7, "TODO_c000_28f7", 0),
    MVI(0xc00028f8, "TODO_c000_28f8", 0),
    MVI(0xc00028f9, "TODO_c000_28f9", 0),
    MVI(0xc00028fa, "TODO_c000_28fa", 0),
    MVI(0xc00028fb, "TODO_c000_28fb", 0),
    MVI(0xc00028fc, "TODO_c000_28fc", 0),
    MVI(0xc00028fd, "TODO_c000_28fd", 0),
    MVI(0xc00028fe, "TODO_c000_28fe", 0),
    MVI(0xc00028ff, "TODO_c000_28ff", 0),
    MVI(0xc0002900, "TODO_c000_2900", 0),
    MVI(0xc0002901, "TODO_c000_2901", 0),
    MVI(0xc0002902, "TODO_c000_2902", 0),
    MVI(0xc0002903, "TODO_c000_2903", 0),
    MVI(0xc0002904, "TODO_c000_2904", 0),
    MVI(0xc0002905, "TODO_c000_2905", 0),
    MVI(0xc0002906, "TODO_c000_2906", 0),
    MVI(0xc0002907, "TODO_c000_2907", 0),
    MVI(0xc0002908, "TODO_c000_2908", 0),
    MVI(0xc0002909, "TODO_c000_2909", 0),
    MVI(0xc000290a, "TODO_c000_290a", 0),
    MVI(0xc000290b, "TODO_c000_290b", 0),
    MVI(0xc000290c, "TODO_c000_290c", 0),
    MVI(0xc000290d, "TODO_c000_290d", 0),
    MVI(0xc000290e, "TODO_c000_290e", 0),
    MVI(0xc000290f, "TODO_c000_290f", 0),
    MVI(0xc0002910, "TODO_c000_2910", 0),
    MVI(0xc0002911, "TODO_c000_2911", 0),
    MVI(0xc0002912, "TODO_c000_2912", 0),
    MVI(0xc0002913, "TODO_c000_2913", 0),
    MVI(0xc0002914, "TODO_c000_2914", 0),
    MVI(0xc0002915, "TODO_c000_2915", 0),
    MVI(0xc0002916, "TODO_c000_2916", 0),
    MVI(0xc0002917, "TODO_c000_2917", 0),
    MVI(0xc0002918, "TODO_c000_2918", 0),
    MVI(0xc0002919, "TODO_c000_2919", 0),
    MVI(0xc000291a, "TODO_c000_291a", 0),
    MVI(0xc000291b, "TODO_c000_291b", 0),
    MVI(0xc000291c, "TODO_c000_291c", 0),
    MVI(0xc000291d, "TODO_c000_291d", 0),
    MVI(0xc000291e, "TODO_c000_291e", 0),
    MVI(0xc000291f, "TODO_c000_291f", 0),
    MVI(0xc0002920, "TODO_c000_2920", 0),
    MVI(0xc0002921, "TODO_c000_2921", 0),
    MVI(0xc0002922, "TODO_c000_2922", 0),
    MVI(0xc0002923, "TODO_c000_2923", 0),
    MVI(0xc0002924, "TODO_c000_2924", 0),
    MVI(0xc0002925, "TODO_c000_2925", 0),
    MVI(0xc0002926, "TODO_c000_2926", 0),
    MVI(0xc0002927, "TODO_c000_2927", 0),
    MVI(0xc0002928, "TODO_c000_2928", 0),
    MVI(0xc0002929, "TODO_c000_2929", 0),
    MVI(0xc000292a, "TODO_c000_292a", 0),
    MVI(0xc000292b, "TODO_c000_292b", 0),
    MVI(0xc000292c, "TODO_c000_292c", 0),
    MVI(0xc000292d, "TODO_c000_292d", 0),
    MVI(0xc000292e, "TODO_c000_292e", 0),
    MVI(0xc000292f, "TODO_c000_292f", 0),
    MVI(0xc0002930, "TODO_c000_2930", 0),
    MVI(0xc0002931, "TODO_c000_2931", 0),
    MVI(0xc0002932, "TODO_c000_2932", 0),
    MVI(0xc0002933, "TODO_c000_2933", 0),
    MVI(0xc0002934, "TODO_c000_2934", 0),
    MVI(0xc0002935, "TODO_c000_2935", 0),
    MVI(0xc0002936, "TODO_c000_2936", 0),
    MVI(0xc0002937, "TODO_c000_2937", 0),
    MVI(0xc0002938, "TODO_c000_2938", 0),
    MVI(0xc0002939, "TODO_c000_2939", 0),
    MVI(0xc000293a, "TODO_c000_293a", 0),
    MVI(0xc000293b, "TODO_c000_293b", 0),
    MVI(0xc000293c, "TODO_c000_293c", 0),
    MVI(0xc000293d, "TODO_c000_293d", 0),
    MVI(0xc000293e, "TODO_c000_293e", 0),
    MVI(0xc000293f, "TODO_c000_293f", 0),
    MVI(0xc0002940, "TODO_c000_2940", 0),
    MVI(0xc0002941, "TODO_c000_2941", 0),
    MVI(0xc0002942, "TODO_c000_2942", 0),
    MVI(0xc0002943, "TODO_c000_2943", 0),
    MVI(0xc0002944, "TODO_c000_2944", 0),
    MVI(0xc0002945, "TODO_c000_2945", 0),
    MVI(0xc0002946, "TODO_c000_2946", 0),
    MVI(0xc0002947, "TODO_c000_2947", 0),
    MVI(0xc0002948, "TODO_c000_2948", 0),
    MVI(0xc0002949, "TODO_c000_2949", 0),
    MVI(0xc000294a, "TODO_c000_294a", 0),
    MVI(0xc000294b, "TODO_c000_294b", 0),
    MVI(0xc000294c, "TODO_c000_294c", 0),
    MVI(0xc000294d, "TODO_c000_294d", 0),
    MVI(0xc000294e, "TODO_c000_294e", 0),
    MVI(0xc000294f, "TODO_c000_294f", 0),
    MVI(0xc0002950, "TODO_c000_2950", 0),
    MVI(0xc0002951, "TODO_c000_2951", 0),
    MVI(0xc0002952, "TODO_c000_2952", 0),
    MVI(0xc0002953, "TODO_c000_2953", 0),
    MVI(0xc0002954, "TODO_c000_2954", 0),
    MVI(0xc0002955, "TODO_c000_2955", 0),
    MVI(0xc0002956, "TODO_c000_2956", 0),
    MVI(0xc0002957, "TODO_c000_2957", 0),
    MVI(0xc0002958, "TODO_c000_2958", 0),
    MVI(0xc0002959, "TODO_c000_2959", 0),
    MVI(0xc000295a, "TODO_c000_295a", 0),
    MVI(0xc000295b, "TODO_c000_295b", 0),
    MVI(0xc000295c, "TODO_c000_295c", 0),
    MVI(0xc000295d, "TODO_c000_295d", 0),
    MVI(0xc000295e, "TODO_c000_295e", 0),
    MVI(0xc000295f, "TODO_c000_295f", 0),
    MVI(0xc0002960, "TODO_c000_2960", 0),
    MVI(0xc0002961, "TODO_c000_2961", 0),
    MVI(0xc0002962, "TODO_c000_2962", 0),
    MVI(0xc0002963, "TODO_c000_2963", 0),
    MVI(0xc0002964, "TODO_c000_2964", 0),
    MVI(0xc0002965, "TODO_c000_2965", 0),
    MVI(0xc0002966, "TODO_c000_2966", 0),
    MVI(0xc0002967, "TODO_c000_2967", 0),
    MVI(0xc0002968, "TODO_c000_2968", 0),
    MVI(0xc0002969, "TODO_c000_2969", 0),
    MVI(0xc000296a, "TODO_c000_296a", 0),
    MVI(0xc000296b, "TODO_c000_296b", 0),
    MVI(0xc000296c, "TODO_c000_296c", 0),
    MVI(0xc000296d, "TODO_c000_296d", 0),
    MVI(0xc000296e, "TODO_c000_296e", 0),
    MVI(0xc000296f, "TODO_c000_296f", 0),
    MVI(0xc0002970, "TODO_c000_2970", 0),
    MVI(0xc0002971, "TODO_c000_2971", 0),
    MVI(0xc0002972, "TODO_c000_2972", 0),
    MVI(0xc0002973, "TODO_c000_2973", 0),
    MVI(0xc0002974, "TODO_c000_2974", 0),
    MVI(0xc0002975, "TODO_c000_2975", 0),
    MVI(0xc0002976, "TODO_c000_2976", 0),
    MVI(0xc0002977, "TODO_c000_2977", 0),
    MVI(0xc0002978, "TODO_c000_2978", 0),
    MVI(0xc0002979, "TODO_c000_2979", 0),
    MVI(0xc000297a, "TODO_c000_297a", 0),
    MVI(0xc000297b, "TODO_c000_297b", 0),
    MVI(0xc000297c, "TODO_c000_297c", 0),
    MVI(0xc000297d, "TODO_c000_297d", 0),
    MVI(0xc000297e, "TODO_c000_297e", 0),
    MVI(0xc000297f, "TODO_c000_297f", 0),
    MVI(0xc0002980, "TODO_c000_2980", 0),
    MVI(0xc0002981, "TODO_c000_2981", 0),
    MVI(0xc0002982, "TODO_c000_2982", 0),
    MVI(0xc0002983, "TODO_c000_2983", 0),
    MVI(0xc0002984, "TODO_c000_2984", 0),
    MVI(0xc0002985, "TODO_c000_2985", 0),
    MVI(0xc0002986, "TODO_c000_2986", 0),
    MVI(0xc0002987, "TODO_c000_2987", 0),
    MVI(0xc0002988, "TODO_c000_2988", 0),
    MVI(0xc0002989, "TODO_c000_2989", 0),
    MVI(0xc000298a, "TODO_c000_298a", 0),
    MVI(0xc000298b, "TODO_c000_298b", 0),
    MVI(0xc000298c, "TODO_c000_298c", 0),
    MVI(0xc000298d, "TODO_c000_298d", 0),
    MVI(0xc000298e, "TODO_c000_298e", 0),
    MVI(0xc000298f, "TODO_c000_298f", 0),
    MVI(0xc0002990, "TODO_c000_2990", 0),
    MVI(0xc0002991, "TODO_c000_2991", 0),
    MVI(0xc0002992, "TODO_c000_2992", 0),
    MVI(0xc0002993, "TODO_c000_2993", 0),
    MVI(0xc0002994, "TODO_c000_2994", 0),
    MVI(0xc0002995, "TODO_c000_2995", 0),
    MVI(0xc0002996, "TODO_c000_2996", 0),
    MVI(0xc0002997, "TODO_c000_2997", 0),
    MVI(0xc0002998, "TODO_c000_2998", 0),
    MVI(0xc0002999, "TODO_c000_2999", 0),
    MVI(0xc000299a, "TODO_c000_299a", 0),
    MVI(0xc000299b, "TODO_c000_299b", 0),
    MVI(0xc000299c, "TODO_c000_299c", 0),
    MVI(0xc000299d, "TODO_c000_299d", 0),
    MVI(0xc000299e, "TODO_c000_299e", 0),
    MVI(0xc000299f, "TODO_c000_299f", 0),
    MVI(0xc00029a0, "TODO_c000_29a0", 0),
    MVI(0xc00029a1, "TODO_c000_29a1", 0),
    MVI(0xc00029a2, "TODO_c000_29a2", 0),
    MVI(0xc00029a3, "TODO_c000_29a3", 0),
    MVI(0xc00029a4, "TODO_c000_29a4", 0),
    MVI(0xc00029a5, "TODO_c000_29a5", 0),
    MVI(0xc00029a6, "TODO_c000_29a6", 0),
    MVI(0xc00029a7, "TODO_c000_29a7", 0),
    MVI(0xc00029a8, "TODO_c000_29a8", 0),
    MVI(0xc00029a9, "TODO_c000_29a9", 0),
    MVI(0xc00029aa, "TODO_c000_29aa", 0),
    MVI(0xc00029ab, "TODO_c000_29ab", 0),
    MVI(0xc00029ac, "TODO_c000_29ac", 0),
    MVI(0xc00029ad, "TODO_c000_29ad", 0),
    MVI(0xc00029ae, "TODO_c000_29ae", 0),
    MVI(0xc00029af, "TODO_c000_29af", 0),
    MVI(0xc00029b0, "TODO_c000_29b0", 0),
    MVI(0xc00029b1, "TODO_c000_29b1", 0),
    MVI(0xc00029b2, "TODO_c000_29b2", 0),
    MVI(0xc00029b3, "TODO_c000_29b3", 0),
    MVI(0xc00029b4, "TODO_c000_29b4", 0),
    MVI(0xc00029b5, "TODO_c000_29b5", 0),
    MVI(0xc00029b6, "TODO_c000_29b6", 0),
    MVI(0xc00029b7, "TODO_c000_29b7", 0),
    MVI(0xc00029b8, "TODO_c000_29b8", 0),
    MVI(0xc00029b9, "TODO_c000_29b9", 0),
    MVI(0xc00029ba, "TODO_c000_29ba", 0),
    MVI(0xc00029bb, "TODO_c000_29bb", 0),
    MVI(0xc00029bc, "TODO_c000_29bc", 0),
    MVI(0xc00029bd, "TODO_c000_29bd", 0),
    MVI(0xc00029be, "TODO_c000_29be", 0),
    MVI(0xc00029bf, "TODO_c000_29bf", 0),
    MVI(0xc00029c0, "TODO_c000_29c0", 0),
    MVI(0xc00029c1, "TODO_c000_29c1", 0),
    MVI(0xc00029c2, "TODO_c000_29c2", 0),
    MVI(0xc00029c3, "TODO_c000_29c3", 0),
    MVI(0xc00029c4, "TODO_c000_29c4", 0),
    MVI(0xc00029c5, "TODO_c000_29c5", 0),
    MVI(0xc00029c6, "TODO_c000_29c6", 0),
    MVI(0xc00029c7, "TODO_c000_29c7", 0),
    MVI(0xc00029c8, "TODO_c000_29c8", 0),
    MVI(0xc00029c9, "TODO_c000_29c9", 0),
    MVI(0xc00029ca, "TODO_c000_29ca", 0),
    MVI(0xc00029cb, "TODO_c000_29cb", 0),
    MVI(0xc00029cc, "TODO_c000_29cc", 0),
    MVI(0xc00029cd, "TODO_c000_29cd", 0),
    MVI(0xc00029ce, "TODO_c000_29ce", 0),
    MVI(0xc00029cf, "TODO_c000_29cf", 0),
    MVI(0xc00029d0, "TODO_c000_29d0", 0),
    MVI(0xc00029d1, "TODO_c000_29d1", 0),
    MVI(0xc00029d2, "TODO_c000_29d2", 0),
    MVI(0xc00029d3, "TODO_c000_29d3", 0),
    MVI(0xc00029d4, "TODO_c000_29d4", 0),
    MVI(0xc00029d5, "TODO_c000_29d5", 0),
    MVI(0xc00029d6, "TODO_c000_29d6", 0),
    MVI(0xc00029d7, "TODO_c000_29d7", 0),
    MVI(0xc00029d8, "TODO_c000_29d8", 0),
    MVI(0xc00029d9, "TODO_c000_29d9", 0),
    MVI(0xc00029da, "TODO_c000_29da", 0),
    MVI(0xc00029db, "TODO_c000_29db", 0),
    MVI(0xc00029dc, "TODO_c000_29dc", 0),
    MVI(0xc00029dd, "TODO_c000_29dd", 0),
    MVI(0xc00029de, "TODO_c000_29de", 0),
    MVI(0xc00029df, "TODO_c000_29df", 0),
    MVI(0xc00029e0, "TODO_c000_29e0", 0),
    MVI(0xc00029e1, "TODO_c000_29e1", 0),
    MVI(0xc00029e2, "TODO_c000_29e2", 0),
    MVI(0xc00029e3, "TODO_c000_29e3", 0),
    MVI(0xc00029e4, "TODO_c000_29e4", 0),
    MVI(0xc00029e5, "TODO_c000_29e5", 0),
    MVI(0xc00029e6, "TODO_c000_29e6", 0),
    MVI(0xc00029e7, "TODO_c000_29e7", 0),
    MVI(0xc00029e8, "TODO_c000_29e8", 0),
    MVI(0xc00029e9, "TODO_c000_29e9", 0),
    MVI(0xc00029ea, "TODO_c000_29ea", 0),
    MVI(0xc00029eb, "TODO_c000_29eb", 0),
    MVI(0xc00029ec, "TODO_c000_29ec", 0),
    MVI(0xc00029ed, "TODO_c000_29ed", 0),
    MVI(0xc00029ee, "TODO_c000_29ee", 0),
    MVI(0xc00029ef, "TODO_c000_29ef", 0),
    MVI(0xc00029f0, "TODO_c000_29f0", 0),
    MVI(0xc00029f1, "TODO_c000_29f1", 0),
    MVI(0xc00029f2, "TODO_c000_29f2", 0),
    MVI(0xc00029f3, "TODO_c000_29f3", 0),
    MVI(0xc00029f4, "TODO_c000_29f4", 0),
    MVI(0xc00029f5, "TODO_c000_29f5", 0),
    MVI(0xc00029f6, "TODO_c000_29f6", 0),
    MVI(0xc00029f7, "TODO_c000_29f7", 0),
    MVI(0xc00029f8, "TODO_c000_29f8", 0),
    MVI(0xc00029f9, "TODO_c000_29f9", 0),
    MVI(0xc00029fa, "TODO_c000_29fa", 0),
    MVI(0xc00029fb, "TODO_c000_29fb", 0),
    MVI(0xc00029fc, "TODO_c000_29fc", 0),
    MVI(0xc00029fd, "TODO_c000_29fd", 0),
    MVI(0xc00029fe, "TODO_c000_29fe", 0),
    MVI(0xc00029ff, "TODO_c000_29ff", 0),
    MVI(0xc0002a00, "TODO_c000_2a00", 0),
    MVI(0xc0002a01, "TODO_c000_2a01", 0),
    MVI(0xc0002a02, "TODO_c000_2a02", 0),
    MVI(0xc0002a03, "TODO_c000_2a03", 0),
    MVI(0xc0002a04, "TODO_c000_2a04", 0),
    MVI(0xc0002a05, "TODO_c000_2a05", 0),
    MVI(0xc0002a06, "TODO_c000_2a06", 0),
    MVI(0xc0002a07, "TODO_c000_2a07", 0),
    MVI(0xc0002a08, "TODO_c000_2a08", 0),
    MVI(0xc0002a09, "TODO_c000_2a09", 0),
    MVI(0xc0002a0a, "TODO_c000_2a0a", 0),
    MVI(0xc0002a0b, "TODO_c000_2a0b", 0),
    MVI(0xc0002a0c, "TODO_c000_2a0c", 0),
    MVI(0xc0002a0d, "TODO_c000_2a0d", 0),
    MVI(0xc0002a0e, "TODO_c000_2a0e", 0),
    MVI(0xc0002a0f, "TODO_c000_2a0f", 0),
    MVI(0xc0002a10, "TODO_c000_2a10", 0),
    MVI(0xc0002a11, "TODO_c000_2a11", 0),
    MVI(0xc0002a12, "TODO_c000_2a12", 0),
    MVI(0xc0002a13, "TODO_c000_2a13", 0),
    MVI(0xc0002a14, "TODO_c000_2a14", 0),
    MVI(0xc0002a15, "TODO_c000_2a15", 0),
    MVI(0xc0002a16, "TODO_c000_2a16", 0),
    MVI(0xc0002a17, "TODO_c000_2a17", 0),
    MVI(0xc0002a18, "TODO_c000_2a18", 0),
    MVI(0xc0002a19, "TODO_c000_2a19", 0),
    MVI(0xc0002a1a, "TODO_c000_2a1a", 0),
    MVI(0xc0002a1b, "TODO_c000_2a1b", 0),
    MVI(0xc0002a1c, "TODO_c000_2a1c", 0),
    MVI(0xc0002a1d, "TODO_c000_2a1d", 0),
    MVI(0xc0002a1e, "TODO_c000_2a1e", 0),
    MVI(0xc0002a1f, "TODO_c000_2a1f", 0),
    MVI(0xc0002a20, "TODO_c000_2a20", 0),
    MVI(0xc0002a21, "TODO_c000_2a21", 0),
    MVI(0xc0002a22, "TODO_c000_2a22", 0),
    MVI(0xc0002a23, "TODO_c000_2a23", 0),
    MVI(0xc0002a24, "TODO_c000_2a24", 0),
    MVI(0xc0002a25, "TODO_c000_2a25", 0),
    MVI(0xc0002a26, "TODO_c000_2a26", 0),
    MVI(0xc0002a27, "TODO_c000_2a27", 0),
    MVI(0xc0002a28, "TODO_c000_2a28", 0),
    MVI(0xc0002a29, "TODO_c000_2a29", 0),
    MVI(0xc0002a2a, "TODO_c000_2a2a", 0),
    MVI(0xc0002a2b, "TODO_c000_2a2b", 0),
    MVI(0xc0002a2c, "TODO_c000_2a2c", 0),
    MVI(0xc0002a2d, "TODO_c000_2a2d", 0),
    MVI(0xc0002a2e, "TODO_c000_2a2e", 0),
    MVI(0xc0002a2f, "TODO_c000_2a2f", 0),
    MVI(0xc0002a30, "TODO_c000_2a30", 0),
    MVI(0xc0002a31, "TODO_c000_2a31", 0),
    MVI(0xc0002a32, "TODO_c000_2a32", 0),
    MVI(0xc0002a33, "TODO_c000_2a33", 0),
    MVI(0xc0002a34, "TODO_c000_2a34", 0),
    MVI(0xc0002a35, "TODO_c000_2a35", 0),
    MVI(0xc0002a36, "TODO_c000_2a36", 0),
    MVI(0xc0002a37, "TODO_c000_2a37", 0),
    MVI(0xc0002a38, "TODO_c000_2a38", 0),
    MVI(0xc0002a39, "TODO_c000_2a39", 0),
    MVI(0xc0002a3a, "TODO_c000_2a3a", 0),
    MVI(0xc0002a3b, "TODO_c000_2a3b", 0),
    MVI(0xc0002a3c, "TODO_c000_2a3c", 0),
    MVI(0xc0002a3d, "TODO_c000_2a3d", 0),
    MVI(0xc0002a3e, "TODO_c000_2a3e", 0),
    MVI(0xc0002a3f, "TODO_c000_2a3f", 0),
    MVI(0xc0002a40, "TODO_c000_2a40", 0),
    MVI(0xc0002a41, "TODO_c000_2a41", 0),
    MVI(0xc0002a42, "TODO_c000_2a42", 0),
    MVI(0xc0002a43, "TODO_c000_2a43", 0),
    MVI(0xc0002a44, "TODO_c000_2a44", 0),
    MVI(0xc0002a45, "TODO_c000_2a45", 0),
    MVI(0xc0002a46, "TODO_c000_2a46", 0),
    MVI(0xc0002a47, "TODO_c000_2a47", 0),
    MVI(0xc0002a48, "TODO_c000_2a48", 0),
    MVI(0xc0002a49, "TODO_c000_2a49", 0),
    MVI(0xc0002a4a, "TODO_c000_2a4a", 0),
    MVI(0xc0002a4b, "TODO_c000_2a4b", 0),
    MVI(0xc0002a4c, "TODO_c000_2a4c", 0),
    MVI(0xc0002a4d, "TODO_c000_2a4d", 0),
    MVI(0xc0002a4e, "TODO_c000_2a4e", 0),
    MVI(0xc0002a4f, "TODO_c000_2a4f", 0),
    MVI(0xc0002a50, "TODO_c000_2a50", 0),
    MVI(0xc0002a51, "TODO_c000_2a51", 0),
    MVI(0xc0002a52, "TODO_c000_2a52", 0),
    MVI(0xc0002a53, "TODO_c000_2a53", 0),
    MVI(0xc0002a54, "TODO_c000_2a54", 0),
    MVI(0xc0002a55, "TODO_c000_2a55", 0),
    MVI(0xc0002a56, "TODO_c000_2a56", 0),
    MVI(0xc0002a57, "TODO_c000_2a57", 0),
    MVI(0xc0002a58, "TODO_c000_2a58", 0),
    MVI(0xc0002a59, "TODO_c000_2a59", 0),
    MVI(0xc0002a5a, "TODO_c000_2a5a", 0),
    MVI(0xc0002a5b, "TODO_c000_2a5b", 0),
    MVI(0xc0002a5c, "TODO_c000_2a5c", 0),
    MVI(0xc0002a5d, "TODO_c000_2a5d", 0),
    MVI(0xc0002a5e, "TODO_c000_2a5e", 0),
    MVI(0xc0002a5f, "TODO_c000_2a5f", 0),
    MVI(0xc0002a60, "TODO_c000_2a60", 0),
    MVI(0xc0002a61, "TODO_c000_2a61", 0),
    MVI(0xc0002a62, "TODO_c000_2a62", 0),
    MVI(0xc0002a63, "TODO_c000_2a63", 0),
    MVI(0xc0002a64, "TODO_c000_2a64", 0),
    MVI(0xc0002a65, "TODO_c000_2a65", 0),
    MVI(0xc0002a66, "TODO_c000_2a66", 0),
    MVI(0xc0002a67, "TODO_c000_2a67", 0),
    MVI(0xc0002a68, "TODO_c000_2a68", 0),
    MVI(0xc0002a69, "TODO_c000_2a69", 0),
    MVI(0xc0002a6a, "TODO_c000_2a6a", 0),
    MVI(0xc0002a6b, "TODO_c000_2a6b", 0),
    MVI(0xc0002a6c, "TODO_c000_2a6c", 0),
    MVI(0xc0002a6d, "TODO_c000_2a6d", 0),
    MVI(0xc0002a6e, "TODO_c000_2a6e", 0),
    MVI(0xc0002a6f, "TODO_c000_2a6f", 0),
    MVI(0xc0002a70, "TODO_c000_2a70", 0),
    MVI(0xc0002a71, "TODO_c000_2a71", 0),
    MVI(0xc0002a72, "TODO_c000_2a72", 0),
    MVI(0xc0002a73, "TODO_c000_2a73", 0),
    MVI(0xc0002a74, "TODO_c000_2a74", 0),
    MVI(0xc0002a75, "TODO_c000_2a75", 0),
    MVI(0xc0002a76, "TODO_c000_2a76", 0),
    MVI(0xc0002a77, "TODO_c000_2a77", 0),
    MVI(0xc0002a78, "TODO_c000_2a78", 0),
    MVI(0xc0002a79, "TODO_c000_2a79", 0),
    MVI(0xc0002a7a, "TODO_c000_2a7a", 0),
    MVI(0xc0002a7b, "TODO_c000_2a7b", 0),
    MVI(0xc0002a7c, "TODO_c000_2a7c", 0),
    MVI(0xc0002a7d, "TODO_c000_2a7d", 0),
    MVI(0xc0002a7e, "TODO_c000_2a7e", 0),
    MVI(0xc0002a7f, "TODO_c000_2a7f", 0),
    MVI(0xc0002a80, "TODO_c000_2a80", 0),
    MVI(0xc0002a81, "TODO_c000_2a81", 0),
    MVI(0xc0002a82, "TODO_c000_2a82", 0),
    MVI(0xc0002a83, "TODO_c000_2a83", 0),
    MVI(0xc0002a84, "TODO_c000_2a84", 0),
    MVI(0xc0002a85, "TODO_c000_2a85", 0),
    MVI(0xc0002a86, "TODO_c000_2a86", 0),
    MVI(0xc0002a87, "TODO_c000_2a87", 0),
    MVI(0xc0002a88, "TODO_c000_2a88", 0),
    MVI(0xc0002a89, "TODO_c000_2a89", 0),
    MVI(0xc0002a8a, "TODO_c000_2a8a", 0),
    MVI(0xc0002a8b, "TODO_c000_2a8b", 0),
    MVI(0xc0002a8c, "TODO_c000_2a8c", 0),
    MVI(0xc0002a8d, "TODO_c000_2a8d", 0),
    MVI(0xc0002a8e, "TODO_c000_2a8e", 0),
    MVI(0xc0002a8f, "TODO_c000_2a8f", 0),
    MVI(0xc0002a90, "TODO_c000_2a90", 0),
    MVI(0xc0002a91, "TODO_c000_2a91", 0),
    MVI(0xc0002a92, "TODO_c000_2a92", 0),
    MVI(0xc0002a93, "TODO_c000_2a93", 0),
    MVI(0xc0002a94, "TODO_c000_2a94", 0),
    MVI(0xc0002a95, "TODO_c000_2a95", 0),
    MVI(0xc0002a96, "TODO_c000_2a96", 0),
    MVI(0xc0002a97, "TODO_c000_2a97", 0),
    MVI(0xc0002a98, "TODO_c000_2a98", 0),
    MVI(0xc0002a99, "TODO_c000_2a99", 0),
    MVI(0xc0002a9a, "TODO_c000_2a9a", 0),
    MVI(0xc0002a9b, "TODO_c000_2a9b", 0),
    MVI(0xc0002a9c, "TODO_c000_2a9c", 0),
    MVI(0xc0002a9d, "TODO_c000_2a9d", 0),
    MVI(0xc0002a9e, "TODO_c000_2a9e", 0),
    MVI(0xc0002a9f, "TODO_c000_2a9f", 0),
    MVI(0xc0002aa0, "TODO_c000_2aa0", 0),
    MVI(0xc0002aa1, "TODO_c000_2aa1", 0),
    MVI(0xc0002aa2, "TODO_c000_2aa2", 0),
    MVI(0xc0002aa3, "TODO_c000_2aa3", 0),
    MVI(0xc0002aa4, "TODO_c000_2aa4", 0),
    MVI(0xc0002aa5, "TODO_c000_2aa5", 0),
    MVI(0xc0002aa6, "TODO_c000_2aa6", 0),
    MVI(0xc0002aa7, "TODO_c000_2aa7", 0),
    MVI(0xc0002aa8, "TODO_c000_2aa8", 0),
    MVI(0xc0002aa9, "TODO_c000_2aa9", 0),
    MVI(0xc0002aaa, "TODO_c000_2aaa", 0),
    MVI(0xc0002aab, "TODO_c000_2aab", 0),
    MVI(0xc0002aac, "TODO_c000_2aac", 0),
    MVI(0xc0002aad, "TODO_c000_2aad", 0),
    MVI(0xc0002aae, "TODO_c000_2aae", 0),
    MVI(0xc0002aaf, "TODO_c000_2aaf", 0),
    MVI(0xc0002ab0, "TODO_c000_2ab0", 0),
    MVI(0xc0002ab1, "TODO_c000_2ab1", 0),
    MVI(0xc0002ab2, "TODO_c000_2ab2", 0),
    MVI(0xc0002ab3, "TODO_c000_2ab3", 0),
    MVI(0xc0002ab4, "TODO_c000_2ab4", 0),
    MVI(0xc0002ab5, "TODO_c000_2ab5", 0),
    MVI(0xc0002ab6, "TODO_c000_2ab6", 0),
    MVI(0xc0002ab7, "TODO_c000_2ab7", 0),
    MVI(0xc0002ab8, "TODO_c000_2ab8", 0),
    MVI(0xc0002ab9, "TODO_c000_2ab9", 0),
    MVI(0xc0002aba, "TODO_c000_2aba", 0),
    MVI(0xc0002abb, "TODO_c000_2abb", 0),
    MVI(0xc0002abc, "TODO_c000_2abc", 0),
    MVI(0xc0002abd, "TODO_c000_2abd", 0),
    MVI(0xc0002abe, "TODO_c000_2abe", 0),
    MVI(0xc0002abf, "TODO_c000_2abf", 0),
    MVI(0xc0002ac0, "TODO_c000_2ac0", 0),
    MVI(0xc0002ac1, "TODO_c000_2ac1", 0),
    MVI(0xc0002ac2, "TODO_c000_2ac2", 0),
    MVI(0xc0002ac3, "TODO_c000_2ac3", 0),
    MVI(0xc0002ac4, "TODO_c000_2ac4", 0),
    MVI(0xc0002ac5, "TODO_c000_2ac5", 0),
    MVI(0xc0002ac6, "TODO_c000_2ac6", 0),
    MVI(0xc0002ac7, "TODO_c000_2ac7", 0),
    MVI(0xc0002ac8, "TODO_c000_2ac8", 0),
    MVI(0xc0002ac9, "TODO_c000_2ac9", 0),
    MVI(0xc0002aca, "TODO_c000_2aca", 0),
    MVI(0xc0002acb, "TODO_c000_2acb", 0),
    MVI(0xc0002acc, "TODO_c000_2acc", 0),
    MVI(0xc0002acd, "TODO_c000_2acd", 0),
    MVI(0xc0002ace, "TODO_c000_2ace", 0),
    MVI(0xc0002acf, "TODO_c000_2acf", 0),
    MVI(0xc0002ad0, "TODO_c000_2ad0", 0),
    MVI(0xc0002ad1, "TODO_c000_2ad1", 0),
    MVI(0xc0002ad2, "TODO_c000_2ad2", 0),
    MVI(0xc0002ad3, "TODO_c000_2ad3", 0),
    MVI(0xc0002ad4, "TODO_c000_2ad4", 0),
    MVI(0xc0002ad5, "TODO_c000_2ad5", 0),
    MVI(0xc0002ad6, "TODO_c000_2ad6", 0),
    MVI(0xc0002ad7, "TODO_c000_2ad7", 0),
    MVI(0xc0002ad8, "TODO_c000_2ad8", 0),
    MVI(0xc0002ad9, "TODO_c000_2ad9", 0),
    MVI(0xc0002ada, "TODO_c000_2ada", 0),
    MVI(0xc0002adb, "TODO_c000_2adb", 0),
    MVI(0xc0002adc, "TODO_c000_2adc", 0),
    MVI(0xc0002add, "TODO_c000_2add", 0),
    MVI(0xc0002ade, "TODO_c000_2ade", 0),
    MVI(0xc0002adf, "TODO_c000_2adf", 0),
    MVI(0xc0002ae0, "TODO_c000_2ae0", 0),
    MVI(0xc0002ae1, "TODO_c000_2ae1", 0),
    MVI(0xc0002ae2, "TODO_c000_2ae2", 0),
    MVI(0xc0002ae3, "TODO_c000_2ae3", 0),
    MVI(0xc0002ae4, "TODO_c000_2ae4", 0),
    MVI(0xc0002ae5, "TODO_c000_2ae5", 0),
    MVI(0xc0002ae6, "TODO_c000_2ae6", 0),
    MVI(0xc0002ae7, "TODO_c000_2ae7", 0),
    MVI(0xc0002ae8, "TODO_c000_2ae8", 0),
    MVI(0xc0002ae9, "TODO_c000_2ae9", 0),
    MVI(0xc0002aea, "TODO_c000_2aea", 0),
    MVI(0xc0002aeb, "TODO_c000_2aeb", 0),
    MVI(0xc0002aec, "TODO_c000_2aec", 0),
    MVI(0xc0002aed, "TODO_c000_2aed", 0),
    MVI(0xc0002aee, "TODO_c000_2aee", 0),
    MVI(0xc0002aef, "TODO_c000_2aef", 0),
    MVI(0xc0002af0, "TODO_c000_2af0", 0),
    MVI(0xc0002af1, "TODO_c000_2af1", 0),
    MVI(0xc0002af2, "TODO_c000_2af2", 0),
    MVI(0xc0002af3, "TODO_c000_2af3", 0),
    MVI(0xc0002af4, "TODO_c000_2af4", 0),
    MVI(0xc0002af5, "TODO_c000_2af5", 0),
    MVI(0xc0002af6, "TODO_c000_2af6", 0),
    MVI(0xc0002af7, "TODO_c000_2af7", 0),
    MVI(0xc0002af8, "TODO_c000_2af8", 0),
    MVI(0xc0002af9, "TODO_c000_2af9", 0),
    MVI(0xc0002afa, "TODO_c000_2afa", 0),
    MVI(0xc0002afb, "TODO_c000_2afb", 0),
    MVI(0xc0002afc, "TODO_c000_2afc", 0),
    MVI(0xc0002afd, "TODO_c000_2afd", 0),
    MVI(0xc0002afe, "TODO_c000_2afe", 0),
    MVI(0xc0002aff, "TODO_c000_2aff", 0),
    MVI(0xc0002b00, "TODO_c000_2b00", 0),
    MVI(0xc0002b01, "TODO_c000_2b01", 0),
    MVI(0xc0002b02, "TODO_c000_2b02", 0),
    MVI(0xc0002b03, "TODO_c000_2b03", 0),
    MVI(0xc0002b04, "TODO_c000_2b04", 0),
    MVI(0xc0002b05, "TODO_c000_2b05", 0),
    MVI(0xc0002b06, "TODO_c000_2b06", 0),
    MVI(0xc0002b07, "TODO_c000_2b07", 0),
    MVI(0xc0002b08, "TODO_c000_2b08", 0),
    MVI(0xc0002b09, "TODO_c000_2b09", 0),
    MVI(0xc0002b0a, "TODO_c000_2b0a", 0),
    MVI(0xc0002b0b, "TODO_c000_2b0b", 0),
    MVI(0xc0002b0c, "TODO_c000_2b0c", 0),
    MVI(0xc0002b0d, "TODO_c000_2b0d", 0),
    MVI(0xc0002b0e, "TODO_c000_2b0e", 0),
    MVI(0xc0002b0f, "TODO_c000_2b0f", 0),
    MVI(0xc0002b10, "TODO_c000_2b10", 0),
    MVI(0xc0002b11, "TODO_c000_2b11", 0),
    MVI(0xc0002b12, "TODO_c000_2b12", 0),
    MVI(0xc0002b13, "TODO_c000_2b13", 0),
    MVI(0xc0002b14, "TODO_c000_2b14", 0),
    MVI(0xc0002b15, "TODO_c000_2b15", 0),
    MVI(0xc0002b16, "TODO_c000_2b16", 0),
    MVI(0xc0002b17, "TODO_c000_2b17", 0),
    MVI(0xc0002b18, "TODO_c000_2b18", 0),
    MVI(0xc0002b19, "TODO_c000_2b19", 0),
    MVI(0xc0002b1a, "TODO_c000_2b1a", 0),
    MVI(0xc0002b1b, "TODO_c000_2b1b", 0),
    MVI(0xc0002b1c, "TODO_c000_2b1c", 0),
    MVI(0xc0002b1d, "TODO_c000_2b1d", 0),
    MVI(0xc0002b1e, "TODO_c000_2b1e", 0),
    MVI(0xc0002b1f, "TODO_c000_2b1f", 0),
    MVI(0xc0002b20, "TODO_c000_2b20", 0),
    MVI(0xc0002b21, "TODO_c000_2b21", 0),
    MVI(0xc0002b22, "TODO_c000_2b22", 0),
    MVI(0xc0002b23, "TODO_c000_2b23", 0),
    MVI(0xc0002b24, "TODO_c000_2b24", 0),
    MVI(0xc0002b25, "TODO_c000_2b25", 0),
    MVI(0xc0002b26, "TODO_c000_2b26", 0),
    MVI(0xc0002b27, "TODO_c000_2b27", 0),
    MVI(0xc0002b28, "TODO_c000_2b28", 0),
    MVI(0xc0002b29, "TODO_c000_2b29", 0),
    MVI(0xc0002b2a, "TODO_c000_2b2a", 0),
    MVI(0xc0002b2b, "TODO_c000_2b2b", 0),
    MVI(0xc0002b2c, "TODO_c000_2b2c", 0),
    MVI(0xc0002b2d, "TODO_c000_2b2d", 0),
    MVI(0xc0002b2e, "TODO_c000_2b2e", 0),
    MVI(0xc0002b2f, "TODO_c000_2b2f", 0),
    MVI(0xc0002b30, "TODO_c000_2b30", 0),
    MVI(0xc0002b31, "TODO_c000_2b31", 0),
    MVI(0xc0002b32, "TODO_c000_2b32", 0),
    MVI(0xc0002b33, "TODO_c000_2b33", 0),
    MVI(0xc0002b34, "TODO_c000_2b34", 0),
    MVI(0xc0002b35, "TODO_c000_2b35", 0),
    MVI(0xc0002b36, "TODO_c000_2b36", 0),
    MVI(0xc0002b37, "TODO_c000_2b37", 0),
    MVI(0xc0002b38, "TODO_c000_2b38", 0),
    MVI(0xc0002b39, "TODO_c000_2b39", 0),
    MVI(0xc0002b3a, "TODO_c000_2b3a", 0),
    MVI(0xc0002b3b, "TODO_c000_2b3b", 0),
    MVI(0xc0002b3c, "TODO_c000_2b3c", 0),
    MVI(0xc0002b3d, "TODO_c000_2b3d", 0),
    MVI(0xc0002b3e, "TODO_c000_2b3e", 0),
    MVI(0xc0002b3f, "TODO_c000_2b3f", 0),
    MVI(0xc0002b40, "TODO_c000_2b40", 0),
    MVI(0xc0002b41, "TODO_c000_2b41", 0),
    MVI(0xc0002b42, "TODO_c000_2b42", 0),
    MVI(0xc0002b43, "TODO_c000_2b43", 0),
    MVI(0xc0002b44, "TODO_c000_2b44", 0),
    MVI(0xc0002b45, "TODO_c000_2b45", 0),
    MVI(0xc0002b46, "TODO_c000_2b46", 0),
    MVI(0xc0002b47, "TODO_c000_2b47", 0),
    MVI(0xc0002b48, "TODO_c000_2b48", 0),
    MVI(0xc0002b49, "TODO_c000_2b49", 0),
    MVI(0xc0002b4a, "TODO_c000_2b4a", 0),
    MVI(0xc0002b4b, "TODO_c000_2b4b", 0),
    MVI(0xc0002b4c, "TODO_c000_2b4c", 0),
    MVI(0xc0002b4d, "TODO_c000_2b4d", 0),
    MVI(0xc0002b4e, "TODO_c000_2b4e", 0),
    MVI(0xc0002b4f, "TODO_c000_2b4f", 0),
    MVI(0xc0002b50, "TODO_c000_2b50", 0),
    MVI(0xc0002b51, "TODO_c000_2b51", 0),
    MVI(0xc0002b52, "TODO_c000_2b52", 0),
    MVI(0xc0002b53, "TODO_c000_2b53", 0),
    MVI(0xc0002b54, "TODO_c000_2b54", 0),
    MVI(0xc0002b55, "TODO_c000_2b55", 0),
    MVI(0xc0002b56, "TODO_c000_2b56", 0),
    MVI(0xc0002b57, "TODO_c000_2b57", 0),
    MVI(0xc0002b58, "TODO_c000_2b58", 0),
    MVI(0xc0002b59, "TODO_c000_2b59", 0),
    MVI(0xc0002b5a, "TODO_c000_2b5a", 0),
    MVI(0xc0002b5b, "TODO_c000_2b5b", 0),
    MVI(0xc0002b5c, "TODO_c000_2b5c", 0),
    MVI(0xc0002b5d, "TODO_c000_2b5d", 0),
    MVI(0xc0002b5e, "TODO_c000_2b5e", 0),
    MVI(0xc0002b5f, "TODO_c000_2b5f", 0),
    MVI(0xc0002b60, "TODO_c000_2b60", 0),
    MVI(0xc0002b61, "TODO_c000_2b61", 0),
    MVI(0xc0002b62, "TODO_c000_2b62", 0),
    MVI(0xc0002b63, "TODO_c000_2b63", 0),
    MVI(0xc0002b64, "TODO_c000_2b64", 0),
    MVI(0xc0002b65, "TODO_c000_2b65", 0),
    MVI(0xc0002b66, "TODO_c000_2b66", 0),
    MVI(0xc0002b67, "TODO_c000_2b67", 0),
    MVI(0xc0002b68, "TODO_c000_2b68", 0),
    MVI(0xc0002b69, "TODO_c000_2b69", 0),
    MVI(0xc0002b6a, "TODO_c000_2b6a", 0),
    MVI(0xc0002b6b, "TODO_c000_2b6b", 0),
    MVI(0xc0002b6c, "TODO_c000_2b6c", 0),
    MVI(0xc0002b6d, "TODO_c000_2b6d", 0),
    MVI(0xc0002b6e, "TODO_c000_2b6e", 0),
    MVI(0xc0002b6f, "TODO_c000_2b6f", 0),
    MVI(0xc0002b70, "TODO_c000_2b70", 0),
    MVI(0xc0002b71, "TODO_c000_2b71", 0),
    MVI(0xc0002b72, "TODO_c000_2b72", 0),
    MVI(0xc0002b73, "TODO_c000_2b73", 0),
    MVI(0xc0002b74, "TODO_c000_2b74", 0),
    MVI(0xc0002b75, "TODO_c000_2b75", 0),
    MVI(0xc0002b76, "TODO_c000_2b76", 0),
    MVI(0xc0002b77, "TODO_c000_2b77", 0),
    MVI(0xc0002b78, "TODO_c000_2b78", 0),
    MVI(0xc0002b79, "TODO_c000_2b79", 0),
    MVI(0xc0002b7a, "TODO_c000_2b7a", 0),
    MVI(0xc0002b7b, "TODO_c000_2b7b", 0),
    MVI(0xc0002b7c, "TODO_c000_2b7c", 0),
    MVI(0xc0002b7d, "TODO_c000_2b7d", 0),
    MVI(0xc0002b7e, "TODO_c000_2b7e", 0),
    MVI(0xc0002b7f, "TODO_c000_2b7f", 0),
    MVI(0xc0002b80, "TODO_c000_2b80", 0),
    MVI(0xc0002b81, "TODO_c000_2b81", 0),
    MVI(0xc0002b82, "TODO_c000_2b82", 0),
    MVI(0xc0002b83, "TODO_c000_2b83", 0),
    MVI(0xc0002b84, "TODO_c000_2b84", 0),
    MVI(0xc0002b85, "TODO_c000_2b85", 0),
    MVI(0xc0002b86, "TODO_c000_2b86", 0),
    MVI(0xc0002b87, "TODO_c000_2b87", 0),
    MVI(0xc0002b88, "TODO_c000_2b88", 0),
    MVI(0xc0002b89, "TODO_c000_2b89", 0),
    MVI(0xc0002b8a, "TODO_c000_2b8a", 0),
    MVI(0xc0002b8b, "TODO_c000_2b8b", 0),
    MVI(0xc0002b8c, "TODO_c000_2b8c", 0),
    MVI(0xc0002b8d, "TODO_c000_2b8d", 0),
    MVI(0xc0002b8e, "TODO_c000_2b8e", 0),
    MVI(0xc0002b8f, "TODO_c000_2b8f", 0),
    MVI(0xc0002b90, "TODO_c000_2b90", 0),
    MVI(0xc0002b91, "TODO_c000_2b91", 0),
    MVI(0xc0002b92, "TODO_c000_2b92", 0),
    MVI(0xc0002b93, "TODO_c000_2b93", 0),
    MVI(0xc0002b94, "TODO_c000_2b94", 0),
    MVI(0xc0002b95, "TODO_c000_2b95", 0),
    MVI(0xc0002b96, "TODO_c000_2b96", 0),
    MVI(0xc0002b97, "TODO_c000_2b97", 0),
    MVI(0xc0002b98, "TODO_c000_2b98", 0),
    MVI(0xc0002b99, "TODO_c000_2b99", 0),
    MVI(0xc0002b9a, "TODO_c000_2b9a", 0),
    MVI(0xc0002b9b, "TODO_c000_2b9b", 0),
    MVI(0xc0002b9c, "TODO_c000_2b9c", 0),
    MVI(0xc0002b9d, "TODO_c000_2b9d", 0),
    MVI(0xc0002b9e, "TODO_c000_2b9e", 0),
    MVI(0xc0002b9f, "TODO_c000_2b9f", 0),
    MVI(0xc0002ba0, "TODO_c000_2ba0", 0),
    MVI(0xc0002ba1, "TODO_c000_2ba1", 0),
    MVI(0xc0002ba2, "TODO_c000_2ba2", 0),
    MVI(0xc0002ba3, "TODO_c000_2ba3", 0),
    MVI(0xc0002ba4, "TODO_c000_2ba4", 0),
    MVI(0xc0002ba5, "TODO_c000_2ba5", 0),
    MVI(0xc0002ba6, "TODO_c000_2ba6", 0),
    MVI(0xc0002ba7, "TODO_c000_2ba7", 0),
    MVI(0xc0002ba8, "TODO_c000_2ba8", 0),
    MVI(0xc0002ba9, "TODO_c000_2ba9", 0),
    MVI(0xc0002baa, "TODO_c000_2baa", 0),
    MVI(0xc0002bab, "TODO_c000_2bab", 0),
    MVI(0xc0002bac, "TODO_c000_2bac", 0),
    MVI(0xc0002bad, "TODO_c000_2bad", 0),
    MVI(0xc0002bae, "TODO_c000_2bae", 0),
    MVI(0xc0002baf, "TODO_c000_2baf", 0),
    MVI(0xc0002bb0, "TODO_c000_2bb0", 0),
    MVI(0xc0002bb1, "TODO_c000_2bb1", 0),
    MVI(0xc0002bb2, "TODO_c000_2bb2", 0),
    MVI(0xc0002bb3, "TODO_c000_2bb3", 0),
    MVI(0xc0002bb4, "TODO_c000_2bb4", 0),
    MVI(0xc0002bb5, "TODO_c000_2bb5", 0),
    MVI(0xc0002bb6, "TODO_c000_2bb6", 0),
    MVI(0xc0002bb7, "TODO_c000_2bb7", 0),
    MVI(0xc0002bb8, "TODO_c000_2bb8", 0),
    MVI(0xc0002bb9, "TODO_c000_2bb9", 0),
    MVI(0xc0002bba, "TODO_c000_2bba", 0),
    MVI(0xc0002bbb, "TODO_c000_2bbb", 0),
    MVI(0xc0002bbc, "TODO_c000_2bbc", 0),
    MVI(0xc0002bbd, "TODO_c000_2bbd", 0),
    MVI(0xc0002bbe, "TODO_c000_2bbe", 0),
    MVI(0xc0002bbf, "TODO_c000_2bbf", 0),
    MVI(0xc0002bc0, "TODO_c000_2bc0", 0),
    MVI(0xc0002bc1, "TODO_c000_2bc1", 0),
    MVI(0xc0002bc2, "TODO_c000_2bc2", 0),
    MVI(0xc0002bc3, "TODO_c000_2bc3", 0),
    MVI(0xc0002bc4, "TODO_c000_2bc4", 0),
    MVI(0xc0002bc5, "TODO_c000_2bc5", 0),
    MVI(0xc0002bc6, "TODO_c000_2bc6", 0),
    MVI(0xc0002bc7, "TODO_c000_2bc7", 0),
    MVI(0xc0002bc8, "TODO_c000_2bc8", 0),
    MVI(0xc0002bc9, "TODO_c000_2bc9", 0),
    MVI(0xc0002bca, "TODO_c000_2bca", 0),
    MVI(0xc0002bcb, "TODO_c000_2bcb", 0),
    MVI(0xc0002bcc, "TODO_c000_2bcc", 0),
    MVI(0xc0002bcd, "TODO_c000_2bcd", 0),
    MVI(0xc0002bce, "TODO_c000_2bce", 0),
    MVI(0xc0002bcf, "TODO_c000_2bcf", 0),
    MVI(0xc0002bd0, "TODO_c000_2bd0", 0),
    MVI(0xc0002bd1, "TODO_c000_2bd1", 0),
    MVI(0xc0002bd2, "TODO_c000_2bd2", 0),
    MVI(0xc0002bd3, "TODO_c000_2bd3", 0),
    MVI(0xc0002bd4, "TODO_c000_2bd4", 0),
    MVI(0xc0002bd5, "TODO_c000_2bd5", 0),
    MVI(0xc0002bd6, "TODO_c000_2bd6", 0),
    MVI(0xc0002bd7, "TODO_c000_2bd7", 0),
    MVI(0xc0002bd8, "TODO_c000_2bd8", 0),
    MVI(0xc0002bd9, "TODO_c000_2bd9", 0),
    MVI(0xc0002bda, "TODO_c000_2bda", 0),
    MVI(0xc0002bdb, "TODO_c000_2bdb", 0),
    MVI(0xc0002bdc, "TODO_c000_2bdc", 0),
    MVI(0xc0002bdd, "TODO_c000_2bdd", 0),
    MVI(0xc0002bde, "TODO_c000_2bde", 0),
    MVI(0xc0002bdf, "TODO_c000_2bdf", 0),
    MVI(0xc0002be0, "TODO_c000_2be0", 0),
    MVI(0xc0002be1, "TODO_c000_2be1", 0),
    MVI(0xc0002be2, "TODO_c000_2be2", 0),
    MVI(0xc0002be3, "TODO_c000_2be3", 0),
    MVI(0xc0002be4, "TODO_c000_2be4", 0),
    MVI(0xc0002be5, "TODO_c000_2be5", 0),
    MVI(0xc0002be6, "TODO_c000_2be6", 0),
    MVI(0xc0002be7, "TODO_c000_2be7", 0),
    MVI(0xc0002be8, "TODO_c000_2be8", 0),
    MVI(0xc0002be9, "TODO_c000_2be9", 0),
    MVI(0xc0002bea, "TODO_c000_2bea", 0),
    MVI(0xc0002beb, "TODO_c000_2beb", 0),
    MVI(0xc0002bec, "TODO_c000_2bec", 0),
    MVI(0xc0002bed, "TODO_c000_2bed", 0),
    MVI(0xc0002bee, "TODO_c000_2bee", 0),
    MVI(0xc0002bef, "TODO_c000_2bef", 0),
    MVI(0xc0002bf0, "TODO_c000_2bf0", 0),
    MVI(0xc0002bf1, "TODO_c000_2bf1", 0),
    MVI(0xc0002bf2, "TODO_c000_2bf2", 0),
    MVI(0xc0002bf3, "TODO_c000_2bf3", 0),
    MVI(0xc0002bf4, "TODO_c000_2bf4", 0),
    MVI(0xc0002bf5, "TODO_c000_2bf5", 0),
    MVI(0xc0002bf6, "TODO_c000_2bf6", 0),
    MVI(0xc0002bf7, "TODO_c000_2bf7", 0),
    MVI(0xc0002bf8, "TODO_c000_2bf8", 0),
    MVI(0xc0002bf9, "TODO_c000_2bf9", 0),
    MVI(0xc0002bfa, "TODO_c000_2bfa", 0),
    MVI(0xc0002bfb, "TODO_c000_2bfb", 0),
    MVI(0xc0002bfc, "TODO_c000_2bfc", 0),
    MVI(0xc0002bfd, "TODO_c000_2bfd", 0),
    MVI(0xc0002bfe, "TODO_c000_2bfe", 0),
    MVI(0xc0002bff, "TODO_c000_2bff", 0),
    MVI(0xc0002c00, "TODO_c000_2c00", 0),
    MVI(0xc0002c01, "TODO_c000_2c01", 0),
    MVI(0xc0002c02, "TODO_c000_2c02", 0),
    MVI(0xc0002c03, "TODO_c000_2c03", 0),
    MVI(0xc0002c04, "TODO_c000_2c04", 0),
    MVI(0xc0002c05, "TODO_c000_2c05", 0),
    MVI(0xc0002c06, "TODO_c000_2c06", 0),
    MVI(0xc0002c07, "TODO_c000_2c07", 0),
    MVI(0xc0002c08, "TODO_c000_2c08", 0),
    MVI(0xc0002c09, "TODO_c000_2c09", 0),
    MVI(0xc0002c0a, "TODO_c000_2c0a", 0),
    MVI(0xc0002c0b, "TODO_c000_2c0b", 0),
    MVI(0xc0002c0c, "TODO_c000_2c0c", 0),
    MVI(0xc0002c0d, "TODO_c000_2c0d", 0),
    MVI(0xc0002c0e, "TODO_c000_2c0e", 0),
    MVI(0xc0002c0f, "TODO_c000_2c0f", 0),
    MVI(0xc0002c10, "TODO_c000_2c10", 0),
    MVI(0xc0002c11, "TODO_c000_2c11", 0),
    MVI(0xc0002c12, "TODO_c000_2c12", 0),
    MVI(0xc0002c13, "TODO_c000_2c13", 0),
    MVI(0xc0002c14, "TODO_c000_2c14", 0),
    MVI(0xc0002c15, "TODO_c000_2c15", 0),
    MVI(0xc0002c16, "TODO_c000_2c16", 0),
    MVI(0xc0002c17, "TODO_c000_2c17", 0),
    MVI(0xc0002c18, "TODO_c000_2c18", 0),
    MVI(0xc0002c19, "TODO_c000_2c19", 0),
    MVI(0xc0002c1a, "TODO_c000_2c1a", 0),
    MVI(0xc0002c1b, "TODO_c000_2c1b", 0),
    MVI(0xc0002c1c, "TODO_c000_2c1c", 0),
    MVI(0xc0002c1d, "TODO_c000_2c1d", 0),
    MVI(0xc0002c1e, "TODO_c000_2c1e", 0),
    MVI(0xc0002c1f, "TODO_c000_2c1f", 0),
    MVI(0xc0002c20, "TODO_c000_2c20", 0),
    MVI(0xc0002c21, "TODO_c000_2c21", 0),
    MVI(0xc0002c22, "TODO_c000_2c22", 0),
    MVI(0xc0002c23, "TODO_c000_2c23", 0),
    MVI(0xc0002c24, "TODO_c000_2c24", 0),
    MVI(0xc0002c25, "TODO_c000_2c25", 0),
    MVI(0xc0002c26, "TODO_c000_2c26", 0),
    MVI(0xc0002c27, "TODO_c000_2c27", 0),
    MVI(0xc0002c28, "TODO_c000_2c28", 0),
    MVI(0xc0002c29, "TODO_c000_2c29", 0),
    MVI(0xc0002c2a, "TODO_c000_2c2a", 0),
    MVI(0xc0002c2b, "TODO_c000_2c2b", 0),
    MVI(0xc0002c2c, "TODO_c000_2c2c", 0),
    MVI(0xc0002c2d, "TODO_c000_2c2d", 0),
    MVI(0xc0002c2e, "TODO_c000_2c2e", 0),
    MVI(0xc0002c2f, "TODO_c000_2c2f", 0),
    MVI(0xc0002c30, "TODO_c000_2c30", 0),
    MVI(0xc0002c31, "TODO_c000_2c31", 0),
    MVI(0xc0002c32, "TODO_c000_2c32", 0),
    MVI(0xc0002c33, "TODO_c000_2c33", 0),
    MVI(0xc0002c34, "TODO_c000_2c34", 0),
    MVI(0xc0002c35, "TODO_c000_2c35", 0),
    MVI(0xc0002c36, "TODO_c000_2c36", 0),
    MVI(0xc0002c37, "TODO_c000_2c37", 0),
    MVI(0xc0002c38, "TODO_c000_2c38", 0),
    MVI(0xc0002c39, "TODO_c000_2c39", 0),
    MVI(0xc0002c3a, "TODO_c000_2c3a", 0),
    MVI(0xc0002c3b, "TODO_c000_2c3b", 0),
    MVI(0xc0002c3c, "TODO_c000_2c3c", 0),
    MVI(0xc0002c3d, "TODO_c000_2c3d", 0),
    MVI(0xc0002c3e, "TODO_c000_2c3e", 0),
    MVI(0xc0002c3f, "TODO_c000_2c3f", 0),
    MVI(0xc0002c40, "TODO_c000_2c40", 0),
    MVI(0xc0002c41, "TODO_c000_2c41", 0),
    MVI(0xc0002c42, "TODO_c000_2c42", 0),
    MVI(0xc0002c43, "TODO_c000_2c43", 0),
    MVI(0xc0002c44, "TODO_c000_2c44", 0),
    MVI(0xc0002c45, "TODO_c000_2c45", 0),
    MVI(0xc0002c46, "TODO_c000_2c46", 0),
    MVI(0xc0002c47, "TODO_c000_2c47", 0),
    MVI(0xc0002c48, "TODO_c000_2c48", 0),
    MVI(0xc0002c49, "TODO_c000_2c49", 0),
    MVI(0xc0002c4a, "TODO_c000_2c4a", 0),
    MVI(0xc0002c4b, "TODO_c000_2c4b", 0),
    MVI(0xc0002c4c, "TODO_c000_2c4c", 0),
    MVI(0xc0002c4d, "TODO_c000_2c4d", 0),
    MVI(0xc0002c4e, "TODO_c000_2c4e", 0),
    MVI(0xc0002c4f, "TODO_c000_2c4f", 0),
    MVI(0xc0002c50, "TODO_c000_2c50", 0),
    MVI(0xc0002c51, "TODO_c000_2c51", 0),
    MVI(0xc0002c52, "TODO_c000_2c52", 0),
    MVI(0xc0002c53, "TODO_c000_2c53", 0),
    MVI(0xc0002c54, "TODO_c000_2c54", 0),
    MVI(0xc0002c55, "TODO_c000_2c55", 0),
    MVI(0xc0002c56, "TODO_c000_2c56", 0),
    MVI(0xc0002c57, "TODO_c000_2c57", 0),
    MVI(0xc0002c58, "TODO_c000_2c58", 0),
    MVI(0xc0002c59, "TODO_c000_2c59", 0),
    MVI(0xc0002c5a, "TODO_c000_2c5a", 0),
    MVI(0xc0002c5b, "TODO_c000_2c5b", 0),
    MVI(0xc0002c5c, "TODO_c000_2c5c", 0),
    MVI(0xc0002c5d, "TODO_c000_2c5d", 0),
    MVI(0xc0002c5e, "TODO_c000_2c5e", 0),
    MVI(0xc0002c5f, "TODO_c000_2c5f", 0),
    MVI(0xc0002c60, "TODO_c000_2c60", 0),
    MVI(0xc0002c61, "TODO_c000_2c61", 0),
    MVI(0xc0002c62, "TODO_c000_2c62", 0),
    MVI(0xc0002c63, "TODO_c000_2c63", 0),
    MVI(0xc0002c64, "TODO_c000_2c64", 0),
    MVI(0xc0002c65, "TODO_c000_2c65", 0),
    MVI(0xc0002c66, "TODO_c000_2c66", 0),
    MVI(0xc0002c67, "TODO_c000_2c67", 0),
    MVI(0xc0002c68, "TODO_c000_2c68", 0),
    MVI(0xc0002c69, "TODO_c000_2c69", 0),
    MVI(0xc0002c6a, "TODO_c000_2c6a", 0),
    MVI(0xc0002c6b, "TODO_c000_2c6b", 0),
    MVI(0xc0002c6c, "TODO_c000_2c6c", 0),
    MVI(0xc0002c6d, "TODO_c000_2c6d", 0),
    MVI(0xc0002c6e, "TODO_c000_2c6e", 0),
    MVI(0xc0002c6f, "TODO_c000_2c6f", 0),
    MVI(0xc0002c70, "TODO_c000_2c70", 0),
    MVI(0xc0002c71, "TODO_c000_2c71", 0),
    MVI(0xc0002c72, "TODO_c000_2c72", 0),
    MVI(0xc0002c73, "TODO_c000_2c73", 0),
    MVI(0xc0002c74, "TODO_c000_2c74", 0),
    MVI(0xc0002c75, "TODO_c000_2c75", 0),
    MVI(0xc0002c76, "TODO_c000_2c76", 0),
    MVI(0xc0002c77, "TODO_c000_2c77", 0),
    MVI(0xc0002c78, "TODO_c000_2c78", 0),
    MVI(0xc0002c79, "TODO_c000_2c79", 0),
    MVI(0xc0002c7a, "TODO_c000_2c7a", 0),
    MVI(0xc0002c7b, "TODO_c000_2c7b", 0),
    MVI(0xc0002c7c, "TODO_c000_2c7c", 0),
    MVI(0xc0002c7d, "TODO_c000_2c7d", 0),
    MVI(0xc0002c7e, "TODO_c000_2c7e", 0),
    MVI(0xc0002c7f, "TODO_c000_2c7f", 0),
    MVI(0xc0002c80, "TODO_c000_2c80", 0),
    MVI(0xc0002c81, "TODO_c000_2c81", 0),
    MVI(0xc0002c82, "TODO_c000_2c82", 0),
    MVI(0xc0002c83, "TODO_c000_2c83", 0),
    MVI(0xc0002c84, "TODO_c000_2c84", 0),
    MVI(0xc0002c85, "TODO_c000_2c85", 0),
    MVI(0xc0002c86, "TODO_c000_2c86", 0),
    MVI(0xc0002c87, "TODO_c000_2c87", 0),
    MVI(0xc0002c88, "TODO_c000_2c88", 0),
    MVI(0xc0002c89, "TODO_c000_2c89", 0),
    MVI(0xc0002c8a, "TODO_c000_2c8a", 0),
    MVI(0xc0002c8b, "TODO_c000_2c8b", 0),
    MVI(0xc0002c8c, "TODO_c000_2c8c", 0),
    MVI(0xc0002c8d, "TODO_c000_2c8d", 0),
    MVI(0xc0002c8e, "TODO_c000_2c8e", 0),
    MVI(0xc0002c8f, "TODO_c000_2c8f", 0),
    MVI(0xc0002c90, "TODO_c000_2c90", 0),
    MVI(0xc0002c91, "TODO_c000_2c91", 0),
    MVI(0xc0002c92, "TODO_c000_2c92", 0),
    MVI(0xc0002c93, "TODO_c000_2c93", 0),
    MVI(0xc0002c94, "TODO_c000_2c94", 0),
    MVI(0xc0002c95, "TODO_c000_2c95", 0),
    MVI(0xc0002c96, "TODO_c000_2c96", 0),
    MVI(0xc0002c97, "TODO_c000_2c97", 0),
    MVI(0xc0002c98, "TODO_c000_2c98", 0),
    MVI(0xc0002c99, "TODO_c000_2c99", 0),
    MVI(0xc0002c9a, "TODO_c000_2c9a", 0),
    MVI(0xc0002c9b, "TODO_c000_2c9b", 0),
    MVI(0xc0002c9c, "TODO_c000_2c9c", 0),
    MVI(0xc0002c9d, "TODO_c000_2c9d", 0),
    MVI(0xc0002c9e, "TODO_c000_2c9e", 0),
    MVI(0xc0002c9f, "TODO_c000_2c9f", 0),
    MVI(0xc0002ca0, "TODO_c000_2ca0", 0),
    MVI(0xc0002ca1, "TODO_c000_2ca1", 0),
    MVI(0xc0002ca2, "TODO_c000_2ca2", 0),
    MVI(0xc0002ca3, "TODO_c000_2ca3", 0),
    MVI(0xc0002ca4, "TODO_c000_2ca4", 0),
    MVI(0xc0002ca5, "TODO_c000_2ca5", 0),
    MVI(0xc0002ca6, "TODO_c000_2ca6", 0),
    MVI(0xc0002ca7, "TODO_c000_2ca7", 0),
    MVI(0xc0002ca8, "TODO_c000_2ca8", 0),
    MVI(0xc0002ca9, "TODO_c000_2ca9", 0),
    MVI(0xc0002caa, "TODO_c000_2caa", 0),
    MVI(0xc0002cab, "TODO_c000_2cab", 0),
    MVI(0xc0002cac, "TODO_c000_2cac", 0),
    MVI(0xc0002cad, "TODO_c000_2cad", 0),
    MVI(0xc0002cae, "TODO_c000_2cae", 0),
    MVI(0xc0002caf, "TODO_c000_2caf", 0),
    MVI(0xc0002cb0, "TODO_c000_2cb0", 0),
    MVI(0xc0002cb1, "TODO_c000_2cb1", 0),
    MVI(0xc0002cb2, "TODO_c000_2cb2", 0),
    MVI(0xc0002cb3, "TODO_c000_2cb3", 0),
    MVI(0xc0002cb4, "TODO_c000_2cb4", 0),
    MVI(0xc0002cb5, "TODO_c000_2cb5", 0),
    MVI(0xc0002cb6, "TODO_c000_2cb6", 0),
    MVI(0xc0002cb7, "TODO_c000_2cb7", 0),
    MVI(0xc0002cb8, "TODO_c000_2cb8", 0),
    MVI(0xc0002cb9, "TODO_c000_2cb9", 0),
    MVI(0xc0002cba, "TODO_c000_2cba", 0),
    MVI(0xc0002cbb, "TODO_c000_2cbb", 0),
    MVI(0xc0002cbc, "TODO_c000_2cbc", 0),
    MVI(0xc0002cbd, "TODO_c000_2cbd", 0),
    MVI(0xc0002cbe, "TODO_c000_2cbe", 0),
    MVI(0xc0002cbf, "TODO_c000_2cbf", 0),
    MVI(0xc0002cc0, "TODO_c000_2cc0", 0),
    MVI(0xc0002cc1, "TODO_c000_2cc1", 0),
    MVI(0xc0002cc2, "TODO_c000_2cc2", 0),
    MVI(0xc0002cc3, "TODO_c000_2cc3", 0),
    MVI(0xc0002cc4, "TODO_c000_2cc4", 0),
    MVI(0xc0002cc5, "TODO_c000_2cc5", 0),
    MVI(0xc0002cc6, "TODO_c000_2cc6", 0),
    MVI(0xc0002cc7, "TODO_c000_2cc7", 0),
    MVI(0xc0002cc8, "TODO_c000_2cc8", 0),
    MVI(0xc0002cc9, "TODO_c000_2cc9", 0),
    MVI(0xc0002cca, "TODO_c000_2cca", 0),
    MVI(0xc0002ccb, "TODO_c000_2ccb", 0),
    MVI(0xc0002ccc, "TODO_c000_2ccc", 0),
    MVI(0xc0002ccd, "TODO_c000_2ccd", 0),
    MVI(0xc0002cce, "TODO_c000_2cce", 0),
    MVI(0xc0002ccf, "TODO_c000_2ccf", 0),
    MVI(0xc0002cd0, "TODO_c000_2cd0", 0),
    MVI(0xc0002cd1, "TODO_c000_2cd1", 0),
    MVI(0xc0002cd2, "TODO_c000_2cd2", 0),
    MVI(0xc0002cd3, "TODO_c000_2cd3", 0),
    MVI(0xc0002cd4, "TODO_c000_2cd4", 0),
    MVI(0xc0002cd5, "TODO_c000_2cd5", 0),
    MVI(0xc0002cd6, "TODO_c000_2cd6", 0),
    MVI(0xc0002cd7, "TODO_c000_2cd7", 0),
    MVI(0xc0002cd8, "TODO_c000_2cd8", 0),
    MVI(0xc0002cd9, "TODO_c000_2cd9", 0),
    MVI(0xc0002cda, "TODO_c000_2cda", 0),
    MVI(0xc0002cdb, "TODO_c000_2cdb", 0),
    MVI(0xc0002cdc, "TODO_c000_2cdc", 0),
    MVI(0xc0002cdd, "TODO_c000_2cdd", 0),
    MVI(0xc0002cde, "TODO_c000_2cde", 0),
    MVI(0xc0002cdf, "TODO_c000_2cdf", 0),
    MVI(0xc0002ce0, "TODO_c000_2ce0", 0),
    MVI(0xc0002ce1, "TODO_c000_2ce1", 0),
    MVI(0xc0002ce2, "TODO_c000_2ce2", 0),
    MVI(0xc0002ce3, "TODO_c000_2ce3", 0),
    MVI(0xc0002ce4, "TODO_c000_2ce4", 0),
    MVI(0xc0002ce5, "TODO_c000_2ce5", 0),
    MVI(0xc0002ce6, "TODO_c000_2ce6", 0),
    MVI(0xc0002ce7, "TODO_c000_2ce7", 0),
    MVI(0xc0002ce8, "TODO_c000_2ce8", 0),
    MVI(0xc0002ce9, "TODO_c000_2ce9", 0),
    MVI(0xc0002cea, "TODO_c000_2cea", 0),
    MVI(0xc0002ceb, "TODO_c000_2ceb", 0),
    MVI(0xc0002cec, "TODO_c000_2cec", 0),
    MVI(0xc0002ced, "TODO_c000_2ced", 0),
    MVI(0xc0002cee, "TODO_c000_2cee", 0),
    MVI(0xc0002cef, "TODO_c000_2cef", 0),
    MVI(0xc0002cf0, "TODO_c000_2cf0", 0),
    MVI(0xc0002cf1, "TODO_c000_2cf1", 0),
    MVI(0xc0002cf2, "TODO_c000_2cf2", 0),
    MVI(0xc0002cf3, "TODO_c000_2cf3", 0),
    MVI(0xc0002cf4, "TODO_c000_2cf4", 0),
    MVI(0xc0002cf5, "TODO_c000_2cf5", 0),
    MVI(0xc0002cf6, "TODO_c000_2cf6", 0),
    MVI(0xc0002cf7, "TODO_c000_2cf7", 0),
    MVI(0xc0002cf8, "TODO_c000_2cf8", 0),
    MVI(0xc0002cf9, "TODO_c000_2cf9", 0),
    MVI(0xc0002cfa, "TODO_c000_2cfa", 0),
    MVI(0xc0002cfb, "TODO_c000_2cfb", 0),
    MVI(0xc0002cfc, "TODO_c000_2cfc", 0),
    MVI(0xc0002cfd, "TODO_c000_2cfd", 0),
    MVI(0xc0002cfe, "TODO_c000_2cfe", 0),
    MVI(0xc0002cff, "TODO_c000_2cff", 0),
    MVI(0xc0002d00, "TODO_c000_2d00", 0),
    MVI(0xc0002d01, "TODO_c000_2d01", 0),
    MVI(0xc0002d02, "TODO_c000_2d02", 0),
    MVI(0xc0002d03, "TODO_c000_2d03", 0),
    MVI(0xc0002d04, "TODO_c000_2d04", 0),
    MVI(0xc0002d05, "TODO_c000_2d05", 0),
    MVI(0xc0002d06, "TODO_c000_2d06", 0),
    MVI(0xc0002d07, "TODO_c000_2d07", 0),
    MVI(0xc0002d08, "TODO_c000_2d08", 0),
    MVI(0xc0002d09, "TODO_c000_2d09", 0),
    MVI(0xc0002d0a, "TODO_c000_2d0a", 0),
    MVI(0xc0002d0b, "TODO_c000_2d0b", 0),
    MVI(0xc0002d0c, "TODO_c000_2d0c", 0),
    MVI(0xc0002d0d, "TODO_c000_2d0d", 0),
    MVI(0xc0002d0e, "TODO_c000_2d0e", 0),
    MVI(0xc0002d0f, "TODO_c000_2d0f", 0),
    MVI(0xc0002d10, "TODO_c000_2d10", 0),
    MVI(0xc0002d11, "TODO_c000_2d11", 0),
    MVI(0xc0002d12, "TODO_c000_2d12", 0),
    MVI(0xc0002d13, "TODO_c000_2d13", 0),
    MVI(0xc0002d14, "TODO_c000_2d14", 0),
    MVI(0xc0002d15, "TODO_c000_2d15", 0),
    MVI(0xc0002d16, "TODO_c000_2d16", 0),
    MVI(0xc0002d17, "TODO_c000_2d17", 0),
    MVI(0xc0002d18, "TODO_c000_2d18", 0),
    MVI(0xc0002d19, "TODO_c000_2d19", 0),
    MVI(0xc0002d1a, "TODO_c000_2d1a", 0),
    MVI(0xc0002d1b, "TODO_c000_2d1b", 0),
    MVI(0xc0002d1c, "TODO_c000_2d1c", 0),
    MVI(0xc0002d1d, "TODO_c000_2d1d", 0),
    MVI(0xc0002d1e, "TODO_c000_2d1e", 0),
    MVI(0xc0002d1f, "TODO_c000_2d1f", 0),
    MVI(0xc0002d20, "TODO_c000_2d20", 0),
    MVI(0xc0002d21, "TODO_c000_2d21", 0),
    MVI(0xc0002d22, "TODO_c000_2d22", 0),
    MVI(0xc0002d23, "TODO_c000_2d23", 0),
    MVI(0xc0002d24, "TODO_c000_2d24", 0),
    MVI(0xc0002d25, "TODO_c000_2d25", 0),
    MVI(0xc0002d26, "TODO_c000_2d26", 0),
    MVI(0xc0002d27, "TODO_c000_2d27", 0),
    MVI(0xc0002d28, "TODO_c000_2d28", 0),
    MVI(0xc0002d29, "TODO_c000_2d29", 0),
    MVI(0xc0002d2a, "TODO_c000_2d2a", 0),
    MVI(0xc0002d2b, "TODO_c000_2d2b", 0),
    MVI(0xc0002d2c, "TODO_c000_2d2c", 0),
    MVI(0xc0002d2d, "TODO_c000_2d2d", 0),
    MVI(0xc0002d2e, "TODO_c000_2d2e", 0),
    MVI(0xc0002d2f, "TODO_c000_2d2f", 0),
    MVI(0xc0002d30, "TODO_c000_2d30", 0),
    MVI(0xc0002d31, "TODO_c000_2d31", 0),
    MVI(0xc0002d32, "TODO_c000_2d32", 0),
    MVI(0xc0002d33, "TODO_c000_2d33", 0),
    MVI(0xc0002d34, "TODO_c000_2d34", 0),
    MVI(0xc0002d35, "TODO_c000_2d35", 0),
    MVI(0xc0002d36, "TODO_c000_2d36", 0),
    MVI(0xc0002d37, "TODO_c000_2d37", 0),
    MVI(0xc0002d38, "TODO_c000_2d38", 0),
    MVI(0xc0002d39, "TODO_c000_2d39", 0),
    MVI(0xc0002d3a, "TODO_c000_2d3a", 0),
    MVI(0xc0002d3b, "TODO_c000_2d3b", 0),
    MVI(0xc0002d3c, "TODO_c000_2d3c", 0),
    MVI(0xc0002d3d, "TODO_c000_2d3d", 0),
    MVI(0xc0002d3e, "TODO_c000_2d3e", 0),
    MVI(0xc0002d3f, "TODO_c000_2d3f", 0),
    MVI(0xc0002d40, "TODO_c000_2d40", 0),
    MVI(0xc0002d41, "TODO_c000_2d41", 0),
    MVI(0xc0002d42, "TODO_c000_2d42", 0),
    MVI(0xc0002d43, "TODO_c000_2d43", 0),
    MVI(0xc0002d44, "TODO_c000_2d44", 0),
    MVI(0xc0002d45, "TODO_c000_2d45", 0),
    MVI(0xc0002d46, "TODO_c000_2d46", 0),
    MVI(0xc0002d47, "TODO_c000_2d47", 0),
    MVI(0xc0002d48, "TODO_c000_2d48", 0),
    MVI(0xc0002d49, "TODO_c000_2d49", 0),
    MVI(0xc0002d4a, "TODO_c000_2d4a", 0),
    MVI(0xc0002d4b, "TODO_c000_2d4b", 0),
    MVI(0xc0002d4c, "TODO_c000_2d4c", 0),
    MVI(0xc0002d4d, "TODO_c000_2d4d", 0),
    MVI(0xc0002d4e, "TODO_c000_2d4e", 0),
    MVI(0xc0002d4f, "TODO_c000_2d4f", 0),
    MVI(0xc0002d50, "TODO_c000_2d50", 0),
    MVI(0xc0002d51, "TODO_c000_2d51", 0),
    MVI(0xc0002d52, "TODO_c000_2d52", 0),
    MVI(0xc0002d53, "TODO_c000_2d53", 0),
    MVI(0xc0002d54, "TODO_c000_2d54", 0),
    MVI(0xc0002d55, "TODO_c000_2d55", 0),
    MVI(0xc0002d56, "TODO_c000_2d56", 0),
    MVI(0xc0002d57, "TODO_c000_2d57", 0),
    MVI(0xc0002d58, "TODO_c000_2d58", 0),
    MVI(0xc0002d59, "TODO_c000_2d59", 0),
    MVI(0xc0002d5a, "TODO_c000_2d5a", 0),
    MVI(0xc0002d5b, "TODO_c000_2d5b", 0),
    MVI(0xc0002d5c, "TODO_c000_2d5c", 0),
    MVI(0xc0002d5d, "TODO_c000_2d5d", 0),
    MVI(0xc0002d5e, "TODO_c000_2d5e", 0),
    MVI(0xc0002d5f, "TODO_c000_2d5f", 0),
    MVI(0xc0002d60, "TODO_c000_2d60", 0),
    MVI(0xc0002d61, "TODO_c000_2d61", 0),
    MVI(0xc0002d62, "TODO_c000_2d62", 0),
    MVI(0xc0002d63, "TODO_c000_2d63", 0),
    MVI(0xc0002d64, "TODO_c000_2d64", 0),
    MVI(0xc0002d65, "TODO_c000_2d65", 0),
    MVI(0xc0002d66, "TODO_c000_2d66", 0),
    MVI(0xc0002d67, "TODO_c000_2d67", 0),
    MVI(0xc0002d68, "TODO_c000_2d68", 0),
    MVI(0xc0002d69, "TODO_c000_2d69", 0),
    MVI(0xc0002d6a, "TODO_c000_2d6a", 0),
    MVI(0xc0002d6b, "TODO_c000_2d6b", 0),
    MVI(0xc0002d6c, "TODO_c000_2d6c", 0),
    MVI(0xc0002d6d, "TODO_c000_2d6d", 0),
    MVI(0xc0002d6e, "TODO_c000_2d6e", 0),
    MVI(0xc0002d6f, "TODO_c000_2d6f", 0),
    MVI(0xc0002d70, "TODO_c000_2d70", 0),
    MVI(0xc0002d71, "TODO_c000_2d71", 0),
    MVI(0xc0002d72, "TODO_c000_2d72", 0),
    MVI(0xc0002d73, "TODO_c000_2d73", 0),
    MVI(0xc0002d74, "TODO_c000_2d74", 0),
    MVI(0xc0002d75, "TODO_c000_2d75", 0),
    MVI(0xc0002d76, "TODO_c000_2d76", 0),
    MVI(0xc0002d77, "TODO_c000_2d77", 0),
    MVI(0xc0002d78, "TODO_c000_2d78", 0),
    MVI(0xc0002d79, "TODO_c000_2d79", 0),
    MVI(0xc0002d7a, "TODO_c000_2d7a", 0),
    MVI(0xc0002d7b, "TODO_c000_2d7b", 0),
    MVI(0xc0002d7c, "TODO_c000_2d7c", 0),
    MVI(0xc0002d7d, "TODO_c000_2d7d", 0),
    MVI(0xc0002d7e, "TODO_c000_2d7e", 0),
    MVI(0xc0002d7f, "TODO_c000_2d7f", 0),
    MVI(0xc0002d80, "TODO_c000_2d80", 0),
    MVI(0xc0002d81, "TODO_c000_2d81", 0),
    MVI(0xc0002d82, "TODO_c000_2d82", 0),
    MVI(0xc0002d83, "TODO_c000_2d83", 0),
    MVI(0xc0002d84, "TODO_c000_2d84", 0),
    MVI(0xc0002d85, "TODO_c000_2d85", 0),
    MVI(0xc0002d86, "TODO_c000_2d86", 0),
    MVI(0xc0002d87, "TODO_c000_2d87", 0),
    MVI(0xc0002d88, "TODO_c000_2d88", 0),
    MVI(0xc0002d89, "TODO_c000_2d89", 0),
    MVI(0xc0002d8a, "TODO_c000_2d8a", 0),
    MVI(0xc0002d8b, "TODO_c000_2d8b", 0),
    MVI(0xc0002d8c, "TODO_c000_2d8c", 0),
    MVI(0xc0002d8d, "TODO_c000_2d8d", 0),
    MVI(0xc0002d8e, "TODO_c000_2d8e", 0),
    MVI(0xc0002d8f, "TODO_c000_2d8f", 0),
    MVI(0xc0002d90, "TODO_c000_2d90", 0),
    MVI(0xc0002d91, "TODO_c000_2d91", 0),
    MVI(0xc0002d92, "TODO_c000_2d92", 0),
    MVI(0xc0002d93, "TODO_c000_2d93", 0),
    MVI(0xc0002d94, "TODO_c000_2d94", 0),
    MVI(0xc0002d95, "TODO_c000_2d95", 0),
    MVI(0xc0002d96, "TODO_c000_2d96", 0),
    MVI(0xc0002d97, "TODO_c000_2d97", 0),
    MVI(0xc0002d98, "TODO_c000_2d98", 0),
    MVI(0xc0002d99, "TODO_c000_2d99", 0),
    MVI(0xc0002d9a, "TODO_c000_2d9a", 0),
    MVI(0xc0002d9b, "TODO_c000_2d9b", 0),
    MVI(0xc0002d9c, "TODO_c000_2d9c", 0),
    MVI(0xc0002d9d, "TODO_c000_2d9d", 0),
    MVI(0xc0002d9e, "TODO_c000_2d9e", 0),
    MVI(0xc0002d9f, "TODO_c000_2d9f", 0),
    MVI(0xc0002da0, "TODO_c000_2da0", 0),
    MVI(0xc0002da1, "TODO_c000_2da1", 0),
    MVI(0xc0002da2, "TODO_c000_2da2", 0),
    MVI(0xc0002da3, "TODO_c000_2da3", 0),
    MVI(0xc0002da4, "TODO_c000_2da4", 0),
    MVI(0xc0002da5, "TODO_c000_2da5", 0),
    MVI(0xc0002da6, "TODO_c000_2da6", 0),
    MVI(0xc0002da7, "TODO_c000_2da7", 0),
    MVI(0xc0002da8, "TODO_c000_2da8", 0),
    MVI(0xc0002da9, "TODO_c000_2da9", 0),
    MVI(0xc0002daa, "TODO_c000_2daa", 0),
    MVI(0xc0002dab, "TODO_c000_2dab", 0),
    MVI(0xc0002dac, "TODO_c000_2dac", 0),
    MVI(0xc0002dad, "TODO_c000_2dad", 0),
    MVI(0xc0002dae, "TODO_c000_2dae", 0),
    MVI(0xc0002daf, "TODO_c000_2daf", 0),
    MVI(0xc0002db0, "TODO_c000_2db0", 0),
    MVI(0xc0002db1, "TODO_c000_2db1", 0),
    MVI(0xc0002db2, "TODO_c000_2db2", 0),
    MVI(0xc0002db3, "TODO_c000_2db3", 0),
    MVI(0xc0002db4, "TODO_c000_2db4", 0),
    MVI(0xc0002db5, "TODO_c000_2db5", 0),
    MVI(0xc0002db6, "TODO_c000_2db6", 0),
    MVI(0xc0002db7, "TODO_c000_2db7", 0),
    MVI(0xc0002db8, "TODO_c000_2db8", 0),
    MVI(0xc0002db9, "TODO_c000_2db9", 0),
    MVI(0xc0002dba, "TODO_c000_2dba", 0),
    MVI(0xc0002dbb, "TODO_c000_2dbb", 0),
    MVI(0xc0002dbc, "TODO_c000_2dbc", 0),
    MVI(0xc0002dbd, "TODO_c000_2dbd", 0),
    MVI(0xc0002dbe, "TODO_c000_2dbe", 0),
    MVI(0xc0002dbf, "TODO_c000_2dbf", 0),
    MVI(0xc0002dc0, "TODO_c000_2dc0", 0),
    MVI(0xc0002dc1, "TODO_c000_2dc1", 0),
    MVI(0xc0002dc2, "TODO_c000_2dc2", 0),
    MVI(0xc0002dc3, "TODO_c000_2dc3", 0),
    MVI(0xc0002dc4, "TODO_c000_2dc4", 0),
    MVI(0xc0002dc5, "TODO_c000_2dc5", 0),
    MVI(0xc0002dc6, "TODO_c000_2dc6", 0),
    MVI(0xc0002dc7, "TODO_c000_2dc7", 0),
    MVI(0xc0002dc8, "TODO_c000_2dc8", 0),
    MVI(0xc0002dc9, "TODO_c000_2dc9", 0),
    MVI(0xc0002dca, "TODO_c000_2dca", 0),
    MVI(0xc0002dcb, "TODO_c000_2dcb", 0),
    MVI(0xc0002dcc, "TODO_c000_2dcc", 0),
    MVI(0xc0002dcd, "TODO_c000_2dcd", 0),
    MVI(0xc0002dce, "TODO_c000_2dce", 0),
    MVI(0xc0002dcf, "TODO_c000_2dcf", 0),
    MVI(0xc0002dd0, "TODO_c000_2dd0", 0),
    MVI(0xc0002dd1, "TODO_c000_2dd1", 0),
    MVI(0xc0002dd2, "TODO_c000_2dd2", 0),
    MVI(0xc0002dd3, "TODO_c000_2dd3", 0),
    MVI(0xc0002dd4, "TODO_c000_2dd4", 0),
    MVI(0xc0002dd5, "TODO_c000_2dd5", 0),
    MVI(0xc0002dd6, "TODO_c000_2dd6", 0),
    MVI(0xc0002dd7, "TODO_c000_2dd7", 0),
    MVI(0xc0002dd8, "TODO_c000_2dd8", 0),
    MVI(0xc0002dd9, "TODO_c000_2dd9", 0),
    MVI(0xc0002dda, "TODO_c000_2dda", 0),
    MVI(0xc0002ddb, "TODO_c000_2ddb", 0),
    MVI(0xc0002ddc, "TODO_c000_2ddc", 0),
    MVI(0xc0002ddd, "TODO_c000_2ddd", 0),
    MVI(0xc0002dde, "TODO_c000_2dde", 0),
    MVI(0xc0002ddf, "TODO_c000_2ddf", 0),
    MVI(0xc0002de0, "TODO_c000_2de0", 0),
    MVI(0xc0002de1, "TODO_c000_2de1", 0),
    MVI(0xc0002de2, "TODO_c000_2de2", 0),
    MVI(0xc0002de3, "TODO_c000_2de3", 0),
    MVI(0xc0002de4, "TODO_c000_2de4", 0),
    MVI(0xc0002de5, "TODO_c000_2de5", 0),
    MVI(0xc0002de6, "TODO_c000_2de6", 0),
    MVI(0xc0002de7, "TODO_c000_2de7", 0),
    MVI(0xc0002de8, "TODO_c000_2de8", 0),
    MVI(0xc0002de9, "TODO_c000_2de9", 0),
    MVI(0xc0002dea, "TODO_c000_2dea", 0),
    MVI(0xc0002deb, "TODO_c000_2deb", 0),
    MVI(0xc0002dec, "TODO_c000_2dec", 0),
    MVI(0xc0002ded, "TODO_c000_2ded", 0),
    MVI(0xc0002dee, "TODO_c000_2dee", 0),
    MVI(0xc0002def, "TODO_c000_2def", 0),
    MVI(0xc0002df0, "TODO_c000_2df0", 0),
    MVI(0xc0002df1, "TODO_c000_2df1", 0),
    MVI(0xc0002df2, "TODO_c000_2df2", 0),
    MVI(0xc0002df3, "TODO_c000_2df3", 0),
    MVI(0xc0002df4, "TODO_c000_2df4", 0),
    MVI(0xc0002df5, "TODO_c000_2df5", 0),
    MVI(0xc0002df6, "TODO_c000_2df6", 0),
    MVI(0xc0002df7, "TODO_c000_2df7", 0),
    MVI(0xc0002df8, "TODO_c000_2df8", 0),
    MVI(0xc0002df9, "TODO_c000_2df9", 0),
    MVI(0xc0002dfa, "TODO_c000_2dfa", 0),
    MVI(0xc0002dfb, "TODO_c000_2dfb", 0),
    MVI(0xc0002dfc, "TODO_c000_2dfc", 0),
    MVI(0xc0002dfd, "TODO_c000_2dfd", 0),
    MVI(0xc0002dfe, "TODO_c000_2dfe", 0),
    MVI(0xc0002dff, "TODO_c000_2dff", 0),
    MVI(0xc0002e00, "TODO_c000_2e00", 0),
    MVI(0xc0002e01, "TODO_c000_2e01", 0),
    MVI(0xc0002e02, "TODO_c000_2e02", 0),
    MVI(0xc0002e03, "TODO_c000_2e03", 0),
    MVI(0xc0002e04, "TODO_c000_2e04", 0),
    MVI(0xc0002e05, "TODO_c000_2e05", 0),
    MVI(0xc0002e06, "TODO_c000_2e06", 0),
    MVI(0xc0002e07, "TODO_c000_2e07", 0),
    MVI(0xc0002e08, "TODO_c000_2e08", 0),
    MVI(0xc0002e09, "TODO_c000_2e09", 0),
    MVI(0xc0002e0a, "TODO_c000_2e0a", 0),
    MVI(0xc0002e0b, "TODO_c000_2e0b", 0),
    MVI(0xc0002e0c, "TODO_c000_2e0c", 0),
    MVI(0xc0002e0d, "TODO_c000_2e0d", 0),
    MVI(0xc0002e0e, "TODO_c000_2e0e", 0),
    MVI(0xc0002e0f, "TODO_c000_2e0f", 0),
    MVI(0xc0002e10, "TODO_c000_2e10", 0),
    MVI(0xc0002e11, "TODO_c000_2e11", 0),
    MVI(0xc0002e12, "TODO_c000_2e12", 0),
    MVI(0xc0002e13, "TODO_c000_2e13", 0),
    MVI(0xc0002e14, "TODO_c000_2e14", 0),
    MVI(0xc0002e15, "TODO_c000_2e15", 0),
    MVI(0xc0002e16, "TODO_c000_2e16", 0),
    MVI(0xc0002e17, "TODO_c000_2e17", 0),
    MVI(0xc0002e18, "TODO_c000_2e18", 0),
    MVI(0xc0002e19, "TODO_c000_2e19", 0),
    MVI(0xc0002e1a, "TODO_c000_2e1a", 0),
    MVI(0xc0002e1b, "TODO_c000_2e1b", 0),
    MVI(0xc0002e1c, "TODO_c000_2e1c", 0),
    MVI(0xc0002e1d, "TODO_c000_2e1d", 0),
    MVI(0xc0002e1e, "TODO_c000_2e1e", 0),
    MVI(0xc0002e1f, "TODO_c000_2e1f", 0),
    MVI(0xc0002e20, "TODO_c000_2e20", 0),
    MVI(0xc0002e21, "TODO_c000_2e21", 0),
    MVI(0xc0002e22, "TODO_c000_2e22", 0),
    MVI(0xc0002e23, "TODO_c000_2e23", 0),
    MVI(0xc0002e24, "TODO_c000_2e24", 0),
    MVI(0xc0002e25, "TODO_c000_2e25", 0),
    MVI(0xc0002e26, "TODO_c000_2e26", 0),
    MVI(0xc0002e27, "TODO_c000_2e27", 0),
    MVI(0xc0002e28, "TODO_c000_2e28", 0),
    MVI(0xc0002e29, "TODO_c000_2e29", 0),
    MVI(0xc0002e2a, "TODO_c000_2e2a", 0),
    MVI(0xc0002e2b, "TODO_c000_2e2b", 0),
    MVI(0xc0002e2c, "TODO_c000_2e2c", 0),
    MVI(0xc0002e2d, "TODO_c000_2e2d", 0),
    MVI(0xc0002e2e, "TODO_c000_2e2e", 0),
    MVI(0xc0002e2f, "TODO_c000_2e2f", 0),
    MVI(0xc0002e30, "TODO_c000_2e30", 0),
    MVI(0xc0002e31, "TODO_c000_2e31", 0),
    MVI(0xc0002e32, "TODO_c000_2e32", 0),
    MVI(0xc0002e33, "TODO_c000_2e33", 0),
    MVI(0xc0002e34, "TODO_c000_2e34", 0),
    MVI(0xc0002e35, "TODO_c000_2e35", 0),
    MVI(0xc0002e36, "TODO_c000_2e36", 0),
    MVI(0xc0002e37, "TODO_c000_2e37", 0),
    MVI(0xc0002e38, "TODO_c000_2e38", 0),
    MVI(0xc0002e39, "TODO_c000_2e39", 0),
    MVI(0xc0002e3a, "TODO_c000_2e3a", 0),
    MVI(0xc0002e3b, "TODO_c000_2e3b", 0),
    MVI(0xc0002e3c, "TODO_c000_2e3c", 0),
    MVI(0xc0002e3d, "TODO_c000_2e3d", 0),
    MVI(0xc0002e3e, "TODO_c000_2e3e", 0),
    MVI(0xc0002e3f, "TODO_c000_2e3f", 0),
    MVI(0xc0002e40, "TODO_c000_2e40", 0),
    MVI(0xc0002e41, "TODO_c000_2e41", 0),
    MVI(0xc0002e42, "TODO_c000_2e42", 0),
    MVI(0xc0002e43, "TODO_c000_2e43", 0),
    MVI(0xc0002e44, "TODO_c000_2e44", 0),
    MVI(0xc0002e45, "TODO_c000_2e45", 0),
    MVI(0xc0002e46, "TODO_c000_2e46", 0),
    MVI(0xc0002e47, "TODO_c000_2e47", 0),
    MVI(0xc0002e48, "TODO_c000_2e48", 0),
    MVI(0xc0002e49, "TODO_c000_2e49", 0),
    MVI(0xc0002e4a, "TODO_c000_2e4a", 0),
    MVI(0xc0002e4b, "TODO_c000_2e4b", 0),
    MVI(0xc0002e4c, "TODO_c000_2e4c", 0),
    MVI(0xc0002e4d, "TODO_c000_2e4d", 0),
    MVI(0xc0002e4e, "TODO_c000_2e4e", 0),
    MVI(0xc0002e4f, "TODO_c000_2e4f", 0),
    MVI(0xc0002e50, "TODO_c000_2e50", 0),
    MVI(0xc0002e51, "TODO_c000_2e51", 0),
    MVI(0xc0002e52, "TODO_c000_2e52", 0),
    MVI(0xc0002e53, "TODO_c000_2e53", 0),
    MVI(0xc0002e54, "TODO_c000_2e54", 0),
    MVI(0xc0002e55, "TODO_c000_2e55", 0),
    MVI(0xc0002e56, "TODO_c000_2e56", 0),
    MVI(0xc0002e57, "TODO_c000_2e57", 0),
    MVI(0xc0002e58, "TODO_c000_2e58", 0),
    MVI(0xc0002e59, "TODO_c000_2e59", 0),
    MVI(0xc0002e5a, "TODO_c000_2e5a", 0),
    MVI(0xc0002e5b, "TODO_c000_2e5b", 0),
    MVI(0xc0002e5c, "TODO_c000_2e5c", 0),
    MVI(0xc0002e5d, "TODO_c000_2e5d", 0),
    MVI(0xc0002e5e, "TODO_c000_2e5e", 0),
    MVI(0xc0002e5f, "TODO_c000_2e5f", 0),
    MVI(0xc0002e60, "TODO_c000_2e60", 0),
    MVI(0xc0002e61, "TODO_c000_2e61", 0),
    MVI(0xc0002e62, "TODO_c000_2e62", 0),
    MVI(0xc0002e63, "TODO_c000_2e63", 0),
    MVI(0xc0002e64, "TODO_c000_2e64", 0),
    MVI(0xc0002e65, "TODO_c000_2e65", 0),
    MVI(0xc0002e66, "TODO_c000_2e66", 0),
    MVI(0xc0002e67, "TODO_c000_2e67", 0),
    MVI(0xc0002e68, "TODO_c000_2e68", 0),
    MVI(0xc0002e69, "TODO_c000_2e69", 0),
    MVI(0xc0002e6a, "TODO_c000_2e6a", 0),
    MVI(0xc0002e6b, "TODO_c000_2e6b", 0),
    MVI(0xc0002e6c, "TODO_c000_2e6c", 0),
    MVI(0xc0002e6d, "TODO_c000_2e6d", 0),
    MVI(0xc0002e6e, "TODO_c000_2e6e", 0),
    MVI(0xc0002e6f, "TODO_c000_2e6f", 0),
    MVI(0xc0002e70, "TODO_c000_2e70", 0),
    MVI(0xc0002e71, "TODO_c000_2e71", 0),
    MVI(0xc0002e72, "TODO_c000_2e72", 0),
    MVI(0xc0002e73, "TODO_c000_2e73", 0),
    MVI(0xc0002e74, "TODO_c000_2e74", 0),
    MVI(0xc0002e75, "TODO_c000_2e75", 0),
    MVI(0xc0002e76, "TODO_c000_2e76", 0),
    MVI(0xc0002e77, "TODO_c000_2e77", 0),
    MVI(0xc0002e78, "TODO_c000_2e78", 0),
    MVI(0xc0002e79, "TODO_c000_2e79", 0),
    MVI(0xc0002e7a, "TODO_c000_2e7a", 0),
    MVI(0xc0002e7b, "TODO_c000_2e7b", 0),
    MVI(0xc0002e7c, "TODO_c000_2e7c", 0),
    MVI(0xc0002e7d, "TODO_c000_2e7d", 0),
    MVI(0xc0002e7e, "TODO_c000_2e7e", 0),
    MVI(0xc0002e7f, "TODO_c000_2e7f", 0),
    MVI(0xc0002e80, "TODO_c000_2e80", 0),
    MVI(0xc0002e81, "TODO_c000_2e81", 0),
    MVI(0xc0002e82, "TODO_c000_2e82", 0),
    MVI(0xc0002e83, "TODO_c000_2e83", 0),
    MVI(0xc0002e84, "TODO_c000_2e84", 0),
    MVI(0xc0002e85, "TODO_c000_2e85", 0),
    MVI(0xc0002e86, "TODO_c000_2e86", 0),
    MVI(0xc0002e87, "TODO_c000_2e87", 0),
    MVI(0xc0002e88, "TODO_c000_2e88", 0),
    MVI(0xc0002e89, "TODO_c000_2e89", 0),
    MVI(0xc0002e8a, "TODO_c000_2e8a", 0),
    MVI(0xc0002e8b, "TODO_c000_2e8b", 0),
    MVI(0xc0002e8c, "TODO_c000_2e8c", 0),
    MVI(0xc0002e8d, "TODO_c000_2e8d", 0),
    MVI(0xc0002e8e, "TODO_c000_2e8e", 0),
    MVI(0xc0002e8f, "TODO_c000_2e8f", 0),
    MVI(0xc0002e90, "TODO_c000_2e90", 0),
    MVI(0xc0002e91, "TODO_c000_2e91", 0),
    MVI(0xc0002e92, "TODO_c000_2e92", 0),
    MVI(0xc0002e93, "TODO_c000_2e93", 0),
    MVI(0xc0002e94, "TODO_c000_2e94", 0),
    MVI(0xc0002e95, "TODO_c000_2e95", 0),
    MVI(0xc0002e96, "TODO_c000_2e96", 0),
    MVI(0xc0002e97, "TODO_c000_2e97", 0),
    MVI(0xc0002e98, "TODO_c000_2e98", 0),
    MVI(0xc0002e99, "TODO_c000_2e99", 0),
    MVI(0xc0002e9a, "TODO_c000_2e9a", 0),
    MVI(0xc0002e9b, "TODO_c000_2e9b", 0),
    MVI(0xc0002e9c, "TODO_c000_2e9c", 0),
    MVI(0xc0002e9d, "TODO_c000_2e9d", 0),
    MVI(0xc0002e9e, "TODO_c000_2e9e", 0),
    MVI(0xc0002e9f, "TODO_c000_2e9f", 0),
    MVI(0xc0002ea0, "TODO_c000_2ea0", 0),
    MVI(0xc0002ea1, "TODO_c000_2ea1", 0),
    MVI(0xc0002ea2, "TODO_c000_2ea2", 0),
    MVI(0xc0002ea3, "TODO_c000_2ea3", 0),
    MVI(0xc0002ea4, "TODO_c000_2ea4", 0),
    MVI(0xc0002ea5, "TODO_c000_2ea5", 0),
    MVI(0xc0002ea6, "TODO_c000_2ea6", 0),
    MVI(0xc0002ea7, "TODO_c000_2ea7", 0),
    MVI(0xc0002ea8, "TODO_c000_2ea8", 0),
    MVI(0xc0002ea9, "TODO_c000_2ea9", 0),
    MVI(0xc0002eaa, "TODO_c000_2eaa", 0),
    MVI(0xc0002eab, "TODO_c000_2eab", 0),
    MVI(0xc0002eac, "TODO_c000_2eac", 0),
    MVI(0xc0002ead, "TODO_c000_2ead", 0),
    MVI(0xc0002eae, "TODO_c000_2eae", 0),
    MVI(0xc0002eaf, "TODO_c000_2eaf", 0),
    MVI(0xc0002eb0, "TODO_c000_2eb0", 0),
    MVI(0xc0002eb1, "TODO_c000_2eb1", 0),
    MVI(0xc0002eb2, "TODO_c000_2eb2", 0),
    MVI(0xc0002eb3, "TODO_c000_2eb3", 0),
    MVI(0xc0002eb4, "TODO_c000_2eb4", 0),
    MVI(0xc0002eb5, "TODO_c000_2eb5", 0),
    MVI(0xc0002eb6, "TODO_c000_2eb6", 0),
    MVI(0xc0002eb7, "TODO_c000_2eb7", 0),
    MVI(0xc0002eb8, "TODO_c000_2eb8", 0),
    MVI(0xc0002eb9, "TODO_c000_2eb9", 0),
    MVI(0xc0002eba, "TODO_c000_2eba", 0),
    MVI(0xc0002ebb, "TODO_c000_2ebb", 0),
    MVI(0xc0002ebc, "TODO_c000_2ebc", 0),
    MVI(0xc0002ebd, "TODO_c000_2ebd", 0),
    MVI(0xc0002ebe, "TODO_c000_2ebe", 0),
    MVI(0xc0002ebf, "TODO_c000_2ebf", 0),
    MVI(0xc0002ec0, "TODO_c000_2ec0", 0),
    MVI(0xc0002ec1, "TODO_c000_2ec1", 0),
    MVI(0xc0002ec2, "TODO_c000_2ec2", 0),
    MVI(0xc0002ec3, "TODO_c000_2ec3", 0),
    MVI(0xc0002ec4, "TODO_c000_2ec4", 0),
    MVI(0xc0002ec5, "TODO_c000_2ec5", 0),
    MVI(0xc0002ec6, "TODO_c000_2ec6", 0),
    MVI(0xc0002ec7, "TODO_c000_2ec7", 0),
    MVI(0xc0002ec8, "TODO_c000_2ec8", 0),
    MVI(0xc0002ec9, "TODO_c000_2ec9", 0),
    MVI(0xc0002eca, "TODO_c000_2eca", 0),
    MVI(0xc0002ecb, "TODO_c000_2ecb", 0),
    MVI(0xc0002ecc, "TODO_c000_2ecc", 0),
    MVI(0xc0002ecd, "TODO_c000_2ecd", 0),
    MVI(0xc0002ece, "TODO_c000_2ece", 0),
    MVI(0xc0002ecf, "TODO_c000_2ecf", 0),
    MVI(0xc0002ed0, "TODO_c000_2ed0", 0),
    MVI(0xc0002ed1, "TODO_c000_2ed1", 0),
    MVI(0xc0002ed2, "TODO_c000_2ed2", 0),
    MVI(0xc0002ed3, "TODO_c000_2ed3", 0),
    MVI(0xc0002ed4, "TODO_c000_2ed4", 0),
    MVI(0xc0002ed5, "TODO_c000_2ed5", 0),
    MVI(0xc0002ed6, "TODO_c000_2ed6", 0),
    MVI(0xc0002ed7, "TODO_c000_2ed7", 0),
    MVI(0xc0002ed8, "TODO_c000_2ed8", 0),
    MVI(0xc0002ed9, "TODO_c000_2ed9", 0),
    MVI(0xc0002eda, "TODO_c000_2eda", 0),
    MVI(0xc0002edb, "TODO_c000_2edb", 0),
    MVI(0xc0002edc, "TODO_c000_2edc", 0),
    MVI(0xc0002edd, "TODO_c000_2edd", 0),
    MVI(0xc0002ede, "TODO_c000_2ede", 0),
    MVI(0xc0002edf, "TODO_c000_2edf", 0),
    MVI(0xc0002ee0, "TODO_c000_2ee0", 0),
    MVI(0xc0002ee1, "TODO_c000_2ee1", 0),
    MVI(0xc0002ee2, "TODO_c000_2ee2", 0),
    MVI(0xc0002ee3, "TODO_c000_2ee3", 0),
    MVI(0xc0002ee4, "TODO_c000_2ee4", 0),
    MVI(0xc0002ee5, "TODO_c000_2ee5", 0),
    MVI(0xc0002ee6, "TODO_c000_2ee6", 0),
    MVI(0xc0002ee7, "TODO_c000_2ee7", 0),
    MVI(0xc0002ee8, "TODO_c000_2ee8", 0),
    MVI(0xc0002ee9, "TODO_c000_2ee9", 0),
    MVI(0xc0002eea, "TODO_c000_2eea", 0),
    MVI(0xc0002eeb, "TODO_c000_2eeb", 0),
    MVI(0xc0002eec, "TODO_c000_2eec", 0),
    MVI(0xc0002eed, "TODO_c000_2eed", 0),
    MVI(0xc0002eee, "TODO_c000_2eee", 0),
    MVI(0xc0002eef, "TODO_c000_2eef", 0),
    MVI(0xc0002ef0, "TODO_c000_2ef0", 0),
    MVI(0xc0002ef1, "TODO_c000_2ef1", 0),
    MVI(0xc0002ef2, "TODO_c000_2ef2", 0),
    MVI(0xc0002ef3, "TODO_c000_2ef3", 0),
    MVI(0xc0002ef4, "TODO_c000_2ef4", 0),
    MVI(0xc0002ef5, "TODO_c000_2ef5", 0),
    MVI(0xc0002ef6, "TODO_c000_2ef6", 0),
    MVI(0xc0002ef7, "TODO_c000_2ef7", 0),
    MVI(0xc0002ef8, "TODO_c000_2ef8", 0),
    MVI(0xc0002ef9, "TODO_c000_2ef9", 0),
    MVI(0xc0002efa, "TODO_c000_2efa", 0),
    MVI(0xc0002efb, "TODO_c000_2efb", 0),
    MVI(0xc0002efc, "TODO_c000_2efc", 0),
    MVI(0xc0002efd, "TODO_c000_2efd", 0),
    MVI(0xc0002efe, "TODO_c000_2efe", 0),
    MVI(0xc0002eff, "TODO_c000_2eff", 0),
    MVI(0xc0002f00, "TODO_c000_2f00", 0),
    MVI(0xc0002f01, "TODO_c000_2f01", 0),
    MVI(0xc0002f02, "TODO_c000_2f02", 0),
    MVI(0xc0002f03, "TODO_c000_2f03", 0),
    MVI(0xc0002f04, "TODO_c000_2f04", 0),
    MVI(0xc0002f05, "TODO_c000_2f05", 0),
    MVI(0xc0002f06, "TODO_c000_2f06", 0),
    MVI(0xc0002f07, "TODO_c000_2f07", 0),
    MVI(0xc0002f08, "TODO_c000_2f08", 0),
    MVI(0xc0002f09, "TODO_c000_2f09", 0),
    MVI(0xc0002f0a, "TODO_c000_2f0a", 0),
    MVI(0xc0002f0b, "TODO_c000_2f0b", 0),
    MVI(0xc0002f0c, "TODO_c000_2f0c", 0),
    MVI(0xc0002f0d, "TODO_c000_2f0d", 0),
    MVI(0xc0002f0e, "TODO_c000_2f0e", 0),
    MVI(0xc0002f0f, "TODO_c000_2f0f", 0),
    MVI(0xc0002f10, "TODO_c000_2f10", 0),
    MVI(0xc0002f11, "TODO_c000_2f11", 0),
    MVI(0xc0002f12, "TODO_c000_2f12", 0),
    MVI(0xc0002f13, "TODO_c000_2f13", 0),
    MVI(0xc0002f14, "TODO_c000_2f14", 0),
    MVI(0xc0002f15, "TODO_c000_2f15", 0),
    MVI(0xc0002f16, "TODO_c000_2f16", 0),
    MVI(0xc0002f17, "TODO_c000_2f17", 0),
    MVI(0xc0002f18, "TODO_c000_2f18", 0),
    MVI(0xc0002f19, "TODO_c000_2f19", 0),
    MVI(0xc0002f1a, "TODO_c000_2f1a", 0),
    MVI(0xc0002f1b, "TODO_c000_2f1b", 0),
    MVI(0xc0002f1c, "TODO_c000_2f1c", 0),
    MVI(0xc0002f1d, "TODO_c000_2f1d", 0),
    MVI(0xc0002f1e, "TODO_c000_2f1e", 0),
    MVI(0xc0002f1f, "TODO_c000_2f1f", 0),
    MVI(0xc0002f20, "TODO_c000_2f20", 0),
    MVI(0xc0002f21, "TODO_c000_2f21", 0),
    MVI(0xc0002f22, "TODO_c000_2f22", 0),
    MVI(0xc0002f23, "TODO_c000_2f23", 0),
    MVI(0xc0002f24, "TODO_c000_2f24", 0),
    MVI(0xc0002f25, "TODO_c000_2f25", 0),
    MVI(0xc0002f26, "TODO_c000_2f26", 0),
    MVI(0xc0002f27, "TODO_c000_2f27", 0),
    MVI(0xc0002f28, "TODO_c000_2f28", 0),
    MVI(0xc0002f29, "TODO_c000_2f29", 0),
    MVI(0xc0002f2a, "TODO_c000_2f2a", 0),
    MVI(0xc0002f2b, "TODO_c000_2f2b", 0),
    MVI(0xc0002f2c, "TODO_c000_2f2c", 0),
    MVI(0xc0002f2d, "TODO_c000_2f2d", 0),
    MVI(0xc0002f2e, "TODO_c000_2f2e", 0),
    MVI(0xc0002f2f, "TODO_c000_2f2f", 0),
    MVI(0xc0002f30, "TODO_c000_2f30", 0),
    MVI(0xc0002f31, "TODO_c000_2f31", 0),
    MVI(0xc0002f32, "TODO_c000_2f32", 0),
    MVI(0xc0002f33, "TODO_c000_2f33", 0),
    MVI(0xc0002f34, "TODO_c000_2f34", 0),
    MVI(0xc0002f35, "TODO_c000_2f35", 0),
    MVI(0xc0002f36, "TODO_c000_2f36", 0),
    MVI(0xc0002f37, "TODO_c000_2f37", 0),
    MVI(0xc0002f38, "TODO_c000_2f38", 0),
    MVI(0xc0002f39, "TODO_c000_2f39", 0),
    MVI(0xc0002f3a, "TODO_c000_2f3a", 0),
    MVI(0xc0002f3b, "TODO_c000_2f3b", 0),
    MVI(0xc0002f3c, "TODO_c000_2f3c", 0),
    MVI(0xc0002f3d, "TODO_c000_2f3d", 0),
    MVI(0xc0002f3e, "TODO_c000_2f3e", 0),
    MVI(0xc0002f3f, "TODO_c000_2f3f", 0),
    MVI(0xc0002f40, "TODO_c000_2f40", 0),
    MVI(0xc0002f41, "TODO_c000_2f41", 0),
    MVI(0xc0002f42, "TODO_c000_2f42", 0),
    MVI(0xc0002f43, "TODO_c000_2f43", 0),
    MVI(0xc0002f44, "TODO_c000_2f44", 0),
    MVI(0xc0002f45, "TODO_c000_2f45", 0),
    MVI(0xc0002f46, "TODO_c000_2f46", 0),
    MVI(0xc0002f47, "TODO_c000_2f47", 0),
    MVI(0xc0002f48, "TODO_c000_2f48", 0),
    MVI(0xc0002f49, "TODO_c000_2f49", 0),
    MVI(0xc0002f4a, "TODO_c000_2f4a", 0),
    MVI(0xc0002f4b, "TODO_c000_2f4b", 0),
    MVI(0xc0002f4c, "TODO_c000_2f4c", 0),
    MVI(0xc0002f4d, "TODO_c000_2f4d", 0),
    MVI(0xc0002f4e, "TODO_c000_2f4e", 0),
    MVI(0xc0002f4f, "TODO_c000_2f4f", 0),
    MVI(0xc0002f50, "TODO_c000_2f50", 0),
    MVI(0xc0002f51, "TODO_c000_2f51", 0),
    MVI(0xc0002f52, "TODO_c000_2f52", 0),
    MVI(0xc0002f53, "TODO_c000_2f53", 0),
    MVI(0xc0002f54, "TODO_c000_2f54", 0),
    MVI(0xc0002f55, "TODO_c000_2f55", 0),
    MVI(0xc0002f56, "TODO_c000_2f56", 0),
    MVI(0xc0002f57, "TODO_c000_2f57", 0),
    MVI(0xc0002f58, "TODO_c000_2f58", 0),
    MVI(0xc0002f59, "TODO_c000_2f59", 0),
    MVI(0xc0002f5a, "TODO_c000_2f5a", 0),
    MVI(0xc0002f5b, "TODO_c000_2f5b", 0),
    MVI(0xc0002f5c, "TODO_c000_2f5c", 0),
    MVI(0xc0002f5d, "TODO_c000_2f5d", 0),
    MVI(0xc0002f5e, "TODO_c000_2f5e", 0),
    MVI(0xc0002f5f, "TODO_c000_2f5f", 0),
    MVI(0xc0002f60, "TODO_c000_2f60", 0),
    MVI(0xc0002f61, "TODO_c000_2f61", 0),
    MVI(0xc0002f62, "TODO_c000_2f62", 0),
    MVI(0xc0002f63, "TODO_c000_2f63", 0),
    MVI(0xc0002f64, "TODO_c000_2f64", 0),
    MVI(0xc0002f65, "TODO_c000_2f65", 0),
    MVI(0xc0002f66, "TODO_c000_2f66", 0),
    MVI(0xc0002f67, "TODO_c000_2f67", 0),
    MVI(0xc0002f68, "TODO_c000_2f68", 0),
    MVI(0xc0002f69, "TODO_c000_2f69", 0),
    MVI(0xc0002f6a, "TODO_c000_2f6a", 0),
    MVI(0xc0002f6b, "TODO_c000_2f6b", 0),
    MVI(0xc0002f6c, "TODO_c000_2f6c", 0),
    MVI(0xc0002f6d, "TODO_c000_2f6d", 0),
    MVI(0xc0002f6e, "TODO_c000_2f6e", 0),
    MVI(0xc0002f6f, "TODO_c000_2f6f", 0),
    MVI(0xc0002f70, "TODO_c000_2f70", 0),
    MVI(0xc0002f71, "TODO_c000_2f71", 0),
    MVI(0xc0002f72, "TODO_c000_2f72", 0),
    MVI(0xc0002f73, "TODO_c000_2f73", 0),
    MVI(0xc0002f74, "TODO_c000_2f74", 0),
    MVI(0xc0002f75, "TODO_c000_2f75", 0),
    MVI(0xc0002f76, "TODO_c000_2f76", 0),
    MVI(0xc0002f77, "TODO_c000_2f77", 0),
    MVI(0xc0002f78, "TODO_c000_2f78", 0),
    MVI(0xc0002f79, "TODO_c000_2f79", 0),
    MVI(0xc0002f7a, "TODO_c000_2f7a", 0),
    MVI(0xc0002f7b, "TODO_c000_2f7b", 0),
    MVI(0xc0002f7c, "TODO_c000_2f7c", 0),
    MVI(0xc0002f7d, "TODO_c000_2f7d", 0),
    MVI(0xc0002f7e, "TODO_c000_2f7e", 0),
    MVI(0xc0002f7f, "TODO_c000_2f7f", 0),
    MVI(0xc0002f80, "TODO_c000_2f80", 0),
    MVI(0xc0002f81, "TODO_c000_2f81", 0),
    MVI(0xc0002f82, "TODO_c000_2f82", 0),
    MVI(0xc0002f83, "TODO_c000_2f83", 0),
    MVI(0xc0002f84, "TODO_c000_2f84", 0),
    MVI(0xc0002f85, "TODO_c000_2f85", 0),
    MVI(0xc0002f86, "TODO_c000_2f86", 0),
    MVI(0xc0002f87, "TODO_c000_2f87", 0),
    MVI(0xc0002f88, "TODO_c000_2f88", 0),
    MVI(0xc0002f89, "TODO_c000_2f89", 0),
    MVI(0xc0002f8a, "TODO_c000_2f8a", 0),
    MVI(0xc0002f8b, "TODO_c000_2f8b", 0),
    MVI(0xc0002f8c, "TODO_c000_2f8c", 0),
    MVI(0xc0002f8d, "TODO_c000_2f8d", 0),
    MVI(0xc0002f8e, "TODO_c000_2f8e", 0),
    MVI(0xc0002f8f, "TODO_c000_2f8f", 0),
    MVI(0xc0002f90, "TODO_c000_2f90", 0),
    MVI(0xc0002f91, "TODO_c000_2f91", 0),
    MVI(0xc0002f92, "TODO_c000_2f92", 0),
    MVI(0xc0002f93, "TODO_c000_2f93", 0),
    MVI(0xc0002f94, "TODO_c000_2f94", 0),
    MVI(0xc0002f95, "TODO_c000_2f95", 0),
    MVI(0xc0002f96, "TODO_c000_2f96", 0),
    MVI(0xc0002f97, "TODO_c000_2f97", 0),
    MVI(0xc0002f98, "TODO_c000_2f98", 0),
    MVI(0xc0002f99, "TODO_c000_2f99", 0),
    MVI(0xc0002f9a, "TODO_c000_2f9a", 0),
    MVI(0xc0002f9b, "TODO_c000_2f9b", 0),
    MVI(0xc0002f9c, "TODO_c000_2f9c", 0),
    MVI(0xc0002f9d, "TODO_c000_2f9d", 0),
    MVI(0xc0002f9e, "TODO_c000_2f9e", 0),
    MVI(0xc0002f9f, "TODO_c000_2f9f", 0),
    MVI(0xc0002fa0, "TODO_c000_2fa0", 0),
    MVI(0xc0002fa1, "TODO_c000_2fa1", 0),
    MVI(0xc0002fa2, "TODO_c000_2fa2", 0),
    MVI(0xc0002fa3, "TODO_c000_2fa3", 0),
    MVI(0xc0002fa4, "TODO_c000_2fa4", 0),
    MVI(0xc0002fa5, "TODO_c000_2fa5", 0),
    MVI(0xc0002fa6, "TODO_c000_2fa6", 0),
    MVI(0xc0002fa7, "TODO_c000_2fa7", 0),
    MVI(0xc0002fa8, "TODO_c000_2fa8", 0),
    MVI(0xc0002fa9, "TODO_c000_2fa9", 0),
    MVI(0xc0002faa, "TODO_c000_2faa", 0),
    MVI(0xc0002fab, "TODO_c000_2fab", 0),
    MVI(0xc0002fac, "TODO_c000_2fac", 0),
    MVI(0xc0002fad, "TODO_c000_2fad", 0),
    MVI(0xc0002fae, "TODO_c000_2fae", 0),
    MVI(0xc0002faf, "TODO_c000_2faf", 0),
    MVI(0xc0002fb0, "TODO_c000_2fb0", 0),
    MVI(0xc0002fb1, "TODO_c000_2fb1", 0),
    MVI(0xc0002fb2, "TODO_c000_2fb2", 0),
    MVI(0xc0002fb3, "TODO_c000_2fb3", 0),
    MVI(0xc0002fb4, "TODO_c000_2fb4", 0),
    MVI(0xc0002fb5, "TODO_c000_2fb5", 0),
    MVI(0xc0002fb6, "TODO_c000_2fb6", 0),
    MVI(0xc0002fb7, "TODO_c000_2fb7", 0),
    MVI(0xc0002fb8, "TODO_c000_2fb8", 0),
    MVI(0xc0002fb9, "TODO_c000_2fb9", 0),
    MVI(0xc0002fba, "TODO_c000_2fba", 0),
    MVI(0xc0002fbb, "TODO_c000_2fbb", 0),
    MVI(0xc0002fbc, "TODO_c000_2fbc", 0),
    MVI(0xc0002fbd, "TODO_c000_2fbd", 0),
    MVI(0xc0002fbe, "TODO_c000_2fbe", 0),
    MVI(0xc0002fbf, "TODO_c000_2fbf", 0),
    MVI(0xc0002fc0, "TODO_c000_2fc0", 0),
    MVI(0xc0002fc1, "TODO_c000_2fc1", 0),
    MVI(0xc0002fc2, "TODO_c000_2fc2", 0),
    MVI(0xc0002fc3, "TODO_c000_2fc3", 0),
    MVI(0xc0002fc4, "TODO_c000_2fc4", 0),
    MVI(0xc0002fc5, "TODO_c000_2fc5", 0),
    MVI(0xc0002fc6, "TODO_c000_2fc6", 0),
    MVI(0xc0002fc7, "TODO_c000_2fc7", 0),
    MVI(0xc0002fc8, "TODO_c000_2fc8", 0),
    MVI(0xc0002fc9, "TODO_c000_2fc9", 0),
    MVI(0xc0002fca, "TODO_c000_2fca", 0),
    MVI(0xc0002fcb, "TODO_c000_2fcb", 0),
    MVI(0xc0002fcc, "TODO_c000_2fcc", 0),
    MVI(0xc0002fcd, "TODO_c000_2fcd", 0),
    MVI(0xc0002fce, "TODO_c000_2fce", 0),
    MVI(0xc0002fcf, "TODO_c000_2fcf", 0),
    MVI(0xc0002fd0, "TODO_c000_2fd0", 0),
    MVI(0xc0002fd1, "TODO_c000_2fd1", 0),
    MVI(0xc0002fd2, "TODO_c000_2fd2", 0),
    MVI(0xc0002fd3, "TODO_c000_2fd3", 0),
    MVI(0xc0002fd4, "TODO_c000_2fd4", 0),
    MVI(0xc0002fd5, "TODO_c000_2fd5", 0),
    MVI(0xc0002fd6, "TODO_c000_2fd6", 0),
    MVI(0xc0002fd7, "TODO_c000_2fd7", 0),
    MVI(0xc0002fd8, "TODO_c000_2fd8", 0),
    MVI(0xc0002fd9, "TODO_c000_2fd9", 0),
    MVI(0xc0002fda, "TODO_c000_2fda", 0),
    MVI(0xc0002fdb, "TODO_c000_2fdb", 0),
    MVI(0xc0002fdc, "TODO_c000_2fdc", 0),
    MVI(0xc0002fdd, "TODO_c000_2fdd", 0),
    MVI(0xc0002fde, "TODO_c000_2fde", 0),
    MVI(0xc0002fdf, "TODO_c000_2fdf", 0),
    MVI(0xc0002fe0, "TODO_c000_2fe0", 0),
    MVI(0xc0002fe1, "TODO_c000_2fe1", 0),
    MVI(0xc0002fe2, "TODO_c000_2fe2", 0),
    MVI(0xc0002fe3, "TODO_c000_2fe3", 0),
    MVI(0xc0002fe4, "TODO_c000_2fe4", 0),
    MVI(0xc0002fe5, "TODO_c000_2fe5", 0),
    MVI(0xc0002fe6, "TODO_c000_2fe6", 0),
    MVI(0xc0002fe7, "TODO_c000_2fe7", 0),
    MVI(0xc0002fe8, "TODO_c000_2fe8", 0),
    MVI(0xc0002fe9, "TODO_c000_2fe9", 0),
    MVI(0xc0002fea, "TODO_c000_2fea", 0),
    MVI(0xc0002feb, "TODO_c000_2feb", 0),
    MVI(0xc0002fec, "TODO_c000_2fec", 0),
    MVI(0xc0002fed, "TODO_c000_2fed", 0),
    MVI(0xc0002fee, "TODO_c000_2fee", 0),
    MVI(0xc0002fef, "TODO_c000_2fef", 0),
    MVI(0xc0002ff0, "TODO_c000_2ff0", 0),
    MVI(0xc0002ff1, "TODO_c000_2ff1", 0),
    MVI(0xc0002ff2, "TODO_c000_2ff2", 0),
    MVI(0xc0002ff3, "TODO_c000_2ff3", 0),
    MVI(0xc0002ff4, "TODO_c000_2ff4", 0),
    MVI(0xc0002ff5, "TODO_c000_2ff5", 0),
    MVI(0xc0002ff6, "TODO_c000_2ff6", 0),
    MVI(0xc0002ff7, "TODO_c000_2ff7", 0),
    MVI(0xc0002ff8, "TODO_c000_2ff8", 0),
    MVI(0xc0002ff9, "TODO_c000_2ff9", 0),
    MVI(0xc0002ffa, "TODO_c000_2ffa", 0),
    MVI(0xc0002ffb, "TODO_c000_2ffb", 0),
    MVI(0xc0002ffc, "TODO_c000_2ffc", 0),
    MVI(0xc0002ffd, "TODO_c000_2ffd", 0),
    MVI(0xc0002ffe, "TODO_c000_2ffe", 0),
    MVI(0xc0002fff, "TODO_c000_2fff", 0),
    RSN(0xc0010000, 0xc0010003, "AMD_K8_PERF_CTL_n", AmdK8PerfCtlN, AmdK8PerfCtlN, 0x0, UINT64_C(0xfffffcf000200000), 0),
    MFX(0xc0010004, "AMD_K8_PERF_CTR_0", AmdK8PerfCtrN, AmdK8PerfCtrN, 0x0, UINT64_C(0xffff0000000022a0), 0), /* XXX: The range ended earlier than expected! */
    MFX(0xc0010005, "AMD_K8_PERF_CTR_1", AmdK8PerfCtrN, AmdK8PerfCtrN, 0, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFX(0xc0010006, "AMD_K8_PERF_CTR_2", AmdK8PerfCtrN, AmdK8PerfCtrN, 0, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFX(0xc0010007, "AMD_K8_PERF_CTR_3", AmdK8PerfCtrN, AmdK8PerfCtrN, 0, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFX(0xc0010010, "AMD_K8_SYS_CFG", AmdK8SysCfg, AmdK8SysCfg, 0x740000, UINT64_C(0xffffffffff00ffff), 0), /* value=0x740000 */
    MFX(0xc0010015, "AMD_K8_HW_CFG", AmdK8HwCr, AmdK8HwCr, 0x9000011, UINT64_C(0xffffffff89006000), 0), /* value=0x9000011 */
    MFW(0xc0010016, "AMD_K8_IORR_BASE_0", AmdK8IorrBaseN, AmdK8IorrBaseN, UINT64_C(0xffff000000000fe7)), /* value=0x0 */
    MFW(0xc0010017, "AMD_K8_IORR_MASK_0", AmdK8IorrMaskN, AmdK8IorrMaskN, UINT64_C(0xffff0000000007ff)), /* value=0x0 */
    MFX(0xc0010018, "AMD_K8_IORR_BASE_1", AmdK8IorrBaseN, AmdK8IorrBaseN, 0x1, UINT64_C(0xffff000000000fe7), 0), /* value=0x0 */
    MFX(0xc0010019, "AMD_K8_IORR_MASK_1", AmdK8IorrMaskN, AmdK8IorrMaskN, 0x1, UINT64_C(0xffff0000000007ff), 0), /* value=0x0 */
    MFW(0xc001001a, "AMD_K8_TOP_MEM", AmdK8TopOfMemN, AmdK8TopOfMemN, UINT64_C(0xffff0000007fffff)), /* value=0x80000000 */
    MFX(0xc001001d, "AMD_K8_TOP_MEM2", AmdK8TopOfMemN, AmdK8TopOfMemN, 0x1, UINT64_C(0xffff0000007fffff), 0), /* value=0x8`80000000 */
    MFI(0xc001001f, "AMD_K8_NB_CFG1", AmdK8NbCfg1), /* value=0x0 */
    MFN(0xc0010021, "AMD_K8_UNK_c001_0021", WriteOnly, IgnoreWrite),
    MFX(0xc0010022, "AMD_K8_MC_XCPT_REDIR", AmdK8McXcptRedir, AmdK8McXcptRedir, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x0 */
    RFN(0xc0010030, 0xc0010035, "AMD_K8_CPU_NAME_n", AmdK8CpuNameN, AmdK8CpuNameN),
    MFX(0xc001003e, "AMD_K8_HTC", AmdK8HwThermalCtrl, AmdK8HwThermalCtrl, 0, UINT64_MAX, 0), /* value=0x0 */
    RFN(0xc0010050, 0xc0010053, "AMD_K8_SMI_ON_IO_TRAP_n", AmdK8SmiOnIoTrapN, AmdK8SmiOnIoTrapN),
    MFX(0xc0010054, "AMD_K8_SMI_ON_IO_TRAP_CTL_STS", AmdK8SmiOnIoTrapCtlSts, AmdK8SmiOnIoTrapCtlSts, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x0 */
    MFI(0xc0010055, "AMD_K8_INT_PENDING_MSG", AmdK8IntPendingMessage), /* value=0x0 */
    MFX(0xc0010056, "AMD_K8_SMI_TRIGGER_IO_CYCLE", AmdK8SmiTriggerIoCycle, AmdK8SmiTriggerIoCycle, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x0 */
    MFX(0xc0010058, "AMD_10H_MMIO_CFG_BASE_ADDR", AmdFam10hMmioCfgBaseAddr, AmdFam10hMmioCfgBaseAddr, 0, UINT64_C(0xffff0000000fffc0), 0), /* value=0xe0000021 */
    MVO(0xc0010060, "AMD_K8_BIST_RESULT", 0),
    MFX(0xc0010061, "AMD_10H_P_ST_CUR_LIM", AmdFam10hPStateCurLimit, ReadOnly, 0x20, 0, 0), /* value=0x20 */
    MFX(0xc0010062, "AMD_10H_P_ST_CTL", AmdFam10hPStateControl, AmdFam10hPStateControl, 0x2, 0, UINT64_C(0xfffffffffffffff8)), /* value=0x2 */
    MFX(0xc0010063, "AMD_10H_P_ST_STS", AmdFam10hPStateStatus, ReadOnly, 0x2, 0, 0), /* value=0x2 */
    MFX(0xc0010064, "AMD_10H_P_ST_0", AmdFam10hPStateN, AmdFam10hPStateN, UINT64_C(0x8000000000178a64), 0, 0), /* value=0x80000000`00178a64 */
    MFX(0xc0010065, "AMD_10H_P_ST_1", AmdFam10hPStateN, AmdFam10hPStateN, UINT64_C(0x800000000018cc60), 0, 0), /* value=0x80000000`0018cc60 */
    MFX(0xc0010066, "AMD_10H_P_ST_2", AmdFam10hPStateN, AmdFam10hPStateN, UINT64_C(0x80000000001a5060), 0, 0), /* value=0x80000000`001a5060 */
    MFX(0xc0010067, "AMD_10H_P_ST_3", AmdFam10hPStateN, AmdFam10hPStateN, 0, 0, 0), /* value=0x0 */
    MFX(0xc0010068, "AMD_10H_P_ST_4", AmdFam10hPStateN, AmdFam10hPStateN, 0, 0, 0), /* value=0x0 */
    MFX(0xc0010069, "AMD_10H_P_ST_5", AmdFam10hPStateN, AmdFam10hPStateN, 0, 0, 0), /* value=0x0 */
    MFX(0xc001006a, "AMD_10H_P_ST_6", AmdFam10hPStateN, AmdFam10hPStateN, 0, 0, 0), /* value=0x0 */
    MFX(0xc001006b, "AMD_10H_P_ST_7", AmdFam10hPStateN, AmdFam10hPStateN, 0, 0, 0), /* value=0x0 */
    MFX(0xc0010073, "AMD_10H_C_ST_IO_BASE_ADDR", AmdFam10hCStateIoBaseAddr, AmdFam10hCStateIoBaseAddr, 0, UINT64_C(0xffffffffffff0000), 0), /* value=0x813 */
    MFX(0xc0010074, "AMD_10H_CPU_WD_TMR_CFG", AmdFam10hCpuWatchdogTimer, AmdFam10hCpuWatchdogTimer, 0, UINT64_C(0xffffffffffffff80), 0), /* value=0x1 */
    MFX(0xc0010111, "AMD_K8_SMM_BASE", AmdK8SmmBase, AmdK8SmmBase, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x7fbcd000 */
    MFX(0xc0010112, "AMD_K8_SMM_ADDR", AmdK8SmmAddr, AmdK8SmmAddr, 0, UINT64_C(0xffff00000001ffff), 0), /* value=0x7c000000 */
    MFX(0xc0010113, "AMD_K8_SMM_MASK", AmdK8SmmMask, AmdK8SmmMask, 0, UINT64_C(0xffff0000000188c0), 0), /* value=0xffff`fc006003 */
    MFX(0xc0010114, "AMD_K8_VM_CR", AmdK8VmCr, AmdK8VmCr, 0, UINT64_C(0xffffffff00000005), UINT32_C(0xffffffe0)), /* value=0x0 */
    MFX(0xc0010115, "AMD_K8_IGNNE", AmdK8IgnNe, AmdK8IgnNe, 0, ~(uint64_t)UINT32_MAX, UINT32_C(0xfffffffe)), /* value=0x0 */
    MFX(0xc0010117, "AMD_K8_VM_HSAVE_PA", AmdK8VmHSavePa, AmdK8VmHSavePa, 0, 0, UINT64_C(0xffff000000000fff)), /* value=0x0 */
    MFN(0xc0010118, "AMD_10H_VM_LOCK_KEY", AmdFam10hVmLockKey, AmdFam10hVmLockKey), /* value=0x0 */
    MFN(0xc0010119, "AMD_10H_SSM_LOCK_KEY", AmdFam10hSmmLockKey, AmdFam10hSmmLockKey), /* value=0x0 */
    MFX(0xc001011a, "AMD_10H_LOCAL_SMI_STS", AmdFam10hLocalSmiStatus, AmdFam10hLocalSmiStatus, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x0 */
    MFN(0xc001011b, "AMD_K8_UNK_c001_011b", WriteOnly, IgnoreWrite),
    MVI(0xc0010120, "TODO_c001_0120", 0),
    MVI(0xc0010121, "TODO_c001_0121", 0),
    MVI(0xc0010122, "TODO_c001_0122", 0),
    MFN(0xc0010140, "AMD_10H_OSVW_ID_LEN", AmdFam10hOsVisWrkIdLength, AmdFam10hOsVisWrkIdLength), /* value=0x0 */
    MFN(0xc0010141, "AMD_10H_OSVW_STS", AmdFam10hOsVisWrkStatus, AmdFam10hOsVisWrkStatus), /* value=0x0 */
    MVX(0xc0010188, "TODO_c001_0188", 0, UINT64_C(0xfffffcf000200000), 0),
    MVX(0xc0010189, "TODO_c001_0189", 0, UINT64_C(0xffff000000000000), 0),
    MVX(0xc001018a, "TODO_c001_018a", 0, UINT64_C(0xfffffcf000200000), 0),
    MVX(0xc001018b, "TODO_c001_018b", 0, UINT64_C(0xffff000000000000), 0),
    MFX(0xc0010200, "AMD_K8_PERF_CTL_0", AmdK8PerfCtlN, AmdK8PerfCtlN, 0x0, UINT64_C(0xfffffcf000200000), 0), /* value=0x530076 */
    MFX(0xc0010201, "AMD_K8_PERF_CTR_0", AmdK8PerfCtrN, AmdK8PerfCtrN, 0x0, UINT64_C(0xffff000000002191), 0), /* value=0xffff`9124f0a3 */
    MFX(0xc0010202, "AMD_K8_PERF_CTL_1", AmdK8PerfCtlN, AmdK8PerfCtlN, 0x1, UINT64_C(0xfffffcf000200000), 0), /* value=0x0 */
    MFX(0xc0010203, "AMD_K8_PERF_CTR_1", AmdK8PerfCtrN, AmdK8PerfCtrN, 0x1, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFX(0xc0010204, "AMD_K8_PERF_CTL_2", AmdK8PerfCtlN, AmdK8PerfCtlN, 0x2, UINT64_C(0xfffffcf000200000), 0), /* value=0x0 */
    MFX(0xc0010205, "AMD_K8_PERF_CTR_2", AmdK8PerfCtrN, AmdK8PerfCtrN, 0x2, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFX(0xc0010206, "AMD_K8_PERF_CTL_3", AmdK8PerfCtlN, AmdK8PerfCtlN, 0x3, UINT64_C(0xfffffcf000200000), 0), /* value=0x0 */
    MFX(0xc0010207, "AMD_K8_PERF_CTR_3", AmdK8PerfCtrN, AmdK8PerfCtrN, 0x3, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFX(0xc0010208, "AMD_K8_PERF_CTL_4", AmdK8PerfCtlN, AmdK8PerfCtlN, 0x4, UINT64_C(0xfffffcf000200000), 0), /* value=0x0 */
    MFX(0xc0010209, "AMD_K8_PERF_CTR_4", AmdK8PerfCtrN, AmdK8PerfCtrN, 0x4, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFX(0xc001020a, "AMD_K8_PERF_CTL_5", AmdK8PerfCtlN, AmdK8PerfCtlN, 0x5, UINT64_C(0xfffffcf000200000), 0), /* value=0x0 */
    MFX(0xc001020b, "AMD_K8_PERF_CTR_5", AmdK8PerfCtrN, AmdK8PerfCtrN, 0x5, UINT64_C(0xffff000000000000), 0), /* value=0xffff */
    MFX(0xc0010230, "AMD_16H_L2I_PERF_CTL_0", AmdFam16hL2IPerfCtlN, AmdFam16hL2IPerfCtlN, 0x0, UINT64_C(0xf0ffffffbf0000), 0), /* value=0x0 */
    MFX(0xc0010231, "AMD_16H_L2I_PERF_CTR_0", AmdFam16hL2IPerfCtrN, AmdFam16hL2IPerfCtrN, 0x0, UINT64_C(0xfffe000000000000), 0), /* value=0x0 */
    MFX(0xc0010232, "AMD_16H_L2I_PERF_CTL_1", AmdFam16hL2IPerfCtlN, AmdFam16hL2IPerfCtlN, 0x1, UINT64_C(0xf0ffffffbf0000), 0), /* value=0x0 */
    MFX(0xc0010233, "AMD_16H_L2I_PERF_CTR_1", AmdFam16hL2IPerfCtrN, AmdFam16hL2IPerfCtrN, 0x1, UINT64_C(0xfffe000000000000), 0), /* value=0x0 */
    MFX(0xc0010234, "AMD_16H_L2I_PERF_CTL_2", AmdFam16hL2IPerfCtlN, AmdFam16hL2IPerfCtlN, 0x2, UINT64_C(0xf0ffffffbf0000), 0), /* value=0x0 */
    MFX(0xc0010235, "AMD_16H_L2I_PERF_CTR_2", AmdFam16hL2IPerfCtrN, AmdFam16hL2IPerfCtrN, 0x2, UINT64_C(0xfffe000000000000), 0), /* value=0x0 */
    MFX(0xc0010236, "AMD_16H_L2I_PERF_CTL_3", AmdFam16hL2IPerfCtlN, AmdFam16hL2IPerfCtlN, 0x3, UINT64_C(0xf0ffffffbf0000), 0), /* value=0x0 */
    MFX(0xc0010237, "AMD_16H_L2I_PERF_CTR_3", AmdFam16hL2IPerfCtrN, AmdFam16hL2IPerfCtrN, 0x3, UINT64_C(0xfffe000000000000), 0), /* value=0x0 */
    MVX(0xc0010238, "TODO_c001_0238", 0, UINT64_C(0xf0ffffffbf0000), 0),
    MVX(0xc0010239, "TODO_c001_0239", 0, UINT64_C(0xfffe000000000000), 0),
    MVX(0xc001023a, "TODO_c001_023a", 0, UINT64_C(0xf0ffffffbf0000), 0),
    MVX(0xc001023b, "TODO_c001_023b", 0, UINT64_C(0xfffe000000000000), 0),
    MFX(0xc0010240, "AMD_15H_NB_PERF_CTL_0", AmdFam15hNorthbridgePerfCtlN, AmdFam15hNorthbridgePerfCtlN, 0x0, UINT64_C(0x1ffffff0ff970000), 0), /* value=0x0 */
    MFX(0xc0010241, "AMD_15H_NB_PERF_CTR_0", AmdFam15hNorthbridgePerfCtrN, AmdFam15hNorthbridgePerfCtrN, 0x0, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFX(0xc0010242, "AMD_15H_NB_PERF_CTL_1", AmdFam15hNorthbridgePerfCtlN, AmdFam15hNorthbridgePerfCtlN, 0x1, UINT64_C(0x1ffffff0ff970000), 0), /* value=0x0 */
    MFX(0xc0010243, "AMD_15H_NB_PERF_CTR_1", AmdFam15hNorthbridgePerfCtrN, AmdFam15hNorthbridgePerfCtrN, 0x1, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFX(0xc0010244, "AMD_15H_NB_PERF_CTL_2", AmdFam15hNorthbridgePerfCtlN, AmdFam15hNorthbridgePerfCtlN, 0x2, UINT64_C(0x1ffffff0ff970000), 0), /* value=0x0 */
    MFX(0xc0010245, "AMD_15H_NB_PERF_CTR_2", AmdFam15hNorthbridgePerfCtrN, AmdFam15hNorthbridgePerfCtrN, 0x2, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFX(0xc0010246, "AMD_15H_NB_PERF_CTL_3", AmdFam15hNorthbridgePerfCtlN, AmdFam15hNorthbridgePerfCtlN, 0x3, UINT64_C(0x1ffffff0ff970000), 0), /* value=0x0 */
    MFX(0xc0010247, "AMD_15H_NB_PERF_CTR_3", AmdFam15hNorthbridgePerfCtrN, AmdFam15hNorthbridgePerfCtrN, 0x3, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MVX(0xc0010290, "TODO_c001_0290", 0, ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0010292, "TODO_c001_0292", 0xf0052, UINT32_MAX, 0),
    MVI(0xc0010293, "TODO_c001_0293", 0xa01060),
    MVX(0xc0010294, "TODO_c001_0294", UINT64_C(0x1001f47f000f0912), UINT64_C(0xc0000000ffe00000), 0),
    MVX(0xc0010296, "TODO_c001_0296", 0x484848, UINT64_C(0xffffffffff808080), 0),
    MVI(0xc0010297, "TODO_c001_0297", UINT64_C(0x380000fc000)),
    MVI(0xc0010299, "TODO_c001_0299", 0xa1003),
    MVI(0xc001029a, "TODO_c001_029a", 0x5382a5),
    MVI(0xc001029b, "TODO_c001_029b", 0x7a66d6c3),
    MVX(0xc0010400, "TODO_c001_0400", 0x600, UINT64_C(0xffffffffffe00000), 0),
    MVX(0xc0010401, "TODO_c001_0401", 0x2000, UINT64_C(0xffffffffffffc000), 0),
    MVX(0xc0010402, "TODO_c001_0402", 0x8, UINT64_C(0xfffffffffffffff0), 0),
    MVX(0xc0010403, "TODO_c001_0403", 0, UINT64_C(0xfffffffffffffe00), 0),
    MVI(0xc0010404, "TODO_c001_0404", 0),
    MVX(0xc0010405, "TODO_c001_0405", 0, UINT64_C(0xfffffffffffff800), 0),
    MVX(0xc0010406, "TODO_c001_0406", 0x40, UINT64_C(0xffffffffffffff80), 0),
    MVX(0xc0010407, "TODO_c001_0407", 0x80, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc0010408, "TODO_c001_0408", 0x80, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc0010409, "TODO_c001_0409", 0x80, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc001040a, "TODO_c001_040a", 0x80, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc001040b, "TODO_c001_040b", 0x80, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc001040c, "TODO_c001_040c", 0x80, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc001040d, "TODO_c001_040d", 0x80, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc001040e, "TODO_c001_040e", 0x80, UINT64_C(0xffffffffffffff00), 0),
    MVX(0xc001040f, "TODO_c001_040f", 0, UINT64_C(0xffffffffffffffc0), 0),
    MVX(0xc0010410, "TODO_c001_0410", 0, UINT64_C(0xffffffffffffffc0), 0),
    MVX(0xc0010411, "TODO_c001_0411", 0, UINT64_C(0xfffffffffffffffe), 0),
    MVX(0xc0010412, "TODO_c001_0412", 0, UINT64_C(0xfffffffffffffffe), 0),
    MVX(0xc0010413, "TODO_c001_0413", 0, UINT64_C(0xfffffffffffffffe), 0),
    MVX(0xc0010414, "TODO_c001_0414", 0, UINT64_C(0xfffffffffffffe00), 0),
    MVX(0xc0010415, "TODO_c001_0415", 0, UINT64_C(0xfffffffffffffe00), 0),
    MVX(0xc0010416, "TODO_c001_0416", 0, UINT64_C(0xfffffffffffffff0), 0),
    MVI(0xc0010417, "TODO_c001_0417", 0),
    MVI(0xc0010418, "TODO_c001_0418", 0),
    MVI(0xc0010419, "TODO_c001_0419", 0),
    MVI(0xc001041a, "TODO_c001_041a", 0),
    MVI(0xc001041b, "TODO_c001_041b", 0),
    MVI(0xc001041c, "TODO_c001_041c", 0),
    MVI(0xc001041d, "TODO_c001_041d", 0),
    MVI(0xc001041e, "TODO_c001_041e", 0),
    MVI(0xc001041f, "TODO_c001_041f", 0),
    MVI(0xc0010420, "TODO_c001_0420", 0),
    MVI(0xc0010421, "TODO_c001_0421", 0),
    MVI(0xc0010422, "TODO_c001_0422", 0),
    MVI(0xc0010423, "TODO_c001_0423", 0),
    MVI(0xc0010424, "TODO_c001_0424", 0),
    MVI(0xc0010425, "TODO_c001_0425", 0),
    MVI(0xc0010426, "TODO_c001_0426", 0),
    MVI(0xc0010427, "TODO_c001_0427", 0),
    MVI(0xc0010428, "TODO_c001_0428", 0),
    MVI(0xc0010429, "TODO_c001_0429", 0),
    MVI(0xc001042a, "TODO_c001_042a", 0),
    MVI(0xc001042b, "TODO_c001_042b", 0),
    MVI(0xc001042c, "TODO_c001_042c", 0),
    MVI(0xc001042d, "TODO_c001_042d", 0),
    MVI(0xc001042e, "TODO_c001_042e", 0),
    MVI(0xc001042f, "TODO_c001_042f", 0),
    MVI(0xc0010430, "TODO_c001_0430", 0),
    MVI(0xc0010431, "TODO_c001_0431", 0),
    MVI(0xc0010432, "TODO_c001_0432", 0),
    MVI(0xc0010433, "TODO_c001_0433", 0),
    MVI(0xc0010434, "TODO_c001_0434", 0),
    MVI(0xc0010435, "TODO_c001_0435", 0),
    MVI(0xc0010436, "TODO_c001_0436", 0),
    MVI(0xc0010437, "TODO_c001_0437", 0),
    MVI(0xc0010438, "TODO_c001_0438", 0),
    MVI(0xc0010439, "TODO_c001_0439", 0),
    MVI(0xc001043a, "TODO_c001_043a", 0),
    MVI(0xc001043b, "TODO_c001_043b", 0),
    MVI(0xc001043c, "TODO_c001_043c", 0),
    MVI(0xc001043d, "TODO_c001_043d", 0),
    MVI(0xc001043e, "TODO_c001_043e", 0),
    MVI(0xc001043f, "TODO_c001_043f", 0),
    MVI(0xc0010440, "TODO_c001_0440", 0),
    MVI(0xc0010441, "TODO_c001_0441", 0),
    MVI(0xc0010442, "TODO_c001_0442", 0),
    MVI(0xc0010443, "TODO_c001_0443", 0),
    MVI(0xc0010444, "TODO_c001_0444", 0),
    MVI(0xc0010445, "TODO_c001_0445", 0),
    MVI(0xc0010446, "TODO_c001_0446", 0),
    MVI(0xc0010447, "TODO_c001_0447", 0),
    MVI(0xc0010448, "TODO_c001_0448", 0),
    MVI(0xc0010449, "TODO_c001_0449", 0),
    MVI(0xc001044a, "TODO_c001_044a", 0),
    MVI(0xc001044b, "TODO_c001_044b", 0),
    MVI(0xc001044c, "TODO_c001_044c", 0),
    MVI(0xc001044d, "TODO_c001_044d", 0),
    MVI(0xc001044e, "TODO_c001_044e", 0),
    MVI(0xc001044f, "TODO_c001_044f", 0),
    MVI(0xc0010450, "TODO_c001_0450", 0),
    MVI(0xc0010451, "TODO_c001_0451", 0),
    MVI(0xc0010452, "TODO_c001_0452", 0),
    MVI(0xc0010453, "TODO_c001_0453", 0),
    MVI(0xc0010454, "TODO_c001_0454", 0),
    MVI(0xc0010455, "TODO_c001_0455", 0),
    MVI(0xc0010456, "TODO_c001_0456", 0),
    MVI(0xc0010457, "TODO_c001_0457", 0),
    MVI(0xc0010458, "TODO_c001_0458", 0),
    MVI(0xc0010459, "TODO_c001_0459", 0),
    MVI(0xc001045a, "TODO_c001_045a", 0),
    MVI(0xc001045b, "TODO_c001_045b", 0),
    MVI(0xc001045c, "TODO_c001_045c", 0),
    MVI(0xc001045d, "TODO_c001_045d", 0),
    MVI(0xc001045e, "TODO_c001_045e", 0),
    MVI(0xc001045f, "TODO_c001_045f", 0),
    MVI(0xc0010460, "TODO_c001_0460", 0),
    MVI(0xc0010461, "TODO_c001_0461", 0),
    MVI(0xc0010462, "TODO_c001_0462", 0),
    MVI(0xc0010463, "TODO_c001_0463", 0),
    MVI(0xc0010464, "TODO_c001_0464", 0),
    MVI(0xc0010465, "TODO_c001_0465", 0),
    MVI(0xc0010466, "TODO_c001_0466", 0),
    MVI(0xc0010467, "TODO_c001_0467", 0),
    MVI(0xc0010468, "TODO_c001_0468", 0),
    MVI(0xc0010469, "TODO_c001_0469", 0),
    MVI(0xc001046a, "TODO_c001_046a", 0),
    MVI(0xc001046b, "TODO_c001_046b", 0),
    MVI(0xc001046c, "TODO_c001_046c", 0),
    MVI(0xc001046d, "TODO_c001_046d", 0),
    MVI(0xc001046e, "TODO_c001_046e", 0),
    MVI(0xc001046f, "TODO_c001_046f", 0),
    MVI(0xc0010470, "TODO_c001_0470", 0),
    MVI(0xc0010471, "TODO_c001_0471", 0),
    MVI(0xc0010472, "TODO_c001_0472", 0),
    MVI(0xc0010473, "TODO_c001_0473", 0),
    MVI(0xc0010474, "TODO_c001_0474", 0),
    MVI(0xc0010475, "TODO_c001_0475", 0),
    MVI(0xc0010476, "TODO_c001_0476", 0),
    MVI(0xc0010477, "TODO_c001_0477", 0),
    MVI(0xc0010478, "TODO_c001_0478", 0),
    MVI(0xc0010479, "TODO_c001_0479", 0),
    MVI(0xc001047a, "TODO_c001_047a", 0),
    MVI(0xc001047b, "TODO_c001_047b", 0),
    MVI(0xc001047c, "TODO_c001_047c", 0),
    MVI(0xc001047d, "TODO_c001_047d", 0),
    MVI(0xc001047e, "TODO_c001_047e", 0),
    MVI(0xc001047f, "TODO_c001_047f", 0),
    MVI(0xc0010480, "TODO_c001_0480", 0),
    MVI(0xc0010481, "TODO_c001_0481", 0),
    MVI(0xc0010482, "TODO_c001_0482", 0),
    MVI(0xc0010483, "TODO_c001_0483", 0),
    MVI(0xc0010484, "TODO_c001_0484", 0),
    MVI(0xc0010485, "TODO_c001_0485", 0),
    MVI(0xc0010486, "TODO_c001_0486", 0),
    MVI(0xc0010487, "TODO_c001_0487", 0),
    MVI(0xc0010488, "TODO_c001_0488", 0),
    MVI(0xc0010489, "TODO_c001_0489", 0),
    MVI(0xc001048a, "TODO_c001_048a", 0),
    MVI(0xc001048b, "TODO_c001_048b", 0),
    MVI(0xc001048c, "TODO_c001_048c", 0),
    MVI(0xc001048d, "TODO_c001_048d", 0),
    MVI(0xc001048e, "TODO_c001_048e", 0),
    MVI(0xc001048f, "TODO_c001_048f", 0),
    MVI(0xc0010490, "TODO_c001_0490", 0),
    MVI(0xc0010491, "TODO_c001_0491", 0),
    MVI(0xc0010492, "TODO_c001_0492", 0),
    MVI(0xc0010493, "TODO_c001_0493", 0),
    MVI(0xc0010494, "TODO_c001_0494", 0),
    MVI(0xc0010495, "TODO_c001_0495", 0),
    MVI(0xc0010496, "TODO_c001_0496", 0),
    MVI(0xc0010497, "TODO_c001_0497", 0),
    MVI(0xc0010498, "TODO_c001_0498", 0),
    MVI(0xc0010499, "TODO_c001_0499", 0),
    MVI(0xc001049a, "TODO_c001_049a", 0),
    MVI(0xc001049b, "TODO_c001_049b", 0),
    MVI(0xc001049c, "TODO_c001_049c", 0),
    MVI(0xc001049d, "TODO_c001_049d", 0),
    MVI(0xc001049e, "TODO_c001_049e", 0),
    MVI(0xc001049f, "TODO_c001_049f", 0),
    MVI(0xc00104a0, "TODO_c001_04a0", 0),
    MVI(0xc00104a1, "TODO_c001_04a1", 0),
    MVI(0xc00104a2, "TODO_c001_04a2", 0),
    MVI(0xc00104a3, "TODO_c001_04a3", 0),
    MVI(0xc00104a4, "TODO_c001_04a4", 0),
    MVI(0xc00104a5, "TODO_c001_04a5", 0),
    MVI(0xc00104a6, "TODO_c001_04a6", 0),
    MVI(0xc00104a7, "TODO_c001_04a7", 0),
    MVI(0xc00104a8, "TODO_c001_04a8", 0),
    MVI(0xc00104a9, "TODO_c001_04a9", 0),
    MVI(0xc00104aa, "TODO_c001_04aa", 0),
    MVI(0xc00104ab, "TODO_c001_04ab", 0),
    MVI(0xc00104ac, "TODO_c001_04ac", 0),
    MVI(0xc00104ad, "TODO_c001_04ad", 0),
    MVI(0xc00104ae, "TODO_c001_04ae", 0),
    MVI(0xc00104af, "TODO_c001_04af", 0),
    MVI(0xc00104b0, "TODO_c001_04b0", 0),
    MVI(0xc00104b1, "TODO_c001_04b1", 0),
    MVI(0xc00104b2, "TODO_c001_04b2", 0),
    MVI(0xc00104b3, "TODO_c001_04b3", 0),
    MVI(0xc00104b4, "TODO_c001_04b4", 0),
    MVI(0xc00104b5, "TODO_c001_04b5", 0),
    MVI(0xc00104b6, "TODO_c001_04b6", 0),
    MVI(0xc00104b7, "TODO_c001_04b7", 0),
    MVI(0xc00104b8, "TODO_c001_04b8", 0),
    MVI(0xc00104b9, "TODO_c001_04b9", 0),
    MVI(0xc00104ba, "TODO_c001_04ba", 0),
    MVI(0xc00104bb, "TODO_c001_04bb", 0),
    MVI(0xc00104bc, "TODO_c001_04bc", 0),
    MVI(0xc00104bd, "TODO_c001_04bd", 0),
    MVI(0xc00104be, "TODO_c001_04be", 0),
    MVI(0xc00104bf, "TODO_c001_04bf", 0),
    MVI(0xc00104c0, "TODO_c001_04c0", 0),
    MVI(0xc00104c1, "TODO_c001_04c1", 0),
    MVI(0xc00104c2, "TODO_c001_04c2", 0),
    MVI(0xc00104c3, "TODO_c001_04c3", 0),
    MVI(0xc00104c4, "TODO_c001_04c4", 0),
    MVI(0xc00104c5, "TODO_c001_04c5", 0),
    MVI(0xc00104c6, "TODO_c001_04c6", 0),
    MVI(0xc00104c7, "TODO_c001_04c7", 0),
    MVI(0xc00104c8, "TODO_c001_04c8", 0),
    MVI(0xc00104c9, "TODO_c001_04c9", 0),
    MVI(0xc00104ca, "TODO_c001_04ca", 0),
    MVI(0xc00104cb, "TODO_c001_04cb", 0),
    MVI(0xc00104cc, "TODO_c001_04cc", 0),
    MVI(0xc00104cd, "TODO_c001_04cd", 0),
    MVI(0xc00104ce, "TODO_c001_04ce", 0),
    MVI(0xc00104cf, "TODO_c001_04cf", 0),
    MVI(0xc00104d0, "TODO_c001_04d0", 0),
    MVI(0xc00104d1, "TODO_c001_04d1", 0),
    MVI(0xc00104d2, "TODO_c001_04d2", 0),
    MVI(0xc00104d3, "TODO_c001_04d3", 0),
    MVI(0xc00104d4, "TODO_c001_04d4", 0),
    MVI(0xc00104d5, "TODO_c001_04d5", 0),
    MVI(0xc00104d6, "TODO_c001_04d6", 0),
    MVI(0xc00104d7, "TODO_c001_04d7", 0),
    MVI(0xc00104d8, "TODO_c001_04d8", 0),
    MVI(0xc00104d9, "TODO_c001_04d9", 0),
    MVI(0xc00104da, "TODO_c001_04da", 0),
    MVI(0xc00104db, "TODO_c001_04db", 0),
    MVI(0xc00104dc, "TODO_c001_04dc", 0),
    MVI(0xc00104dd, "TODO_c001_04dd", 0),
    MVI(0xc00104de, "TODO_c001_04de", 0),
    MVI(0xc00104df, "TODO_c001_04df", 0),
    MVI(0xc00104e0, "TODO_c001_04e0", 0),
    MVI(0xc00104e1, "TODO_c001_04e1", 0),
    MVI(0xc00104e2, "TODO_c001_04e2", 0),
    MVI(0xc00104e3, "TODO_c001_04e3", 0),
    MVI(0xc00104e4, "TODO_c001_04e4", 0),
    MVI(0xc00104e5, "TODO_c001_04e5", 0),
    MVI(0xc00104e6, "TODO_c001_04e6", 0),
    MVI(0xc00104e7, "TODO_c001_04e7", 0),
    MVI(0xc00104e8, "TODO_c001_04e8", 0),
    MVI(0xc00104e9, "TODO_c001_04e9", 0),
    MVI(0xc00104ea, "TODO_c001_04ea", 0),
    MVI(0xc00104eb, "TODO_c001_04eb", 0),
    MVI(0xc00104ec, "TODO_c001_04ec", 0),
    MVI(0xc00104ed, "TODO_c001_04ed", 0),
    MVI(0xc00104ee, "TODO_c001_04ee", 0),
    MVI(0xc00104ef, "TODO_c001_04ef", 0),
    MVI(0xc00104f0, "TODO_c001_04f0", 0),
    MVI(0xc00104f1, "TODO_c001_04f1", 0),
    MVI(0xc00104f2, "TODO_c001_04f2", 0),
    MVI(0xc00104f3, "TODO_c001_04f3", 0),
    MVI(0xc00104f4, "TODO_c001_04f4", 0),
    MVI(0xc00104f5, "TODO_c001_04f5", 0),
    MVI(0xc00104f6, "TODO_c001_04f6", 0),
    MVI(0xc00104f7, "TODO_c001_04f7", 0),
    MVI(0xc00104f8, "TODO_c001_04f8", 0),
    MVI(0xc00104f9, "TODO_c001_04f9", 0),
    MVI(0xc00104fa, "TODO_c001_04fa", 0),
    MVI(0xc00104fb, "TODO_c001_04fb", 0),
    MVI(0xc00104fc, "TODO_c001_04fc", 0),
    MVI(0xc00104fd, "TODO_c001_04fd", 0),
    MVI(0xc00104fe, "TODO_c001_04fe", 0),
    MVI(0xc00104ff, "TODO_c001_04ff", 0),
    MVI(0xc0010500, "TODO_c001_0500", 0),
    MVI(0xc0010501, "TODO_c001_0501", 0),
    MVX(0xc0010502, "TODO_c001_0502", 0, UINT64_C(0xfffe000000000000), 0),
    MVI(0xc0010503, "TODO_c001_0503", 0),
    MVI(0xc0010504, "TODO_c001_0504", 0),
    MVI(0xc0010505, "TODO_c001_0505", 0),
    MVI(0xc0010506, "TODO_c001_0506", 0),
    MVX(0xc0010507, "TODO_c001_0507", 0, UINT64_C(0xfffe000000000000), 0),
    MVX(0xc0010508, "TODO_c001_0508", 0, UINT64_C(0xfffe000000000000), 0),
    MVX(0xc0010509, "TODO_c001_0509", 0, UINT64_C(0xfffe000000000000), 0),
    MVX(0xc001050a, "TODO_c001_050a", 0, UINT64_C(0xfffe000000000000), 0),
    MVX(0xc001050b, "TODO_c001_050b", 0, UINT64_C(0xfffe000000000000), 0),
    MVX(0xc001050c, "TODO_c001_050c", 0, UINT64_C(0xfffe000000000000), 0),
    MVX(0xc001050d, "TODO_c001_050d", 0, UINT64_C(0xfffe000000000000), 0),
    MVX(0xc001050e, "TODO_c001_050e", 0, UINT64_C(0xfffe000000000000), 0),
    MVI(0xc001050f, "TODO_c001_050f", 0),
    MVI(0xc0010510, "TODO_c001_0510", 0),
    MVI(0xc0010511, "TODO_c001_0511", 0),
    MVI(0xc0010512, "TODO_c001_0512", 0),
    MVI(0xc0010513, "TODO_c001_0513", 0),
    MVX(0xc0010514, "TODO_c001_0514", 0, UINT64_C(0xfffffe0000000000), 0),
    MVX(0xc0010515, "TODO_c001_0515", 0, UINT64_C(0xfffffe0000000000), 0),
    MVI(0xc0010516, "TODO_c001_0516", 0),
    MVI(0xc0010517, "TODO_c001_0517", 0),
    MVI(0xc0010518, "TODO_c001_0518", 0),
    MVI(0xc0010519, "TODO_c001_0519", 0),
    MVI(0xc001051a, "TODO_c001_051a", 0),
    MVI(0xc001051b, "TODO_c001_051b", 0),
    MVI(0xc001051c, "TODO_c001_051c", 0),
    MVI(0xc001051d, "TODO_c001_051d", 0),
    MVI(0xc001051e, "TODO_c001_051e", 0),
    MVI(0xc001051f, "TODO_c001_051f", 0),
    MVI(0xc0010520, "TODO_c001_0520", 0),
    MVI(0xc0010521, "TODO_c001_0521", 0),
    MVI(0xc0010522, "TODO_c001_0522", 0),
    MVI(0xc0010523, "TODO_c001_0523", 0),
    MVI(0xc0010524, "TODO_c001_0524", 0),
    MVI(0xc0010525, "TODO_c001_0525", 0),
    MVI(0xc0010526, "TODO_c001_0526", 0),
    MVI(0xc0010527, "TODO_c001_0527", 0),
    MVI(0xc0010528, "TODO_c001_0528", 0),
    MVI(0xc0010529, "TODO_c001_0529", 0),
    MVI(0xc001052a, "TODO_c001_052a", 0),
    MVI(0xc001052b, "TODO_c001_052b", 0),
    MVI(0xc001052c, "TODO_c001_052c", 0),
    MVI(0xc001052d, "TODO_c001_052d", 0),
    MVI(0xc001052e, "TODO_c001_052e", 0),
    MVI(0xc001052f, "TODO_c001_052f", 0),
    MVI(0xc0010530, "TODO_c001_0530", 0),
    MVI(0xc0010531, "TODO_c001_0531", 0),
    MVI(0xc0010532, "TODO_c001_0532", 0),
    MVI(0xc0010533, "TODO_c001_0533", 0),
    MVI(0xc0010534, "TODO_c001_0534", 0),
    MVI(0xc0010535, "TODO_c001_0535", 0),
    MVI(0xc0010536, "TODO_c001_0536", 0),
    MVI(0xc0010537, "TODO_c001_0537", 0),
    MVI(0xc0010538, "TODO_c001_0538", 0),
    MVI(0xc0010539, "TODO_c001_0539", 0),
    MVI(0xc001053a, "TODO_c001_053a", 0),
    MVI(0xc001053b, "TODO_c001_053b", 0),
    MVI(0xc001053c, "TODO_c001_053c", 0),
    MVI(0xc001053d, "TODO_c001_053d", 0),
    MVI(0xc001053e, "TODO_c001_053e", 0),
    MVI(0xc001053f, "TODO_c001_053f", 0),
    MVI(0xc0010540, "TODO_c001_0540", 0),
    MVI(0xc0010541, "TODO_c001_0541", 0),
    MVI(0xc0010542, "TODO_c001_0542", 0),
    MVI(0xc0010543, "TODO_c001_0543", 0),
    MVI(0xc0010544, "TODO_c001_0544", 0),
    MVI(0xc0010545, "TODO_c001_0545", 0),
    MVI(0xc0010546, "TODO_c001_0546", 0),
    MVI(0xc0010547, "TODO_c001_0547", 0),
    MVI(0xc0010548, "TODO_c001_0548", 0),
    MVI(0xc0010549, "TODO_c001_0549", 0),
    MVI(0xc001054a, "TODO_c001_054a", 0),
    MVI(0xc001054b, "TODO_c001_054b", 0),
    MVI(0xc001054c, "TODO_c001_054c", 0),
    MVI(0xc001054d, "TODO_c001_054d", 0),
    MVI(0xc001054e, "TODO_c001_054e", 0),
    MVI(0xc001054f, "TODO_c001_054f", 0),
    MVI(0xc0010550, "TODO_c001_0550", 0),
    MVI(0xc0010551, "TODO_c001_0551", 0),
    MVI(0xc0010552, "TODO_c001_0552", 0),
    MVI(0xc0010553, "TODO_c001_0553", 0),
    MVI(0xc0010554, "TODO_c001_0554", 0),
    MVI(0xc0010555, "TODO_c001_0555", 0),
    MVI(0xc0010556, "TODO_c001_0556", 0),
    MVI(0xc0010557, "TODO_c001_0557", 0),
    MVI(0xc0010558, "TODO_c001_0558", 0),
    MVI(0xc0010559, "TODO_c001_0559", 0),
    MVI(0xc001055a, "TODO_c001_055a", 0),
    MVI(0xc001055b, "TODO_c001_055b", 0),
    MVI(0xc001055c, "TODO_c001_055c", 0),
    MVI(0xc001055d, "TODO_c001_055d", 0),
    MVI(0xc001055e, "TODO_c001_055e", 0),
    MVI(0xc001055f, "TODO_c001_055f", 0),
    MVI(0xc0010560, "TODO_c001_0560", 0),
    MVI(0xc0010561, "TODO_c001_0561", 0),
    MVI(0xc0010562, "TODO_c001_0562", 0),
    MVI(0xc0010563, "TODO_c001_0563", 0),
    MVI(0xc0010564, "TODO_c001_0564", 0),
    MVI(0xc0010565, "TODO_c001_0565", 0),
    MVI(0xc0010566, "TODO_c001_0566", 0),
    MVI(0xc0010567, "TODO_c001_0567", 0),
    MVI(0xc0010568, "TODO_c001_0568", 0),
    MVI(0xc0010569, "TODO_c001_0569", 0),
    MVI(0xc001056a, "TODO_c001_056a", 0),
    MVI(0xc001056b, "TODO_c001_056b", 0),
    MVI(0xc001056c, "TODO_c001_056c", 0),
    MVI(0xc001056d, "TODO_c001_056d", 0),
    MVI(0xc001056e, "TODO_c001_056e", 0),
    MVI(0xc001056f, "TODO_c001_056f", 0),
    MVI(0xc0010570, "TODO_c001_0570", 0),
    MVI(0xc0010571, "TODO_c001_0571", 0),
    MVI(0xc0010572, "TODO_c001_0572", 0),
    MVI(0xc0010573, "TODO_c001_0573", 0),
    MVI(0xc0010574, "TODO_c001_0574", 0),
    MVI(0xc0010575, "TODO_c001_0575", 0),
    MVI(0xc0010576, "TODO_c001_0576", 0),
    MVI(0xc0010577, "TODO_c001_0577", 0),
    MVI(0xc0010578, "TODO_c001_0578", 0),
    MVI(0xc0010579, "TODO_c001_0579", 0),
    MVI(0xc001057a, "TODO_c001_057a", 0),
    MVI(0xc001057b, "TODO_c001_057b", 0),
    MVI(0xc001057c, "TODO_c001_057c", 0),
    MVI(0xc001057d, "TODO_c001_057d", 0),
    MVI(0xc001057e, "TODO_c001_057e", 0),
    MVI(0xc001057f, "TODO_c001_057f", 0),
    MVI(0xc0010580, "TODO_c001_0580", 0),
    MVI(0xc0010581, "TODO_c001_0581", 0),
    MVI(0xc0010582, "TODO_c001_0582", 0),
    MVI(0xc0010583, "TODO_c001_0583", 0),
    MVI(0xc0010584, "TODO_c001_0584", 0),
    MVI(0xc0010585, "TODO_c001_0585", 0),
    MVI(0xc0010586, "TODO_c001_0586", 0),
    MVI(0xc0010587, "TODO_c001_0587", 0),
    MVI(0xc0010588, "TODO_c001_0588", 0),
    MVI(0xc0010589, "TODO_c001_0589", 0),
    MVI(0xc001058a, "TODO_c001_058a", 0),
    MVI(0xc001058b, "TODO_c001_058b", 0),
    MVI(0xc001058c, "TODO_c001_058c", 0),
    MVI(0xc001058d, "TODO_c001_058d", 0),
    MVI(0xc001058e, "TODO_c001_058e", 0),
    MVI(0xc001058f, "TODO_c001_058f", 0),
    MVI(0xc0010590, "TODO_c001_0590", 0),
    MVI(0xc0010591, "TODO_c001_0591", 0),
    MVI(0xc0010592, "TODO_c001_0592", 0),
    MVI(0xc0010593, "TODO_c001_0593", 0),
    MVI(0xc0010594, "TODO_c001_0594", 0),
    MVI(0xc0010595, "TODO_c001_0595", 0),
    MVI(0xc0010596, "TODO_c001_0596", 0),
    MVI(0xc0010597, "TODO_c001_0597", 0),
    MVI(0xc0010598, "TODO_c001_0598", 0),
    MVI(0xc0010599, "TODO_c001_0599", 0),
    MVI(0xc001059a, "TODO_c001_059a", 0),
    MVI(0xc001059b, "TODO_c001_059b", 0),
    MVI(0xc001059c, "TODO_c001_059c", 0),
    MVI(0xc001059d, "TODO_c001_059d", 0),
    MVI(0xc001059e, "TODO_c001_059e", 0),
    MVI(0xc001059f, "TODO_c001_059f", 0),
    MVI(0xc00105a0, "TODO_c001_05a0", 0),
    MVI(0xc00105a1, "TODO_c001_05a1", 0),
    MVI(0xc00105a2, "TODO_c001_05a2", 0),
    MVI(0xc00105a3, "TODO_c001_05a3", 0),
    MVI(0xc00105a4, "TODO_c001_05a4", 0),
    MVI(0xc00105a5, "TODO_c001_05a5", 0),
    MVI(0xc00105a6, "TODO_c001_05a6", 0),
    MVI(0xc00105a7, "TODO_c001_05a7", 0),
    MVI(0xc00105a8, "TODO_c001_05a8", 0),
    MVI(0xc00105a9, "TODO_c001_05a9", 0),
    MVI(0xc00105aa, "TODO_c001_05aa", 0),
    MVI(0xc00105ab, "TODO_c001_05ab", 0),
    MVI(0xc00105ac, "TODO_c001_05ac", 0),
    MVI(0xc00105ad, "TODO_c001_05ad", 0),
    MVI(0xc00105ae, "TODO_c001_05ae", 0),
    MVI(0xc00105af, "TODO_c001_05af", 0),
    MVI(0xc00105b0, "TODO_c001_05b0", 0),
    MVI(0xc00105b1, "TODO_c001_05b1", 0),
    MVI(0xc00105b2, "TODO_c001_05b2", 0),
    MVI(0xc00105b3, "TODO_c001_05b3", 0),
    MVI(0xc00105b4, "TODO_c001_05b4", 0),
    MVI(0xc00105b5, "TODO_c001_05b5", 0),
    MVI(0xc00105b6, "TODO_c001_05b6", 0),
    MVI(0xc00105b7, "TODO_c001_05b7", 0),
    MVI(0xc00105b8, "TODO_c001_05b8", 0),
    MVI(0xc00105b9, "TODO_c001_05b9", 0),
    MVI(0xc00105ba, "TODO_c001_05ba", 0),
    MVI(0xc00105bb, "TODO_c001_05bb", 0),
    MVI(0xc00105bc, "TODO_c001_05bc", 0),
    MVI(0xc00105bd, "TODO_c001_05bd", 0),
    MVI(0xc00105be, "TODO_c001_05be", 0),
    MVI(0xc00105bf, "TODO_c001_05bf", 0),
    MVI(0xc00105c0, "TODO_c001_05c0", 0),
    MVI(0xc00105c1, "TODO_c001_05c1", 0),
    MVI(0xc00105c2, "TODO_c001_05c2", 0),
    MVI(0xc00105c3, "TODO_c001_05c3", 0),
    MVI(0xc00105c4, "TODO_c001_05c4", 0),
    MVI(0xc00105c5, "TODO_c001_05c5", 0),
    MVI(0xc00105c6, "TODO_c001_05c6", 0),
    MVI(0xc00105c7, "TODO_c001_05c7", 0),
    MVI(0xc00105c8, "TODO_c001_05c8", 0),
    MVI(0xc00105c9, "TODO_c001_05c9", 0),
    MVI(0xc00105ca, "TODO_c001_05ca", 0),
    MVI(0xc00105cb, "TODO_c001_05cb", 0),
    MVI(0xc00105cc, "TODO_c001_05cc", 0),
    MVI(0xc00105cd, "TODO_c001_05cd", 0),
    MVI(0xc00105ce, "TODO_c001_05ce", 0),
    MVI(0xc00105cf, "TODO_c001_05cf", 0),
    MVI(0xc00105d0, "TODO_c001_05d0", 0),
    MVI(0xc00105d1, "TODO_c001_05d1", 0),
    MVI(0xc00105d2, "TODO_c001_05d2", 0),
    MVI(0xc00105d3, "TODO_c001_05d3", 0),
    MVI(0xc00105d4, "TODO_c001_05d4", 0),
    MVI(0xc00105d5, "TODO_c001_05d5", 0),
    MVI(0xc00105d6, "TODO_c001_05d6", 0),
    MVI(0xc00105d7, "TODO_c001_05d7", 0),
    MVI(0xc00105d8, "TODO_c001_05d8", 0),
    MVI(0xc00105d9, "TODO_c001_05d9", 0),
    MVI(0xc00105da, "TODO_c001_05da", 0),
    MVI(0xc00105db, "TODO_c001_05db", 0),
    MVI(0xc00105dc, "TODO_c001_05dc", 0),
    MVI(0xc00105dd, "TODO_c001_05dd", 0),
    MVI(0xc00105de, "TODO_c001_05de", 0),
    MVI(0xc00105df, "TODO_c001_05df", 0),
    MVI(0xc00105e0, "TODO_c001_05e0", 0),
    MVI(0xc00105e1, "TODO_c001_05e1", 0),
    MVI(0xc00105e2, "TODO_c001_05e2", 0),
    MVI(0xc00105e3, "TODO_c001_05e3", 0),
    MVI(0xc00105e4, "TODO_c001_05e4", 0),
    MVI(0xc00105e5, "TODO_c001_05e5", 0),
    MVI(0xc00105e6, "TODO_c001_05e6", 0),
    MVI(0xc00105e7, "TODO_c001_05e7", 0),
    MVI(0xc00105e8, "TODO_c001_05e8", 0),
    MVI(0xc00105e9, "TODO_c001_05e9", 0),
    MVI(0xc00105ea, "TODO_c001_05ea", 0),
    MVI(0xc00105eb, "TODO_c001_05eb", 0),
    MVI(0xc00105ec, "TODO_c001_05ec", 0),
    MVI(0xc00105ed, "TODO_c001_05ed", 0),
    MVI(0xc00105ee, "TODO_c001_05ee", 0),
    MVI(0xc00105ef, "TODO_c001_05ef", 0),
    MVI(0xc00105f0, "TODO_c001_05f0", 0),
    MVI(0xc00105f1, "TODO_c001_05f1", 0),
    MVI(0xc00105f2, "TODO_c001_05f2", 0),
    MVI(0xc00105f3, "TODO_c001_05f3", 0),
    MVI(0xc00105f4, "TODO_c001_05f4", 0),
    MVI(0xc00105f5, "TODO_c001_05f5", 0),
    MVI(0xc00105f6, "TODO_c001_05f6", 0),
    MVI(0xc00105f7, "TODO_c001_05f7", 0),
    MVI(0xc00105f8, "TODO_c001_05f8", 0),
    MVI(0xc00105f9, "TODO_c001_05f9", 0),
    MVI(0xc00105fa, "TODO_c001_05fa", 0),
    MVI(0xc00105fb, "TODO_c001_05fb", 0),
    MVI(0xc00105fc, "TODO_c001_05fc", 0),
    MVI(0xc00105fd, "TODO_c001_05fd", 0),
    MVI(0xc00105fe, "TODO_c001_05fe", 0),
    MVI(0xc00105ff, "TODO_c001_05ff", 0),
    MVI(0xc0010600, "TODO_c001_0600", 0),
    MVI(0xc0010601, "TODO_c001_0601", 0),
    MVX(0xc0010602, "TODO_c001_0602", 0, 0, 0),
    MVI(0xc0010603, "TODO_c001_0603", 0),
    MVI(0xc0010604, "TODO_c001_0604", 0),
    MVI(0xc0010605, "TODO_c001_0605", 0),
    MVI(0xc0010606, "TODO_c001_0606", 0),
    MVX(0xc0010607, "TODO_c001_0607", 0, 0, 0),
    MVX(0xc0010608, "TODO_c001_0608", 0, 0, 0),
    MVX(0xc0010609, "TODO_c001_0609", 0, 0, 0),
    MVX(0xc001060a, "TODO_c001_060a", 0, 0, 0),
    MVX(0xc001060b, "TODO_c001_060b", 0, 0, 0),
    MVX(0xc001060c, "TODO_c001_060c", 0, 0, 0),
    MVX(0xc001060d, "TODO_c001_060d", 0, 0, 0),
    MVX(0xc001060e, "TODO_c001_060e", 0, 0, 0),
    MVI(0xc001060f, "TODO_c001_060f", 0),
    MVI(0xc0010610, "TODO_c001_0610", 0),
    MVI(0xc0010611, "TODO_c001_0611", 0),
    MVI(0xc0010612, "TODO_c001_0612", 0),
    MVI(0xc0010613, "TODO_c001_0613", 0),
    MVX(0xc0010614, "TODO_c001_0614", 0, 0, 0),
    MVX(0xc0010615, "TODO_c001_0615", 0, 0, 0),
    MVI(0xc0010616, "TODO_c001_0616", 0),
    MVI(0xc0010617, "TODO_c001_0617", 0),
    MVI(0xc0010618, "TODO_c001_0618", 0),
    MVI(0xc0010619, "TODO_c001_0619", 0),
    MVI(0xc001061a, "TODO_c001_061a", 0),
    MVI(0xc001061b, "TODO_c001_061b", 0),
    MVI(0xc001061c, "TODO_c001_061c", 0),
    MVI(0xc001061d, "TODO_c001_061d", 0),
    MVI(0xc001061e, "TODO_c001_061e", 0),
    MVI(0xc001061f, "TODO_c001_061f", 0),
    MVI(0xc0010620, "TODO_c001_0620", 0),
    MVI(0xc0010621, "TODO_c001_0621", 0),
    MVI(0xc0010622, "TODO_c001_0622", 0),
    MVI(0xc0010623, "TODO_c001_0623", 0),
    MVI(0xc0010624, "TODO_c001_0624", 0),
    MVI(0xc0010625, "TODO_c001_0625", 0),
    MVI(0xc0010626, "TODO_c001_0626", 0),
    MVI(0xc0010627, "TODO_c001_0627", 0),
    MVI(0xc0010628, "TODO_c001_0628", 0),
    MVI(0xc0010629, "TODO_c001_0629", 0),
    MVI(0xc001062a, "TODO_c001_062a", 0),
    MVI(0xc001062b, "TODO_c001_062b", 0),
    MVI(0xc001062c, "TODO_c001_062c", 0),
    MVI(0xc001062d, "TODO_c001_062d", 0),
    MVI(0xc001062e, "TODO_c001_062e", 0),
    MVI(0xc001062f, "TODO_c001_062f", 0),
    MVI(0xc0010630, "TODO_c001_0630", 0),
    MVI(0xc0010631, "TODO_c001_0631", 0),
    MVI(0xc0010632, "TODO_c001_0632", 0),
    MVI(0xc0010633, "TODO_c001_0633", 0),
    MVI(0xc0010634, "TODO_c001_0634", 0),
    MVI(0xc0010635, "TODO_c001_0635", 0),
    MVI(0xc0010636, "TODO_c001_0636", 0),
    MVI(0xc0010637, "TODO_c001_0637", 0),
    MVI(0xc0010638, "TODO_c001_0638", 0),
    MVI(0xc0010639, "TODO_c001_0639", 0),
    MVI(0xc001063a, "TODO_c001_063a", 0),
    MVI(0xc001063b, "TODO_c001_063b", 0),
    MVI(0xc001063c, "TODO_c001_063c", 0),
    MVI(0xc001063d, "TODO_c001_063d", 0),
    MVI(0xc001063e, "TODO_c001_063e", 0),
    MVI(0xc001063f, "TODO_c001_063f", 0),
    MVI(0xc0010640, "TODO_c001_0640", 0),
    MVI(0xc0010641, "TODO_c001_0641", 0),
    MVI(0xc0010642, "TODO_c001_0642", 0),
    MVI(0xc0010643, "TODO_c001_0643", 0),
    MVI(0xc0010644, "TODO_c001_0644", 0),
    MVI(0xc0010645, "TODO_c001_0645", 0),
    MVI(0xc0010646, "TODO_c001_0646", 0),
    MVI(0xc0010647, "TODO_c001_0647", 0),
    MVI(0xc0010648, "TODO_c001_0648", 0),
    MVI(0xc0010649, "TODO_c001_0649", 0),
    MVI(0xc001064a, "TODO_c001_064a", 0),
    MVI(0xc001064b, "TODO_c001_064b", 0),
    MVI(0xc001064c, "TODO_c001_064c", 0),
    MVI(0xc001064d, "TODO_c001_064d", 0),
    MVI(0xc001064e, "TODO_c001_064e", 0),
    MVI(0xc001064f, "TODO_c001_064f", 0),
    MVI(0xc0010650, "TODO_c001_0650", 0),
    MVI(0xc0010651, "TODO_c001_0651", 0),
    MVI(0xc0010652, "TODO_c001_0652", 0),
    MVI(0xc0010653, "TODO_c001_0653", 0),
    MVI(0xc0010654, "TODO_c001_0654", 0),
    MVI(0xc0010655, "TODO_c001_0655", 0),
    MVI(0xc0010656, "TODO_c001_0656", 0),
    MVI(0xc0010657, "TODO_c001_0657", 0),
    MVI(0xc0010658, "TODO_c001_0658", 0),
    MVI(0xc0010659, "TODO_c001_0659", 0),
    MVI(0xc001065a, "TODO_c001_065a", 0),
    MVI(0xc001065b, "TODO_c001_065b", 0),
    MVI(0xc001065c, "TODO_c001_065c", 0),
    MVI(0xc001065d, "TODO_c001_065d", 0),
    MVI(0xc001065e, "TODO_c001_065e", 0),
    MVI(0xc001065f, "TODO_c001_065f", 0),
    MVI(0xc0010660, "TODO_c001_0660", 0),
    MVI(0xc0010661, "TODO_c001_0661", 0),
    MVI(0xc0010662, "TODO_c001_0662", 0),
    MVI(0xc0010663, "TODO_c001_0663", 0),
    MVI(0xc0010664, "TODO_c001_0664", 0),
    MVI(0xc0010665, "TODO_c001_0665", 0),
    MVI(0xc0010666, "TODO_c001_0666", 0),
    MVI(0xc0010667, "TODO_c001_0667", 0),
    MVI(0xc0010668, "TODO_c001_0668", 0),
    MVI(0xc0010669, "TODO_c001_0669", 0),
    MVI(0xc001066a, "TODO_c001_066a", 0),
    MVI(0xc001066b, "TODO_c001_066b", 0),
    MVI(0xc001066c, "TODO_c001_066c", 0),
    MVI(0xc001066d, "TODO_c001_066d", 0),
    MVI(0xc001066e, "TODO_c001_066e", 0),
    MVI(0xc001066f, "TODO_c001_066f", 0),
    MVI(0xc0010670, "TODO_c001_0670", 0),
    MVI(0xc0010671, "TODO_c001_0671", 0),
    MVI(0xc0010672, "TODO_c001_0672", 0),
    MVI(0xc0010673, "TODO_c001_0673", 0),
    MVI(0xc0010674, "TODO_c001_0674", 0),
    MVI(0xc0010675, "TODO_c001_0675", 0),
    MVI(0xc0010676, "TODO_c001_0676", 0),
    MVI(0xc0010677, "TODO_c001_0677", 0),
    MVI(0xc0010678, "TODO_c001_0678", 0),
    MVI(0xc0010679, "TODO_c001_0679", 0),
    MVI(0xc001067a, "TODO_c001_067a", 0),
    MVI(0xc001067b, "TODO_c001_067b", 0),
    MVI(0xc001067c, "TODO_c001_067c", 0),
    MVI(0xc001067d, "TODO_c001_067d", 0),
    MVI(0xc001067e, "TODO_c001_067e", 0),
    MVI(0xc001067f, "TODO_c001_067f", 0),
    MVI(0xc0010680, "TODO_c001_0680", 0),
    MVI(0xc0010681, "TODO_c001_0681", 0),
    MVI(0xc0010682, "TODO_c001_0682", 0),
    MVI(0xc0010683, "TODO_c001_0683", 0),
    MVI(0xc0010684, "TODO_c001_0684", 0),
    MVI(0xc0010685, "TODO_c001_0685", 0),
    MVI(0xc0010686, "TODO_c001_0686", 0),
    MVI(0xc0010687, "TODO_c001_0687", 0),
    MVI(0xc0010688, "TODO_c001_0688", 0),
    MVI(0xc0010689, "TODO_c001_0689", 0),
    MVI(0xc001068a, "TODO_c001_068a", 0),
    MVI(0xc001068b, "TODO_c001_068b", 0),
    MVI(0xc001068c, "TODO_c001_068c", 0),
    MVI(0xc001068d, "TODO_c001_068d", 0),
    MVI(0xc001068e, "TODO_c001_068e", 0),
    MVI(0xc001068f, "TODO_c001_068f", 0),
    MVI(0xc0010690, "TODO_c001_0690", 0),
    MVI(0xc0010691, "TODO_c001_0691", 0),
    MVI(0xc0010692, "TODO_c001_0692", 0),
    MVI(0xc0010693, "TODO_c001_0693", 0),
    MVI(0xc0010694, "TODO_c001_0694", 0),
    MVI(0xc0010695, "TODO_c001_0695", 0),
    MVI(0xc0010696, "TODO_c001_0696", 0),
    MVI(0xc0010697, "TODO_c001_0697", 0),
    MVI(0xc0010698, "TODO_c001_0698", 0),
    MVI(0xc0010699, "TODO_c001_0699", 0),
    MVI(0xc001069a, "TODO_c001_069a", 0),
    MVI(0xc001069b, "TODO_c001_069b", 0),
    MVI(0xc001069c, "TODO_c001_069c", 0),
    MVI(0xc001069d, "TODO_c001_069d", 0),
    MVI(0xc001069e, "TODO_c001_069e", 0),
    MVI(0xc001069f, "TODO_c001_069f", 0),
    MVI(0xc00106a0, "TODO_c001_06a0", 0),
    MVI(0xc00106a1, "TODO_c001_06a1", 0),
    MVI(0xc00106a2, "TODO_c001_06a2", 0),
    MVI(0xc00106a3, "TODO_c001_06a3", 0),
    MVI(0xc00106a4, "TODO_c001_06a4", 0),
    MVI(0xc00106a5, "TODO_c001_06a5", 0),
    MVI(0xc00106a6, "TODO_c001_06a6", 0),
    MVI(0xc00106a7, "TODO_c001_06a7", 0),
    MVI(0xc00106a8, "TODO_c001_06a8", 0),
    MVI(0xc00106a9, "TODO_c001_06a9", 0),
    MVI(0xc00106aa, "TODO_c001_06aa", 0),
    MVI(0xc00106ab, "TODO_c001_06ab", 0),
    MVI(0xc00106ac, "TODO_c001_06ac", 0),
    MVI(0xc00106ad, "TODO_c001_06ad", 0),
    MVI(0xc00106ae, "TODO_c001_06ae", 0),
    MVI(0xc00106af, "TODO_c001_06af", 0),
    MVI(0xc00106b0, "TODO_c001_06b0", 0),
    MVI(0xc00106b1, "TODO_c001_06b1", 0),
    MVI(0xc00106b2, "TODO_c001_06b2", 0),
    MVI(0xc00106b3, "TODO_c001_06b3", 0),
    MVI(0xc00106b4, "TODO_c001_06b4", 0),
    MVI(0xc00106b5, "TODO_c001_06b5", 0),
    MVI(0xc00106b6, "TODO_c001_06b6", 0),
    MVI(0xc00106b7, "TODO_c001_06b7", 0),
    MVI(0xc00106b8, "TODO_c001_06b8", 0),
    MVI(0xc00106b9, "TODO_c001_06b9", 0),
    MVI(0xc00106ba, "TODO_c001_06ba", 0),
    MVI(0xc00106bb, "TODO_c001_06bb", 0),
    MVI(0xc00106bc, "TODO_c001_06bc", 0),
    MVI(0xc00106bd, "TODO_c001_06bd", 0),
    MVI(0xc00106be, "TODO_c001_06be", 0),
    MVI(0xc00106bf, "TODO_c001_06bf", 0),
    MVI(0xc00106c0, "TODO_c001_06c0", 0),
    MVI(0xc00106c1, "TODO_c001_06c1", 0),
    MVI(0xc00106c2, "TODO_c001_06c2", 0),
    MVI(0xc00106c3, "TODO_c001_06c3", 0),
    MVI(0xc00106c4, "TODO_c001_06c4", 0),
    MVI(0xc00106c5, "TODO_c001_06c5", 0),
    MVI(0xc00106c6, "TODO_c001_06c6", 0),
    MVI(0xc00106c7, "TODO_c001_06c7", 0),
    MVI(0xc00106c8, "TODO_c001_06c8", 0),
    MVI(0xc00106c9, "TODO_c001_06c9", 0),
    MVI(0xc00106ca, "TODO_c001_06ca", 0),
    MVI(0xc00106cb, "TODO_c001_06cb", 0),
    MVI(0xc00106cc, "TODO_c001_06cc", 0),
    MVI(0xc00106cd, "TODO_c001_06cd", 0),
    MVI(0xc00106ce, "TODO_c001_06ce", 0),
    MVI(0xc00106cf, "TODO_c001_06cf", 0),
    MVI(0xc00106d0, "TODO_c001_06d0", 0),
    MVI(0xc00106d1, "TODO_c001_06d1", 0),
    MVI(0xc00106d2, "TODO_c001_06d2", 0),
    MVI(0xc00106d3, "TODO_c001_06d3", 0),
    MVI(0xc00106d4, "TODO_c001_06d4", 0),
    MVI(0xc00106d5, "TODO_c001_06d5", 0),
    MVI(0xc00106d6, "TODO_c001_06d6", 0),
    MVI(0xc00106d7, "TODO_c001_06d7", 0),
    MVI(0xc00106d8, "TODO_c001_06d8", 0),
    MVI(0xc00106d9, "TODO_c001_06d9", 0),
    MVI(0xc00106da, "TODO_c001_06da", 0),
    MVI(0xc00106db, "TODO_c001_06db", 0),
    MVI(0xc00106dc, "TODO_c001_06dc", 0),
    MVI(0xc00106dd, "TODO_c001_06dd", 0),
    MVI(0xc00106de, "TODO_c001_06de", 0),
    MVI(0xc00106df, "TODO_c001_06df", 0),
    MVI(0xc00106e0, "TODO_c001_06e0", 0),
    MVI(0xc00106e1, "TODO_c001_06e1", 0),
    MVI(0xc00106e2, "TODO_c001_06e2", 0),
    MVI(0xc00106e3, "TODO_c001_06e3", 0),
    MVI(0xc00106e4, "TODO_c001_06e4", 0),
    MVI(0xc00106e5, "TODO_c001_06e5", 0),
    MVI(0xc00106e6, "TODO_c001_06e6", 0),
    MVI(0xc00106e7, "TODO_c001_06e7", 0),
    MVI(0xc00106e8, "TODO_c001_06e8", 0),
    MVI(0xc00106e9, "TODO_c001_06e9", 0),
    MVI(0xc00106ea, "TODO_c001_06ea", 0),
    MVI(0xc00106eb, "TODO_c001_06eb", 0),
    MVI(0xc00106ec, "TODO_c001_06ec", 0),
    MVI(0xc00106ed, "TODO_c001_06ed", 0),
    MVI(0xc00106ee, "TODO_c001_06ee", 0),
    MVI(0xc00106ef, "TODO_c001_06ef", 0),
    MVI(0xc00106f0, "TODO_c001_06f0", 0),
    MVI(0xc00106f1, "TODO_c001_06f1", 0),
    MVI(0xc00106f2, "TODO_c001_06f2", 0),
    MVI(0xc00106f3, "TODO_c001_06f3", 0),
    MVI(0xc00106f4, "TODO_c001_06f4", 0),
    MVI(0xc00106f5, "TODO_c001_06f5", 0),
    MVI(0xc00106f6, "TODO_c001_06f6", 0),
    MVI(0xc00106f7, "TODO_c001_06f7", 0),
    MVI(0xc00106f8, "TODO_c001_06f8", 0),
    MVI(0xc00106f9, "TODO_c001_06f9", 0),
    MVI(0xc00106fa, "TODO_c001_06fa", 0),
    MVI(0xc00106fb, "TODO_c001_06fb", 0),
    MVI(0xc00106fc, "TODO_c001_06fc", 0),
    MVI(0xc00106fd, "TODO_c001_06fd", 0),
    MVI(0xc00106fe, "TODO_c001_06fe", 0),
    MVI(0xc00106ff, "TODO_c001_06ff", 0),
    MFX(0xc0011000, "AMD_K7_MCODE_CTL", AmdK7MicrocodeCtl, AmdK7MicrocodeCtl, 0x18000000, ~(uint64_t)UINT32_MAX, 0x4), /* value=0x18000000 */
    MFX(0xc0011001, "AMD_K7_APIC_CLUSTER_ID", AmdK7ClusterIdMaybe, AmdK7ClusterIdMaybe, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x0 */
    MFN(0xc0011002, "AMD_K8_CPUID_CTL_STD07", AmdK8CpuIdCtlStd07hEbax, AmdK8CpuIdCtlStd07hEbax), /* value=0x9c01a9 */
    MFX(0xc0011003, "AMD_K8_CPUID_CTL_STD06", AmdK8CpuIdCtlStd06hEcx, AmdK8CpuIdCtlStd06hEcx, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x1 */
    MFN(0xc0011004, "AMD_K8_CPUID_CTL_STD01", AmdK8CpuIdCtlStd01hEdcx, AmdK8CpuIdCtlStd01hEdcx), /* value=0x7cd83209`178bfbff */
    MFN(0xc0011005, "AMD_K8_CPUID_CTL_EXT01", AmdK8CpuIdCtlExt01hEdcx, AmdK8CpuIdCtlExt01hEdcx), /* value=0x35c233ff`2fd3fbff */
    MFX(0xc0011006, "AMD_K7_DEBUG_STS?", AmdK7DebugStatusMaybe, AmdK7DebugStatusMaybe, 0, UINT64_C(0xffffffff00000080), 0), /* value=0x0 */
    MFN(0xc0011007, "AMD_K7_BH_TRACE_BASE?", AmdK7BHTraceBaseMaybe, AmdK7BHTraceBaseMaybe), /* value=0x0 */
    MFN(0xc0011008, "AMD_K7_BH_TRACE_PTR?", AmdK7BHTracePtrMaybe, AmdK7BHTracePtrMaybe), /* value=0x0 */
    MFN(0xc0011009, "AMD_K7_BH_TRACE_LIM?", AmdK7BHTraceLimitMaybe, AmdK7BHTraceLimitMaybe), /* value=0x0 */
    MFI(0xc001100a, "AMD_K7_HDT_CFG?", AmdK7HardwareDebugToolCfgMaybe), /* value=0x0 */
    MFX(0xc001100b, "AMD_K7_FAST_FLUSH_COUNT?", AmdK7FastFlushCountMaybe, AmdK7FastFlushCountMaybe, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x0 */
    MFX(0xc001100c, "AMD_K7_NODE_ID", AmdK7NodeId, AmdK7NodeId, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x0 */
    MVX(0xc001100e, "AMD_K8_WRMSR_BP?", 0, ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc001100f, "AMD_K8_WRMSR_BP_MASK?", 0, ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0011010, "AMD_K8_BH_TRACE_CTL?", 0, UINT64_C(0xffffffff00010000), 0),
    MVI(0xc0011011, "AMD_K8_BH_TRACE_USRD?", 0), /* value=0x0 */
    MVX(0xc0011014, "AMD_K8_XCPT_BP_RIP?", 0, 0, 0),
    MVX(0xc0011015, "AMD_K8_XCPT_BP_RIP_MASK?", 0, 0, 0),
    MVX(0xc0011016, "AMD_K8_COND_HDT_VAL?", 0, 0, 0),
    MVX(0xc0011017, "AMD_K8_COND_HDT_VAL_MASK?", 0, 0, 0),
    MVX(0xc0011018, "AMD_K8_XCPT_BP_CTL?", 0, 0, 0),
    RSN(0xc0011019, 0xc001101a, "AMD_16H_DR1_ADDR_MASn", AmdK7DrXAddrMaskN, AmdK7DrXAddrMaskN, 0x1, ~(uint64_t)UINT32_MAX, 0),
    MFX(0xc001101b, "AMD_16H_DR3_ADDR_MASK", AmdK7DrXAddrMaskN, AmdK7DrXAddrMaskN, 0, ~(uint64_t)UINT32_MAX, 0), /* value=0x0 */
    MFX(0xc0011020, "AMD_K7_LS_CFG", AmdK7LoadStoreCfg, AmdK7LoadStoreCfg, 0, UINT64_C(0x7c000fffc000), 0), /* value=0x2068000`00000000 */
    MFX(0xc0011021, "AMD_K7_IC_CFG", AmdK7InstrCacheCfg, AmdK7InstrCacheCfg, 0x201000, 0, 0), /* value=0x201000 */
    MFX(0xc0011022, "AMD_K7_DC_CFG", AmdK7DataCacheCfg, AmdK7DataCacheCfg, 0, UINT64_C(0xfffffffff000000), 0), /* value=0x500000 */
    MFN(0xc0011023, "AMD_K7_BU_CFG", AmdK7BusUnitCfg, AmdK7BusUnitCfg), /* Villain? value=0x20000`00000000 */
    MFX(0xc0011024, "AMD_K7_DEBUG_CTL_2?", AmdK7DebugCtl2Maybe, AmdK7DebugCtl2Maybe, 0, UINT64_C(0xfffffffffffffffc), 0), /* value=0x0 */
    MFN(0xc0011025, "AMD_K7_DR0_DATA_MATCH?", AmdK7Dr0DataMatchMaybe, AmdK7Dr0DataMatchMaybe), /* value=0x0 */
    MFN(0xc0011026, "AMD_K7_DR0_DATA_MATCH?", AmdK7Dr0DataMaskMaybe, AmdK7Dr0DataMaskMaybe), /* value=0x0 */
    MFX(0xc0011027, "AMD_K7_DR0_ADDR_MASK", AmdK7DrXAddrMaskN, AmdK7DrXAddrMaskN, 0x0, ~(uint64_t)UINT32_MAX, 0), /* value=0x0 */
    MFX(0xc0011028, "AMD_15H_FP_CFG", AmdFam15hFpuCfg, AmdFam15hFpuCfg, 0, UINT64_C(0xffa0f0fc0004fc00), 0), /* value=0x140a00`248000d4 */
    MFX(0xc0011029, "AMD_15H_DC_CFG", AmdFam15hDecoderCfg, AmdFam15hDecoderCfg, 0, 0x18001, 0), /* value=0x10e26002 */
    MFN(0xc001102a, "AMD_10H_BU_CFG2", AmdFam10hBusUnitCfg2, AmdFam10hBusUnitCfg2), /* value=0x6800000`00028080 */
    MVX(0xc001102b, "TODO_c001_102b", 0x1808cc17, 0, 0),
    MVI(0xc001102c, "TODO_c001_102c", UINT64_C(0x68000000000000)), /* Villain? */
    MVX(0xc001102d, "TODO_c001_102d", UINT64_C(0x1000000500000020), UINT64_C(0x1ffc0ffe00000), 0),
    MVX(0xc001102e, "TODO_c001_102e", 0x1, ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc001102f, "TODO_c001_102f", 0, UINT64_C(0xffff000000000000), 0),
    MFX(0xc0011030, "AMD_10H_IBS_FETCH_CTL", AmdFam10hIbsFetchCtl, AmdFam10hIbsFetchCtl, 0, UINT64_C(0xfdfeffffffff0000), 0), /* value=0x0 */
    MFX(0xc0011031, "AMD_10H_IBS_FETCH_LIN_ADDR", AmdFam10hIbsFetchLinAddr, AmdFam10hIbsFetchLinAddr, 0, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFX(0xc0011032, "AMD_10H_IBS_FETCH_PHYS_ADDR", AmdFam10hIbsFetchPhysAddr, AmdFam10hIbsFetchPhysAddr, 0, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFX(0xc0011033, "AMD_10H_IBS_OP_EXEC_CTL", AmdFam10hIbsOpExecCtl, AmdFam10hIbsOpExecCtl, 0, UINT64_C(0xf8000000f8010000), 0), /* value=0x0 */
    MFN(0xc0011034, "AMD_10H_IBS_OP_RIP", AmdFam10hIbsOpRip, AmdFam10hIbsOpRip), /* value=0x0 */
    MFX(0xc0011035, "AMD_10H_IBS_OP_DATA", AmdFam10hIbsOpData, AmdFam10hIbsOpData, 0, UINT64_C(0xfffffe0300000000), 0), /* value=0x0 */
    MFX(0xc0011036, "AMD_10H_IBS_OP_DATA2", AmdFam10hIbsOpData2, AmdFam10hIbsOpData2, 0, UINT64_C(0xffffffffffffffc8), 0), /* value=0x0 */
    MFX(0xc0011037, "AMD_10H_IBS_OP_DATA3", AmdFam10hIbsOpData3, AmdFam10hIbsOpData3, 0, 0x1e00, 0), /* value=0x0 */
    MFN(0xc0011038, "AMD_10H_IBS_DC_LIN_ADDR", AmdFam10hIbsDcLinAddr, AmdFam10hIbsDcLinAddr), /* value=0x0 */
    MFX(0xc0011039, "AMD_10H_IBS_DC_PHYS_ADDR", AmdFam10hIbsDcPhysAddr, AmdFam10hIbsDcPhysAddr, 0, UINT64_C(0xffff000000000000), 0), /* value=0x0 */
    MFO(0xc001103a, "AMD_10H_IBS_CTL", AmdFam10hIbsCtl), /* value=0x100 */
    MFN(0xc001103b, "AMD_14H_IBS_BR_TARGET", AmdFam14hIbsBrTarget, AmdFam14hIbsBrTarget), /* value=0x0 */
    MVI(0xc001103c, "TODO_c001_103c", 0),
    MVX(0xc0011041, "AMD_15H_UNK_c001_1041", 0, ~(uint64_t)UINT32_MAX, 0),
    MVI(0xc0011042, "AMD_15H_UNK_c001_1042", 0),
    MVX(0xc0011074, "TODO_c001_1074", UINT64_C(0x8000000000000000), UINT64_C(0x8fffffffffffffff), 0),
    MVX(0xc0011075, "TODO_c001_1075", 0, UINT64_C(0xfffffffff0000000), 0),
    MVX(0xc0011076, "TODO_c001_1076", 0x14, UINT64_C(0xffffffffffffffe0), 0),
    MVI(0xc0011077, "TODO_c001_1077", UINT64_C(0xd400005d5150595b)),
    MVI(0xc0011078, "TODO_c001_1078", 0),
    MVI(0xc0011083, "TODO_c001_1083", UINT64_C(0x1bc6f1bc1bc6f1bc)),
    MVX(0xc0011093, "TODO_c001_1093", 0xe860e0, ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0011094, "TODO_c001_1094", 0x11fd, ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0011095, "TODO_c001_1095", 0, ~(uint64_t)UINT32_MAX, 0),
    MVX(0xc0011096, "TODO_c001_1096", 0, UINT64_C(0xffffffff87ff0000), 0),
    MVX(0xc0011097, "TODO_c001_1097", 0xff6, UINT64_C(0xffffffffffffc000), 0),
    MVO(0xc00110a2, "TODO_c001_10a2", UINT32_C(0xfeb00000)),
    MFN(0xc00110e0, "TODO_c001_10e0", WriteOnly, IgnoreWrite),
};
#endif /* !CPUM_DB_STANDALONE */


/**
 * Database entry for Hygon C86 7185 32-core Processor.
 */
static CPUMDBENTRY const g_Entry_Hygon_C86_7185_32_core =
{
    /*.pszName          = */ "Hygon C86 7185 32-core",
    /*.pszFullName      = */ "Hygon C86 7185 32-core Processor",
    /*.enmVendor        = */ CPUMCPUVENDOR_HYGON,
    /*.uFamily          = */ 24,
    /*.uModel           = */ 0,
    /*.uStepping        = */ 1,
    /*.enmMicroarch     = */ kCpumMicroarch_Hygon_Dhyana,
    /*.uScalableBusFreq = */ CPUM_SBUSFREQ_UNKNOWN,
    /*.fFlags           = */ 0,
    /*.cMaxPhysAddrWidth= */ 48,
    /*.fMxCsrMask       = */ 0x0002ffff,
    /*.paCpuIdLeaves    = */ NULL_ALONE(g_aCpuIdLeaves_Hygon_C86_7185_32_core),
    /*.cCpuIdLeaves     = */ ZERO_ALONE(RT_ELEMENTS(g_aCpuIdLeaves_Hygon_C86_7185_32_core)),
    /*.enmUnknownCpuId  = */ CPUMUNKNOWNCPUID_DEFAULTS,
    /*.DefUnknownCpuId  = */ { 0x00000000, 0x00000000, 0x00000000, 0x00000000 },
    /*.fMsrMask         = */ UINT32_MAX,
    /*.cMsrRanges       = */ ZERO_ALONE(RT_ELEMENTS(g_aMsrRanges_Hygon_C86_7185_32_core)),
    /*.paMsrRanges      = */ NULL_ALONE(g_aMsrRanges_Hygon_C86_7185_32_core),
};

#endif /* !VBOX_CPUDB_Hygon_C86_7185_32_core_h */

