// Copyright 2016 The Bazel Authors. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package com.google.testing.junit.runner.junit4;

import com.google.testing.junit.runner.util.Factory;

/**
 * A factory that supplies {@link JUnit4Options}.
 */
public final class JUnit4OptionsFactory implements Factory<JUnit4Options> {
  private final JUnit4InstanceModules.Config module;

  public JUnit4OptionsFactory(JUnit4InstanceModules.Config module) {
    assert module != null;
    this.module = module;
  }

  @Override
  public JUnit4Options get() {
    JUnit4Options options = module.options();
    assert options != null;
    return options;
  }

  public static Factory<JUnit4Options> create(JUnit4InstanceModules.Config module) {
    return new JUnit4OptionsFactory(module);
  }
}
