{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdStripCount: TMFInt32;
    { Internal wrapper for property @link(StripCount). This wrapper API may change, we advise to access simpler @link(StripCount) instead. }
    public property FdStripCount: TMFInt32 read FFdStripCount;
    {  }
    procedure SetStripCount(const Value: array of LongInt); overload;
    {  }
    procedure SetStripCount(const Value: TLongIntList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TTriangleStripSetNode ----------------------------------------------- }

procedure TTriangleStripSetNode.SetStripCount(const Value: array of LongInt);
begin
  FdStripCount.Send(Value);
end;

procedure TTriangleStripSetNode.SetStripCount(const Value: TLongIntList);
begin
  FdStripCount.Send(Value);
end;

class function TTriangleStripSetNode.ClassX3DType: String;
begin
  Result := 'TriangleStripSet';
end;

procedure TTriangleStripSetNode.CreateNode;
begin
  inherited;

  FFdStripCount := TMFInt32.Create(Self, True, 'stripCount', []);
   FdStripCount.ChangeAlways := chGeometry;
  AddField(FFdStripCount);
end;

{$endif read_implementation}
