/*
 * Copyright (c) 2002 Robert Collins.
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     A copy of the GNU General Public License can be found at
 *     http://www.gnu.org/
 *
 * Written by Robert Collins <robertc@hotmail.com>
 *
 */

#include "Path.h"

Path::Path () :  _name (), _basename(), _dirname ()
{}

Path::Path (Path const &old) :  _name (old._name), _basename(old._basename), _dirname (old._dirname)
{
}

Path::Path (string const &aDir)
{
    setToString (aDir);
}

Path::~Path(){}

Path& 
Path::operator= (string const &aDir)
{
    setToString (aDir);
    return *this;
}

Path& 
Path::operator= (Path const &old)
{
    _name = old._name;
    _basename = old._basename;
    _dirname = old._dirname;
    return *this;
}

Path
Path::operator + (Path const &rhs) const
{
    /* Path a + Path b */
    /* thoughts:
     * case 1) b is relative (does not start with /)
     * case 2) b is absolute, throw exception.
     * case 1a) b has more .. elements than a has elements. Throw exception.
     * XXX if needed, implement the above rules.
     * for now: concat the full names, and set to string.
     */
    Path result (_name + "/" + rhs._name);
    return result;
}

void
Path::StripSlash (string &aString)
{
    if (aString[aString.size() - 1] == '/' && aString.size() > 1)
      aString.erase (aString.size() - 1);
}

void
Path::setToString (string const &aDir)
{
    if (!aDir.size())
	throw (string) "Illegal Path \"\"";
    _name = aDir;
    StripSlash (_name);
    _dirname = _name;
    unsigned int offset = _dirname.rfind ("/");
    if (offset != string::npos) {
	_basename = _dirname.substr (offset + 1);
	_dirname.erase(offset);
        /* dirname must be '/' at a minimum when a '/' was provided */
	if (!_dirname.size())
	    _dirname = '/';
    } else {
	_dirname = '.';
	_basename = _name;
    }
}

/*
 *   1. If string is //, skip steps 2 to 5.

   2. If string consists entirely of slash characters, string will be set to a single slash character. In this case, skip steps 3 to 8.

   3. If there are any trailing slash characters in string, they will be removed.

   4. If there are no slash characters remaining in string, string will be set to a single period character. In this case, skip steps 5 to 8.

   5. If there are any trailing non-slash characters in string, they will be removed.

   6. If the remaining string is //, it is implementation-dependent whether steps 7 and 8 are skipped or processed.

   7. If there are any trailing slash characters in string, they will be removed.

   8. If the remaining string is empty, string will be set to a single slash character.

The resulting string will be written to standard output. 
*/
