#include "wakeupthread"

void Wakeupthread::execute() {
    Threadlist::desc("Wakeup thread");
    
    while (1) {
	if (config.wakeupsec()) {
	    for (unsigned i = 0; i < balancer.nbackends(); i++) {
		if (! balancer.backend(i).live()) {
		    Backend target(balancer.backend(i).backenddef());
		    try {
			target.check();
			if (target.live()) {
			    msg ("Wakeup call: backend " +
				 target.description() +
				 " has awoken\n");
			    balancer.backend(i).live(true);
			} else
			    balancer.backend(i).markconnecterror();
		    } catch (...) {
			socketclose(target.sock());
		    }
		}
	    }
	    sleep (config.wakeupsec());
	} else
	    sleep(30);
    }
}

