#include "httpdispatcher"

void HttpDispatcher::handle() {
    PROFILE("HttpDispatcher::handle");

    // The client request was already retrieved before starting the
    // dispatcher. We can continue by applying server-directed headers.
    if (config.addxrversion())
	buf().setheader ("XR", VER);
    if (config.addxforwardedfor())
	buf().addheader ("X-Forwarded-For", clientipstr());
    for (unsigned n = 0; n < config.nserverheaders(); n++)
	buf().setheader (config.serverheader(n));

    // Patch up the Host: header if requested so.
    if (config.replacehostheader())
	buf().replaceheader("Host:",
			  balancer.backend(targetbackend()).server());
    
    // Flush client info received so far to the back end.
    debugmsg("Sending client request to back end\n");
    buf().netwrite(backendfd(), config.backend_write_timeout());

    // Let's see if we will need to modify the server headers.
    bool modify_serverheaders = false;
    if (config.addxrversion() ||
	(config.stickyhttp() && !issticky()))
	modify_serverheaders = true;

    // Store the client request. May want to log it later.
    string client_request = buf().firstline();

    // Go into copy-thru mode. If required, catch the server headers on
    // their first appearance and modify them.
    bool backend_response_checked = false;
    while (1) {
	Fdset readset (maxtimeout(config.client_read_timeout(),
				  config.backend_read_timeout()));
	readset.add(clientfd());
	readset.add(backendfd());
	readset.wait_r();

	int sock;
	if (readset.readable(clientfd()))
	    sock = clientfd();
	else if (readset.readable(backendfd()))
	    sock = backendfd();
	else
	    break;
	
	buf().reset();
	
	if (!buf().netread(sock))
	    break;

	if (sock == backendfd() && modify_serverheaders) {
	    debugmsg("Back end response seen, applying modifications\n");
	    modify_serverheaders = false;
	    while (! buf().headersreceived())
		if (!buf().netread (sock, config.backend_read_timeout()))
		    throw Error("Failed to get headers from back end");
	    if (config.addxrversion())
		buf().setheader("XR", VER);
	    if (config.stickyhttp() && !issticky()) {
		ostringstream o;
		o << "XRTarget=" << targetbackend() << "; path=/";
		buf().setheader("Set-Cookie", o.str());
	    }
	}
	
	// The back end response may now get flushed to the client. 
	// If the response code is 4** or 5**, log it as a warning.
	if (!backend_response_checked &&
	    sock == backendfd() && buf().headersreceived()) {
	    string respcode = buf().stringat(9, 3);
	    if (respcode[0] == '4' || respcode[0] == '5')
		warnmsg("HTTP back end indicates fault: '" +
			buf().firstline() + "' as response to '" +
			client_request + "'\n");
	    backend_response_checked = true;
	}

	// Flush info to the other connected side.
	int othersock, timeout;
	if (sock == clientfd()) {
	    othersock = backendfd();
	    timeout = config.backend_read_timeout();
	    // Re-patch Host header if requested
	    if (config.replacehostheader())
		buf().replaceheader("Host:",
				  balancer.backend(targetbackend()).server());
	} else {
	    othersock = clientfd();
	    timeout = config.client_read_timeout();
	}

	debugmsg (Mstr("Had data on ") + sock +
		  (Mstr(", sending to ") + othersock) + "\n");

	buf().netwrite(othersock, timeout);
	if (sock == backendfd())
	    balancer.backend(targetbackend()).addbytes(buf().bufsz());
    }

}
