/***************************************************************************
 *     Copyright (c) 1999-2009, Broadcom Corporation
 *
 **********************************************************************
 * This file is part of the crystalhd device driver.
 *
 * This driver is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2 of the License.
 *
 * This driver is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this driver.  If not, see <http://www.gnu.org/licenses/>.
 **********************************************************************
 *
 * $brcm_Workfile: bchp_misc1.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:11p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:40 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_misc1.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:11p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_MISC1_H__
#define BCHP_MISC1_H__

/***************************************************************************
 *MISC1 - Registers for DMA List Control
 ***************************************************************************/
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST0    0x00502000 /* Tx DMA Descriptor List0 First Descriptor lower Address */
#define BCHP_MISC1_TX_FIRST_DESC_U_ADDR_LIST0    0x00502004 /* Tx DMA Descriptor List0 First Descriptor Upper Address */
#define BCHP_MISC1_TX_FIRST_DESC_L_ADDR_LIST1    0x00502008 /* Tx DMA Descriptor List1 First Descriptor Lower Address */
#define BCHP_MISC1_TX_FIRST_DESC_U_ADDR_LIST1    0x0050200c /* Tx DMA Descriptor List1 First Descriptor Upper Address */
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS      0x00502010 /* Tx DMA Software Descriptor List Control and Status */
#define BCHP_MISC1_TX_DMA_ERROR_STATUS           0x00502018 /* Tx DMA Engine Error Status */
#define BCHP_MISC1_TX_DMA_CTRL                   0x00502034 /* Tx DMA Flea Interface Control */
#define BCHP_MISC1_Y_RX_SW_DESC_LIST_CTRL_STS    0x00502050 /* Y Rx Software Descriptor List Control and Status */
#define BCHP_MISC1_Y_RX_ERROR_STATUS             0x00502054 /* Y Rx Engine Error Status */
#define BCHP_MISC1_Y_RX_LIST0_CUR_BYTE_CNT       0x00502060 /* Y Rx List0 Current Descriptor Byte Count */
#define BCHP_MISC1_Y_RX_LIST1_CUR_BYTE_CNT       0x0050206c /* Y Rx List1 Current Descriptor Byte Count */
#define BCHP_MISC1_HIF_RX_ERROR_STATUS           0x00502094 /* HIF Rx Engine Error Status */
#define BCHP_MISC1_HIF_RX_LIST0_CUR_BYTE_CNT     0x005020a0 /* HIF Rx List0 Current Descriptor Byte Count */
#define BCHP_MISC1_HIF_RX_LIST1_CUR_BYTE_CNT     0x005020ac /* HIF Rx List1 Current Descriptor Byte Count */
#define BCHP_MISC1_HIF_DMA_CTRL                  0x005020b0 /* HIF Rx DMA Flea Interface Control */
#define BCHP_MISC1_DMA_DEBUG_OPTIONS_REG         0x005020c0 /* DMA Debug Options Register */

/***************************************************************************
 *TX_SW_DESC_LIST_CTRL_STS - Tx DMA Software Descriptor List Control and Status
 ***************************************************************************/
/* MISC1 :: TX_SW_DESC_LIST_CTRL_STS :: TX_DMA_RUN_STOP [00:00] */
#define BCHP_MISC1_TX_SW_DESC_LIST_CTRL_STS_TX_DMA_RUN_STOP_MASK   0x00000001

#endif /* #ifndef BCHP_MISC1_H__ */

/**********************************************************************
 *
 * $brcm_Workfile: bchp_misc2.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:11p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:37 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_misc2.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:11p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_MISC2_H__
#define BCHP_MISC2_H__

/***************************************************************************
 *MISC2 - Registers for Meta DMA, Direct DRAM Access, Global Controls
 ***************************************************************************/
#define BCHP_MISC2_DIRECT_WINDOW_CONTROL         0x00502120 /* Direct DRAM Access Window Control */

/***************************************************************************
 *DIRECT_WINDOW_CONTROL - Direct DRAM Access Window Control
 ***************************************************************************/
/* MISC2 :: DIRECT_WINDOW_CONTROL :: DIRECT_WINDOW_BASE_ADDR [31:16] */
#define BCHP_MISC2_DIRECT_WINDOW_CONTROL_DIRECT_WINDOW_BASE_ADDR_MASK 0xffff0000

/* MISC2 :: DIRECT_WINDOW_CONTROL :: DIRECT_WINDOW_ENABLE [00:00] */
#define BCHP_MISC2_DIRECT_WINDOW_CONTROL_DIRECT_WINDOW_ENABLE_MASK 0x00000001

#endif /* #ifndef BCHP_MISC2_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_misc3.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:11p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:19 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_misc3.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:11p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_MISC3_H__
#define BCHP_MISC3_H__

/***************************************************************************
 *MISC3 - Registers for Reset, Options, DMA Checksums
 ***************************************************************************/
#define BCHP_MISC3_RESET_CTRL                    0x00502200 /* Reset Control Register */

#endif /* #ifndef BCHP_MISC3_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_scrub_ctrl.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:18p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:19 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_scrub_ctrl.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:18p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_SCRUB_CTRL_H__
#define BCHP_SCRUB_CTRL_H__

/***************************************************************************
 *SCRUB_CTRL - Scrub Control Registers
 ***************************************************************************/
#define BCHP_SCRUB_CTRL_SCRUB_ENABLE             0x000f6000 /* Secure Sequencer Enable */
#define BCHP_SCRUB_CTRL_BORCH_END_ADDRESS        0x000f6004 /* ARM Bridge Out-of-Range Checker End Address */
#define BCHP_SCRUB_CTRL_STARCH_END_ADDRESS       0x000f6008 /* Static ARCH End Address */
#define BCHP_SCRUB_CTRL_BI_CMAC_31_0             0x000f600c /* Boot Image CMAC value[31:0] */
#define BCHP_SCRUB_CTRL_BI_CMAC_63_32            0x000f6010 /* Boot Image CMAC value[63:32] */
#define BCHP_SCRUB_CTRL_BI_CMAC_95_64            0x000f6014 /* Boot Image CMAC value[95:64] */
#define BCHP_SCRUB_CTRL_BI_CMAC_127_96           0x000f6018 /* Boot Image CMAC value[127:96] */

/***************************************************************************
 *SCRUB_ENABLE - Secure Sequencer Enable
 ***************************************************************************/
/* SCRUB_CTRL :: SCRUB_ENABLE :: DSCRAM_EN [01:01] */
#define BCHP_SCRUB_CTRL_SCRUB_ENABLE_DSCRAM_EN_SHIFT               1

/* SCRUB_CTRL :: SCRUB_ENABLE :: SCRUB_EN [00:00] */
#define BCHP_SCRUB_CTRL_SCRUB_ENABLE_SCRUB_EN_SHIFT                0

/***************************************************************************
 *BORCH_END_ADDRESS - ARM Bridge Out-of-Range Checker End Address
 ***************************************************************************/
/* SCRUB_CTRL :: BORCH_END_ADDRESS :: BORCH_END_ADDR [26:00] */
#define BCHP_SCRUB_CTRL_BORCH_END_ADDRESS_BORCH_END_ADDR_MASK      0x07ffffff

#endif /* #ifndef BCHP_SCRUB_CTRL_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_wrap_misc_intr2.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:23p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:43:21 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_wrap_misc_intr2.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:23p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_WRAP_MISC_INTR2_H__
#define BCHP_WRAP_MISC_INTR2_H__

/***************************************************************************
 *WRAP_MISC_INTR2 - MISC block Level 2 Interrupt Controller
 ***************************************************************************/
#define BCHP_WRAP_MISC_INTR2_CPU_STATUS          0x000f2000 /* CPU interrupt Status Register */
#define BCHP_WRAP_MISC_INTR2_PCI_STATUS          0x000f2018 /* PCI interrupt Status Register */
#define BCHP_WRAP_MISC_INTR2_PCI_CLEAR           0x000f2020 /* PCI interrupt Clear Register */

/***************************************************************************
 *CPU_STATUS - CPU interrupt Status Register
 ***************************************************************************/
/* WRAP_MISC_INTR2 :: CPU_STATUS :: BOOT_VER_FAIL_INTR [23:23] */
#define BCHP_WRAP_MISC_INTR2_CPU_STATUS_BOOT_VER_FAIL_INTR_SHIFT   23

/* WRAP_MISC_INTR2 :: CPU_STATUS :: BOOT_VER_DONE_INTR [22:22] */
#define BCHP_WRAP_MISC_INTR2_CPU_STATUS_BOOT_VER_DONE_INTR_SHIFT   22

/* WRAP_MISC_INTR2 :: CPU_STATUS :: SCRM_KEY_DONE_INTR [19:19] */
#define BCHP_WRAP_MISC_INTR2_CPU_STATUS_SCRM_KEY_DONE_INTR_SHIFT   19

/* WRAP_MISC_INTR2 :: CPU_STATUS :: SHARF_ERR_INTR [04:04] */
#define BCHP_WRAP_MISC_INTR2_CPU_STATUS_SHARF_ERR_INTR_SHIFT       4

#endif /* #ifndef BCHP_WRAP_MISC_INTR2_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_armcr4_bridge.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:28p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:56 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_armcr4_bridge.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:28p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_ARMCR4_BRIDGE_H__
#define BCHP_ARMCR4_BRIDGE_H__

/***************************************************************************
 *ARMCR4_BRIDGE - ARM Cortex R4 Bridge control registers
 ***************************************************************************/
#define BCHP_ARMCR4_BRIDGE_REG_CORE_REV_ID       0x000e0000 /* ARM Cortex R4 bridge revision ID */
#define BCHP_ARMCR4_BRIDGE_REG_BRIDGE_CTL        0x000e0004 /* Bridge interface and buffer configuration
 */
#define BCHP_ARMCR4_BRIDGE_REG_ARM_CTL           0x000e0008 /* ARM core configuration */
#define BCHP_ARMCR4_BRIDGE_REG_BRIDGE_STS        0x000e0014 /* Bridge interface and buffer status */
#define BCHP_ARMCR4_BRIDGE_REG_MBOX_PCI1         0x000e0018 /* PCI mailbox #1 */
#define BCHP_ARMCR4_BRIDGE_REG_MBOX_ARM1         0x000e001c /* ARM mailbox #1 */
#define BCHP_ARMCR4_BRIDGE_REG_MBOX_PCI2         0x000e0020 /* PCI mailbox #2 */
#define BCHP_ARMCR4_BRIDGE_REG_MBOX_ARM2         0x000e0024 /* ARM mailbox #2 */
#define BCHP_ARMCR4_BRIDGE_REG_MBOX_PCI3         0x000e0028 /* PCI mailbox #3 */
#define BCHP_ARMCR4_BRIDGE_REG_MBOX_ARM3         0x000e002c /* ARM mailbox #3 */
#define BCHP_ARMCR4_BRIDGE_REG_MBOX_PCI4         0x000e0030 /* PCI mailbox #4 */
#define BCHP_ARMCR4_BRIDGE_REG_MBOX_ARM4         0x000e0034 /* ARM mailbox #4 */
#define BCHP_ARMCR4_BRIDGE_REG_SEMAPHORE_1       0x000e0038 /* CPU semaphore #1 */
#define BCHP_ARMCR4_BRIDGE_REG_SEMAPHORE_2       0x000e003c /* CPU semaphore #2 */
#define BCHP_ARMCR4_BRIDGE_REG_SEMAPHORE_3       0x000e0040 /* CPU semaphore #3 */
#define BCHP_ARMCR4_BRIDGE_REG_SEMAPHORE_4       0x000e0044 /* CPU semaphore #4 */
#define BCHP_ARMCR4_BRIDGE_REG_SCRATCH_1         0x000e0048 /* CPU scratchpad #1 */
#define BCHP_ARMCR4_BRIDGE_REG_SCRATCH_2         0x000e004c /* CPU scratchpad #2 */
#define BCHP_ARMCR4_BRIDGE_REG_SCRATCH_3         0x000e0050 /* CPU scratchpad #3 */
#define BCHP_ARMCR4_BRIDGE_REG_SCRATCH_4         0x000e0054 /* CPU scratchpad #4 */
#define BCHP_ARMCR4_BRIDGE_REG_SCRATCH_5         0x000e0058 /* CPU scratchpad #5 */
#define BCHP_ARMCR4_BRIDGE_REG_SCRATCH_6         0x000e005c /* CPU scratchpad #6 */
#define BCHP_ARMCR4_BRIDGE_REG_SCRATCH_7         0x000e0060 /* CPU scratchpad #7 */
#define BCHP_ARMCR4_BRIDGE_REG_SCRATCH_8         0x000e0064 /* CPU scratchpad #8 */
#define BCHP_ARMCR4_BRIDGE_REG_SCRATCH_9         0x000e0068 /* CPU scratchpad #9 */
#define BCHP_ARMCR4_BRIDGE_REG_PERF_CONFIG       0x000e006c /* Performance monitor configuration */
#define BCHP_ARMCR4_BRIDGE_REG_PERF_LIMIT        0x000e0070 /* Performance monitor count threshold */
#define BCHP_ARMCR4_BRIDGE_REG_PERF_WR_CNT       0x000e0074 /* Counts the number of merge buffer updates (hits + misses) */
#define BCHP_ARMCR4_BRIDGE_REG_PERF_WR_MISS      0x000e0078 /* Counts the number of merge buffer misses */
#define BCHP_ARMCR4_BRIDGE_REG_PERF_RD_CNT       0x000e007c /* Counts the number of prefetch buffer accesses (hits + misses) */
#define BCHP_ARMCR4_BRIDGE_REG_PERF_RD_MISS      0x000e0080 /* Counts the number of prefetch buffer misses */
#define BCHP_ARMCR4_BRIDGE_REG_MEMORY_TM1        0x000e0084 /* ARM memory TM1 control register */
#define BCHP_ARMCR4_BRIDGE_REG_MEMORY_TM2        0x000e0088 /* ARM memory TM2 control register */
#define BCHP_ARMCR4_BRIDGE_REG_MEMORY_TM3        0x000e008c /* ARM memory TM3 control register */
#define BCHP_ARMCR4_BRIDGE_REG_FIFO_STATUS       0x000e0090 /* Fifo Status */
#define BCHP_ARMCR4_BRIDGE_REG_BORCH_STATUS      0x000e0094 /* Bridge Out-of-range Checker Status */
#define BCHP_ARMCR4_BRIDGE_REG_MEMORY_TM4        0x000e0098 /* ARM memory TM4 control register */


/***************************************************************************
 *REG_BRIDGE_CTL - Bridge interface and buffer configuration
 ***************************************************************************/
/* ARMCR4_BRIDGE :: REG_BRIDGE_CTL :: arm_run_request [01:01] */
#define BCHP_ARMCR4_BRIDGE_REG_BRIDGE_CTL_arm_run_request_SHIFT    1

#endif /* #ifndef BCHP_ARMCR4_BRIDGE_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_intr.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:09p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:44 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_intr.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:09p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_INTR_H__
#define BCHP_INTR_H__

/***************************************************************************
 *INTR - TGT L2 Interrupt Controller Registers
 ***************************************************************************/
#define BCHP_INTR_INTR_STATUS                    0x00500700 /* Interrupt Status Register */
#define BCHP_INTR_INTR_CLR_REG                   0x00500708 /* Interrupt Clear Register */
#define BCHP_INTR_INTR_MSK_SET_REG               0x00500710 /* Interrupt Mask Set Register */
#define BCHP_INTR_INTR_MSK_CLR_REG               0x00500714 /* Interrupt Mask Clear Register */
#define BCHP_INTR_EOI_CTRL                       0x00500718 /* End of interrupt control register */


#endif /* #ifndef BCHP_INTR_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_pri_arb_control_regs.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:14p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:43:12 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_pri_arb_control_regs.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:14p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_PRI_ARB_CONTROL_REGS_H__
#define BCHP_PRI_ARB_CONTROL_REGS_H__

/***************************************************************************
 *PRI_ARB_CONTROL_REGS - PRIMARY_ARB control registers
 ***************************************************************************/
#define BCHP_PRI_ARB_CONTROL_REGS_REFRESH_CTL_0  0x0040cb00 /* Refresh client control for ddr interface #0 */
#define BCHP_PRI_ARB_CONTROL_REGS_MASTER_CTL     0x0040cb30 /* Master Control */

/***************************************************************************
 *REFRESH_CTL_0 - Refresh client control for ddr interface #0
 ***************************************************************************/
/* PRI_ARB_CONTROL_REGS :: REFRESH_CTL_0 :: enable [12:12] */
#define BCHP_PRI_ARB_CONTROL_REGS_REFRESH_CTL_0_enable_MASK        0x00001000

/***************************************************************************
 *MASTER_CTL - Master Control
 ***************************************************************************/
/* PRI_ARB_CONTROL_REGS :: MASTER_CTL :: arb_disable [00:00] */
#define BCHP_PRI_ARB_CONTROL_REGS_MASTER_CTL_arb_disable_Enable    0
#define BCHP_PRI_ARB_CONTROL_REGS_MASTER_CTL_arb_disable_Disable   1

#endif /* #ifndef BCHP_PRI_ARB_CONTROL_REGS_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_ddr23_ctl_regs_0.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 7:59p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:43:08 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_ddr23_ctl_regs_0.h $
 *
 * Hydra_Software_Devel/1   7/17/09 7:59p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_DDR23_CTL_REGS_0_H__
#define BCHP_DDR23_CTL_REGS_0_H__

/***************************************************************************
 *DDR23_CTL_REGS_0 - DDR23 controller registers
 ***************************************************************************/
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS         0x01800004 /* DDR23 Controller status register */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1            0x01800010 /* DDR23 Controller Configuration Set #1 */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2            0x01800014 /* DDR23 Controller Configuration Set #2 */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3            0x01800018 /* DDR23 Controller Configuration Set #3 */
#define BCHP_DDR23_CTL_REGS_0_REFRESH            0x0180001c /* DDR23 Controller Automated Refresh Configuration */
#define BCHP_DDR23_CTL_REGS_0_REFRESH_CMD        0x01800020 /* Host Initiated Refresh Control */
#define BCHP_DDR23_CTL_REGS_0_PRECHARGE_CMD      0x01800024 /* Host Initiated Precharge Control */
#define BCHP_DDR23_CTL_REGS_0_LOAD_MODE_CMD      0x01800028 /* Host Initiated Load Mode Control */
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE_CMD     0x0180002c /* Host Initiated Load Extended Mode Control */
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE2_CMD    0x01800030 /* Host Initiated Load Extended Mode #2 Control */
#define BCHP_DDR23_CTL_REGS_0_LOAD_EMODE3_CMD    0x01800034 /* Host Initiated Load Extended Mode #3 Control */
#define BCHP_DDR23_CTL_REGS_0_ZQ_CALIBRATE       0x01800038 /* Host Initiated ZQ Calibration Cycle */
#define BCHP_DDR23_CTL_REGS_0_LATENCY            0x01800040 /* DDR2 Controller Access Latency Control */
#define BCHP_DDR23_CTL_REGS_0_SCRATCH            0x01800058 /* Scratch Register */
#define BCHP_DDR23_CTL_REGS_0_UPDATE_VDL         0x018000f0 /* RAM Macro TM Control */

/***************************************************************************
 *CTL_STATUS - DDR23 Controller status register
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: CTL_STATUS :: clke [01:01] */
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_clke_MASK                 0x00000002

/* DDR23_CTL_REGS_0 :: CTL_STATUS :: idle [00:00] */
#define BCHP_DDR23_CTL_REGS_0_CTL_STATUS_idle_MASK                 0x00000001

/***************************************************************************
 *PARAMS1 - DDR23 Controller Configuration Set #1
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PARAMS1 :: trtp [31:28] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trtp_MASK                    0xf0000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trtp_SHIFT                   28

/* DDR23_CTL_REGS_0 :: PARAMS1 :: twl [27:24] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_twl_MASK                     0x0f000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_twl_SHIFT                    24

/* DDR23_CTL_REGS_0 :: PARAMS1 :: tcas [23:20] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_tcas_MASK                    0x00f00000
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_tcas_SHIFT                   20

/* DDR23_CTL_REGS_0 :: PARAMS1 :: twtr [19:16] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_twtr_MASK                    0x000f0000
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_twtr_SHIFT                   16

/* DDR23_CTL_REGS_0 :: PARAMS1 :: twr [15:12] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_twr_MASK                     0x0000f000
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_twr_SHIFT                    12

/* DDR23_CTL_REGS_0 :: PARAMS1 :: trrd [11:08] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trrd_MASK                    0x00000f00
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trrd_SHIFT                   8

/* DDR23_CTL_REGS_0 :: PARAMS1 :: trp [07:04] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trp_MASK                     0x000000f0
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trp_SHIFT                    4

/* DDR23_CTL_REGS_0 :: PARAMS1 :: trcd [03:00] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trcd_MASK                    0x0000000f
#define BCHP_DDR23_CTL_REGS_0_PARAMS1_trcd_SHIFT                   0

/***************************************************************************
 *PARAMS2 - DDR23 Controller Configuration Set #2
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PARAMS2 :: auto_idle [31:31] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_auto_idle_MASK               0x80000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_auto_idle_SHIFT              31

/* DDR23_CTL_REGS_0 :: PARAMS2 :: row_bits [30:30] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_row_bits_MASK                0x40000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_row_bits_SHIFT               30

/* DDR23_CTL_REGS_0 :: PARAMS2 :: use_chr_hgt [29:29] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_use_chr_hgt_MASK             0x20000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_use_chr_hgt_SHIFT            29

/* DDR23_CTL_REGS_0 :: PARAMS2 :: clke [28:28] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_clke_MASK                    0x10000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_clke_SHIFT                   28

/* DDR23_CTL_REGS_0 :: PARAMS2 :: sd_col_bits [27:26] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_sd_col_bits_MASK             0x0c000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_sd_col_bits_SHIFT            26

/* DDR23_CTL_REGS_0 :: PARAMS2 :: il_sel [25:25] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_il_sel_MASK                  0x02000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_il_sel_SHIFT                 25

/* DDR23_CTL_REGS_0 :: PARAMS2 :: dis_itlv [24:24] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_dis_itlv_MASK                0x01000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_dis_itlv_SHIFT               24

/* DDR23_CTL_REGS_0 :: PARAMS2 :: reserved0 [23:23] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_reserved0_MASK               0x00800000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_reserved0_SHIFT              23

/* DDR23_CTL_REGS_0 :: PARAMS2 :: cs0_only [22:22] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_cs0_only_MASK                0x00400000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_cs0_only_SHIFT               22

/* DDR23_CTL_REGS_0 :: PARAMS2 :: allow_pictmem_rd [21:21] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_allow_pictmem_rd_MASK        0x00200000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_allow_pictmem_rd_SHIFT       21

/* DDR23_CTL_REGS_0 :: PARAMS2 :: bank_bits [20:20] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_bank_bits_MASK               0x00100000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_bank_bits_SHIFT              20

/* DDR23_CTL_REGS_0 :: PARAMS2 :: trfc [19:12] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_trfc_MASK                    0x000ff000
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_trfc_SHIFT                   12

/* DDR23_CTL_REGS_0 :: PARAMS2 :: tfaw [11:06] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_tfaw_MASK                    0x00000fc0
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_tfaw_SHIFT                   6

/* DDR23_CTL_REGS_0 :: PARAMS2 :: tras [05:00] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_tras_MASK                    0x0000003f
#define BCHP_DDR23_CTL_REGS_0_PARAMS2_tras_SHIFT                   0

/***************************************************************************
 *PARAMS3 - DDR23 Controller Configuration Set #3
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: PARAMS3 :: ddr3_reset [31:31] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_ddr3_reset_MASK              0x80000000
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_ddr3_reset_SHIFT             31

/* DDR23_CTL_REGS_0 :: PARAMS3 :: reserved0 [30:06] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_reserved0_MASK               0x7fffffc0
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_reserved0_SHIFT              6

/* DDR23_CTL_REGS_0 :: PARAMS3 :: ddr_bl [05:05] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_ddr_bl_MASK                  0x00000020
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_ddr_bl_SHIFT                 5

/* DDR23_CTL_REGS_0 :: PARAMS3 :: cmd_2t [04:04] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_cmd_2t_MASK                  0x00000010
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_cmd_2t_SHIFT                 4

/* DDR23_CTL_REGS_0 :: PARAMS3 :: wr_odt_mode [03:03] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_mode_MASK             0x00000008
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_mode_SHIFT            3

/* DDR23_CTL_REGS_0 :: PARAMS3 :: wr_odt_te_adj [02:02] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_te_adj_MASK           0x00000004
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_te_adj_SHIFT          2

/* DDR23_CTL_REGS_0 :: PARAMS3 :: wr_odt_le_adj [01:01] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_le_adj_MASK           0x00000002
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_le_adj_SHIFT          1

/* DDR23_CTL_REGS_0 :: PARAMS3 :: wr_odt_en [00:00] */
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_en_MASK               0x00000001
#define BCHP_DDR23_CTL_REGS_0_PARAMS3_wr_odt_en_SHIFT              0

/***************************************************************************
 *UPDATE_VDL - RAM Macro TM Control
 ***************************************************************************/
/* DDR23_CTL_REGS_0 :: UPDATE_VDL :: refresh [00:00] */
#define BCHP_DDR23_CTL_REGS_0_UPDATE_VDL_refresh_MASK              0x00000001


#endif /* #ifndef BCHP_DDR23_CTL_REGS_0_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_ddr23_phy_byte_lane_0.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 7:59p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:43:18 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_ddr23_phy_byte_lane_0.h $
 *
 * Hydra_Software_Devel/1   7/17/09 7:59p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_DDR23_PHY_BYTE_LANE_0_H__
#define BCHP_DDR23_PHY_BYTE_LANE_0_H__

/***************************************************************************
 *DDR23_PHY_BYTE_LANE_0 - DDR23 DDR23 byte lane #0 control registers
 ***************************************************************************/
#define BCHP_DDR23_PHY_BYTE_LANE_0_VDL_CALIBRATE 0x01801204 /* Byte lane VDL calibration control register */
#define BCHP_DDR23_PHY_BYTE_LANE_0_VDL_STATUS    0x01801208 /* Byte lane VDL calibration status register */
#define BCHP_DDR23_PHY_BYTE_LANE_0_VDL_OVERRIDE_0 0x01801210 /* Read DQSP VDL static override control register */
#define BCHP_DDR23_PHY_BYTE_LANE_0_VDL_OVERRIDE_1 0x01801214 /* Read DQSN VDL static override control register */
#define BCHP_DDR23_PHY_BYTE_LANE_0_VDL_OVERRIDE_2 0x01801218 /* Read Enable VDL static override control register */
#define BCHP_DDR23_PHY_BYTE_LANE_0_VDL_OVERRIDE_3 0x0180121c /* Write data and mask VDL static override control register */
#define BCHP_DDR23_PHY_BYTE_LANE_0_READ_CONTROL  0x01801230 /* Byte Lane read channel control register */
#define BCHP_DDR23_PHY_BYTE_LANE_0_IDLE_PAD_CONTROL 0x0180123c /* Idle mode SSTL pad control register */
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL 0x01801240 /* SSTL pad drive characteristics control register */
#define BCHP_DDR23_PHY_BYTE_LANE_0_WR_PREAMBLE_MODE 0x01801248 /* Write cycle preamble control register */
#define BCHP_DDR23_PHY_BYTE_LANE_0_CLOCK_REG_CONTROL 0x0180124c /* Clock Regulator control register */

/***************************************************************************
 *READ_CONTROL - Byte Lane read channel control register
 ***************************************************************************/
/* DDR23_PHY_BYTE_LANE_1 :: READ_CONTROL :: rd_data_dly [09:08] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_READ_CONTROL_rd_data_dly_MASK   0x00000300
#define BCHP_DDR23_PHY_BYTE_LANE_0_READ_CONTROL_rd_data_dly_SHIFT  8

/* DDR23_PHY_BYTE_LANE_1 :: READ_CONTROL :: dq_odt_enable [03:03] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_READ_CONTROL_dq_odt_enable_MASK 0x00000008
#define BCHP_DDR23_PHY_BYTE_LANE_0_READ_CONTROL_dq_odt_enable_SHIFT 3

/* DDR23_PHY_BYTE_LANE_1 :: READ_CONTROL :: dq_odt_adj [02:02] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_READ_CONTROL_dq_odt_adj_MASK    0x00000004
#define BCHP_DDR23_PHY_BYTE_LANE_0_READ_CONTROL_dq_odt_adj_SHIFT   2

/* DDR23_PHY_BYTE_LANE_1 :: READ_CONTROL :: rd_enb_odt_enable [01:01] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_READ_CONTROL_rd_enb_odt_enable_MASK 0x00000002
#define BCHP_DDR23_PHY_BYTE_LANE_0_READ_CONTROL_rd_enb_odt_enable_SHIFT 1

/* DDR23_PHY_BYTE_LANE_1 :: READ_CONTROL :: rd_enb_odt_adj [00:00] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_READ_CONTROL_rd_enb_odt_adj_MASK 0x00000001
#define BCHP_DDR23_PHY_BYTE_LANE_0_READ_CONTROL_rd_enb_odt_adj_SHIFT 0

/***************************************************************************
 *IDLE_PAD_CONTROL - Idle mode SSTL pad control register
 ***************************************************************************/
/* DDR23_PHY_BYTE_LANE_1 :: IDLE_PAD_CONTROL :: idle [31:31] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_IDLE_PAD_CONTROL_idle_MASK      0x80000000

/* DDR23_PHY_BYTE_LANE_1 :: IDLE_PAD_CONTROL :: dm_iddq [18:18] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_IDLE_PAD_CONTROL_dm_iddq_MASK   0x00040000

/* DDR23_PHY_BYTE_LANE_1 :: IDLE_PAD_CONTROL :: dq_iddq [14:14] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_IDLE_PAD_CONTROL_dq_iddq_MASK   0x00004000

/* DDR23_PHY_BYTE_LANE_1 :: IDLE_PAD_CONTROL :: read_enb_iddq [10:10] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_IDLE_PAD_CONTROL_read_enb_iddq_MASK 0x00000400

/* DDR23_PHY_BYTE_LANE_1 :: IDLE_PAD_CONTROL :: dqs_iddq [06:06] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_IDLE_PAD_CONTROL_dqs_iddq_MASK  0x00000040

/* DDR23_PHY_BYTE_LANE_1 :: IDLE_PAD_CONTROL :: clk_iddq [02:02] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_IDLE_PAD_CONTROL_clk_iddq_MASK  0x00000004

/***************************************************************************
 *DRIVE_PAD_CTL - SSTL pad drive characteristics control register
 ***************************************************************************/
/* DDR23_PHY_BYTE_LANE_1 :: DRIVE_PAD_CTL :: seltxdrv_ci [02:02] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_seltxdrv_ci_MASK  0x00000004

/***************************************************************************
 *CLOCK_REG_CONTROL - Clock Regulator control register
 ***************************************************************************/
/* DDR23_PHY_BYTE_LANE_1 :: CLOCK_REG_CONTROL :: pwrdn [00:00] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_CLOCK_REG_CONTROL_pwrdn_MASK    0x00000001

#endif /* #ifndef BCHP_DDR23_PHY_BYTE_LANE_0_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_ddr23_phy_byte_lane_1.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 7:59p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:17 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_ddr23_phy_byte_lane_1.h $
 *
 * Hydra_Software_Devel/1   7/17/09 7:59p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_DDR23_PHY_BYTE_LANE_1_H__
#define BCHP_DDR23_PHY_BYTE_LANE_1_H__

/***************************************************************************
 *DDR23_PHY_BYTE_LANE_1 - DDR23 DDR23 byte lane #1 control registers
 ***************************************************************************/
#define BCHP_DDR23_PHY_BYTE_LANE_1_VDL_CALIBRATE 0x01801104 /* Byte lane VDL calibration control register */
#define BCHP_DDR23_PHY_BYTE_LANE_1_VDL_STATUS    0x01801108 /* Byte lane VDL calibration status register */
#define BCHP_DDR23_PHY_BYTE_LANE_1_VDL_OVERRIDE_0 0x01801110 /* Read DQSP VDL static override control register */
#define BCHP_DDR23_PHY_BYTE_LANE_1_VDL_OVERRIDE_1 0x01801114 /* Read DQSN VDL static override control register */
#define BCHP_DDR23_PHY_BYTE_LANE_1_VDL_OVERRIDE_2 0x01801118 /* Read Enable VDL static override control register */
#define BCHP_DDR23_PHY_BYTE_LANE_1_VDL_OVERRIDE_3 0x0180111c /* Write data and mask VDL static override control register */
#define BCHP_DDR23_PHY_BYTE_LANE_1_READ_CONTROL  0x01801130 /* Byte Lane read channel control register */
#define BCHP_DDR23_PHY_BYTE_LANE_1_IDLE_PAD_CONTROL 0x0180113c /* Idle mode SSTL pad control register */
#define BCHP_DDR23_PHY_BYTE_LANE_1_DRIVE_PAD_CTL 0x01801140 /* SSTL pad drive characteristics control register */
#define BCHP_DDR23_PHY_BYTE_LANE_1_CLOCK_PAD_DISABLE 0x01801144 /* Clock pad disable register */
#define BCHP_DDR23_PHY_BYTE_LANE_1_WR_PREAMBLE_MODE 0x01801148 /* Write cycle preamble control register */
#define BCHP_DDR23_PHY_BYTE_LANE_1_CLOCK_REG_CONTROL 0x0180114c /* Clock Regulator control register */

/***************************************************************************
 *READ_CONTROL - Byte Lane read channel control register
 ***************************************************************************/
/* DDR23_PHY_BYTE_LANE_1 :: READ_CONTROL :: dq_odt_enable [03:03] */
#define BCHP_DDR23_PHY_BYTE_LANE_1_READ_CONTROL_dq_odt_enable_MASK 0x00000008

/***************************************************************************
 *IDLE_PAD_CONTROL - Idle mode SSTL pad control register
 ***************************************************************************/
/* DDR23_PHY_BYTE_LANE_1 :: IDLE_PAD_CONTROL :: idle [31:31] */
#define BCHP_DDR23_PHY_BYTE_LANE_1_IDLE_PAD_CONTROL_idle_MASK      0x80000000

/* DDR23_PHY_BYTE_LANE_1 :: IDLE_PAD_CONTROL :: dm_iddq [18:18] */
#define BCHP_DDR23_PHY_BYTE_LANE_1_IDLE_PAD_CONTROL_dm_iddq_MASK   0x00040000

/* DDR23_PHY_BYTE_LANE_1 :: IDLE_PAD_CONTROL :: dq_iddq [14:14] */
#define BCHP_DDR23_PHY_BYTE_LANE_1_IDLE_PAD_CONTROL_dq_iddq_MASK   0x00004000

/* DDR23_PHY_BYTE_LANE_1 :: IDLE_PAD_CONTROL :: read_enb_iddq [10:10] */
#define BCHP_DDR23_PHY_BYTE_LANE_1_IDLE_PAD_CONTROL_read_enb_iddq_MASK 0x00000400

/* DDR23_PHY_BYTE_LANE_1 :: IDLE_PAD_CONTROL :: dqs_iddq [06:06] */
#define BCHP_DDR23_PHY_BYTE_LANE_1_IDLE_PAD_CONTROL_dqs_iddq_MASK  0x00000040

/* DDR23_PHY_BYTE_LANE_1 :: IDLE_PAD_CONTROL :: clk_iddq [02:02] */
#define BCHP_DDR23_PHY_BYTE_LANE_1_IDLE_PAD_CONTROL_clk_iddq_MASK  0x00000004

/***************************************************************************
 *DRIVE_PAD_CTL - SSTL pad drive characteristics control register
 ***************************************************************************/
/* DDR23_PHY_BYTE_LANE_1 :: DRIVE_PAD_CTL :: reserved0 [31:06] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_reserved0_MASK    0xffffffc0
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_reserved0_SHIFT   6

/* DDR23_PHY_BYTE_LANE_1 :: DRIVE_PAD_CTL :: rt60b_ddr_read_enb [05:05] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_rt60b_ddr_read_enb_MASK 0x00000020
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_rt60b_ddr_read_enb_SHIFT 5

/* DDR23_PHY_BYTE_LANE_1 :: DRIVE_PAD_CTL :: rt60b [04:04] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_rt60b_MASK        0x00000010
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_rt60b_SHIFT       4

/* DDR23_PHY_BYTE_LANE_1 :: DRIVE_PAD_CTL :: sel_sstl18 [03:03] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_sel_sstl18_MASK   0x00000008
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_sel_sstl18_SHIFT  3

/* DDR23_PHY_BYTE_LANE_1 :: DRIVE_PAD_CTL :: seltxdrv_ci [02:02] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_seltxdrv_ci_MASK  0x00000004
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_seltxdrv_ci_SHIFT 2

/* DDR23_PHY_BYTE_LANE_1 :: DRIVE_PAD_CTL :: selrxdrv [01:01] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_selrxdrv_MASK     0x00000002
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_selrxdrv_SHIFT    1

/* DDR23_PHY_BYTE_LANE_1 :: DRIVE_PAD_CTL :: slew [00:00] */
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_slew_MASK         0x00000001
#define BCHP_DDR23_PHY_BYTE_LANE_0_DRIVE_PAD_CTL_slew_SHIFT        0

/***************************************************************************
 *CLOCK_PAD_DISABLE - Clock pad disable register
 ***************************************************************************/
/* DDR23_PHY_BYTE_LANE_1 :: CLOCK_PAD_DISABLE :: clk_pad_dis [00:00] */
#define BCHP_DDR23_PHY_BYTE_LANE_1_CLOCK_PAD_DISABLE_clk_pad_dis_MASK 0x00000001

/***************************************************************************
 *CLOCK_REG_CONTROL - Clock Regulator control register
 ***************************************************************************/
/* DDR23_PHY_BYTE_LANE_1 :: CLOCK_REG_CONTROL :: pwrdn [00:00] */
#define BCHP_DDR23_PHY_BYTE_LANE_1_CLOCK_REG_CONTROL_pwrdn_MASK    0x00000001

#endif /* #ifndef BCHP_DDR23_PHY_BYTE_LANE_1_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_ddr23_phy_control_regs.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 7:59p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:21 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_ddr23_phy_control_regs.h $
 *
 * Hydra_Software_Devel/1   7/17/09 7:59p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_DDR23_PHY_CONTROL_REGS_H__
#define BCHP_DDR23_PHY_CONTROL_REGS_H__

/***************************************************************************
 *DDR23_PHY_CONTROL_REGS - DDR23 DDR23 physical interface control registers
 ***************************************************************************/
#define BCHP_DDR23_PHY_CONTROL_REGS_CLK_PM_CTRL  0x01801004 /* PHY clock power management control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_STATUS   0x01801010 /* PHY PLL status register */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG   0x01801014 /* PHY PLL configuration register */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_PRE_DIVIDER 0x01801018 /* PHY PLL pre-divider control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_DIVIDER  0x0180101c /* PHY PLL divider control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_STATIC_VDL_OVERRIDE 0x01801030 /* Address & Control VDL static override control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL 0x01801038 /* Idle mode SSTL pad control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL 0x0180103c /* PVT Compensation control and status register */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL 0x01801040 /* SSTL pad drive characteristics control register */
#define BCHP_DDR23_PHY_CONTROL_REGS_CLOCK_REG_CONTROL 0x01801044 /* Clock Regulator control register */

/***************************************************************************
 *CLK_PM_CTRL - PHY clock power management control register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: CLK_PM_CTRL :: DIS_DDR_CLK [00:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_CLK_PM_CTRL_DIS_DDR_CLK_MASK   0x00000001

/***************************************************************************
 *PLL_CONFIG - PHY PLL configuration register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: ENB_CLKOUT [04:04] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_ENB_CLKOUT_MASK     0x00000010

/* DDR23_PHY_CONTROL_REGS :: PLL_CONFIG :: PWRDN [00:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_PLL_CONFIG_PWRDN_MASK          0x00000001

/***************************************************************************
 *IDLE_PAD_CONTROL - Idle mode SSTL pad control register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: idle [31:31] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_idle_MASK     0x80000000

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: rxenb [08:08] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_rxenb_MASK    0x00000100

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: ctl_iddq [06:06] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_ctl_iddq_MASK 0x00000040

/* DDR23_PHY_CONTROL_REGS :: IDLE_PAD_CONTROL :: cke_reb [01:01] */
#define BCHP_DDR23_PHY_CONTROL_REGS_IDLE_PAD_CONTROL_cke_reb_MASK  0x00000002

/***************************************************************************
 *DRIVE_PAD_CTL - SSTL pad drive characteristics control register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: DRIVE_PAD_CTL :: reserved0 [31:05] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_reserved0_MASK   0xffffffe0
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_reserved0_SHIFT  5

/* DDR23_PHY_CONTROL_REGS :: DRIVE_PAD_CTL :: rt60b [04:04] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_rt60b_MASK       0x00000010
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_rt60b_SHIFT      4

/* DDR23_PHY_CONTROL_REGS :: DRIVE_PAD_CTL :: sel_sstl18 [03:03] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_sel_sstl18_MASK  0x00000008
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_sel_sstl18_SHIFT 3

/* DDR23_PHY_CONTROL_REGS :: DRIVE_PAD_CTL :: seltxdrv_ci [02:02] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_seltxdrv_ci_MASK 0x00000004
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_seltxdrv_ci_SHIFT 2

/* DDR23_PHY_CONTROL_REGS :: DRIVE_PAD_CTL :: selrxdrv [01:01] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_selrxdrv_MASK    0x00000002
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_selrxdrv_SHIFT   1

/* DDR23_PHY_CONTROL_REGS :: DRIVE_PAD_CTL :: slew [00:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_slew_MASK        0x00000001
#define BCHP_DDR23_PHY_CONTROL_REGS_DRIVE_PAD_CTL_slew_SHIFT       0

/***************************************************************************
 *ZQ_PVT_COMP_CTL - PVT Compensation control and status register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: sample_done [28:28] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_sample_done_MASK 0x10000000

/* DDR23_PHY_CONTROL_REGS :: ZQ_PVT_COMP_CTL :: sample_en [26:26] */
#define BCHP_DDR23_PHY_CONTROL_REGS_ZQ_PVT_COMP_CTL_sample_en_MASK 0x04000000

/***************************************************************************
 *CLOCK_REG_CONTROL - Clock Regulator control register
 ***************************************************************************/
/* DDR23_PHY_CONTROL_REGS :: CLOCK_REG_CONTROL :: pwrdn [00:00] */
#define BCHP_DDR23_PHY_CONTROL_REGS_CLOCK_REG_CONTROL_pwrdn_MASK   0x00000001

#endif /* #ifndef BCHP_DDR23_PHY_CONTROL_REGS_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_clk.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 7:58p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:39 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_clk.h $
 *
 * Hydra_Software_Devel/1   7/17/09 7:58p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_CLK_H__
#define BCHP_CLK_H__

/***************************************************************************
 *CLK - CLOCK_GEN Registers
 ***************************************************************************/
#define BCHP_CLK_PM_CTRL                         0x00070004 /* Software power management control to turn off clocks */
#define BCHP_CLK_TEMP_MON_CTRL                   0x00070040 /* Temperature monitor control. */
#define BCHP_CLK_TEMP_MON_STATUS                 0x00070044 /* Temperature monitor status. */
#define BCHP_CLK_PLL0_ARM_DIV                    0x00070110 /* Main PLL0 channel 3 ARM clock divider settings */
#define BCHP_CLK_PLL1_CTRL                       0x00070120 /* Main PLL1 reset, enable, powerdown, and control */

/***************************************************************************
 *PM_CTRL - Software power management control to turn off clocks
 ***************************************************************************/
/* CLK :: PM_CTRL :: DIS_SUN_27_LOW_PWR [25:25] */
#define BCHP_CLK_PM_CTRL_DIS_SUN_27_LOW_PWR_MASK                   0x02000000

/* CLK :: PM_CTRL :: DIS_SUN_108_LOW_PWR [24:24] */
#define BCHP_CLK_PM_CTRL_DIS_SUN_108_LOW_PWR_MASK                  0x01000000

/* CLK :: PM_CTRL :: DIS_MISC_OTP_9_CLK [19:19] */
#define BCHP_CLK_PM_CTRL_DIS_MISC_OTP_9_CLK_MASK                   0x00080000

/* CLK :: PM_CTRL :: DIS_ARM_CLK [18:18] */
#define BCHP_CLK_PM_CTRL_DIS_ARM_CLK_MASK                          0x00040000

/* CLK :: PM_CTRL :: DIS_AVD_CLK [17:17] */
#define BCHP_CLK_PM_CTRL_DIS_AVD_CLK_MASK                          0x00020000

/* CLK :: PM_CTRL :: DIS_BLINK_108_CLK [12:12] */
#define BCHP_CLK_PM_CTRL_DIS_BLINK_108_CLK_MASK                    0x00001000

/* CLK :: PM_CTRL :: DIS_DDR_108_CLK [11:11] */
#define BCHP_CLK_PM_CTRL_DIS_DDR_108_CLK_MASK                      0x00000800

/* CLK :: PM_CTRL :: DIS_AVD_108_CLK [10:10] */
#define BCHP_CLK_PM_CTRL_DIS_AVD_108_CLK_MASK                      0x00000400

/* CLK :: PM_CTRL :: DIS_MISC_108_CLK [09:09] */
#define BCHP_CLK_PM_CTRL_DIS_MISC_108_CLK_MASK                     0x00000200

/* CLK :: PM_CTRL :: DIS_BLINK_216_CLK [04:04] */
#define BCHP_CLK_PM_CTRL_DIS_BLINK_216_CLK_MASK                    0x00000010

/* CLK :: PM_CTRL :: DIS_DDR_216_CLK [03:03] */
#define BCHP_CLK_PM_CTRL_DIS_DDR_216_CLK_MASK                      0x00000008

/* CLK :: PM_CTRL :: DIS_AVD_216_CLK [02:02] */
#define BCHP_CLK_PM_CTRL_DIS_AVD_216_CLK_MASK                      0x00000004

/* CLK :: PM_CTRL :: DIS_MISC_216_CLK [01:01] */
#define BCHP_CLK_PM_CTRL_DIS_MISC_216_CLK_MASK                     0x00000002

/* CLK :: PM_CTRL :: DIS_SUN_216_CLK [00:00] */
#define BCHP_CLK_PM_CTRL_DIS_SUN_216_CLK_MASK                      0x00000001

/***************************************************************************
 *PLL1_CTRL - Main PLL1 reset, enable, powerdown, and control
 ***************************************************************************/
/* CLK :: PLL1_CTRL :: POWERDOWN [03:03] */
#define BCHP_CLK_PLL1_CTRL_POWERDOWN_MASK                          0x00000008

#endif /* #ifndef BCHP_CLK_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_pcie_tl.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:13p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:28 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_pcie_tl.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:13p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_PCIE_TL_H__
#define BCHP_PCIE_TL_H__

/***************************************************************************
 *PCIE_TL - PCIE TL related registers
 ***************************************************************************/
#define BCHP_PCIE_TL_TRANSACTION_CONFIGURATION   0x00500404 /* TRANSACTION_CONFIGURATION Register */

#endif /* #ifndef BCHP_PCIE_TL_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_sun_gisb_arb.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:19p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:30 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_sun_gisb_arb.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:19p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_SUN_GISB_ARB_H__
#define BCHP_SUN_GISB_ARB_H__

/***************************************************************************
 *SUN_GISB_ARB - GISB Arbiter registers
 ***************************************************************************/
#define BCHP_SUN_GISB_ARB_TIMER                  0x0040000c /* GISB ARBITER Timer Value Register */

#endif /* #ifndef BCHP_SUN_GISB_ARB_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_misc_perst.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:12p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:43:23 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_misc_perst.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:12p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_MISC_PERST_H__
#define BCHP_MISC_PERST_H__

/***************************************************************************
 *MISC_PERST - Registers for Link reset on PERST_N
 ***************************************************************************/
#define BCHP_MISC_PERST_CLOCK_CTRL               0x0050229c /* Clock Control Register */

/***************************************************************************
 *CLOCK_CTRL - Clock Control Register
 ***************************************************************************/
/* MISC_PERST :: CLOCK_CTRL :: EARLY_L1_EXIT [02:02] */
#define BCHP_MISC_PERST_CLOCK_CTRL_EARLY_L1_EXIT_MASK              0x00000004

#endif /* #ifndef BCHP_MISC_PERST_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_sun_top_ctrl.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:20p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:43:07 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_sun_top_ctrl.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:20p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_SUN_TOP_CTRL_H__
#define BCHP_SUN_TOP_CTRL_H__

/***************************************************************************
 *SUN_TOP_CTRL - Top Control registers
 ***************************************************************************/
#define BCHP_SUN_TOP_CTRL_PIN_MUX_CTRL_0         0x00404100 /* Pinmux control register 0 */

#endif /* #ifndef BCHP_SUN_TOP_CTRL_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_gio.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:07p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:13 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_gio.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:07p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_GIO_H__
#define BCHP_GIO_H__

/***************************************************************************
 *GIO - GPIO
 ***************************************************************************/
#define BCHP_GIO_DATA_LO                         0x00406004 /* GENERAL PURPOSE I/O DATA [31:0] */
#define BCHP_GIO_IODIR_LO                        0x00406008 /* GENERAL PURPOSE I/O DIRECTION [31:0] */

#endif /* #ifndef BCHP_GIO_H__ */

/***************************************************************************
 *
 * $brcm_Workfile: bchp_pri_client_regs.h $
 * $brcm_Revision: Hydra_Software_Devel/1 $
 * $brcm_Date: 7/17/09 8:16p $
 *
 * Module Description:
 *                     DO NOT EDIT THIS FILE DIRECTLY
 *
 * This module was generated magically with RDB from a source description
 * file. You must edit the source file for changes to be made to this file.
 *
 *
 * Date:           Generated on         Fri Jul 17 19:42:12 2009
 *                 MD5 Checksum         2914699efc3fb3edefca5cb4f4f38b34
 *
 * Compiled with:  RDB Utility          combo_header.pl
 *                 RDB Parser           3.0
 *                 unknown              unknown
 *                 Perl Interpreter     5.008008
 *                 Operating System     linux
 *
 * Revision History:
 *
 * $brcm_Log: /magnum/basemodules/chp/70015/rdb/a0/bchp_pri_client_regs.h $
 *
 * Hydra_Software_Devel/1   7/17/09 8:16p albertl
 * PR56880: Initial revision.
 *
 ***************************************************************************/

#ifndef BCHP_PRI_CLIENT_REGS_H__
#define BCHP_PRI_CLIENT_REGS_H__

/***************************************************************************
 *PRI_CLIENT_REGS - PRIMARY_ARB_CLIENTS client configuration registers
 ***************************************************************************/
#define BCHP_PRI_CLIENT_REGS_CLIENT_00_COUNT     0x0040c000 /* Arbiter Client DEBLOCK Blockout Counter Register */
#define BCHP_PRI_CLIENT_REGS_CLIENT_00_CONTROL   0x0040c004 /* Arbiter Client DEBLOCK Configuration Register */

#endif /* #ifndef BCHP_PRI_CLIENT_REGS_H__ */
