/*
 * Copyright (C) 2001-2012 Jacek Sieka, arnetheduck on gmail point com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#pragma once

#include "debug.h"

namespace dcpp {

class ISingleton{
public:
    ISingleton(){}

    virtual void release() = 0;
};

template<typename T>
class Singleton: public ISingleton {
public:
    Singleton() { }
    virtual ~Singleton() { }

    static T* getInstance() {
        return instance;
    }

    static void newInstance() {
        if(instance)
            delete instance;

        instance = new T();
    }

    static void deleteInstance() {
        delete instance;

        instance = NULL;
    }
    virtual void release(){
        deleteInstance();
    }

protected:
    static T* instance;
private:
    Singleton(const Singleton&);
    Singleton& operator=(const Singleton&);

};

template<class T> T* Singleton<T>::instance = NULL;

} // namespace dcpp
