/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AnnotationLabels;
import jalview.appletgui.AnnotationPanel;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.IdPanel;
import jalview.appletgui.IdwidthAdjuster;
import jalview.appletgui.OverviewPanel;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.ScalePanel;
import jalview.appletgui.SeqPanel;
import jalview.appletgui.SequenceRenderer;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SequenceI;
import jalview.structure.StructureSelectionManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class AlignmentPanel
extends Panel
implements AdjustmentListener {
    public AlignViewport av;
    OverviewPanel overviewPanel;
    SeqPanel seqPanel;
    IdPanel idPanel;
    IdwidthAdjuster idwidthAdjuster;
    public AlignFrame alignFrame;
    ScalePanel scalePanel;
    AnnotationPanel annotationPanel;
    AnnotationLabels alabels;
    boolean fastPaint = true;
    int hextent = 0;
    int vextent = 0;
    protected Panel sequenceHolderPanel = new Panel();
    protected Scrollbar vscroll = new Scrollbar();
    protected Scrollbar hscroll = new Scrollbar();
    protected Panel seqPanelHolder = new Panel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    protected Panel scalePanelHolder = new Panel();
    protected Panel idPanelHolder = new Panel();
    BorderLayout borderLayout5 = new BorderLayout();
    protected Panel idSpaceFillerPanel1 = new Panel();
    public Panel annotationSpaceFillerHolder = new Panel();
    BorderLayout borderLayout6 = new BorderLayout();
    BorderLayout borderLayout7 = new BorderLayout();
    Panel hscrollHolder = new Panel();
    BorderLayout borderLayout10 = new BorderLayout();
    protected Panel hscrollFillerPanel = new Panel();
    BorderLayout borderLayout11 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();

    public AlignmentPanel(AlignFrame af, final AlignViewport av) {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.alignFrame = af;
        this.av = av;
        this.seqPanel = new SeqPanel(av, this);
        this.idPanel = new IdPanel(av, this);
        this.scalePanel = new ScalePanel(av, this);
        this.idwidthAdjuster = new IdwidthAdjuster(this);
        this.annotationPanel = new AnnotationPanel(this);
        this.sequenceHolderPanel.add((Component)this.annotationPanel, "South");
        this.alabels = new AnnotationLabels(this);
        this.setAnnotationVisible(av.showAnnotation);
        this.idPanelHolder.add((Component)this.idPanel, "Center");
        this.idSpaceFillerPanel1.add((Component)this.idwidthAdjuster, "Center");
        this.annotationSpaceFillerHolder.add((Component)this.alabels, "Center");
        this.scalePanelHolder.add((Component)this.scalePanel, "Center");
        this.seqPanelHolder.add((Component)this.seqPanel, "Center");
        this.fontChanged();
        this.setScrollValues(0, 0);
        this.hscroll.addAdjustmentListener(this);
        this.vscroll.addAdjustmentListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                AlignmentPanel.this.setScrollValues(av.getStartRes(), av.getStartSeq());
                AlignmentPanel.this.repaint();
            }
        });
        Dimension d = this.calculateIdWidth();
        this.idPanel.idCanvas.setSize(d);
        this.hscrollFillerPanel.setSize(d.width, this.annotationPanel.getSize().height);
        this.idPanel.idCanvas.setSize(d.width, this.seqPanel.seqCanvas.getSize().height);
        this.annotationSpaceFillerHolder.setSize(d.width, this.annotationPanel.getSize().height);
        this.alabels.setSize(d.width, this.annotationPanel.getSize().height);
        final AlignmentPanel ap = this;
        av.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("alignment")) {
                    PaintRefresher.Refresh(ap, av.getSequenceSetId(), true, true);
                    AlignmentPanel.this.alignmentChanged();
                }
            }
        });
    }

    public SequenceRenderer getSequenceRenderer() {
        return this.seqPanel.seqCanvas.sr;
    }

    public FeatureRenderer getFeatureRenderer() {
        return this.seqPanel.seqCanvas.fr;
    }

    public void alignmentChanged() {
        this.av.alignmentChanged(this);
        if (this.overviewPanel != null) {
            this.overviewPanel.updateOverviewImage();
        }
        this.alignFrame.updateEditMenuBar();
        this.repaint();
    }

    public void fontChanged() {
        this.idPanel.idCanvas.image = null;
        FontMetrics fm = this.getFontMetrics(this.av.getFont());
        this.scalePanel.setSize(new Dimension(10, this.av.charHeight + fm.getDescent()));
        this.idwidthAdjuster.setSize(new Dimension(10, this.av.charHeight + fm.getDescent()));
        this.av.updateSequenceIdColours();
        this.annotationPanel.image = null;
        int ap = this.annotationPanel.adjustPanelHeight();
        this.annotationPanel.repaint();
        Dimension d = this.calculateIdWidth();
        d.setSize(d.width + 4, this.seqPanel.seqCanvas.getSize().height);
        this.alabels.setSize(d.width + 4, ap);
        this.idPanel.idCanvas.setSize(d);
        this.hscrollFillerPanel.setSize(d);
        this.validate();
        this.repaint();
        if (this.overviewPanel != null) {
            this.overviewPanel.updateOverviewImage();
        }
    }

    public void setIdWidth(int w, int h) {
        this.idPanel.idCanvas.setSize(w, h);
        this.idPanelHolder.setSize(w, this.idPanelHolder.getSize().height);
        this.alabels.setSize(w, this.alabels.getSize().height);
        this.validate();
    }

    Dimension calculateIdWidth() {
        int i;
        if (this.av.nullFrame == null) {
            this.av.nullFrame = new Frame();
            this.av.nullFrame.addNotify();
        }
        Graphics g = this.av.nullFrame.getGraphics();
        FontMetrics fm = g.getFontMetrics(this.av.font);
        AlignmentI al = this.av.getAlignment();
        int idWidth = 0;
        for (i = 0; i < al.getHeight() && al.getSequenceAt(i) != null; ++i) {
            SequenceI s = al.getSequenceAt(i);
            String id = s.getDisplayId(this.av.getShowJVSuffix());
            if (fm.stringWidth(id) <= idWidth) continue;
            idWidth = fm.stringWidth(id);
        }
        if (al.getAlignmentAnnotation() != null) {
            fm = g.getFontMetrics(this.av.nullFrame.getFont());
            for (i = 0; i < al.getAlignmentAnnotation().length; ++i) {
                String label = al.getAlignmentAnnotation()[i].label;
                if (fm.stringWidth(label) <= idWidth) continue;
                idWidth = fm.stringWidth(label);
            }
        }
        return new Dimension(idWidth, this.idPanel.idCanvas.getSize().height);
    }

    public void highlightSearchResults(SearchResults results) {
        this.seqPanel.seqCanvas.highlightSearchResults(results);
        if (results != null) {
            SequenceI seq = results.getResultSequence(0);
            int seqIndex = this.av.alignment.findIndex(seq);
            int start = seq.findIndex(results.getResultStart(0)) - 1;
            int end = seq.findIndex(results.getResultEnd(0)) - 1;
            if (!this.av.wrapAlignment) {
                if (this.av.getStartRes() > end || this.av.getEndRes() < start || this.av.getStartSeq() > seqIndex || this.av.getEndSeq() < seqIndex) {
                    if (start > this.av.alignment.getWidth() - this.hextent && (start = this.av.alignment.getWidth() - this.hextent) < 0) {
                        start = 0;
                    }
                    if (seqIndex > this.av.alignment.getHeight() - this.vextent && (seqIndex = this.av.alignment.getHeight() - this.vextent) < 0) {
                        seqIndex = 0;
                    }
                    this.setScrollValues(start, seqIndex);
                }
            } else {
                this.scrollToWrappedVisible(start);
            }
        }
        this.repaint();
    }

    void scrollToWrappedVisible(int res) {
        int cwidth = this.seqPanel.seqCanvas.getWrappedCanvasWidth(this.seqPanel.seqCanvas.getSize().width);
        if (res <= this.av.getStartRes() || res >= this.av.getStartRes() + cwidth) {
            this.vscroll.setValue(res / cwidth);
            this.av.startRes = this.vscroll.getValue() * cwidth;
        }
    }

    public OverviewPanel getOverviewPanel() {
        return this.overviewPanel;
    }

    public void setOverviewPanel(OverviewPanel op) {
        this.overviewPanel = op;
    }

    public void setAnnotationVisible(boolean b) {
        if (!this.av.wrapAlignment) {
            this.annotationSpaceFillerHolder.setVisible(b);
            this.annotationPanel.setVisible(b);
        }
        this.validate();
        this.repaint();
    }

    public void setWrapAlignment(boolean wrap) {
        this.av.startSeq = 0;
        this.av.startRes = 0;
        this.scalePanelHolder.setVisible(!wrap);
        this.hscroll.setVisible(!wrap);
        this.idwidthAdjuster.setVisible(!wrap);
        if (wrap) {
            this.annotationPanel.setVisible(false);
            this.annotationSpaceFillerHolder.setVisible(false);
        } else if (this.av.showAnnotation) {
            this.annotationPanel.setVisible(true);
            this.annotationSpaceFillerHolder.setVisible(true);
        }
        this.idSpaceFillerPanel1.setVisible(!wrap);
        this.fontChanged();
        this.validate();
        this.repaint();
    }

    public boolean scrollUp(boolean up) {
        if (up) {
            if (this.vscroll.getValue() < 1) {
                return false;
            }
            this.setScrollValues(this.hscroll.getValue(), this.vscroll.getValue() - 1);
        } else {
            if (this.vextent + this.vscroll.getValue() >= this.av.getAlignment().getHeight()) {
                return false;
            }
            this.setScrollValues(this.hscroll.getValue(), this.vscroll.getValue() + 1);
        }
        this.repaint();
        return true;
    }

    public boolean scrollRight(boolean right) {
        if (!right) {
            if (this.hscroll.getValue() < 1) {
                return false;
            }
            this.setScrollValues(this.hscroll.getValue() - 1, this.vscroll.getValue());
        } else {
            if (this.hextent + this.hscroll.getValue() >= this.av.getAlignment().getWidth()) {
                return false;
            }
            this.setScrollValues(this.hscroll.getValue() + 1, this.vscroll.getValue());
        }
        this.repaint();
        return true;
    }

    public void setScrollValues(int x, int y) {
        int width = this.av.alignment.getWidth();
        int height = this.av.alignment.getHeight();
        if (this.av.hasHiddenColumns) {
            width = this.av.getColumnSelection().findColumnPosition(width);
        }
        this.av.setStartRes(x);
        this.av.setEndRes(x + this.seqPanel.seqCanvas.getSize().width / this.av.charWidth - 1);
        this.hextent = this.seqPanel.seqCanvas.getSize().width / this.av.charWidth;
        this.vextent = this.seqPanel.seqCanvas.getSize().height / this.av.charHeight;
        if (this.hextent > width) {
            this.hextent = width;
        }
        if (this.vextent > height) {
            this.vextent = height;
        }
        if (this.hextent + x > width) {
            x = width - this.hextent;
        }
        if (this.vextent + y > height) {
            y = height - this.vextent;
        }
        if (y < 0) {
            y = 0;
        }
        if (x < 0) {
            x = 0;
        }
        this.av.setStartSeq(y);
        int endSeq = y + this.vextent;
        if (endSeq > this.av.alignment.getHeight()) {
            endSeq = this.av.alignment.getHeight();
        }
        this.av.setEndSeq(endSeq);
        this.hscroll.setValues(x, this.hextent, 0, width);
        this.vscroll.setValues(y, this.vextent, 0, height);
        if (this.overviewPanel != null) {
            this.overviewPanel.setBoxPosition();
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        int oldX = this.av.getStartRes();
        int oldY = this.av.getStartSeq();
        if (evt == null || evt.getSource() == this.hscroll) {
            int x = this.hscroll.getValue();
            this.av.setStartRes(x);
            this.av.setEndRes(x + this.seqPanel.seqCanvas.getSize().width / this.av.getCharWidth() - 1);
        }
        if (evt == null || evt.getSource() == this.vscroll) {
            int offy = this.vscroll.getValue();
            if (this.av.getWrapAlignment()) {
                int rowSize = this.seqPanel.seqCanvas.getWrappedCanvasWidth(this.seqPanel.seqCanvas.getSize().width);
                this.av.setStartRes(this.vscroll.getValue() * rowSize);
                this.av.setEndRes((this.vscroll.getValue() + 1) * rowSize);
            } else {
                this.av.setStartSeq(offy);
                this.av.setEndSeq(offy + this.seqPanel.seqCanvas.getSize().height / this.av.getCharHeight());
            }
        }
        if (this.overviewPanel != null) {
            this.overviewPanel.setBoxPosition();
        }
        int scrollX = this.av.startRes - oldX;
        int scrollY = this.av.startSeq - oldY;
        if (this.av.getWrapAlignment() || !this.fastPaint || this.av.MAC) {
            this.repaint();
        } else {
            if (scrollX > this.av.endRes - this.av.startRes) {
                scrollX = this.av.endRes - this.av.startRes;
            } else if (scrollX < this.av.startRes - this.av.endRes) {
                scrollX = this.av.startRes - this.av.endRes;
            }
            this.idPanel.idCanvas.fastPaint(scrollY);
            this.seqPanel.seqCanvas.fastPaint(scrollX, scrollY);
            this.scalePanel.repaint();
            if (this.av.getShowAnnotation()) {
                this.annotationPanel.fastPaint(this.av.getStartRes() - oldX);
            }
        }
    }

    public void paintAlignment(boolean updateOverview) {
        this.repaint();
        if (updateOverview) {
            StructureSelectionManager.getStructureSelectionManager().sequenceColoursChanged(this);
            if (this.overviewPanel != null) {
                this.overviewPanel.updateOverviewImage();
            }
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.invalidate();
        Dimension d = this.idPanel.idCanvas.getSize();
        this.idPanel.idCanvas.setSize(d.width, this.seqPanel.seqCanvas.getSize().height);
        this.annotationSpaceFillerHolder.setSize(d.width, this.annotationPanel.getSize().height);
        this.alabels.setSize(d.width, this.annotationPanel.getSize().height);
        if (this.av.getWrapAlignment()) {
            int canvasWidth;
            int maxwidth = this.av.alignment.getWidth();
            if (this.av.hasHiddenColumns) {
                maxwidth = this.av.getColumnSelection().findColumnPosition(maxwidth) - 1;
            }
            if ((canvasWidth = this.seqPanel.seqCanvas.getWrappedCanvasWidth(this.seqPanel.seqCanvas.getSize().width)) > 0) {
                int max = maxwidth / canvasWidth;
                this.vscroll.setMaximum(max);
                this.vscroll.setUnitIncrement(1);
                this.vscroll.setVisibleAmount(1);
            }
        } else {
            this.setScrollValues(this.av.getStartRes(), this.av.getStartSeq());
        }
        this.alabels.repaint();
        this.seqPanel.seqCanvas.repaint();
        this.scalePanel.repaint();
        this.annotationPanel.repaint();
        this.idPanel.idCanvas.repaint();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout7);
        this.sequenceHolderPanel.setLayout(this.borderLayout3);
        this.seqPanelHolder.setLayout(this.borderLayout1);
        this.scalePanelHolder.setBackground(Color.white);
        this.scalePanelHolder.setLayout(this.borderLayout6);
        this.idPanelHolder.setLayout(this.borderLayout5);
        this.idSpaceFillerPanel1.setBackground(Color.white);
        this.idSpaceFillerPanel1.setLayout(this.borderLayout11);
        this.annotationSpaceFillerHolder.setBackground(Color.white);
        this.annotationSpaceFillerHolder.setLayout(this.borderLayout4);
        this.hscroll.setOrientation(0);
        this.hscrollHolder.setLayout(this.borderLayout10);
        this.hscrollFillerPanel.setBackground(Color.white);
        this.hscrollHolder.setBackground(Color.white);
        this.seqPanelHolder.setBackground(Color.white);
        this.idPanelHolder.setBackground(Color.white);
        this.sequenceHolderPanel.add((Component)this.scalePanelHolder, "North");
        this.sequenceHolderPanel.add((Component)this.seqPanelHolder, "Center");
        this.seqPanelHolder.add((Component)this.vscroll, "East");
        this.add((Component)this.idPanelHolder, "West");
        this.idPanelHolder.add((Component)this.idSpaceFillerPanel1, "North");
        this.idPanelHolder.add((Component)this.annotationSpaceFillerHolder, "South");
        this.add((Component)this.hscrollHolder, "South");
        this.hscrollHolder.add((Component)this.hscroll, "Center");
        this.hscrollHolder.add((Component)this.hscrollFillerPanel, "West");
        this.add((Component)this.sequenceHolderPanel, "Center");
    }
}

