/*
 * Decompiled with CFR 0.152.
 */
package jalview.datamodel;

import jalview.datamodel.Annotation;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.GraphLine;
import jalview.datamodel.SequenceI;
import jalview.schemes.ResidueProperties;
import java.util.Enumeration;
import java.util.Hashtable;

public class AlignmentAnnotation {
    public boolean autoCalculated = false;
    public String annotationId;
    public SequenceI sequenceRef;
    public String label;
    public String description;
    public Annotation[] annotations;
    public Hashtable sequenceMapping;
    public float graphMin;
    public float graphMax;
    public double score = Double.NaN;
    public boolean hasScore = false;
    public GraphLine threshold;
    public boolean editable = false;
    public boolean hasIcons;
    public boolean hasText;
    public boolean visible = true;
    public int graphGroup = -1;
    public int height = 0;
    public int graph = 0;
    public int graphHeight = 40;
    public boolean padGaps = false;
    public static final int NO_GRAPH = 0;
    public static final int BAR_GRAPH = 1;
    public static final int LINE_GRAPH = 2;
    public boolean belowAlignment = true;

    public static int getGraphValueFromString(String string) {
        if (string.equalsIgnoreCase("BAR_GRAPH")) {
            return 1;
        }
        if (string.equalsIgnoreCase("LINE_GRAPH")) {
            return 2;
        }
        return 0;
    }

    public AlignmentAnnotation(String label, String description, Annotation[] annotations) {
        this.editable = true;
        this.label = label;
        this.description = description;
        this.annotations = annotations;
        this.validateRangeAndDisplay();
    }

    void areLabelsSecondaryStructure() {
        boolean nonSSLabel = false;
        char firstChar = '\u0000';
        for (int i = 0; i < this.annotations.length; ++i) {
            if (this.annotations[i] == null) continue;
            if (this.annotations[i].secondaryStructure == 'H' || this.annotations[i].secondaryStructure == 'E') {
                this.hasIcons = true;
            }
            if (this.annotations[i].displayCharacter == null) continue;
            if (this.annotations[i].displayCharacter.length() == 1 && (firstChar = this.annotations[i].displayCharacter.charAt(0)) != 'H' && firstChar != 'E' && firstChar != '-' && firstChar != '-' && firstChar < ResidueProperties.aaIndex.length && ResidueProperties.aaIndex[firstChar] < 23) {
                nonSSLabel = true;
            }
            if (this.annotations[i].displayCharacter.length() <= 0) continue;
            this.hasText = true;
        }
        if (nonSSLabel) {
            this.hasIcons = false;
            for (int j = 0; j < this.annotations.length; ++j) {
                if (this.annotations[j] == null || this.annotations[j].secondaryStructure == ' ') continue;
                this.annotations[j].displayCharacter = String.valueOf(this.annotations[j].secondaryStructure);
                this.annotations[j].secondaryStructure = (char)32;
            }
        }
        this.annotationId = this.hashCode() + "";
    }

    public AlignmentAnnotation(String label, String description, Annotation[] annotations, float min, float max, int graphType) {
        this.editable = graphType == 0;
        this.label = label;
        this.description = description;
        this.annotations = annotations;
        this.graph = graphType;
        this.graphMin = min;
        this.graphMax = max;
        this.validateRangeAndDisplay();
    }

    private void validateRangeAndDisplay() {
        int i;
        if (this.annotations == null) {
            this.visible = false;
            return;
        }
        int graphType = this.graph;
        float min = this.graphMin;
        float max = this.graphMax;
        boolean drawValues = true;
        if (min == max) {
            min = 1.0E9f;
            for (i = 0; i < this.annotations.length; ++i) {
                if (this.annotations[i] == null) continue;
                if (drawValues && this.annotations[i].displayCharacter != null && this.annotations[i].displayCharacter.length() > 1) {
                    drawValues = false;
                }
                if (this.annotations[i].value > max) {
                    max = this.annotations[i].value;
                }
                if (!(this.annotations[i].value < min)) continue;
                min = this.annotations[i].value;
            }
        }
        this.graphMin = min;
        this.graphMax = max;
        this.areLabelsSecondaryStructure();
        if (!drawValues && graphType != 0) {
            for (i = 0; i < this.annotations.length; ++i) {
                if (this.annotations[i] == null) continue;
                this.annotations[i].displayCharacter = "";
            }
        }
    }

    public AlignmentAnnotation(AlignmentAnnotation annotation) {
        this.label = new String(annotation.label);
        if (annotation.description != null) {
            this.description = new String(annotation.description);
        }
        this.graphMin = annotation.graphMin;
        this.graphMax = annotation.graphMax;
        this.graph = annotation.graph;
        this.graphHeight = annotation.graphHeight;
        this.graphGroup = annotation.graphGroup;
        this.editable = annotation.editable;
        this.autoCalculated = annotation.autoCalculated;
        this.hasIcons = annotation.hasIcons;
        this.hasText = annotation.hasText;
        this.height = annotation.height;
        this.label = annotation.label;
        this.padGaps = annotation.padGaps;
        this.visible = annotation.visible;
        this.hasScore = annotation.hasScore;
        if (this.hasScore) {
            this.score = annotation.score;
        }
        if (this.threshold != null) {
            this.threshold = new GraphLine(annotation.threshold);
        }
        if (annotation.annotations != null) {
            Annotation[] ann = annotation.annotations;
            this.annotations = new Annotation[ann.length];
            for (int i = 0; i < ann.length; ++i) {
                this.annotations[i] = new Annotation(ann[i]);
            }
            if (annotation.sequenceRef != null) {
                this.sequenceRef = annotation.sequenceRef;
                if (annotation.sequenceMapping != null) {
                    Integer p = null;
                    this.sequenceMapping = new Hashtable();
                    Enumeration pos = annotation.sequenceMapping.keys();
                    while (pos.hasMoreElements()) {
                        p = (Integer)pos.nextElement();
                        Annotation a = (Annotation)annotation.sequenceMapping.get(p);
                        if (a == null) continue;
                        for (int i = 0; i < ann.length; ++i) {
                            if (ann[i] != a) continue;
                            this.sequenceMapping.put(p, this.annotations[i]);
                        }
                    }
                } else {
                    this.sequenceMapping = null;
                }
            }
        }
        this.validateRangeAndDisplay();
    }

    public void restrict(int startRes, int endRes) {
        if (this.annotations == null) {
            return;
        }
        if (startRes < 0) {
            startRes = 0;
        }
        if (startRes >= this.annotations.length) {
            startRes = this.annotations.length - 1;
        }
        if (endRes >= this.annotations.length) {
            endRes = this.annotations.length - 1;
        }
        if (this.annotations == null) {
            return;
        }
        Annotation[] temp = new Annotation[endRes - startRes + 1];
        if (startRes < this.annotations.length) {
            System.arraycopy(this.annotations, startRes, temp, 0, endRes - startRes + 1);
        }
        if (this.sequenceRef != null) {
            int spos = this.sequenceRef.findPosition(startRes);
            int epos = this.sequenceRef.findPosition(endRes);
            if (this.sequenceMapping != null) {
                Hashtable newmapping = new Hashtable();
                Enumeration e = this.sequenceMapping.keys();
                while (e.hasMoreElements()) {
                    Integer pos = (Integer)e.nextElement();
                    if (pos < spos || pos > epos) continue;
                    newmapping.put(pos, this.sequenceMapping.get(pos));
                }
                this.sequenceMapping.clear();
                this.sequenceMapping = newmapping;
            }
        }
        this.annotations = temp;
    }

    public boolean padAnnotation(int length) {
        if (this.annotations == null) {
            return true;
        }
        if (this.annotations.length < length) {
            Annotation[] na = new Annotation[length];
            System.arraycopy(this.annotations, 0, na, 0, this.annotations.length);
            this.annotations = na;
            return true;
        }
        return this.annotations.length > length;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        for (i = 0; i < this.annotations.length; ++i) {
            if (this.annotations[i] != null) {
                if (this.graph != 0) {
                    buffer.append(this.annotations[i].value);
                } else if (this.hasIcons) {
                    buffer.append(this.annotations[i].secondaryStructure);
                } else {
                    buffer.append(this.annotations[i].displayCharacter);
                }
            }
            buffer.append(", ");
        }
        if (this.label.equals("Consensus")) {
            buffer.append("\n");
            for (i = 0; i < this.annotations.length; ++i) {
                if (this.annotations[i] != null) {
                    buffer.append(this.annotations[i].description);
                }
                buffer.append(", ");
            }
        }
        return buffer.toString();
    }

    public void setThreshold(GraphLine line) {
        this.threshold = line;
    }

    public GraphLine getThreshold() {
        return this.threshold;
    }

    public void createSequenceMapping(SequenceI seqRef, int startRes, boolean alreadyMapped) {
        if (seqRef == null) {
            return;
        }
        this.sequenceRef = seqRef;
        if (this.annotations == null) {
            return;
        }
        this.sequenceMapping = new Hashtable();
        for (int i = 0; i < this.annotations.length; ++i) {
            if (this.annotations[i] == null) continue;
            int seqPos = alreadyMapped ? seqRef.findPosition(i) : i + startRes;
            this.sequenceMapping.put(new Integer(seqPos), this.annotations[i]);
        }
    }

    public void adjustForAlignment() {
        if (this.sequenceRef == null) {
            return;
        }
        if (this.annotations == null) {
            return;
        }
        int a = 0;
        int aSize = this.sequenceRef.getLength();
        if (aSize == 0) {
            return;
        }
        Annotation[] temp = new Annotation[aSize];
        for (a = this.sequenceRef.getStart(); a <= this.sequenceRef.getEnd(); ++a) {
            Integer index = new Integer(a);
            if (!this.sequenceMapping.containsKey(index)) continue;
            int position = this.sequenceRef.findIndex(a) - 1;
            temp[position] = (Annotation)this.sequenceMapping.get(index);
        }
        this.annotations = temp;
    }

    public int compactAnnotationArray() {
        int i = 0;
        int iSize = this.annotations.length;
        while (i < iSize) {
            if (this.annotations[i] == null) {
                if (i + 1 < iSize) {
                    System.arraycopy(this.annotations, i + 1, this.annotations, i, iSize - i - 1);
                }
                --iSize;
                continue;
            }
            ++i;
        }
        Annotation[] ann = this.annotations;
        this.annotations = new Annotation[i];
        System.arraycopy(ann, 0, this.annotations, 0, i);
        ann = null;
        return iSize;
    }

    public void setSequenceRef(SequenceI sequenceI) {
        if (sequenceI != null) {
            if (this.sequenceRef != null) {
                if (this.sequenceRef != sequenceI && !this.sequenceRef.equals(sequenceI) && this.sequenceRef.getDatasetSequence() != sequenceI.getDatasetSequence()) {
                    this.sequenceRef = null;
                    if (this.sequenceMapping != null) {
                        this.sequenceMapping = null;
                    }
                    this.createSequenceMapping(sequenceI, 1, true);
                    this.adjustForAlignment();
                } else {
                    this.sequenceRef = sequenceI;
                }
            } else {
                this.createSequenceMapping(sequenceI, 1, true);
                this.adjustForAlignment();
            }
        } else {
            this.sequenceMapping = null;
            this.sequenceRef = null;
        }
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double score) {
        this.hasScore = true;
        this.score = score;
    }

    public boolean hasScore() {
        return this.hasScore || !Double.isNaN(this.score);
    }

    public AlignmentAnnotation(String label, String description, double score) {
        this(label, description, null);
        this.setScore(score);
    }

    public AlignmentAnnotation(AlignmentAnnotation alignmentAnnotation, ColumnSelection colSel) {
        this(alignmentAnnotation);
        if (this.annotations == null) {
            return;
        }
        colSel.makeVisibleAnnotation(this);
    }

    public void setPadGaps(boolean padgaps, char gapchar) {
        this.padGaps = padgaps;
        if (padgaps) {
            this.hasText = true;
            for (int i = 0; i < this.annotations.length; ++i) {
                if (this.annotations[i] == null) {
                    this.annotations[i] = new Annotation(String.valueOf(gapchar), null, ' ', 0.0f);
                    continue;
                }
                if (this.annotations[i].displayCharacter != null && !this.annotations[i].displayCharacter.equals(" ")) continue;
                this.annotations[i].displayCharacter = String.valueOf(gapchar);
            }
        }
    }

    public String getDescription(boolean seqname) {
        if (seqname && this.sequenceRef != null) {
            return this.sequenceRef.getName() + " : " + this.description;
        }
        return this.description;
    }
}

