/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.FileParse;
import java.io.IOException;

public class FastaFile
extends AlignFile {
    int len = 72;
    StringBuffer out;

    public FastaFile() {
    }

    public FastaFile(String inFile, String type) throws IOException {
        super(inFile, type);
    }

    public FastaFile(FileParse source) throws IOException {
        super(source);
    }

    public void parse() throws IOException {
        String anotString;
        Annotation[] anots;
        String line;
        StringBuffer sb = new StringBuffer();
        boolean firstLine = true;
        Sequence seq = null;
        boolean annotation = false;
        while ((line = this.nextLine()) != null) {
            if ((line = line.trim()).length() <= 0) continue;
            if (line.charAt(0) == '>') {
                if (line.startsWith(">#_")) {
                    if (annotation) {
                        anots = new Annotation[sb.length()];
                        anotString = sb.toString();
                        for (int i = 0; i < sb.length(); ++i) {
                            anots[i] = new Annotation(anotString.substring(i, i + 1), null, ' ', 0.0f);
                        }
                        AlignmentAnnotation aa = new AlignmentAnnotation(seq.getName().substring(2), seq.getDescription(), anots);
                        this.annotations.addElement(aa);
                    }
                } else {
                    annotation = false;
                }
                if (!firstLine) {
                    seq.setSequence(sb.toString());
                    if (!annotation) {
                        this.seqs.addElement(seq);
                    }
                }
                seq = this.parseId(line.substring(1));
                firstLine = false;
                sb = new StringBuffer();
                if (!line.startsWith(">#_")) continue;
                annotation = true;
                continue;
            }
            sb.append(line);
        }
        if (annotation) {
            anots = new Annotation[sb.length()];
            anotString = sb.toString();
            for (int i = 0; i < sb.length(); ++i) {
                anots[i] = new Annotation(anotString.substring(i, i + 1), null, ' ', 0.0f);
            }
            AlignmentAnnotation aa = new AlignmentAnnotation(seq.getName().substring(2), seq.getDescription(), anots);
            this.annotations.addElement(aa);
        } else if (!firstLine) {
            seq.setSequence(sb.toString());
            this.seqs.addElement(seq);
        }
    }

    public void addAnnotations(Alignment al) {
        this.addProperties(al);
        for (int i = 0; i < this.annotations.size(); ++i) {
            AlignmentAnnotation aa = (AlignmentAnnotation)this.annotations.elementAt(i);
            aa.setPadGaps(true, al.getGapCharacter());
            al.addAnnotation(aa);
        }
    }

    public String print(SequenceI[] s) {
        this.out = new StringBuffer();
        for (int i = 0; i < s.length && s[i] != null; ++i) {
            this.out.append(">" + this.printId(s[i]));
            if (s[i].getDescription() != null) {
                this.out.append(" " + s[i].getDescription());
            }
            this.out.append("\n");
            int nochunks = s[i].getLength() / this.len + 1;
            for (int j = 0; j < nochunks; ++j) {
                int start = j * this.len;
                int end = start + this.len;
                if (end < s[i].getLength()) {
                    this.out.append(s[i].getSequenceAsString(start, end) + "\n");
                    continue;
                }
                if (start >= s[i].getLength()) continue;
                this.out.append(s[i].getSequenceAsString(start, s[i].getLength()) + "\n");
            }
        }
        return this.out.toString();
    }

    public String print() {
        return this.print(this.getSeqsAsArray());
    }
}

