/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.io.AppletFormatAdapter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;

public class FileParse {
    public File inFile = null;
    public int index = 1;
    protected char suffixSeparator = (char)35;
    protected String suffix = null;
    protected String type = null;
    protected BufferedReader dataIn = null;
    protected String errormessage = "UNITIALISED SOURCE";
    protected boolean error = true;
    protected String warningMessage = null;
    final int READAHEAD_LIMIT = 2048;

    public FileParse() {
    }

    public FileParse(FileParse from) throws IOException {
        if (from == null) {
            throw new Error("Implementation error. Null FileParse in copy constructor");
        }
        if (from == this) {
            return;
        }
        this.index = ++from.index;
        this.inFile = from.inFile;
        this.suffixSeparator = from.suffixSeparator;
        this.suffix = from.suffix;
        this.errormessage = from.errormessage;
        this.error = false;
        this.type = from.type;
        this.dataIn = from.dataIn;
        if (this.dataIn != null) {
            this.mark();
        }
    }

    private boolean checkFileSource(String fileStr) throws IOException {
        this.error = false;
        this.inFile = new File(fileStr);
        if (!this.inFile.exists()) {
            this.errormessage = "FILE NOT FOUND";
            this.error = true;
        }
        if (!this.inFile.canRead()) {
            this.errormessage = "FILE CANNOT BE OPENED FOR READING";
            this.error = true;
        }
        if (this.inFile.isDirectory()) {
            this.errormessage = "FILE IS A DIRECTORY";
            this.error = true;
        }
        if (!this.error) {
            this.dataIn = new BufferedReader(new FileReader(fileStr));
        }
        return this.error;
    }

    private boolean checkURLSource(String fileStr) throws IOException, MalformedURLException {
        this.errormessage = "URL NOT FOUND";
        URL url = new URL(fileStr);
        this.dataIn = new BufferedReader(new InputStreamReader(url.openStream()));
        return false;
    }

    private String extractSuffix(String fileStr) {
        int sfpos = fileStr.lastIndexOf(this.suffixSeparator);
        if (sfpos > -1 && sfpos < fileStr.length() - 1) {
            this.suffix = fileStr.substring(sfpos + 1);
            return fileStr.substring(0, sfpos);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileParse(String fileStr, String type) throws MalformedURLException, IOException {
        this.type = type;
        this.error = false;
        if (type.equals(AppletFormatAdapter.FILE)) {
            if (this.checkFileSource(fileStr)) {
                String suffixLess = this.extractSuffix(fileStr);
                if (suffixLess == null) throw new IOException("Problem opening " + this.inFile + " : " + this.errormessage);
                if (this.checkFileSource(suffixLess)) {
                    throw new IOException("Problem opening " + this.inFile + " (also tried " + suffixLess + ") : " + this.errormessage);
                }
            }
        } else if (type.equals(AppletFormatAdapter.URL)) {
            try {
                try {
                    this.checkURLSource(fileStr);
                    if (this.suffixSeparator == '#') {
                        this.extractSuffix(fileStr);
                    }
                }
                catch (IOException e) {
                    String suffixLess = this.extractSuffix(fileStr);
                    if (suffixLess == null) {
                        throw e;
                    }
                    try {
                        this.checkURLSource(suffixLess);
                    }
                    catch (IOException e2) {
                        this.errormessage = "BAD URL WITH OR WITHOUT SUFFIX";
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                this.errormessage = "CANNOT ACCESS DATA AT URL '" + fileStr + "' (" + e.getMessage() + ")";
                this.error = true;
            }
        } else if (type.equals(AppletFormatAdapter.PASTE)) {
            this.errormessage = "PASTE INACCESSIBLE!";
            this.dataIn = new BufferedReader(new StringReader(fileStr));
        } else if (type.equals(AppletFormatAdapter.CLASSLOADER)) {
            String suffixLess;
            this.errormessage = "RESOURCE CANNOT BE LOCATED";
            InputStream is = this.getClass().getResourceAsStream("/" + fileStr);
            if (is == null && (suffixLess = this.extractSuffix(fileStr)) != null) {
                is = this.getClass().getResourceAsStream("/" + suffixLess);
            }
            if (is != null) {
                this.dataIn = new BufferedReader(new InputStreamReader(is));
            } else {
                this.error = true;
            }
        } else {
            this.errormessage = "PROBABLE IMPLEMENTATION ERROR : Datasource Type given as '" + (type != null ? type : "null") + "'";
            this.error = true;
        }
        if (this.dataIn == null || this.error) {
            throw new IOException("Failed to read data from source:\n" + this.errormessage);
        }
        this.error = false;
        this.dataIn.mark(2048);
    }

    public void mark() throws IOException {
        if (this.dataIn == null) {
            throw new IOException("Unitialised Source Stream");
        }
        this.dataIn.mark(2048);
    }

    public String nextLine() throws IOException {
        if (!this.error) {
            return this.dataIn.readLine();
        }
        throw new IOException("Invalid Source Stream:" + this.errormessage);
    }

    public boolean isValid() {
        return !this.error;
    }

    public void close() throws IOException {
        this.errormessage = "EXCEPTION ON CLOSE";
        this.error = true;
        this.dataIn.close();
        this.dataIn = null;
        this.errormessage = "SOURCE IS CLOSED";
    }

    public void reset() throws IOException {
        if (this.dataIn == null || this.error) {
            throw new IOException("Implementation Error: Reset called for invalid source.");
        }
        this.dataIn.reset();
    }

    public boolean hasWarningMessage() {
        return this.warningMessage != null && this.warningMessage.length() > 0;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public String getInFile() {
        if (this.inFile != null) {
            return this.inFile.getAbsolutePath() + " (" + this.index + ")";
        }
        return "From Paste + (" + this.index + ")";
    }

    public Reader getReader() throws IOException {
        if (this.dataIn != null && this.dataIn.ready()) {
            return this.dataIn;
        }
        return null;
    }
}

