/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.datamodel.SequenceGroup;
import jalview.schemes.ResidueColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.util.Comparison;
import java.awt.Color;

public class PIDColourScheme
extends ResidueColourScheme {
    public Color[] pidColours = ResidueProperties.pidColours;
    public float[] thresholds = ResidueProperties.pidThresholds;
    SequenceGroup group;

    public Color findColour(char c, int j) {
        if ('a' <= c && c <= 'z') {
            c = (char)(c - 32);
        }
        if (this.consensus == null || j >= this.consensus.length || this.consensus[j] == null) {
            return Color.white;
        }
        if (this.threshold != 0 && !this.aboveThreshold(c, j)) {
            return Color.white;
        }
        Color currentColour = Color.white;
        double sc = 0.0;
        if (this.consensus.length <= j) {
            return Color.white;
        }
        if (Integer.parseInt(this.consensus[j].get("C").toString()) != -1 && this.consensus[j].contains(String.valueOf(c))) {
            sc = ((Float)this.consensus[j].get(this.ignoreGaps)).floatValue();
            if (!Comparison.isGap(c)) {
                for (int i = 0; i < this.thresholds.length; ++i) {
                    if (!(sc > (double)this.thresholds[i])) continue;
                    currentColour = this.pidColours[i];
                    break;
                }
            }
        }
        if (this.conservationColouring) {
            currentColour = this.applyConservation(currentColour, j);
        }
        return currentColour;
    }
}

