/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.emboss.jemboss.draw.Block;
import org.emboss.jemboss.draw.DNADraw;
import org.emboss.jemboss.gui.form.TextFieldFloat;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class GeneticMarker
extends JPanel
implements TableModelListener {
    private DNADraw draw;
    private JTable markerTable;
    private MarkerTableModel markerModel;

    public GeneticMarker(final DNADraw draw, final Vector block) {
        this.draw = draw;
        Box bdown = Box.createVerticalBox();
        Dimension d = new Dimension(100, 25);
        bdown.add(Box.createVerticalStrut(4));
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("Label");
        columnNames.add("Start");
        columnNames.add("End");
        columnNames.add("Colour");
        columnNames.add("Line width");
        columnNames.add("Arrow head");
        columnNames.add("Arrow tail");
        this.markerModel = new MarkerTableModel(block, columnNames);
        this.markerTable = new JTable(this.markerModel);
        this.markerTable.getModel().addTableModelListener(this);
        this.setUpColorRenderer(this.markerTable);
        this.setUpColorEditor(this.markerTable);
        DefaultCellEditor edFloat = (DefaultCellEditor)this.markerTable.getDefaultEditor(Float.class);
        edFloat.setClickCountToStart(1);
        JScrollPane scrollMarker = new JScrollPane(this.markerTable);
        scrollMarker.setPreferredSize(new Dimension(200, 150));
        scrollMarker.getViewport().setBackground(Color.white);
        bdown.add(scrollMarker);
        bdown.add(Box.createVerticalStrut(4));
        bdown.add(new JSeparator());
        bdown.add(Box.createVerticalStrut(4));
        Box bacross = Box.createHorizontalBox();
        final TextFieldInt start = new TextFieldInt();
        start.setMaximumSize(d);
        start.setPreferredSize(d);
        bacross.add(new JLabel("start:"));
        bacross.add(start);
        bacross.add(Box.createHorizontalStrut(4));
        final TextFieldInt end = new TextFieldInt();
        end.setMaximumSize(d);
        end.setPreferredSize(d);
        bacross.add(new JLabel(" stop:"));
        bacross.add(end);
        bacross.add(Box.createHorizontalStrut(4));
        final JButton markerColour = this.setUpColorButton(Color.red);
        bacross.add(new JLabel(" colour:"));
        bacross.add(markerColour);
        bacross.add(Box.createHorizontalStrut(4));
        final TextFieldFloat lineSize = new TextFieldFloat();
        int lsize = 10;
        if (draw != null) {
            lsize = draw.getLineSize();
        }
        final JSlider slider = new JSlider(1, 25, lsize);
        lineSize.setColumns(3);
        lineSize.setValue(lsize);
        bacross.add(new JLabel(" line width:"));
        bacross.add(lineSize);
        bacross.add(new JLabel(" "));
        bacross.add(Box.createHorizontalStrut(4));
        lineSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                float size = (float)lineSize.getValue();
                slider.setValue((int)size);
            }
        });
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int size = slider.getValue();
                lineSize.setValue(size);
            }
        });
        bacross.add(slider);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        JButton addMarker = new JButton("Add Feature");
        addMarker.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Block drawBlock;
                Vector<Object> marker = new Vector<Object>();
                marker.add(new String("CDS"));
                marker.add(new Integer(start.getValue()));
                marker.add(new Integer(end.getValue()));
                marker.add(markerColour.getBackground());
                marker.add(new Float(lineSize.getValue()));
                marker.add(new Boolean(true));
                marker.add(new Boolean(false));
                if (draw != null) {
                    drawBlock = new Block(marker, draw);
                    draw.addBlock(drawBlock);
                } else {
                    drawBlock = new Block(marker);
                }
                marker.add(drawBlock);
                block.add(marker);
                GeneticMarker.this.markerModel.addRow();
            }
        });
        bacross.add(addMarker);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        this.add(bdown);
    }

    public void tableChanged(TableModelEvent e) {
        if (this.draw != null) {
            this.draw.repaint();
        }
    }

    protected JMenuBar createMenuBar(final JFrame f) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        JMenuItem closeMenu = new JMenuItem("Close");
        closeMenu.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        closeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        fileMenu.add(closeMenu);
        JMenu toolMenu = new JMenu("Tools");
        menuBar.add(toolMenu);
        JMenuItem deleteRow = new JMenuItem("Delete Selected Row");
        deleteRow.setAccelerator(KeyStroke.getKeyStroke(127, 2));
        deleteRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int row = GeneticMarker.this.markerTable.getSelectedRow();
                Block drawBlock = (Block)GeneticMarker.this.markerModel.getValueAt(row, 7);
                GeneticMarker.this.draw.remove(drawBlock);
                GeneticMarker.this.markerModel.deleteRow(row);
            }
        });
        toolMenu.add(deleteRow);
        return menuBar;
    }

    private void setUpColorRenderer(JTable table) {
        table.setDefaultRenderer(Color.class, new ColorRenderer(true));
    }

    private void setUpColorEditor(JTable table) {
        final JButton button = new JButton(""){

            public void setText(String s) {
            }
        };
        button.setBackground(Color.white);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        final ColorEditor colorEditor = new ColorEditor(button);
        table.setDefaultEditor(Color.class, colorEditor);
        final JColorChooser colorChooser = new JColorChooser();
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                colorEditor.currentColor = colorChooser.getColor();
            }
        };
        final JDialog dialog = JColorChooser.createDialog(button, "Pick a Color", true, colorChooser, okListener, null);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                button.setBackground(colorEditor.currentColor);
                colorChooser.setColor(colorEditor.currentColor);
                dialog.show();
            }
        });
    }

    private JButton setUpColorButton(Color col) {
        final JButton button = new JButton(""){

            public void setText(String s) {
            }
        };
        button.setBackground(col);
        button.setBorderPainted(false);
        button.setMargin(new Insets(0, 0, 0, 0));
        Dimension d = new Dimension(25, 25);
        button.setPreferredSize(d);
        button.setMinimumSize(d);
        button.setMaximumSize(d);
        final JColorChooser colorChooser = new JColorChooser();
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                button.setBackground(colorChooser.getColor());
            }
        };
        final JDialog dialog = JColorChooser.createDialog(button, "Pick a Color", true, colorChooser, okListener, null);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.show();
            }
        });
        return button;
    }

    class MarkerTableModel
    extends AbstractTableModel {
        private Vector rowData;
        private Vector columnNames;

        public MarkerTableModel(Vector rowData, Vector columnNames) {
            this.columnNames = columnNames;
            this.rowData = rowData;
        }

        public int getColumnCount() {
            return this.columnNames.size();
        }

        public int getRowCount() {
            return this.rowData.size();
        }

        public String getColumnName(int col) {
            return (String)this.columnNames.elementAt(col);
        }

        public Object getValueAt(int row, int col) {
            return ((Vector)this.rowData.elementAt(row)).elementAt(col);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public void setValueAt(Object value, int row, int col) {
            Vector vrow = (Vector)this.rowData.elementAt(row);
            vrow.setElementAt(value, col);
            this.rowData.setElementAt(vrow, row);
            this.fireTableCellUpdated(row, col);
        }

        public void addRow() {
            this.fireTableRowsInserted(this.rowData.size(), this.rowData.size());
        }

        public boolean deleteRow(int row) {
            if (row < 0 || row >= this.rowData.size()) {
                return false;
            }
            this.rowData.remove(row);
            this.fireTableRowsDeleted(row, row);
            return true;
        }
    }

    class ColorEditor
    extends DefaultCellEditor {
        Color currentColor;

        public ColorEditor(JButton b) {
            super(new JCheckBox());
            this.currentColor = null;
            this.editorComponent = b;
            this.setClickCountToStart(1);
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ColorEditor.this.fireEditingStopped();
                }
            });
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        public Object getCellEditorValue() {
            return this.currentColor;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ((JButton)this.editorComponent).setText(value.toString());
            this.currentColor = (Color)value;
            return this.editorComponent;
        }
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        Border unselectedBorder = null;
        Border selectedBorder = null;
        boolean isBordered = true;

        public ColorRenderer(boolean isBordered) {
            this.isBordered = isBordered;
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground((Color)color);
            if (this.isBordered) {
                if (isSelected) {
                    if (this.selectedBorder == null) {
                        this.selectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                    }
                    this.setBorder(this.selectedBorder);
                } else {
                    if (this.unselectedBorder == null) {
                        this.unselectedBorder = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                    }
                    this.setBorder(this.unselectedBorder);
                }
            }
            return this;
        }
    }
}

