/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import org.emboss.jemboss.editor.Matrix;
import org.emboss.jemboss.editor.PlotConsensus;
import org.emboss.jemboss.editor.PrettyPlotJFrame;
import org.emboss.jemboss.editor.Sequence;
import org.emboss.jemboss.editor.SequenceJPanel;
import org.emboss.jemboss.editor.SequenceNameJButton;
import org.emboss.jemboss.gui.form.MultiLineToolTipUI;

public class GraphicSequenceCollection
extends JPanel
implements Printable,
Scrollable {
    private Vector removedSeqs = new Vector();
    protected Vector seqs;
    protected Vector graphicSequence;
    protected Vector graphicName;
    protected Hashtable colorScheme;
    private PlotConsensus pc = null;
    private int hgt;
    private int len;
    protected int MAXSEQLENGTH = 0;
    private int numResiduePerLine = 0;
    protected SequenceJPanel numberDraw;
    protected JScrollPane jspSequence;
    private JPanel seqNamePanel;
    protected Box seqBox;
    protected Box seqNameBox;
    private Box plotconsSeqBox = null;
    protected boolean drawSequence;
    protected boolean drawBlackBox;
    protected boolean drawColorBox;
    protected boolean drawNumber;
    private int plotConStrut = 20;
    private PrettyPlotJFrame prettyPlot;
    private Matrix mat;

    public GraphicSequenceCollection(Vector seqs, Hashtable colorScheme, JScrollPane jspSequence, boolean drawSequence, boolean drawBlackBox, boolean drawColorBox, boolean drawNumber, JTextField statusField) {
        super(new BorderLayout());
        this.seqs = seqs;
        this.colorScheme = colorScheme;
        this.jspSequence = jspSequence;
        this.drawSequence = drawSequence;
        this.drawBlackBox = drawBlackBox;
        this.drawColorBox = drawColorBox;
        this.drawNumber = drawNumber;
        jspSequence.getViewport().setBackground(Color.white);
        this.setBackground(Color.white);
        MultiLineToolTipUI.initialize();
        this.graphicSequence = new Vector();
        this.graphicName = new Vector();
        this.setMaxSeqLength();
        Box centerBox = new Box(1);
        this.seqBox = new Box(1);
        centerBox.add(this.seqBox);
        Box westBox = new Box(1);
        this.seqNameBox = new Box(1);
        westBox.add(this.seqNameBox);
        this.seqNamePanel = new JPanel(new BorderLayout());
        this.seqNamePanel.add((Component)westBox, "Center");
        this.seqNamePanel.setBackground(Color.white);
        jspSequence.setRowHeaderView(this.seqNamePanel);
        if (drawNumber) {
            this.drawNumber();
        }
        Enumeration enumer = seqs.elements();
        while (enumer.hasMoreElements()) {
            this.addSequence((Sequence)enumer.nextElement(), false, 0, 0);
        }
        westBox.add(Box.createVerticalGlue());
        centerBox.add(Box.createVerticalGlue());
        this.plotconsSeqBox = new Box(1);
        centerBox.add(this.plotconsSeqBox);
        this.add((Component)centerBox, "Center");
        int xfill = this.getNameWidth();
        this.seqNamePanel.setPreferredSize(new Dimension(xfill, 2000));
    }

    public GraphicSequenceCollection(Vector seqs, JScrollPane jspSequence, boolean drawSequence, boolean drawBlackBox, boolean drawColorBox, boolean drawNumber, JTextField statusField) {
        this(seqs, null, jspSequence, drawSequence, drawBlackBox, drawColorBox, drawNumber, statusField);
    }

    protected Vector getSequenceCollection() {
        return this.seqs;
    }

    protected Sequence getConsensusSequence() {
        Enumeration enumer = this.seqs.elements();
        while (enumer.hasMoreElements()) {
            Sequence s = (Sequence)enumer.nextElement();
            String name = s.getName();
            if (!name.equals("Consensus")) continue;
            return s;
        }
        return null;
    }

    protected int getNumberSequences() {
        return this.seqs.size();
    }

    protected Point getViewPosition() {
        return this.jspSequence.getViewport().getViewPosition();
    }

    protected Rectangle getViewRect() {
        Rectangle r = this.jspSequence.getViewport().getViewRect();
        return r;
    }

    protected void showConsensusPlot(File matrix, int wsize) {
        this.deleteConsensusPlot();
        SequenceJPanel sj = (SequenceJPanel)this.graphicSequence.get(0);
        int interval = sj.getSequenceResidueWidth();
        this.pc = new PlotConsensus(matrix, this.seqs, wsize, interval, this);
        this.pc.setBackground(Color.white);
        Box XBox = new Box(0);
        XBox.add(this.pc);
        XBox.add(Box.createHorizontalGlue());
        this.plotconsSeqBox.add(Box.createVerticalStrut(this.plotConStrut));
        this.plotconsSeqBox.add(XBox);
        this.plotconsSeqBox.add(Box.createVerticalGlue());
        Dimension dpane = this.getPanelSize();
        this.setMinimumSize(dpane);
        this.setPreferredSize(dpane);
        this.setJScrollPaneViewportView();
    }

    protected void showConsensusPlot(Matrix mat, int wsize) {
        this.deleteConsensusPlot();
        SequenceJPanel sj = (SequenceJPanel)this.graphicSequence.get(0);
        int interval = sj.getSequenceResidueWidth();
        Vector seqs_ = new Vector(this.seqs);
        Sequence seq = (Sequence)this.seqs.lastElement();
        if (seq.getName().equals("Consensus")) {
            seqs_.removeElementAt(this.seqs.size() - 1);
        }
        this.pc = new PlotConsensus(mat, seqs_, wsize, interval, this);
        this.pc.setBackground(Color.white);
        Box XBox = new Box(0);
        XBox.add(this.pc);
        XBox.add(Box.createHorizontalGlue());
        this.plotconsSeqBox.add(Box.createVerticalStrut(20));
        this.plotconsSeqBox.add(XBox);
        this.plotconsSeqBox.add(Box.createVerticalGlue());
        Dimension dpane = this.getPanelSize();
        this.setMinimumSize(dpane);
        this.setPreferredSize(dpane);
        this.setJScrollPaneViewportView();
    }

    protected void deleteConsensusPlot() {
        this.plotconsSeqBox.removeAll();
    }

    protected void setMaxSequenceLength(int max) {
        if (max > this.MAXSEQLENGTH) {
            this.MAXSEQLENGTH = max;
        }
    }

    protected void setMaxSeqLength() {
        this.MAXSEQLENGTH = 0;
        Enumeration enumer = this.seqs.elements();
        while (enumer.hasMoreElements()) {
            Sequence seq = (Sequence)enumer.nextElement();
            if (seq.getSequence().length() <= this.MAXSEQLENGTH) continue;
            this.MAXSEQLENGTH = seq.getSequence().length();
        }
    }

    public int getMaxSeqLength() {
        return this.MAXSEQLENGTH;
    }

    protected void setSequenceLock(boolean llock) {
        Enumeration enumer = this.graphicName.elements();
        if (!llock) {
            while (enumer.hasMoreElements()) {
                ((SequenceNameJButton)enumer.nextElement()).setSelected(false);
            }
            enumer = this.graphicSequence.elements();
            while (enumer.hasMoreElements()) {
                ((SequenceJPanel)enumer.nextElement()).detachAll();
            }
            return;
        }
        int i = 0;
        Vector<SequenceJPanel> selected = new Vector<SequenceJPanel>();
        while (enumer.hasMoreElements()) {
            SequenceNameJButton sbutt = (SequenceNameJButton)enumer.nextElement();
            if (sbutt.isSelected()) {
                selected.add((SequenceJPanel)this.graphicSequence.get(i));
            }
            ++i;
        }
        for (i = 0; i < selected.size(); ++i) {
            SequenceJPanel si = (SequenceJPanel)selected.get(i);
            for (int j = 0; j < selected.size(); ++j) {
                if (i == j) continue;
                ((SequenceJPanel)selected.get(j)).attach(si);
            }
        }
    }

    protected void setNumberSize() {
        Dimension actual = this.numberDraw.getMaximumSize();
        int slen = this.numberDraw.getResidueWidth() * (int)((double)this.MAXSEQLENGTH * 1.5);
        this.numberDraw.setMaximumSize(new Dimension(slen, (int)actual.getHeight()));
    }

    protected void setMatrix(Matrix mat) {
        this.mat = mat;
    }

    protected Color getColor(String s, int pos, String seqName) {
        if (s.equals("-") || s.equals(".")) {
            return Color.black;
        }
        int identical = 1;
        int nseqs = 0;
        Enumeration enumer = this.seqs.elements();
        while (enumer.hasMoreElements()) {
            ++nseqs;
            Sequence seq = (Sequence)enumer.nextElement();
            if (seqName.equals(seq.getName())) continue;
            SequenceJPanel seqPanel = (SequenceJPanel)this.graphicSequence.get(nseqs);
            if (pos >= seq.getLength() || !seqPanel.isPrettyPlot() || !seq.getResidue(pos).equalsIgnoreCase(s)) continue;
            ++identical;
        }
        if (identical >= this.prettyPlot.getMinimumIdentity(nseqs)) {
            return this.prettyPlot.getIDColour();
        }
        if (this.mat != null) {
            double threshold = this.prettyPlot.getMatchThreshold();
            int m1 = this.mat.getMatrixIndex(s);
            int[][] matrix = this.mat.getMatrix();
            float matching = 0.0f;
            nseqs = 0;
            enumer = this.seqs.elements();
            while (enumer.hasMoreElements()) {
                Sequence seq = (Sequence)enumer.nextElement();
                SequenceJPanel seqPanel = (SequenceJPanel)this.graphicSequence.get(++nseqs);
                if (pos >= seq.getLength() || !seqPanel.isPrettyPlot()) continue;
                int m2 = this.mat.getMatrixIndex(seq.getResidue(pos));
                if (m1 < 0 || m2 < 0 || matrix[m1][m2] <= 0) continue;
                matching += seq.getWeight();
            }
            if ((double)matching >= threshold) {
                return this.prettyPlot.getMatchColour();
            }
        }
        return Color.black;
    }

    protected Color getPrettyBackground(Color textColour) {
        if (textColour.equals(this.prettyPlot.getIDColour())) {
            return this.prettyPlot.getIDBackgroundColour();
        }
        if (textColour.equals(this.prettyPlot.getMatchColour())) {
            return this.prettyPlot.getMatchBackgroundColour();
        }
        return null;
    }

    protected boolean isPrettyBox() {
        return this.prettyPlot.isPrettyBox();
    }

    protected int testUpAndDown(int pos, Sequence seq) {
        int seqIndex = this.seqs.indexOf(seq);
        int testUp = -1;
        if (seqIndex == 0) {
            testUp = 1;
        } else {
            Sequence seqUp = (Sequence)this.seqs.get(seqIndex - 1);
            String res = seqUp.getSequence().substring(pos, pos + 1);
            Color col = this.getColor(res, pos, seqUp.getName());
            if (col.equals(Color.black)) {
                testUp = 1;
            }
        }
        int testDown = -1;
        if (seqIndex + 1 == this.seqs.size()) {
            testDown = 1;
        } else {
            Sequence seqDown = (Sequence)this.seqs.get(seqIndex + 1);
            SequenceJPanel seqPanelDown = (SequenceJPanel)this.graphicSequence.get(seqIndex + 2);
            String res = seqDown.getSequence().substring(pos, pos + 1);
            Color col = this.getColor(res, pos, seqDown.getName());
            if (col.equals(Color.black) || !seqPanelDown.isPrettyPlot()) {
                testDown = 1;
            }
        }
        if (testUp > -1 && testDown > -1) {
            return 3;
        }
        if (testDown > -1) {
            return 2;
        }
        if (testUp > -1) {
            return 1;
        }
        return -1;
    }

    private Sequence removeSequence(String name) {
        boolean removed = false;
        int index = 0;
        Enumeration enumer = this.seqs.elements();
        Sequence seq = null;
        while (enumer.hasMoreElements()) {
            seq = (Sequence)enumer.nextElement();
            if (seq.getName().equals(name)) {
                this.removedSeqs.add(seq);
                removed = true;
                this.seqs.remove(seq);
                break;
            }
            ++index;
        }
        if (!removed) {
            return null;
        }
        if (this.drawNumber) {
            ++index;
        }
        this.seqBox.remove(index);
        this.seqNameBox.remove(index);
        this.graphicName.removeElementAt(index);
        this.graphicSequence.removeElementAt(index);
        return seq;
    }

    protected void deleteSequence(String name) {
        this.removeSequence(name);
        this.setMaxSeqLength();
        this.numberDraw.setSequenceLength(this.MAXSEQLENGTH);
        Dimension dpane = this.getPanelSize();
        this.setMinimumSize(dpane);
        this.setPreferredSize(dpane);
        this.numberDraw.setMaximumSize(this.numberDraw.getPreferredSize());
        this.numberDraw.setMinimumSize(this.numberDraw.getPreferredSize());
        this.setJScrollPaneViewportView();
    }

    protected void moveSequence(String name, int i) {
        Sequence seq = this.removeSequence(name);
        this.addSequence(seq, true, 0, 0, i);
    }

    protected void idSort() {
        int nseqs = 0;
        Enumeration enumer = this.seqs.elements();
        while (enumer.hasMoreElements()) {
            String name = ((Sequence)enumer.nextElement()).getName();
            if (name.equals("Consensus")) continue;
            ++nseqs;
        }
        Object[] seqName = new String[nseqs];
        int i = 0;
        enumer = this.seqs.elements();
        while (enumer.hasMoreElements()) {
            String name = ((Sequence)enumer.nextElement()).getName();
            if (name.equals("Consensus")) continue;
            seqName[i] = new String(name);
            ++i;
        }
        Arrays.sort(seqName);
        for (i = 0; i < nseqs; ++i) {
            this.moveSequence((String)seqName[i], i);
        }
    }

    protected void addSequence(Sequence seq, boolean addToSequences, int ypad, int fontSize, int index) {
        if (addToSequences) {
            this.seqs.add(index, seq);
        }
        if (this.drawNumber) {
            ++index;
        }
        SequenceJPanel gs = new SequenceJPanel(seq, this, this.drawSequence, this.drawBlackBox, this.drawColorBox, this.colorScheme, ypad);
        this.graphicSequence.add(index, gs);
        Box XBox = new Box(0);
        XBox.add(gs);
        XBox.add(Box.createHorizontalGlue());
        this.seqBox.add((Component)XBox, index);
        gs.setToolTipText("");
        SequenceNameJButton snj = new SequenceNameJButton(seq, ypad);
        this.graphicName.add(index, snj);
        XBox = new Box(0);
        XBox.add(Box.createHorizontalGlue());
        XBox.add(snj);
        this.seqNameBox.add((Component)XBox, index);
        if (seq.getLength() > this.MAXSEQLENGTH) {
            this.MAXSEQLENGTH = seq.getLength();
        }
        Dimension actual = gs.getMaximumSize();
        int slen = gs.getResidueWidth() * (int)((double)this.MAXSEQLENGTH * 1.2);
        gs.setMaximumSize(new Dimension(slen, (int)actual.getHeight()));
    }

    protected void addSequence(Sequence seq, boolean addToSequences, int ypad, int fontSize) {
        if (addToSequences) {
            this.seqs.add(seq);
        }
        SequenceJPanel gs = new SequenceJPanel(seq, this, this.drawSequence, this.drawBlackBox, this.drawColorBox, this.colorScheme, fontSize, ypad);
        this.graphicSequence.add(gs);
        Box XBox = new Box(0);
        XBox.add(gs);
        XBox.add(Box.createHorizontalGlue());
        this.seqBox.add(XBox);
        gs.setToolTipText("");
        SequenceNameJButton snj = new SequenceNameJButton(seq, ypad);
        this.graphicName.add(snj);
        XBox = new Box(0);
        XBox.add(Box.createHorizontalGlue());
        XBox.add(snj);
        this.seqNameBox.add(XBox);
        if (seq.getLength() > this.MAXSEQLENGTH) {
            this.MAXSEQLENGTH = seq.getLength();
        }
        Dimension actual = gs.getMaximumSize();
        int slen = gs.getResidueWidth() * (int)((double)this.MAXSEQLENGTH * 1.2);
        gs.setMaximumSize(new Dimension(slen, (int)actual.getHeight()));
    }

    public Dimension getViewSize() {
        this.hgt = 1;
        this.len = 0;
        Enumeration enumer = this.graphicSequence.elements();
        while (enumer.hasMoreElements()) {
            SequenceJPanel gs = (SequenceJPanel)enumer.nextElement();
            this.hgt += gs.getSequenceHeight();
            if (this.len >= gs.getSequenceWidth()) continue;
            this.len = gs.getSequenceWidth();
        }
        if (this.pc != null) {
            Dimension dplot = this.pc.getPreferredSize();
            this.hgt = this.hgt + (int)dplot.getHeight() + this.plotConStrut;
        }
        return new Dimension(this.len, this.hgt);
    }

    public String getName(int i) {
        return ((Sequence)this.seqs.get(i)).getName();
    }

    public Dimension getNameViewSize() {
        int hgtName = this.getNameHeight();
        int lenName = this.getNameWidth();
        return new Dimension(lenName, hgtName);
    }

    public Dimension getPanelSize() {
        this.getViewSize();
        return new Dimension(this.len, this.hgt);
    }

    public int getNameHeight() {
        int hgtName = 0;
        Enumeration enumer = this.graphicName.elements();
        while (enumer.hasMoreElements()) {
            hgtName += ((SequenceNameJButton)enumer.nextElement()).getPanelHeight();
        }
        return hgtName;
    }

    public int getNameWidth() {
        int lenName = 0;
        Enumeration enumer = this.graphicName.elements();
        while (enumer.hasMoreElements()) {
            SequenceNameJButton gs = (SequenceNameJButton)enumer.nextElement();
            if (lenName >= gs.getPanelWidth()) continue;
            lenName = gs.getPanelWidth();
        }
        return lenName;
    }

    public void setNamePanelWidth(int x) {
        this.seqNamePanel.setPreferredSize(new Dimension(x, 1000));
    }

    public int getPanelHeight() {
        this.getViewSize();
        return this.hgt;
    }

    public int getPanelWidth() {
        this.getViewSize();
        return this.len;
    }

    public Vector getGraphicSequence() {
        return this.graphicSequence;
    }

    public void setDrawBoxes(boolean drawBlackBox) {
        this.drawBlackBox = drawBlackBox;
        Enumeration enumer = this.graphicSequence.elements();
        while (enumer.hasMoreElements()) {
            ((SequenceJPanel)enumer.nextElement()).setDrawBoxes(drawBlackBox);
        }
        this.setJScrollPaneViewportView();
    }

    public void setDrawColor(boolean drawColorBox) {
        this.drawColorBox = drawColorBox;
        Enumeration enumer = this.graphicSequence.elements();
        while (enumer.hasMoreElements()) {
            ((SequenceJPanel)enumer.nextElement()).setDrawColor(drawColorBox);
        }
        this.setJScrollPaneViewportView();
    }

    public void setFontSizeForCollection(int fs) {
        Enumeration enumer = this.graphicSequence.elements();
        while (enumer.hasMoreElements()) {
            SequenceJPanel gs = (SequenceJPanel)enumer.nextElement();
            gs.setFontSize(fs);
            Dimension actual = gs.getMaximumSize();
            int slen = gs.getResidueWidth() * (int)((double)this.MAXSEQLENGTH * 1.2);
            gs.setMaximumSize(new Dimension(slen, (int)actual.getHeight()));
        }
        Enumeration enumName = this.graphicName.elements();
        while (enumName.hasMoreElements()) {
            SequenceNameJButton snjp = (SequenceNameJButton)enumName.nextElement();
            snjp.setFontSize(fs);
            snjp.setMaximumSize(snjp.getPreferredSize());
        }
        if (this.pc != null) {
            SequenceJPanel sj = (SequenceJPanel)this.graphicSequence.get(0);
            int interval = sj.getSequenceResidueWidth();
            this.pc.setInterval(interval);
            this.pc.setPlotSize();
        }
        Dimension dpane = this.getPanelSize();
        this.setMinimumSize(dpane);
        this.setPreferredSize(dpane);
        this.setNamePanelWidth(this.getNameWidth());
        this.setJScrollPaneViewportView();
    }

    public int getFontSize() {
        return ((SequenceJPanel)this.graphicSequence.get(0)).getFontSize();
    }

    public int findPattern(String pat, int oldResPosition, boolean wrapAround) {
        int newResPos;
        int resWidth = ((SequenceJPanel)this.graphicSequence.get(0)).getSequenceResidueWidth();
        Rectangle r = this.getViewRect();
        int ypos = r.y;
        int xpos = r.x / resWidth;
        int viewWidth = r.width / resWidth;
        pat = pat.toLowerCase();
        Enumeration enumer = this.graphicSequence.elements();
        while (enumer.hasMoreElements()) {
            SequenceJPanel sjp = (SequenceJPanel)enumer.nextElement();
            sjp.showPattern(pat);
        }
        if (oldResPosition > -1) {
            xpos = oldResPosition;
        }
        if ((newResPos = this.searchSequences(xpos, pat)) > -1) {
            int mid = this.findMiddle(newResPos, viewWidth, pat);
            this.jspSequence.getViewport().setViewPosition(new Point(mid * resWidth, ypos));
        } else if (wrapAround) {
            newResPos = this.searchSequences(0, pat);
            if (newResPos > -1) {
                int mid = this.findMiddle(newResPos, viewWidth, pat);
                this.jspSequence.getViewport().setViewPosition(new Point(mid * resWidth, ypos));
            }
        } else if (!wrapAround) {
            newResPos = oldResPosition;
        }
        return newResPos + 1;
    }

    private int searchSequences(int startSearch, String pat) {
        int newResPos = 0;
        int nfound = 0;
        Enumeration enumer = this.seqs.elements();
        while (enumer.hasMoreElements()) {
            Sequence seq = (Sequence)enumer.nextElement();
            int index = seq.getSequence().toLowerCase().indexOf(pat, startSearch);
            if (index <= -1) continue;
            if (nfound == 0 || index < newResPos) {
                newResPos = index;
            }
            ++nfound;
        }
        if (nfound == 0) {
            return -1;
        }
        return newResPos;
    }

    private int findMiddle(int newResPos, int viewWidth, String pat) {
        int viewWidth2 = viewWidth / 2;
        int mid = newResPos <= viewWidth2 ? 0 : newResPos - viewWidth2 + pat.length() / 2;
        return mid;
    }

    public void setColorScheme(Hashtable colourTable) {
        this.colorScheme = colourTable;
        this.drawColorBox = true;
        Enumeration enumer = this.graphicSequence.elements();
        while (enumer.hasMoreElements()) {
            SequenceJPanel sjp = (SequenceJPanel)enumer.nextElement();
            sjp.setColorScheme(colourTable);
            sjp.setDrawColor(this.drawColorBox);
        }
    }

    public void setPrettyPlot(boolean bpretty, PrettyPlotJFrame prettyPlot) {
        this.prettyPlot = prettyPlot;
        Enumeration enumer = this.graphicSequence.elements();
        while (enumer.hasMoreElements()) {
            ((SequenceJPanel)enumer.nextElement()).setPrettyPlot(bpretty);
        }
    }

    public void setJScrollPaneViewportView() {
        this.jspSequence.setViewportView(this);
    }

    public int getNumberPages(PageFormat format) {
        return this.getNumberPages(format, this.getResiduesPerLine(format));
    }

    public int getNumberPages(PageFormat format, int numResPerLine) {
        double pageHeight = format.getImageableHeight();
        int residueWidth = ((SequenceJPanel)this.graphicSequence.get(0)).getSequenceHeight();
        int nblockPerPage = (int)(pageHeight / (double)((this.graphicSequence.size() + 2) * residueWidth));
        int npage = this.MAXSEQLENGTH / (nblockPerPage * numResPerLine) + 1;
        return npage;
    }

    public Dimension getImageableSize(int numResPerLine) {
        SequenceJPanel seq = (SequenceJPanel)this.graphicSequence.get(0);
        int residueHeight = seq.getSequenceHeight();
        int alignHeight = (this.graphicSequence.size() + 1) * residueHeight;
        int nalign = Math.round((float)this.MAXSEQLENGTH / (float)numResPerLine + 0.5f) * alignHeight;
        int width = seq.getResidueWidth() * (numResPerLine + 2) + this.getNameWidth();
        return new Dimension(width, nalign);
    }

    public int getResiduesPerLine(PageFormat format) {
        double pwidth = format.getImageableWidth() - (double)this.getNameWidth();
        int resWidth = ((SequenceJPanel)this.graphicSequence.get(0)).getSequenceResidueWidth();
        return (int)(pwidth / (double)resWidth);
    }

    public int getResiduesPerPage(PageFormat format, int numResPerLine) {
        double pageHeight = format.getImageableHeight();
        int residueWidth = ((SequenceJPanel)this.graphicSequence.get(0)).getSequenceHeight();
        int nblockPerPage = (int)(pageHeight / (double)(residueWidth * (this.graphicSequence.size() + 2)));
        return nblockPerPage * numResPerLine;
    }

    public int print(Graphics g, PageFormat format, int pageIndex) throws PrinterException {
        Graphics2D g2d = (Graphics2D)g.create();
        this.drawSequences(g2d, format, pageIndex, this.numResiduePerLine);
        return 0;
    }

    protected void setNumberOfResiduesPerLine(int numResiduePerLine) {
        this.numResiduePerLine = numResiduePerLine;
    }

    public void drawSequences(Graphics2D g2d, PageFormat format, int pageIndex) {
        int numResPerLine = this.getResiduesPerLine(format);
        this.drawSequences(g2d, format, pageIndex, numResPerLine);
    }

    public void drawSequences(Graphics2D g2d, PageFormat format, int pageIndex, int numResPerLine) {
        g2d.translate(format.getImageableX(), format.getImageableY());
        int resPerPage = this.getResiduesPerPage(format, numResPerLine);
        int istart = resPerPage * pageIndex;
        int istop = istart + resPerPage;
        if (istop > this.MAXSEQLENGTH) {
            istop = this.MAXSEQLENGTH;
        }
        for (int i = istart; i < istop; i += numResPerLine) {
            Enumeration enumer = this.graphicSequence.elements();
            SequenceJPanel gs = null;
            while (enumer.hasMoreElements()) {
                int iend = i + numResPerLine;
                if (iend > istop) {
                    iend = istop;
                }
                gs = (SequenceJPanel)enumer.nextElement();
                gs.getSequencePrintGraphic(g2d, this.getNameWidth(), i, iend);
                gs.getNamePrintGraphic(g2d);
                g2d.translate(0, gs.getSequenceHeight());
            }
            g2d.translate(0, gs.getSequenceHeight());
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public int getScrollableBlockIncrement(Rectangle r, int orientation, int direction) {
        return 60;
    }

    public int getScrollableUnitIncrement(Rectangle r, int orientation, int direction) {
        return 60;
    }

    public static void main(String[] args) {
        Vector<Sequence> seqs = new Vector<Sequence>();
        seqs.add(new Sequence("Seq1", "ACCaaaaaaaaaaaaaaaaaaaaTAGAtTATACCaaaaaaaaaaaaaaaaaaaaTAGAtTATACCaaaaaaaaaaaaaaaaaaaaTAGAtTAT"));
        seqs.add(new Sequence("Seq2", "ACCaaaaaaaaaaaaaaaaaaaaTAGAtTATACCaaaaaaaaaaaaaaaaaaaaTAGAtTATACCaaaaaaaaaaaaaaaaaaaaTAGAtTAT"));
        JScrollPane jspSequence = new JScrollPane();
        GraphicSequenceCollection gsc = new GraphicSequenceCollection(seqs, null, jspSequence, true, true, true, false, null);
        jspSequence.setViewportView(gsc);
        JFrame f = new JFrame("Sequence Panel");
        JPanel pane = (JPanel)f.getContentPane();
        pane.add(jspSequence);
        f.pack();
        f.setVisible(true);
    }

    protected void drawNumber() {
        this.numberDraw = new SequenceJPanel(10, this.MAXSEQLENGTH);
        this.graphicSequence.add(this.numberDraw);
        Box XBox = new Box(0);
        XBox.add(this.numberDraw);
        XBox.add(Box.createHorizontalGlue());
        this.seqBox.add(XBox);
        this.setNumberSize();
        SequenceNameJButton snjBlank = new SequenceNameJButton(new Sequence("seq-id:", ""), 0);
        snjBlank.setEnabled(false);
        this.graphicName.add(snjBlank);
        XBox = new Box(0);
        XBox.add(Box.createHorizontalGlue());
        XBox.add(snjBlank);
        this.seqNameBox.add(XBox);
    }

    protected void addAnnotationSequence(Sequence s) {
        this.addSequence(s, true, 0, this.getFontSize());
    }
}

