/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.programs;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JTextArea;

public class RunEmbossApplication2 {
    private Process p;
    private StringBuffer stdout = new StringBuffer();
    private StringBuffer stderr = new StringBuffer();
    private String initialIOError = null;
    private String status = "0";
    private StdoutHandler stdouth;
    private StderrHandler stderrh;
    private JTextArea textArea;

    public RunEmbossApplication2(String[] embossCommand, String[] envp, File project) {
        Runtime embossRun = Runtime.getRuntime();
        try {
            this.p = embossRun.exec(embossCommand, envp, project);
            this.stdouth = new StdoutHandler(this);
            this.stderrh = new StderrHandler(this);
            this.stdouth.start();
            this.stderrh.start();
        }
        catch (IOException ioe) {
            System.err.println("Error executing: " + embossCommand);
            this.initialIOError = ioe.getMessage();
            this.status = "1";
        }
    }

    public RunEmbossApplication2(String embossCommand, String[] envp, File project) {
        Runtime embossRun = Runtime.getRuntime();
        try {
            this.p = embossRun.exec(embossCommand, envp, project);
            this.stdouth = new StdoutHandler(this);
            this.stderrh = new StderrHandler(this);
            this.stdouth.start();
            this.stderrh.start();
        }
        catch (IOException ioe) {
            System.err.println("Error executing: " + embossCommand);
            this.initialIOError = ioe.getMessage();
            this.status = "1";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcessStderr() {
        BufferedInputStream stderrStream = null;
        BufferedReader stderrRead = null;
        try {
            stderrStream = new BufferedInputStream(this.p.getErrorStream());
            stderrRead = new BufferedReader(new InputStreamReader(stderrStream));
            char[] c = new char[100];
            int nc = 0;
            while ((nc = stderrRead.read(c, 0, 100)) != -1) {
                this.stderr = this.stderr.append(new String(c, 0, nc));
            }
        }
        catch (Exception io) {
            io.printStackTrace();
            System.err.println("RunEmbossApplication2: Error in collecting standard error output");
        }
        finally {
            try {
                if (stderrStream != null) {
                    stderrStream.close();
                }
            }
            catch (IOException ioe) {
                System.err.println("RunEmbossApplication2: Error closing stream");
            }
            try {
                if (stderrRead != null) {
                    stderrRead.close();
                }
            }
            catch (IOException ioe) {
                System.err.println("RunEmbossApplication2: Error closing reader");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProcessStdout() {
        BufferedInputStream stdoutStream = null;
        BufferedReader stdoutRead = null;
        try {
            stdoutStream = new BufferedInputStream(this.p.getInputStream());
            stdoutRead = new BufferedReader(new InputStreamReader(stdoutStream));
            char[] c = new char[100];
            int nc = 0;
            while ((nc = stdoutRead.read(c, 0, 100)) != -1) {
                String chunk = new String(c, 0, nc);
                this.stdout = this.stdout.append(chunk);
                if (this.textArea == null) continue;
                this.textArea.append(chunk);
                this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
            }
        }
        catch (IOException io) {
            System.err.println("RunEmbossApplication2: Error in collecting standard out");
        }
        finally {
            try {
                if (stdoutStream != null) {
                    stdoutStream.close();
                }
            }
            catch (IOException ioe) {
                System.err.println("RunEmbossApplication2: Error closing stream");
            }
            try {
                if (stdoutRead != null) {
                    stdoutRead.close();
                }
            }
            catch (IOException ioe) {
                System.err.println("RunEmbossApplication2: Error closing reader");
            }
        }
    }

    public String getProcessStdout() {
        try {
            while (this.stdouth.isAlive()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return new String(this.stdout.toString().trim());
    }

    public String getProcessStderr() {
        try {
            while (this.stderrh.isAlive()) {
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        return new String(this.stderr.toString().trim());
    }

    public void waitFor() {
        try {
            int exitVal = this.p.waitFor();
            if (exitVal != 0) {
                System.out.println("Exit value:: " + exitVal);
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    public Process getProcess() {
        return this.p;
    }

    public String getStatus() {
        return this.status;
    }

    public String getInitialIOError() {
        return this.initialIOError;
    }

    class StderrHandler
    extends Thread {
        RunEmbossApplication2 rea;

        protected StderrHandler(RunEmbossApplication2 rea) {
            this.rea = rea;
        }

        public void run() {
            this.rea.readProcessStderr();
        }
    }

    class StdoutHandler
    extends Thread {
        RunEmbossApplication2 rea;

        protected StdoutHandler(RunEmbossApplication2 rea) {
            this.rea = rea;
        }

        public void run() {
            this.rea.readProcessStdout();
        }
    }
}

