/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.soap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.MemoryComboBox;

public class ServerSetup
extends JTabbedPane {
    private MemoryComboBox publicURL;
    private MemoryComboBox privateURL;
    private MemoryComboBox publicName;
    private MemoryComboBox privateName;
    private MemoryComboBox proxyName;
    private MemoryComboBox proxyPort;
    private MemoryComboBox proxyBrowserName;
    private MemoryComboBox proxyBrowserPort;
    private JCheckBox userAuth;
    private JCheckBox useProxy;
    private JCheckBox useBrowserProxy;
    private JCheckBox callTFM;
    private JembossParams myset;

    public ServerSetup(JembossParams mysettings) {
        this(mysettings, true);
    }

    public ServerSetup(final JembossParams mysettings, boolean withSoap) {
        this.myset = mysettings;
        GridLayout gl = null;
        JPanel jpWest = null;
        JPanel jpCenter = null;
        if (withSoap) {
            Vector<String> PublicServerURL = new Vector<String>();
            PublicServerURL.add(this.myset.getPublicSoapURL());
            Vector<String> PrivateServerURL = new Vector<String>();
            PrivateServerURL.add(this.myset.getPrivateSoapURL());
            Vector<String> PublicServerName = new Vector<String>();
            PublicServerName.add(this.myset.getPublicSoapService());
            Vector<String> PrivateServerName = new Vector<String>();
            PrivateServerName.add(this.myset.getPrivateSoapService());
            Vector<String> proxyNameSettings = new Vector<String>();
            proxyNameSettings.add(this.myset.getProxyHost());
            Vector<Integer> proxyPortSettings = new Vector<Integer>();
            proxyPortSettings.add(new Integer(this.myset.getProxyPortNum()));
            Vector<String> proxyBrowserNameSettings = new Vector<String>();
            proxyBrowserNameSettings.add(this.myset.getBrowserProxyHost());
            Vector<Integer> proxyBrowserPortSettings = new Vector<Integer>();
            proxyBrowserPortSettings.add(new Integer(this.myset.getBrowserProxyPort()));
            gl = new GridLayout(7, 1, 6, 6);
            JPanel general = new JPanel(new BorderLayout());
            jpWest = new JPanel(gl);
            jpCenter = new JPanel(gl);
            JLabel lab = new JLabel("Public Server");
            jpWest.add(lab);
            this.publicURL = new MemoryComboBox((Vector)PublicServerURL);
            jpCenter.add(this.publicURL);
            lab = new JLabel("Public Service Name");
            jpWest.add(lab);
            this.publicName = new MemoryComboBox((Vector)PublicServerName);
            jpCenter.add(this.publicName);
            jpWest.add(new JLabel(""));
            jpCenter.add(new JLabel(""));
            lab = new JLabel("Private Server");
            jpWest.add(lab);
            this.privateURL = new MemoryComboBox((Vector)PrivateServerURL);
            jpCenter.add(this.privateURL);
            lab = new JLabel("Private Service Name ");
            jpWest.add(lab);
            this.privateName = new MemoryComboBox((Vector)PrivateServerName);
            jpCenter.add(this.privateName);
            jpWest.add(new JLabel(""));
            jpCenter.add(new JLabel(""));
            this.userAuth = new JCheckBox("User authentication required by private server", this.myset.getUseAuth());
            jpWest.add(new JLabel(""));
            jpCenter.add(this.userAuth);
            general.add((Component)jpWest, "West");
            general.add((Component)jpCenter, "Center");
            this.addTab("Servers", general);
            gl = new GridLayout(7, 1, 6, 6);
            JPanel proxy = new JPanel(new BorderLayout());
            this.useProxy = new JCheckBox("Use proxy settings to connect to the server", this.myset.getUseProxy());
            jpWest = new JPanel(gl);
            jpCenter = new JPanel(gl);
            jpWest.add(new JLabel(""));
            jpCenter.add(new JLabel(""));
            jpWest.add(new JLabel(""));
            jpCenter.add(this.useProxy);
            lab = new JLabel("Proxy ");
            jpWest.add(lab);
            this.proxyName = new MemoryComboBox((Vector)proxyNameSettings);
            jpCenter.add(this.proxyName);
            lab = new JLabel("Proxy Port");
            jpWest.add(lab);
            this.proxyPort = new MemoryComboBox((Vector)proxyPortSettings);
            jpCenter.add(this.proxyPort);
            this.proxyName.setEnabled(this.useProxy.isSelected());
            this.proxyPort.setEnabled(this.useProxy.isSelected());
            this.useProxy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ServerSetup.this.proxyName.setEnabled(ServerSetup.this.useProxy.isSelected());
                    ServerSetup.this.proxyPort.setEnabled(ServerSetup.this.useProxy.isSelected());
                    String[] settings = new String[]{new String("proxy.override=true")};
                    ServerSetup.this.myset.updateJembossPropStrings(settings);
                }
            });
            jpWest.add(new JLabel(this.myset.proxyDescription()));
            jpCenter.add(new JLabel(""));
            jpWest.add(new JLabel(""));
            jpCenter.add(new JLabel(""));
            proxy.add((Component)jpWest, "West");
            proxy.add((Component)jpCenter, "Center");
            this.addTab("Proxies", proxy);
            proxy = new JPanel(new BorderLayout());
            gl = new GridLayout(7, 1, 6, 6);
            jpWest = new JPanel(gl);
            jpCenter = new JPanel(gl);
            this.useBrowserProxy = new JCheckBox("Use proxy settings for HTTP browser connection", this.myset.isBrowserProxy());
            jpWest.add(new JLabel(""));
            jpCenter.add(new JLabel(""));
            jpWest.add(new JLabel(""));
            jpCenter.add(this.useBrowserProxy);
            lab = new JLabel("Proxy ");
            jpWest.add(lab);
            this.proxyBrowserName = new MemoryComboBox((Vector)proxyBrowserNameSettings);
            jpCenter.add(this.proxyBrowserName);
            lab = new JLabel("Proxy Port   ");
            jpWest.add(lab);
            this.proxyBrowserPort = new MemoryComboBox((Vector)proxyBrowserPortSettings);
            jpCenter.add(this.proxyBrowserPort);
            this.proxyBrowserName.setEnabled(this.useBrowserProxy.isSelected());
            this.proxyBrowserPort.setEnabled(this.useBrowserProxy.isSelected());
            this.useBrowserProxy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ServerSetup.this.proxyBrowserName.setEnabled(ServerSetup.this.useBrowserProxy.isSelected());
                    ServerSetup.this.proxyBrowserPort.setEnabled(ServerSetup.this.useBrowserProxy.isSelected());
                }
            });
            this.callTFM = new JCheckBox("Get help page directly from the server");
            this.callTFM.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ServerSetup.this.useBrowserProxy.setEnabled(!ServerSetup.this.callTFM.isSelected());
                    ServerSetup.this.proxyBrowserName.setEnabled(!ServerSetup.this.callTFM.isSelected());
                    ServerSetup.this.proxyBrowserPort.setEnabled(!ServerSetup.this.callTFM.isSelected());
                }
            });
            jpWest.add(new JLabel(""));
            jpCenter.add(this.callTFM);
            jpCenter.add(Box.createVerticalGlue());
            proxy.add((Component)jpWest, "West");
            proxy.add((Component)jpCenter, "Center");
            this.addTab("Browser Proxies", proxy);
        }
        gl = new GridLayout(6, 1, 6, 6);
        JPanel client = new JPanel(new BorderLayout());
        jpWest = new JPanel(gl);
        jpCenter = new JPanel(gl);
        jpWest.add(new JLabel("Java version  "));
        jpCenter.add(new JLabel(System.getProperty("java.version")));
        jpWest.add(new JLabel("Java home"));
        jpCenter.add(new JLabel(System.getProperty("java.home")));
        jpWest.add(new JLabel("User name "));
        jpCenter.add(new JLabel(System.getProperty("user.name")));
        jpWest.add(new JLabel("User home"));
        jpCenter.add(new JLabel(System.getProperty("user.home")));
        client.add((Component)jpWest, "West");
        client.add((Component)jpCenter, "Center");
        this.addTab("Client properties", client);
        if (!withSoap) {
            JPanel proxy = new JPanel(new BorderLayout());
            gl = new GridLayout(5, 1, 6, 6);
            jpWest = new JPanel(gl);
            jpCenter = new JPanel(gl);
            this.useBrowserProxy = new JCheckBox("Use proxy settings for HTTP browser connection", this.myset.isBrowserProxy());
            jpWest.add(new JLabel(""));
            jpCenter.add(new JLabel(""));
            jpWest.add(new JLabel(""));
            jpCenter.add(this.useBrowserProxy);
            JLabel lab = new JLabel("Proxy ");
            jpWest.add(lab);
            Vector<String> proxyBrowserNameSettings = new Vector<String>();
            if (System.getProperty("http.proxyHost") != null) {
                proxyBrowserNameSettings.add(System.getProperty("http.proxyHost"));
            }
            this.proxyBrowserName = new MemoryComboBox((Vector)proxyBrowserNameSettings);
            jpCenter.add(this.proxyBrowserName);
            lab = new JLabel("Proxy Port   ");
            jpWest.add(lab);
            Vector<String> proxyBrowserPortSettings = new Vector<String>();
            if (System.getProperty("http.proxyPort") != null) {
                proxyBrowserPortSettings.add(System.getProperty("http.proxyPort"));
            }
            this.proxyBrowserPort = new MemoryComboBox((Vector)proxyBrowserPortSettings);
            jpCenter.add(this.proxyBrowserPort);
            this.proxyBrowserName.setEnabled(this.useBrowserProxy.isSelected());
            this.proxyBrowserPort.setEnabled(this.useBrowserProxy.isSelected());
            this.useBrowserProxy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ServerSetup.this.proxyBrowserName.setEnabled(ServerSetup.this.useBrowserProxy.isSelected());
                    ServerSetup.this.proxyBrowserPort.setEnabled(ServerSetup.this.useBrowserProxy.isSelected());
                    if (ServerSetup.this.useBrowserProxy.isSelected()) {
                        String[] settings = new String[]{new String("browserProxy.host=" + (String)ServerSetup.this.proxyBrowserName.getSelectedItem()), new String("browserProxy.port=" + (String)ServerSetup.this.proxyBrowserPort.getSelectedItem()), new String("browserProxy.use=true")};
                        mysettings.updateJembossPropStrings(settings);
                    }
                }
            });
            proxy.add((Component)jpWest, "West");
            proxy.add((Component)jpCenter, "Center");
            this.addTab("Browser Proxies", proxy);
        }
    }

    public JembossParams setNewSettings() {
        String[] settings = new String[12];
        settings[0] = new String("server.public=" + (String)this.publicURL.getSelectedItem());
        settings[1] = new String("server.private=" + (String)this.privateURL.getSelectedItem());
        settings[2] = new String("service.public=" + (String)this.publicName.getSelectedItem());
        settings[3] = new String("service.private=" + (String)this.privateName.getSelectedItem());
        settings[4] = this.userAuth.isSelected() ? new String("user.auth=true") : new String("user.auth=false");
        settings[6] = new String("proxy.host=" + (String)this.proxyName.getSelectedItem());
        settings[7] = new String("proxy.port=" + ((Integer)this.proxyPort.getSelectedItem()).toString());
        settings[5] = this.useProxy.isSelected() ? new String("proxy.use=true") : new String("proxy.use=false");
        settings[8] = new String("browserProxy.host=" + (String)this.proxyBrowserName.getSelectedItem());
        settings[9] = new String("browserProxy.port=" + ((Integer)this.proxyBrowserPort.getSelectedItem()).toString());
        settings[10] = this.callTFM.isSelected() ? new String("tfm.use=true") : new String("tfm.use=false");
        settings[11] = this.useBrowserProxy.isSelected() ? new String("browserProxy.use=true") : new String("browserProxy.use=false");
        this.myset.updateJembossPropStrings(settings);
        return this.myset;
    }
}

