/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.editor.PrintAlignment;
import org.emboss.jemboss.gui.ScrollPanel;

public class PrintAlignmentImage
extends ScrollPanel {
    private PageFormat format = null;
    private int pageIndex = 0;
    private GraphicSequenceCollection gsc;
    private JTextField statusField = new JTextField("");
    private int nResPerLine = 0;
    private boolean antiAlias = false;
    private String ftype;

    public PrintAlignmentImage(GraphicSequenceCollection gsc, PageFormat format) {
        this(gsc);
        this.format = format;
    }

    public PrintAlignmentImage(GraphicSequenceCollection gsc) {
        this.gsc = gsc;
        this.setBackground(Color.white);
    }

    protected void setFormat(PageFormat format) {
        this.format = format;
    }

    protected PageFormat getFormat() {
        return this.format;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.nResPerLine == 0) {
            this.gsc.drawSequences(g2d, this.format, this.pageIndex);
        } else {
            this.gsc.drawSequences(g2d, this.format, this.pageIndex, this.nResPerLine);
        }
    }

    public void print() {
        if (this.format == null) {
            this.getFormatDialog();
        }
        try {
            String fsave = this.showOptions();
            if (fsave == null) {
                return;
            }
            int npages = this.gsc.getNumberPages(this.format, this.nResPerLine);
            for (int i = 0; i < npages; ++i) {
                RenderedImage rendImage = this.createAlignmentImage(i);
                this.writeImageToFile(rendImage, new File(fsave + i + "." + this.ftype), this.ftype);
            }
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(this, "This option requires Java 1.4 or higher.");
        }
    }

    public void print(int nResPerLine, String type, String filePrefix, boolean landscape, double leftMargin, double rightMargin, double topMargin, double btmMargin) {
        this.nResPerLine = nResPerLine;
        this.format = new PageFormat();
        if (landscape) {
            this.format.setOrientation(0);
        } else {
            this.format.setOrientation(1);
        }
        if (leftMargin > 0.0) {
            Paper paper = this.format.getPaper();
            double width = paper.getWidth() - 72.0 * (leftMargin + rightMargin);
            double hgt = paper.getHeight() - 72.0 * (topMargin + btmMargin);
            paper.setImageableArea(leftMargin * 72.0, topMargin * 72.0, width, hgt);
            this.format.setPaper(paper);
        }
        if (nResPerLine <= 0) {
            this.nResPerLine = this.gsc.getResiduesPerLine(this.format);
        }
        try {
            int npages = this.gsc.getNumberPages(this.format, this.nResPerLine);
            for (int i = 0; i < npages; ++i) {
                RenderedImage rendImage = this.createAlignmentImage(i);
                this.writeImageToFile(rendImage, new File(filePrefix + i + "." + type), type);
            }
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(this, "This option requires Java 1.4 or higher.");
        }
    }

    public void print(String filePrefix, double leftMargin, double rightMargin, double topMargin, double btmMargin) {
        this.print(this.nResPerLine, this.ftype, filePrefix, leftMargin, rightMargin, topMargin, btmMargin);
    }

    public void print(int nResPerLine, String type, String filePrefix, double leftMargin, double rightMargin, double topMargin, double btmMargin) {
        this.nResPerLine = nResPerLine;
        this.format = new PageFormat();
        Dimension d = this.gsc.getImageableSize(nResPerLine);
        double imageWidth = d.getWidth();
        double imageHeight = d.getHeight();
        Paper paper = this.format.getPaper();
        if (leftMargin > 0.0) {
            paper.setSize(imageWidth + ((leftMargin *= 72.0) + (rightMargin *= 72.0)), imageHeight + ((topMargin *= 72.0) + (btmMargin *= 72.0)));
        } else {
            paper.setSize(imageWidth, imageHeight);
            leftMargin = 0.0;
            topMargin = 0.0;
        }
        paper.setImageableArea(leftMargin, topMargin, imageWidth, imageHeight + imageHeight);
        this.format.setPaper(paper);
        try {
            RenderedImage rendImage = this.createAlignmentImage(0);
            this.writeImageToFile(rendImage, new File(filePrefix + "." + type), type);
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(this, "This option requires Java 1.4 or higher.");
        }
    }

    protected String showOptions() {
        Box YBox = Box.createVerticalBox();
        YBox.add(Box.createVerticalGlue());
        if (this.format == null) {
            this.format = new PageFormat();
        }
        String mres = Integer.toString(this.gsc.getResiduesPerLine(this.format));
        JLabel jres = new JLabel("Residues per line: [max:" + mres + "]");
        if (this.nResPerLine != 0) {
            mres = Integer.toString(this.nResPerLine);
        }
        YBox.add(jres);
        JTextField maxResiduesField = new JTextField(mres, 4);
        Dimension d = maxResiduesField.getPreferredSize();
        maxResiduesField.setMaximumSize(d);
        Box bacross = Box.createHorizontalBox();
        bacross.add(Box.createHorizontalGlue());
        bacross.add(maxResiduesField);
        YBox.add(bacross);
        String cwd = System.getProperty("user.dir");
        JFileChooser fc = new JFileChooser(cwd);
        File fselect = new File(cwd + System.getProperty("file.separator") + "jae_image.jpeg");
        fc.setSelectedFile(fselect);
        JLabel labFormat = new JLabel("Select Format:");
        Font font = labFormat.getFont();
        labFormat.setFont(font.deriveFont(1));
        YBox.add(labFormat);
        bacross = Box.createHorizontalBox();
        JComboBox<String> formatSelect = new JComboBox<String>(ImageIO.getWriterFormatNames());
        d = formatSelect.getPreferredSize();
        formatSelect.setMaximumSize(d);
        bacross.add(Box.createHorizontalGlue());
        bacross.add(formatSelect);
        YBox.add(bacross);
        fc.setAccessory(YBox);
        int n = fc.showSaveDialog(null);
        if (n == 1) {
            return null;
        }
        this.nResPerLine = Integer.parseInt(maxResiduesField.getText());
        this.ftype = (String)formatSelect.getSelectedItem();
        String fsave = fc.getSelectedFile().getAbsolutePath().toLowerCase();
        if (fsave.endsWith(".png") || fsave.endsWith(".jpg") || fsave.endsWith(".jpeg")) {
            int ind = fsave.lastIndexOf(".");
            fsave = fc.getSelectedFile().getAbsolutePath();
            fsave = fsave.substring(0, ind);
        } else {
            fsave = fc.getSelectedFile().getAbsolutePath();
        }
        return fsave;
    }

    protected String showPrintPreviewOptions() {
        JPanel joptions = new JPanel();
        Box YBox = Box.createVerticalBox();
        joptions.add(YBox);
        Box XBox = Box.createHorizontalBox();
        if (this.format == null) {
            this.format = new PageFormat();
        }
        String mres = Integer.toString(this.gsc.getResiduesPerLine(this.format));
        JLabel jres = new JLabel("Residues per line: [max:" + mres + "]");
        if (this.nResPerLine != 0) {
            mres = Integer.toString(this.nResPerLine);
        }
        JTextField maxResiduesField = new JTextField(mres);
        XBox.add(jres);
        XBox.add(maxResiduesField);
        XBox.add(Box.createHorizontalGlue());
        YBox.add(XBox);
        JOptionPane.showMessageDialog(null, joptions, "Options", -1);
        this.nResPerLine = Integer.parseInt(maxResiduesField.getText());
        return null;
    }

    protected PageFormat getFormatDialog() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.format = new PageFormat();
        this.format = printerJob.pageDialog(this.format);
        return this.format;
    }

    protected void setAntiAlias(boolean antiAlias) {
        this.antiAlias = antiAlias;
    }

    private RenderedImage createAlignmentImage(int pageIndex) {
        int width = (int)this.format.getWidth();
        int height = (int)this.format.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        if (this.antiAlias) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2d.setColor(Color.white);
        g2d.fillRect(0, 0, width, height);
        if (this.nResPerLine == 0) {
            this.gsc.drawSequences(g2d, this.format, pageIndex);
        } else {
            this.gsc.drawSequences(g2d, this.format, pageIndex, this.nResPerLine);
        }
        return bufferedImage;
    }

    protected void printSinglePagePreview() {
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
        this.statusField.setBorder(compound);
        this.statusField.setEditable(false);
        this.format = new PageFormat();
        Dimension d = this.gsc.getImageableSize(this.nResPerLine);
        double imageWidth = d.getWidth();
        double imageHeight = d.getHeight();
        Paper paper = this.format.getPaper();
        paper.setSize(imageWidth, imageHeight);
        paper.setImageableArea(0.0, 0.0, imageWidth, imageHeight + imageHeight);
        this.format.setPaper(paper);
        this.statusField.setText(this.pageIndex + "1 of 1 page(s)");
        final JFrame f = new JFrame("Print Preview");
        JPanel jpane = (JPanel)f.getContentPane();
        JScrollPane scrollPane = new JScrollPane(this);
        jpane.setLayout(new BorderLayout());
        jpane.add((Component)scrollPane, "Center");
        jpane.add((Component)this.statusField, "South");
        Dimension dScreen = f.getToolkit().getScreenSize();
        d = new Dimension((int)this.format.getWidth(), (int)this.format.getHeight());
        this.setPreferredSize(d);
        d = new Dimension((int)(dScreen.getWidth() / 2.0), (int)(dScreen.getHeight() * 3.0 / 4.0));
        f.setSize(d);
        JMenuBar menuBar = new JMenuBar();
        JMenu filemenu = new JMenu("File");
        menuBar.add(filemenu);
        JMenuItem printImage = new JMenuItem("Print Image File (png/jpeg)...");
        printImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintAlignmentImage.this.print();
            }
        });
        filemenu.add(printImage);
        filemenu.add(new JSeparator());
        JMenuItem menuClose = new JMenuItem("Close");
        menuClose.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        filemenu.add(menuClose);
        menuClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        f.setJMenuBar(menuBar);
        f.setVisible(true);
    }

    protected void printPreview() {
        Border loweredbevel = BorderFactory.createLoweredBevelBorder();
        Border raisedbevel = BorderFactory.createRaisedBevelBorder();
        CompoundBorder compound = BorderFactory.createCompoundBorder(raisedbevel, loweredbevel);
        this.statusField.setBorder(compound);
        this.statusField.setEditable(false);
        if (this.format == null) {
            this.format = this.getFormatDialog();
        }
        this.showPrintPreviewOptions();
        final int npages = this.gsc.getNumberPages(this.format, this.nResPerLine);
        this.statusField.setText(this.pageIndex + "1 of " + npages + " page(s)");
        final JFrame f = new JFrame("Print Preview");
        JPanel jpane = (JPanel)f.getContentPane();
        JScrollPane scrollPane = new JScrollPane(this);
        jpane.setLayout(new BorderLayout());
        jpane.add((Component)scrollPane, "Center");
        jpane.add((Component)this.statusField, "South");
        Dimension dScreen = f.getToolkit().getScreenSize();
        Dimension d = new Dimension((int)this.format.getWidth(), (int)this.format.getHeight());
        this.setPreferredSize(d);
        d = new Dimension((int)(dScreen.getWidth() / 2.0), (int)(dScreen.getHeight() * 3.0 / 4.0));
        f.setSize(d);
        JMenuBar menuBar = new JMenuBar();
        JMenu filemenu = new JMenu("File");
        menuBar.add(filemenu);
        JMenu printMenu = new JMenu("Print");
        filemenu.add(printMenu);
        JMenuItem print = new JMenuItem("Print Postscript...");
        print.setToolTipText("Print using available printers in your computer\nor export alignment image to a postscript file (if you have  installed postscript printers)");
        print.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new PrintAlignment(PrintAlignmentImage.this.gsc);
            }
        });
        printMenu.add(print);
        JMenuItem printImage = new JMenuItem("Print Image Files (png/jpeg)...");
        printImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintAlignmentImage.this.print();
            }
        });
        printMenu.add(printImage);
        filemenu.add(new JSeparator());
        JMenuItem menuClose = new JMenuItem("Close");
        menuClose.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        filemenu.add(menuClose);
        menuClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        final JButton nextPage = new JButton(">");
        final JButton endPage = new JButton(">>");
        final JButton previousPage = new JButton("<");
        final JButton firstPage = new JButton("<<");
        menuBar.add(firstPage);
        firstPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintAlignmentImage.this.pageIndex = 0;
                PrintAlignmentImage.this.repaint();
                previousPage.setEnabled(false);
                firstPage.setEnabled(false);
                nextPage.setEnabled(true);
                endPage.setEnabled(true);
                PrintAlignmentImage.this.statusField.setText(PrintAlignmentImage.this.pageIndex + 1 + " of " + npages + " pages");
            }
        });
        menuBar.add(previousPage);
        previousPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintAlignmentImage.this.pageIndex--;
                PrintAlignmentImage.this.repaint();
                if (PrintAlignmentImage.this.pageIndex == 0) {
                    previousPage.setEnabled(false);
                    firstPage.setEnabled(false);
                }
                nextPage.setEnabled(true);
                endPage.setEnabled(true);
                PrintAlignmentImage.this.statusField.setText(PrintAlignmentImage.this.pageIndex + 1 + " of " + npages + " pages");
            }
        });
        previousPage.setEnabled(false);
        firstPage.setEnabled(false);
        menuBar.add(nextPage);
        nextPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintAlignmentImage.this.pageIndex++;
                PrintAlignmentImage.this.repaint();
                if (PrintAlignmentImage.this.pageIndex == npages - 1) {
                    nextPage.setEnabled(false);
                    endPage.setEnabled(false);
                }
                previousPage.setEnabled(true);
                firstPage.setEnabled(true);
                PrintAlignmentImage.this.statusField.setText(PrintAlignmentImage.this.pageIndex + 1 + " of " + npages + " pages");
            }
        });
        menuBar.add(endPage);
        endPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintAlignmentImage.this.pageIndex = npages - 1;
                PrintAlignmentImage.this.repaint();
                nextPage.setEnabled(false);
                endPage.setEnabled(false);
                previousPage.setEnabled(true);
                firstPage.setEnabled(true);
                PrintAlignmentImage.this.statusField.setText(PrintAlignmentImage.this.pageIndex + 1 + " of " + npages + " pages");
            }
        });
        if (this.pageIndex == npages - 1) {
            nextPage.setEnabled(false);
            endPage.setEnabled(false);
        }
        f.setJMenuBar(menuBar);
        f.setVisible(true);
    }

    private void writeImageToFile(RenderedImage image, File file, String type) {
        try {
            ImageIO.write(image, type, file);
        }
        catch (IOException e) {
            System.out.println("Java 1.4+ is required");
            e.printStackTrace();
        }
    }
}

