/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.emboss.jemboss.gui.ColumnData;
import org.emboss.jemboss.gui.SequenceData;

class SequenceListTableModel
extends AbstractTableModel {
    protected static Vector modelVector;
    public static final int COL_NAME = 0;
    public static final int COL_BEG = 1;
    public static final int COL_END = 2;
    public static final int COL_LIST = 3;
    public static final int COL_DEF = 4;
    public static final ColumnData[] modelColumns;

    public SequenceListTableModel() {
        modelVector = new Vector();
        File fseq = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jembossSeqList");
        this.setDefaultData();
        if (fseq.canRead()) {
            this.loadStoredSeqList(fseq);
        }
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    protected void loadStoredSeqList(File fseq) {
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(fseq));
            int nrow = 0;
            while ((line = in.readLine()) != null) {
                if (line.equals("")) continue;
                line = line.trim();
                StringTokenizer st = new StringTokenizer(line, " ");
                for (int i = 0; i < this.getColumnCount() && st.hasMoreTokens(); ++i) {
                    String value;
                    if (nrow >= this.getRowCount()) {
                        Boolean bdef = new Boolean(false);
                        modelVector.addElement(new SequenceData("", "", "", bdef, bdef, bdef));
                    }
                    if ((value = st.nextToken()).equals("-")) {
                        value = "";
                    }
                    if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false")) {
                        this.setValueAt(new Boolean(value), nrow, i);
                        continue;
                    }
                    this.setValueAt(value, nrow, i);
                }
                ++nrow;
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            System.out.println("ArrayIndexOutOfBoundsException in SequenceList");
            this.setDefaultData();
        }
        catch (IOException ioe) {
            this.setDefaultData();
        }
    }

    protected void setDefaultData() {
        modelVector.removeAllElements();
        Boolean bdef = new Boolean(false);
        for (int i = 0; i < this.getColumnCount(); ++i) {
            modelVector.addElement(new SequenceData("", "", "", bdef, bdef, bdef));
        }
    }

    protected SequenceData getSequenceData(int nrow) {
        return (SequenceData)modelVector.get(nrow);
    }

    public int getRowCount() {
        return modelVector == null ? 0 : modelVector.size();
    }

    public int getColumnCount() {
        return modelColumns.length;
    }

    public String getColumnName(int c) {
        return SequenceListTableModel.modelColumns[c].title;
    }

    public boolean isCellEditable(int nRow, int nCol) {
        return true;
    }

    public Object getValueAt(int nRow, int nCol) {
        if (nRow < 0 || nCol >= this.getRowCount()) {
            return "";
        }
        SequenceData row = (SequenceData)modelVector.elementAt(nRow);
        switch (nCol) {
            case 0: {
                return row.s_name;
            }
            case 1: {
                return row.s_beg;
            }
            case 2: {
                return row.s_end;
            }
            case 4: {
                return row.s_default;
            }
            case 3: {
                return row.s_listFile;
            }
        }
        return "";
    }

    public void setValueAt(Object value, int nRow, int nCol) {
        if (nRow < 0 || nCol >= this.getRowCount()) {
            return;
        }
        SequenceData row = (SequenceData)modelVector.elementAt(nRow);
        String svalue = value.toString();
        switch (nCol) {
            case 0: {
                if (row.s_name.equals(svalue)) break;
                row.s_name = svalue;
                this.fireTableCellUpdated(nRow, nCol);
                break;
            }
            case 1: {
                row.s_beg = svalue;
                break;
            }
            case 2: {
                row.s_end = svalue;
                break;
            }
            case 4: {
                row.s_default = (Boolean)value;
                break;
            }
            case 3: {
                row.s_listFile = (Boolean)value;
            }
        }
    }

    public void insertRow(int row) {
        if (row < 0) {
            row = 0;
        }
        if (row > modelVector.size()) {
            row = modelVector.size();
        }
        modelVector.insertElementAt(new SequenceData(), row);
    }

    public boolean deleteRow(int row) {
        if (row < 0 || row >= modelVector.size()) {
            return false;
        }
        modelVector.remove(row);
        if (this.getRowCount() < this.getColumnCount()) {
            Boolean bdef = new Boolean(false);
            modelVector.addElement(new SequenceData("", "", "", bdef, bdef, bdef));
        }
        return true;
    }

    static {
        modelColumns = new ColumnData[]{new ColumnData("File / Database Entry", 170, 2), new ColumnData("Start", 45, 2), new ColumnData("End", 45, 2), new ColumnData("List File", 15, 2), new ColumnData("Default", 15, 2)};
    }
}

