/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.analysis.AAFrequency;
import jalview.analysis.AlignmentSorter;
import jalview.analysis.Conservation;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.AnnotationColourChooser;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EmbmenuFrame;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.FeatureSettings;
import jalview.appletgui.Finder;
import jalview.appletgui.FontChooser;
import jalview.appletgui.OverviewPanel;
import jalview.appletgui.PCAPanel;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.PairwiseAlignPanel;
import jalview.appletgui.RedundancyPanel;
import jalview.appletgui.SeqCanvas;
import jalview.appletgui.SliderPanel;
import jalview.appletgui.TreePanel;
import jalview.appletgui.UserDefinedColours;
import jalview.bin.JalviewLite;
import jalview.commands.CommandI;
import jalview.commands.EditCommand;
import jalview.commands.OrderCommand;
import jalview.commands.RemoveGapColCommand;
import jalview.commands.RemoveGapsCommand;
import jalview.commands.SlideSequencesCommand;
import jalview.commands.TrimRegionCommand;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.AnnotationFile;
import jalview.io.AppletFormatAdapter;
import jalview.io.FeaturesFile;
import jalview.io.NewickFile;
import jalview.schemes.Blosum62ColourScheme;
import jalview.schemes.BuriedColourScheme;
import jalview.schemes.ClustalxColourScheme;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.HelixColourScheme;
import jalview.schemes.HydrophobicColourScheme;
import jalview.schemes.NucleotideColourScheme;
import jalview.schemes.PIDColourScheme;
import jalview.schemes.ResidueProperties;
import jalview.schemes.StrandColourScheme;
import jalview.schemes.TaylorColourScheme;
import jalview.schemes.TurnColourScheme;
import jalview.schemes.ZappoColourScheme;
import jalview.structure.StructureSelectionManager;
import jalview.util.Comparison;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AlignFrame
extends EmbmenuFrame
implements ActionListener,
ItemListener,
KeyListener {
    public AlignmentPanel alignPanel;
    public AlignViewport viewport;
    int DEFAULT_WIDTH = 700;
    int DEFAULT_HEIGHT = 500;
    String jalviewServletURL;
    static StringBuffer copiedSequences;
    static Vector copiedHiddenColumns;
    MenuBar alignFrameMenuBar = new MenuBar();
    Menu fileMenu = new Menu("File");
    MenuItem loadApplication = new MenuItem("View in Full Application");
    MenuItem loadTree = new MenuItem("Load Associated Tree ...");
    MenuItem loadAnnotations = new MenuItem("Load Features/Annotations ...");
    MenuItem outputFeatures = new MenuItem("Export Features ...");
    MenuItem outputAnnotations = new MenuItem("Export Annotations ...");
    MenuItem closeMenuItem = new MenuItem("Close");
    Menu editMenu = new Menu("Edit");
    Menu viewMenu = new Menu("View");
    Menu colourMenu = new Menu("Colour");
    Menu calculateMenu = new Menu("Calculate");
    MenuItem selectAllSequenceMenuItem = new MenuItem("Select all");
    MenuItem deselectAllSequenceMenuItem = new MenuItem("Deselect All");
    MenuItem invertSequenceMenuItem = new MenuItem("Invert Selection");
    MenuItem remove2LeftMenuItem = new MenuItem();
    MenuItem remove2RightMenuItem = new MenuItem();
    MenuItem removeGappedColumnMenuItem = new MenuItem();
    MenuItem removeAllGapsMenuItem = new MenuItem();
    CheckboxMenuItem viewBoxesMenuItem = new CheckboxMenuItem();
    CheckboxMenuItem viewTextMenuItem = new CheckboxMenuItem();
    MenuItem sortPairwiseMenuItem = new MenuItem();
    MenuItem sortIDMenuItem = new MenuItem();
    MenuItem sortGroupMenuItem = new MenuItem();
    MenuItem removeRedundancyMenuItem = new MenuItem();
    MenuItem pairwiseAlignmentMenuItem = new MenuItem();
    MenuItem PCAMenuItem = new MenuItem();
    MenuItem averageDistanceTreeMenuItem = new MenuItem();
    MenuItem neighbourTreeMenuItem = new MenuItem();
    BorderLayout borderLayout1 = new BorderLayout();
    public Label statusBar = new Label();
    Menu outputTextboxMenu = new Menu();
    MenuItem clustalColour = new MenuItem();
    MenuItem zappoColour = new MenuItem();
    MenuItem taylorColour = new MenuItem();
    MenuItem hydrophobicityColour = new MenuItem();
    MenuItem helixColour = new MenuItem();
    MenuItem strandColour = new MenuItem();
    MenuItem turnColour = new MenuItem();
    MenuItem buriedColour = new MenuItem();
    MenuItem userDefinedColour = new MenuItem();
    MenuItem PIDColour = new MenuItem();
    MenuItem BLOSUM62Colour = new MenuItem();
    MenuItem njTreeBlosumMenuItem = new MenuItem();
    MenuItem avDistanceTreeBlosumMenuItem = new MenuItem();
    CheckboxMenuItem annotationPanelMenuItem = new CheckboxMenuItem();
    CheckboxMenuItem colourTextMenuItem = new CheckboxMenuItem();
    MenuItem alProperties = new MenuItem("Alignment Properties...");
    MenuItem overviewMenuItem = new MenuItem();
    MenuItem undoMenuItem = new MenuItem();
    MenuItem redoMenuItem = new MenuItem();
    CheckboxMenuItem conservationMenuItem = new CheckboxMenuItem();
    MenuItem noColourmenuItem = new MenuItem();
    CheckboxMenuItem wrapMenuItem = new CheckboxMenuItem();
    CheckboxMenuItem renderGapsMenuItem = new CheckboxMenuItem();
    MenuItem findMenuItem = new MenuItem();
    CheckboxMenuItem abovePIDThreshold = new CheckboxMenuItem();
    MenuItem nucleotideColour = new MenuItem();
    MenuItem deleteGroups = new MenuItem();
    MenuItem delete = new MenuItem();
    MenuItem copy = new MenuItem();
    MenuItem cut = new MenuItem();
    Menu pasteMenu = new Menu();
    MenuItem pasteNew = new MenuItem();
    MenuItem pasteThis = new MenuItem();
    CheckboxMenuItem applyToAllGroups = new CheckboxMenuItem();
    MenuItem font = new MenuItem();
    CheckboxMenuItem scaleAbove = new CheckboxMenuItem();
    CheckboxMenuItem scaleLeft = new CheckboxMenuItem();
    CheckboxMenuItem scaleRight = new CheckboxMenuItem();
    MenuItem modifyPID = new MenuItem();
    MenuItem modifyConservation = new MenuItem();
    CheckboxMenuItem autoCalculate = new CheckboxMenuItem("Autocalculate Consensus", true);
    Menu sortByTreeMenu = new Menu();
    Menu sort = new Menu();
    Menu calculate = new Menu();
    MenuItem inputText = new MenuItem();
    Menu helpMenu = new Menu();
    MenuItem documentation = new MenuItem();
    MenuItem about = new MenuItem();
    CheckboxMenuItem seqLimits = new CheckboxMenuItem();
    CheckboxMenuItem centreColumnLabelFlag = new CheckboxMenuItem();
    MenuItem featureSettings = new MenuItem();
    CheckboxMenuItem sequenceFeatures = new CheckboxMenuItem();
    MenuItem annotationColour = new MenuItem();
    MenuItem invertColSel = new MenuItem();
    Menu menu1 = new Menu();
    MenuItem showColumns = new MenuItem();
    MenuItem showSeqs = new MenuItem();
    Menu menu2 = new Menu();
    MenuItem hideColumns = new MenuItem();
    MenuItem hideSequences = new MenuItem();
    Menu formatMenu = new Menu();
    Menu selectMenu = new Menu();
    MenuItem newView = new MenuItem();

    public AlignFrame(AlignmentI al, JalviewLite applet, String title, boolean embedded) {
        if (applet != null) {
            this.jalviewServletURL = applet.getParameter("APPLICATION_URL");
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.viewport = new AlignViewport(al, applet);
        this.alignPanel = new AlignmentPanel(this, this.viewport);
        this.viewport.updateConservation(this.alignPanel);
        this.viewport.updateConsensus(this.alignPanel);
        this.annotationPanelMenuItem.setState(this.viewport.showAnnotation);
        this.seqLimits.setState(this.viewport.showJVSuffix);
        if (applet != null) {
            String param = applet.getParameter("sortBy");
            if (param != null) {
                if (param.equalsIgnoreCase("Id")) {
                    this.sortIDMenuItem_actionPerformed();
                } else if (param.equalsIgnoreCase("Pairwise Identity")) {
                    this.sortPairwiseMenuItem_actionPerformed();
                }
            }
            if ((param = applet.getParameter("wrap")) != null && param.equalsIgnoreCase("true")) {
                this.wrapMenuItem.setState(true);
                this.wrapMenuItem_actionPerformed();
            }
            if ((param = applet.getParameter("centrecolumnlabels")) != null) {
                this.centreColumnLabelFlag.setState(true);
                this.centreColumnLabelFlag_stateChanged();
            }
            try {
                param = applet.getParameter("windowWidth");
                if (param != null) {
                    int width;
                    this.DEFAULT_WIDTH = width = Integer.parseInt(param);
                }
                if ((param = applet.getParameter("windowHeight")) != null) {
                    int height;
                    this.DEFAULT_HEIGHT = height = Integer.parseInt(param);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.addKeyListener(this);
        this.alignPanel.seqPanel.seqCanvas.addKeyListener(this);
        this.alignPanel.idPanel.idCanvas.addKeyListener(this);
        this.alignPanel.scalePanel.addKeyListener(this);
        this.alignPanel.annotationPanel.addKeyListener(this);
        this.createAlignFrameWindow(embedded, title);
        this.alignPanel.validate();
        this.alignPanel.paintAlignment(true);
    }

    public AlignViewport getAlignViewport() {
        return this.viewport;
    }

    public SeqCanvas getSeqcanvas() {
        return this.alignPanel.seqPanel.seqCanvas;
    }

    public void parseFeaturesFile(String file, String type) {
        Hashtable featureLinks = new Hashtable();
        boolean featuresFile = false;
        try {
            featuresFile = new FeaturesFile(file, type).parse(this.viewport.alignment, this.alignPanel.seqPanel.seqCanvas.getFeatureRenderer().featureColours, featureLinks, true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (featuresFile) {
            if (featureLinks.size() > 0) {
                this.alignPanel.seqPanel.seqCanvas.getFeatureRenderer().featureLinks = featureLinks;
            }
            this.viewport.showSequenceFeatures = true;
            this.sequenceFeatures.setState(true);
            this.alignPanel.paintAlignment(true);
        }
    }

    public void keyPressed(KeyEvent evt) {
        if (this.viewport.cursorMode && (evt.getKeyCode() >= 48 && evt.getKeyCode() <= 57 || evt.getKeyCode() >= 96 && evt.getKeyCode() <= 105) && Character.isDigit(evt.getKeyChar())) {
            this.alignPanel.seqPanel.numberPressed(evt.getKeyChar());
        }
        switch (evt.getKeyCode()) {
            case 27: {
                this.deselectAllSequenceMenuItem_actionPerformed();
                break;
            }
            case 88: {
                if (!evt.isControlDown() && !evt.isMetaDown()) break;
                this.cut_actionPerformed();
                break;
            }
            case 67: {
                if (this.viewport.cursorMode && !evt.isControlDown()) {
                    this.alignPanel.seqPanel.setCursorColumn();
                }
                if (!evt.isControlDown() && !evt.isMetaDown()) break;
                this.copy_actionPerformed();
                break;
            }
            case 86: {
                if (!evt.isControlDown()) break;
                this.paste(evt.isShiftDown());
                break;
            }
            case 65: {
                if (!evt.isControlDown() && !evt.isMetaDown()) break;
                this.selectAllSequenceMenuItem_actionPerformed();
                break;
            }
            case 40: {
                if (this.viewport.cursorMode) {
                    this.alignPanel.seqPanel.moveCursor(0, 1);
                    break;
                }
                this.moveSelectedSequences(false);
                break;
            }
            case 38: {
                if (this.viewport.cursorMode) {
                    this.alignPanel.seqPanel.moveCursor(0, -1);
                    break;
                }
                this.moveSelectedSequences(true);
                break;
            }
            case 37: {
                if (evt.isAltDown() || !this.viewport.cursorMode) {
                    this.slideSequences(false, this.alignPanel.seqPanel.getKeyboardNo1());
                    break;
                }
                this.alignPanel.seqPanel.moveCursor(-1, 0);
                break;
            }
            case 39: {
                if (evt.isAltDown() || !this.viewport.cursorMode) {
                    this.slideSequences(true, this.alignPanel.seqPanel.getKeyboardNo1());
                    break;
                }
                this.alignPanel.seqPanel.moveCursor(1, 0);
                break;
            }
            case 32: {
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.insertGapAtCursor(evt.isControlDown() || evt.isShiftDown() || evt.isAltDown());
                break;
            }
            case 8: 
            case 127: {
                if (this.viewport.cursorMode) {
                    this.alignPanel.seqPanel.deleteGapAtCursor(evt.isControlDown() || evt.isShiftDown() || evt.isAltDown());
                    break;
                }
                this.cut_actionPerformed();
                this.alignPanel.seqPanel.seqCanvas.repaint();
                break;
            }
            case 83: {
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.setCursorRow();
                break;
            }
            case 80: {
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.setCursorPosition();
                break;
            }
            case 10: 
            case 44: {
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.setCursorRowAndColumn();
                break;
            }
            case 81: {
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.setSelectionAreaAtCursor(true);
                break;
            }
            case 77: {
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.setSelectionAreaAtCursor(false);
                break;
            }
            case 113: {
                this.viewport.cursorMode = !this.viewport.cursorMode;
                this.statusBar.setText("Keyboard editing mode is " + (this.viewport.cursorMode ? "on" : "off"));
                if (!this.viewport.cursorMode) break;
                this.alignPanel.seqPanel.seqCanvas.cursorX = this.viewport.startRes;
                this.alignPanel.seqPanel.seqCanvas.cursorY = this.viewport.startSeq;
                break;
            }
            case 70: {
                if (!evt.isControlDown()) break;
                this.findMenuItem_actionPerformed();
                break;
            }
            case 72: {
                boolean toggleSeqs = !evt.isControlDown();
                boolean toggleCols = !evt.isShiftDown();
                boolean hide = false;
                SequenceGroup sg = this.viewport.getSelectionGroup();
                if (toggleSeqs) {
                    if (sg != null && sg.getSize() != this.viewport.alignment.getHeight()) {
                        hide = true;
                        this.viewport.hideAllSelectedSeqs();
                    } else if (!toggleCols || this.viewport.colSel.getSelected().size() <= 0) {
                        this.viewport.showAllHiddenSeqs();
                    }
                }
                if (!toggleCols) break;
                if (this.viewport.colSel.getSelected().size() > 0) {
                    this.viewport.hideSelectedColumns();
                    if (toggleSeqs) break;
                    this.viewport.selectionGroup = sg;
                    break;
                }
                if (hide) break;
                this.viewport.showAllHiddenColumns();
                break;
            }
            case 33: {
                if (this.viewport.wrapAlignment) {
                    this.alignPanel.scrollUp(true);
                    break;
                }
                this.alignPanel.setScrollValues(this.viewport.startRes, this.viewport.startSeq - this.viewport.endSeq + this.viewport.startSeq);
                break;
            }
            case 34: {
                if (this.viewport.wrapAlignment) {
                    this.alignPanel.scrollUp(false);
                    break;
                }
                this.alignPanel.setScrollValues(this.viewport.startRes, this.viewport.startSeq + this.viewport.endSeq - this.viewport.startSeq);
                break;
            }
            case 90: {
                if (!evt.isControlDown()) break;
                this.undoMenuItem_actionPerformed();
                break;
            }
            case 89: {
                if (!evt.isControlDown()) break;
                this.redoMenuItem_actionPerformed();
                break;
            }
            case 76: {
                if (!evt.isControlDown()) break;
                this.trimAlignment(true);
                break;
            }
            case 82: {
                if (!evt.isControlDown()) break;
                this.trimAlignment(false);
                break;
            }
            case 69: {
                if (!evt.isControlDown()) break;
                if (evt.isShiftDown()) {
                    this.removeAllGapsMenuItem_actionPerformed();
                    break;
                }
                this.removeGappedColumnMenuItem_actionPerformed();
                break;
            }
            case 73: {
                if (!evt.isControlDown()) break;
                if (evt.isAltDown()) {
                    this.viewport.invertColumnSelection();
                    break;
                }
                this.invertSequenceMenuItem_actionPerformed();
                break;
            }
            case 85: {
                if (!evt.isControlDown()) break;
                this.deleteGroups_actionPerformed();
                break;
            }
            case 84: {
                if (!evt.isControlDown()) break;
                this.newView(null);
            }
        }
        this.alignPanel.paintAlignment(true);
    }

    public void keyReleased(KeyEvent evt) {
    }

    public void keyTyped(KeyEvent evt) {
    }

    public void itemStateChanged(ItemEvent evt) {
        if (evt.getSource() == this.colourTextMenuItem) {
            this.colourTextMenuItem_actionPerformed();
        } else if (evt.getSource() == this.wrapMenuItem) {
            this.wrapMenuItem_actionPerformed();
        } else if (evt.getSource() == this.scaleAbove) {
            this.viewport.setScaleAboveWrapped(this.scaleAbove.getState());
        } else if (evt.getSource() == this.scaleLeft) {
            this.viewport.setScaleLeftWrapped(this.scaleLeft.getState());
        } else if (evt.getSource() == this.scaleRight) {
            this.viewport.setScaleRightWrapped(this.scaleRight.getState());
        } else if (evt.getSource() == this.seqLimits) {
            this.seqLimits_itemStateChanged();
        } else if (evt.getSource() == this.viewBoxesMenuItem) {
            this.viewport.setShowBoxes(this.viewBoxesMenuItem.getState());
        } else if (evt.getSource() == this.viewTextMenuItem) {
            this.viewport.setShowText(this.viewTextMenuItem.getState());
        } else if (evt.getSource() == this.renderGapsMenuItem) {
            this.viewport.setRenderGaps(this.renderGapsMenuItem.getState());
        } else if (evt.getSource() == this.annotationPanelMenuItem) {
            this.viewport.setShowAnnotation(this.annotationPanelMenuItem.getState());
            this.alignPanel.setAnnotationVisible(this.annotationPanelMenuItem.getState());
        } else if (evt.getSource() == this.sequenceFeatures) {
            this.viewport.showSequenceFeatures(this.sequenceFeatures.getState());
            this.alignPanel.seqPanel.seqCanvas.repaint();
        } else if (evt.getSource() == this.conservationMenuItem) {
            this.conservationMenuItem_actionPerformed();
        } else if (evt.getSource() == this.abovePIDThreshold) {
            this.abovePIDThreshold_actionPerformed();
        } else if (evt.getSource() == this.applyToAllGroups) {
            this.viewport.setColourAppliesToAllGroups(this.applyToAllGroups.getState());
        } else if (evt.getSource() == this.autoCalculate) {
            this.viewport.autocalculateConsensus = this.autoCalculate.getState();
        } else if (evt.getSource() == this.centreColumnLabelFlag) {
            this.centreColumnLabelFlag_stateChanged();
        }
        this.alignPanel.paintAlignment(true);
    }

    private void centreColumnLabelFlag_stateChanged() {
        this.viewport.centreColumnLabels = this.centreColumnLabelFlag.getState();
        this.alignPanel.annotationPanel.repaint();
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.inputText) {
            this.inputText_actionPerformed();
        } else if (source == this.loadTree) {
            this.loadTree_actionPerformed();
        } else if (source == this.loadApplication) {
            this.launchFullApplication();
        } else if (source == this.loadAnnotations) {
            this.loadAnnotations();
        } else if (source == this.outputAnnotations) {
            this.outputAnnotations(true);
        } else if (source == this.outputFeatures) {
            this.outputFeatures(true, "Jalview");
        } else if (source == this.closeMenuItem) {
            this.closeMenuItem_actionPerformed();
        } else if (source == this.copy) {
            this.copy_actionPerformed();
        } else if (source == this.undoMenuItem) {
            this.undoMenuItem_actionPerformed();
        } else if (source == this.redoMenuItem) {
            this.redoMenuItem_actionPerformed();
        } else if (source == this.inputText) {
            this.inputText_actionPerformed();
        } else if (source == this.closeMenuItem) {
            this.closeMenuItem_actionPerformed();
        } else if (source == this.undoMenuItem) {
            this.undoMenuItem_actionPerformed();
        } else if (source == this.redoMenuItem) {
            this.redoMenuItem_actionPerformed();
        } else if (source == this.copy) {
            this.copy_actionPerformed();
        } else if (source == this.pasteNew) {
            this.pasteNew_actionPerformed();
        } else if (source == this.pasteThis) {
            this.pasteThis_actionPerformed();
        } else if (source == this.cut) {
            this.cut_actionPerformed();
        } else if (source == this.delete) {
            this.delete_actionPerformed();
        } else if (source == this.deleteGroups) {
            this.deleteGroups_actionPerformed();
        } else if (source == this.selectAllSequenceMenuItem) {
            this.selectAllSequenceMenuItem_actionPerformed();
        } else if (source == this.deselectAllSequenceMenuItem) {
            this.deselectAllSequenceMenuItem_actionPerformed();
        } else if (source == this.invertSequenceMenuItem) {
            this.invertSequenceMenuItem_actionPerformed();
        } else if (source == this.invertColSel) {
            this.viewport.invertColumnSelection();
            this.alignPanel.paintAlignment(true);
        } else if (source == this.remove2LeftMenuItem) {
            this.trimAlignment(true);
        } else if (source == this.remove2RightMenuItem) {
            this.trimAlignment(false);
        } else if (source == this.removeGappedColumnMenuItem) {
            this.removeGappedColumnMenuItem_actionPerformed();
        } else if (source == this.removeAllGapsMenuItem) {
            this.removeAllGapsMenuItem_actionPerformed();
        } else if (source == this.findMenuItem) {
            this.findMenuItem_actionPerformed();
        } else if (source == this.font) {
            new FontChooser(this.alignPanel);
        } else if (source == this.newView) {
            this.newView(null);
        } else if (source == this.showColumns) {
            this.viewport.showAllHiddenColumns();
            this.alignPanel.paintAlignment(true);
        } else if (source == this.showSeqs) {
            this.viewport.showAllHiddenSeqs();
        } else if (source == this.hideColumns) {
            this.viewport.hideSelectedColumns();
            this.alignPanel.paintAlignment(true);
        } else if (source == this.hideSequences && this.viewport.getSelectionGroup() != null) {
            this.viewport.hideAllSelectedSeqs();
        } else if (source == this.featureSettings) {
            new FeatureSettings(this.alignPanel);
        } else if (source == this.alProperties) {
            StringBuffer contents = new StringBuffer();
            float avg = 0.0f;
            int min = Integer.MAX_VALUE;
            int max = 0;
            for (int i = 0; i < this.viewport.alignment.getHeight(); ++i) {
                int size = this.viewport.alignment.getSequenceAt(i).getEnd() - this.viewport.alignment.getSequenceAt(i).getStart();
                avg += (float)size;
                if (size > max) {
                    max = size;
                }
                if (size >= min) continue;
                min = size;
            }
            avg /= (float)this.viewport.alignment.getHeight();
            contents.append("\nSequences: " + this.viewport.alignment.getHeight());
            contents.append("\nMinimum Sequence Length: " + min);
            contents.append("\nMaximum Sequence Length: " + max);
            contents.append("\nAverage Length: " + (int)avg);
            if (((Alignment)this.viewport.alignment).alignmentProperties != null) {
                Hashtable props = ((Alignment)this.viewport.alignment).alignmentProperties;
                Enumeration en = props.keys();
                while (en.hasMoreElements()) {
                    String key = en.nextElement().toString();
                    contents.append("\n" + key + "\t" + props.get(key));
                }
            }
            CutAndPasteTransfer cap = new CutAndPasteTransfer(false, this);
            cap.setText(contents.toString());
            Frame frame = new Frame();
            frame.add(cap);
            JalviewLite.addFrame(frame, "Alignment Properties: " + this.getTitle(), 400, 250);
        } else if (source == this.overviewMenuItem) {
            this.overviewMenuItem_actionPerformed();
        } else if (source == this.noColourmenuItem) {
            this.changeColour(null);
        } else if (source == this.clustalColour) {
            this.abovePIDThreshold.setState(false);
            this.changeColour(new ClustalxColourScheme(this.viewport.alignment.getSequences(), this.viewport.alignment.getWidth()));
        } else if (source == this.zappoColour) {
            this.changeColour(new ZappoColourScheme());
        } else if (source == this.taylorColour) {
            this.changeColour(new TaylorColourScheme());
        } else if (source == this.hydrophobicityColour) {
            this.changeColour(new HydrophobicColourScheme());
        } else if (source == this.helixColour) {
            this.changeColour(new HelixColourScheme());
        } else if (source == this.strandColour) {
            this.changeColour(new StrandColourScheme());
        } else if (source == this.turnColour) {
            this.changeColour(new TurnColourScheme());
        } else if (source == this.buriedColour) {
            this.changeColour(new BuriedColourScheme());
        } else if (source == this.nucleotideColour) {
            this.changeColour(new NucleotideColourScheme());
        } else if (source == this.modifyPID) {
            this.modifyPID_actionPerformed();
        } else if (source == this.modifyConservation) {
            this.modifyConservation_actionPerformed();
        } else if (source == this.userDefinedColour) {
            new UserDefinedColours(this.alignPanel, null);
        } else if (source == this.PIDColour) {
            this.changeColour(new PIDColourScheme());
        } else if (source == this.BLOSUM62Colour) {
            this.changeColour(new Blosum62ColourScheme());
        } else if (source == this.annotationColour) {
            new AnnotationColourChooser(this.viewport, this.alignPanel);
        } else if (source == this.sortPairwiseMenuItem) {
            this.sortPairwiseMenuItem_actionPerformed();
        } else if (source == this.sortIDMenuItem) {
            this.sortIDMenuItem_actionPerformed();
        } else if (source == this.sortGroupMenuItem) {
            this.sortGroupMenuItem_actionPerformed();
        } else if (source == this.removeRedundancyMenuItem) {
            this.removeRedundancyMenuItem_actionPerformed();
        } else if (source == this.pairwiseAlignmentMenuItem) {
            this.pairwiseAlignmentMenuItem_actionPerformed();
        } else if (source == this.PCAMenuItem) {
            this.PCAMenuItem_actionPerformed();
        } else if (source == this.averageDistanceTreeMenuItem) {
            this.averageDistanceTreeMenuItem_actionPerformed();
        } else if (source == this.neighbourTreeMenuItem) {
            this.neighbourTreeMenuItem_actionPerformed();
        } else if (source == this.njTreeBlosumMenuItem) {
            this.njTreeBlosumMenuItem_actionPerformed();
        } else if (source == this.avDistanceTreeBlosumMenuItem) {
            this.avTreeBlosumMenuItem_actionPerformed();
        } else if (source == this.documentation) {
            this.documentation_actionPerformed();
        } else if (source == this.about) {
            this.about_actionPerformed();
        }
    }

    public void inputText_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(true, this);
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, "Cut & Paste Input", 500, 500);
    }

    protected void outputText_actionPerformed(ActionEvent e) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(true, this);
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, "Alignment output - " + e.getActionCommand(), 600, 500);
        cap.setText(new AppletFormatAdapter().formatSequences(e.getActionCommand(), this.viewport.getAlignment(), this.viewport.showJVSuffix));
    }

    public void loadAnnotations() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(true, this);
        cap.setText("Paste your features / annotations file here.");
        cap.setAnnotationImport();
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, "Paste Annotations ", 400, 300);
    }

    public String outputAnnotations(boolean displayTextbox) {
        String annotation = new AnnotationFile().printAnnotations(this.viewport.showAnnotation ? this.viewport.alignment.getAlignmentAnnotation() : null, this.viewport.alignment.getGroups(), ((Alignment)this.viewport.alignment).alignmentProperties);
        if (displayTextbox) {
            CutAndPasteTransfer cap = new CutAndPasteTransfer(false, this);
            Frame frame = new Frame();
            frame.add(cap);
            JalviewLite.addFrame(frame, "Annotations", 600, 500);
            cap.setText(annotation);
        }
        return annotation;
    }

    public String outputFeatures(boolean displayTextbox, String format) {
        String features = format.equalsIgnoreCase("Jalview") ? new FeaturesFile().printJalviewFormat(this.viewport.alignment.getSequencesArray(), this.viewport.featuresDisplayed) : new FeaturesFile().printGFFFormat(this.viewport.alignment.getSequencesArray(), this.viewport.featuresDisplayed);
        if (displayTextbox) {
            CutAndPasteTransfer cap = new CutAndPasteTransfer(false, this);
            Frame frame = new Frame();
            frame.add(cap);
            JalviewLite.addFrame(frame, "Features", 600, 500);
            cap.setText(features);
        }
        return features;
    }

    void launchFullApplication() {
        StringBuffer url = new StringBuffer(this.jalviewServletURL);
        url.append("?open=" + this.appendProtocol(this.viewport.applet.getParameter("file")));
        if (this.viewport.applet.getParameter("features") != null) {
            url.append("&features=");
            url.append(this.appendProtocol(this.viewport.applet.getParameter("features")));
        }
        if (this.viewport.applet.getParameter("annotations") != null) {
            url.append("&annotations=");
            url.append(this.appendProtocol(this.viewport.applet.getParameter("annotations")));
        }
        if (this.viewport.applet.getParameter("jnetfile") != null) {
            url.append("&annotations=");
            url.append(this.appendProtocol(this.viewport.applet.getParameter("jnetfile")));
        }
        if (this.viewport.applet.getParameter("defaultColour") != null) {
            url.append("&colour=" + this.removeWhiteSpace(this.viewport.applet.getParameter("defaultColour")));
        }
        if (this.viewport.applet.getParameter("userDefinedColour") != null) {
            url.append("&colour=" + this.removeWhiteSpace(this.viewport.applet.getParameter("userDefinedColour")));
        }
        if (this.viewport.applet.getParameter("tree") != null) {
            url.append("&tree=" + this.appendProtocol(this.viewport.applet.getParameter("tree")));
        }
        if (this.viewport.applet.getParameter("treeFile") != null) {
            url.append("&tree=" + this.appendProtocol(this.viewport.applet.getParameter("treeFile")));
        }
        this.showURL(url.toString(), "FULL_APP");
    }

    String removeWhiteSpace(String colour) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < colour.length(); ++i) {
            if (Character.isWhitespace(colour.charAt(i))) {
                sb.append("%20");
                continue;
            }
            sb.append(colour.charAt(i));
        }
        return sb.toString();
    }

    String appendProtocol(String url) {
        try {
            new URL(url);
            url = URLEncoder.encode(url);
        }
        catch (MalformedURLException ex) {
            url = this.viewport.applet.getCodeBase() + url;
        }
        return url;
    }

    public void closeMenuItem_actionPerformed() {
        PaintRefresher.RemoveComponent(this.alignPanel);
        PaintRefresher.RemoveComponent(this.alignPanel.seqPanel.seqCanvas);
        PaintRefresher.RemoveComponent(this.alignPanel.idPanel.idCanvas);
        if (PaintRefresher.components.size() == 0 && this.viewport.applet == null) {
            System.exit(0);
        }
        this.dispose();
    }

    void updateEditMenuBar() {
        CommandI command;
        if (this.viewport.historyList.size() > 0) {
            this.undoMenuItem.setEnabled(true);
            command = (CommandI)this.viewport.historyList.peek();
            this.undoMenuItem.setLabel("Undo " + command.getDescription());
        } else {
            this.undoMenuItem.setEnabled(false);
            this.undoMenuItem.setLabel("Undo");
        }
        if (this.viewport.redoList.size() > 0) {
            this.redoMenuItem.setEnabled(true);
            command = (CommandI)this.viewport.redoList.peek();
            this.redoMenuItem.setLabel("Redo " + command.getDescription());
        } else {
            this.redoMenuItem.setEnabled(false);
            this.redoMenuItem.setLabel("Redo");
        }
    }

    public void addHistoryItem(CommandI command) {
        if (command.getSize() > 0) {
            this.viewport.historyList.push(command);
            this.viewport.redoList.removeAllElements();
            this.updateEditMenuBar();
            this.viewport.hasHiddenColumns = this.viewport.colSel.getHiddenColumns() != null;
        }
    }

    protected void undoMenuItem_actionPerformed() {
        if (this.viewport.historyList.size() < 1) {
            return;
        }
        CommandI command = (CommandI)this.viewport.historyList.pop();
        this.viewport.redoList.push(command);
        command.undoCommand(null);
        AlignViewport originalSource = this.getOriginatingSource(command);
        originalSource.hasHiddenColumns = this.viewport.colSel.getHiddenColumns() != null;
        this.updateEditMenuBar();
        originalSource.firePropertyChange("alignment", null, originalSource.alignment.getSequences());
    }

    protected void redoMenuItem_actionPerformed() {
        if (this.viewport.redoList.size() < 1) {
            return;
        }
        CommandI command = (CommandI)this.viewport.redoList.pop();
        this.viewport.historyList.push(command);
        command.doCommand(null);
        AlignViewport originalSource = this.getOriginatingSource(command);
        originalSource.hasHiddenColumns = this.viewport.colSel.getHiddenColumns() != null;
        this.updateEditMenuBar();
        originalSource.firePropertyChange("alignment", null, originalSource.alignment.getSequences());
    }

    AlignViewport getOriginatingSource(CommandI command) {
        AlignViewport originalSource = null;
        AlignmentI al = null;
        if (command instanceof EditCommand) {
            EditCommand editCommand = (EditCommand)command;
            al = editCommand.getAlignment();
            Vector comps = (Vector)PaintRefresher.components.get(this.viewport.getSequenceSetId());
            for (int i = 0; i < comps.size(); ++i) {
                if (!(comps.elementAt(i) instanceof AlignmentPanel) || al != ((AlignmentPanel)comps.elementAt((int)i)).av.alignment) continue;
                originalSource = ((AlignmentPanel)comps.elementAt((int)i)).av;
                break;
            }
        }
        if (originalSource == null) {
            if (al != null) {
                PaintRefresher.validateSequences(al, this.viewport.alignment);
            }
            originalSource = this.viewport;
        }
        return originalSource;
    }

    public void moveSelectedSequences(boolean up) {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg == null) {
            return;
        }
        if (up) {
            for (int i = 1; i < this.viewport.alignment.getHeight(); ++i) {
                SequenceI seq = this.viewport.alignment.getSequenceAt(i);
                if (!sg.getSequences(null).contains(seq)) continue;
                SequenceI temp = this.viewport.alignment.getSequenceAt(i - 1);
                if (sg.getSequences(null).contains(temp)) continue;
                this.viewport.alignment.getSequences().setElementAt(temp, i);
                this.viewport.alignment.getSequences().setElementAt(seq, i - 1);
            }
        } else {
            for (int i = this.viewport.alignment.getHeight() - 2; i > -1; --i) {
                SequenceI seq = this.viewport.alignment.getSequenceAt(i);
                if (!sg.getSequences(this.viewport.hiddenRepSequences).contains(seq)) continue;
                SequenceI temp = this.viewport.alignment.getSequenceAt(i + 1);
                if (sg.getSequences(this.viewport.hiddenRepSequences).contains(temp)) continue;
                this.viewport.alignment.getSequences().setElementAt(temp, i);
                this.viewport.alignment.getSequences().setElementAt(seq, i + 1);
            }
        }
        this.alignPanel.paintAlignment(true);
    }

    synchronized void slideSequences(boolean right, int size) {
        Vector sg = new Vector();
        if (this.viewport.cursorMode) {
            sg.addElement(this.viewport.alignment.getSequenceAt(this.alignPanel.seqPanel.seqCanvas.cursorY));
        } else if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() != this.viewport.alignment.getHeight()) {
            sg = this.viewport.getSelectionGroup().getSequences(this.viewport.hiddenRepSequences);
        }
        if (sg.size() < 1) {
            return;
        }
        Vector<SequenceI> invertGroup = new Vector<SequenceI>();
        for (int i = 0; i < this.viewport.alignment.getHeight(); ++i) {
            if (sg.contains(this.viewport.alignment.getSequenceAt(i))) continue;
            invertGroup.addElement(this.viewport.alignment.getSequenceAt(i));
        }
        SequenceI[] seqs1 = new SequenceI[sg.size()];
        for (int i = 0; i < sg.size(); ++i) {
            seqs1[i] = (SequenceI)sg.elementAt(i);
        }
        SequenceI[] seqs2 = new SequenceI[invertGroup.size()];
        for (int i = 0; i < invertGroup.size(); ++i) {
            seqs2[i] = (SequenceI)invertGroup.elementAt(i);
        }
        SlideSequencesCommand ssc = right ? new SlideSequencesCommand("Slide Sequences", seqs2, seqs1, size, this.viewport.getGapCharacter()) : new SlideSequencesCommand("Slide Sequences", seqs1, seqs2, size, this.viewport.getGapCharacter());
        int groupAdjustment = 0;
        if (ssc.getGapsInsertedBegin() && right) {
            if (this.viewport.cursorMode) {
                this.alignPanel.seqPanel.moveCursor(size, 0);
            } else {
                groupAdjustment = size;
            }
        } else if (!ssc.getGapsInsertedBegin() && !right) {
            if (this.viewport.cursorMode) {
                this.alignPanel.seqPanel.moveCursor(-size, 0);
            } else {
                groupAdjustment = -size;
            }
        }
        if (groupAdjustment != 0) {
            this.viewport.getSelectionGroup().setStartRes(this.viewport.getSelectionGroup().getStartRes() + groupAdjustment);
            this.viewport.getSelectionGroup().setEndRes(this.viewport.getSelectionGroup().getEndRes() + groupAdjustment);
        }
        boolean appendHistoryItem = false;
        if (this.viewport.historyList != null && this.viewport.historyList.size() > 0 && this.viewport.historyList.peek() instanceof SlideSequencesCommand) {
            appendHistoryItem = ssc.appendSlideCommand((SlideSequencesCommand)this.viewport.historyList.peek());
        }
        if (!appendHistoryItem) {
            this.addHistoryItem(ssc);
        }
        this.repaint();
    }

    protected void copy_actionPerformed() {
        if (this.viewport.getSelectionGroup() == null) {
            return;
        }
        SequenceGroup sg = this.viewport.getSelectionGroup();
        copiedSequences = new StringBuffer();
        Hashtable<String, SequenceI> orderedSeqs = new Hashtable<String, SequenceI>();
        for (int i = 0; i < sg.getSize(); ++i) {
            SequenceI seq = sg.getSequenceAt(i);
            int index = this.viewport.alignment.findIndex(seq);
            orderedSeqs.put(index + "", seq);
        }
        int index = 0;
        if (this.viewport.hasHiddenColumns && this.viewport.getSelectionGroup() != null) {
            copiedHiddenColumns = new Vector();
            int hiddenOffset = this.viewport.getSelectionGroup().getStartRes();
            for (int i = 0; i < this.viewport.getColumnSelection().getHiddenColumns().size(); ++i) {
                int[] region = (int[])this.viewport.getColumnSelection().getHiddenColumns().elementAt(i);
                copiedHiddenColumns.addElement(new int[]{region[0] - hiddenOffset, region[1] - hiddenOffset});
            }
        } else {
            copiedHiddenColumns = null;
        }
        for (int i = 0; i < sg.getSize(); ++i) {
            SequenceI seq = null;
            while (seq == null) {
                if (orderedSeqs.containsKey(index + "")) {
                    seq = (SequenceI)orderedSeqs.get(index + "");
                    ++index;
                    break;
                }
                ++index;
            }
            int startRes = seq.findPosition(sg.getStartRes());
            int endRes = 0;
            for (int j = 0; j < sg.getEndRes() + 1 && j < seq.getLength(); ++j) {
                char ch = seq.getCharAt(j);
                if (Comparison.isGap(ch)) continue;
                ++endRes;
            }
            if (endRes > 0) {
                endRes += seq.getStart() - 1;
            }
            copiedSequences.append(seq.getName() + "\t" + startRes + "\t" + endRes + "\t" + seq.getSequenceAsString(sg.getStartRes(), sg.getEndRes() + 1) + "\n");
        }
    }

    protected void pasteNew_actionPerformed() {
        this.paste(true);
    }

    protected void pasteThis_actionPerformed() {
        this.paste(false);
    }

    void paste(boolean newAlignment) {
        try {
            if (copiedSequences == null) {
                return;
            }
            StringTokenizer st = new StringTokenizer(copiedSequences.toString());
            Vector<Sequence> seqs = new Vector<Sequence>();
            while (st.hasMoreElements()) {
                String name = st.nextToken();
                int start = Integer.parseInt(st.nextToken());
                int end = Integer.parseInt(st.nextToken());
                seqs.addElement(new Sequence(name, st.nextToken(), start, end));
            }
            SequenceI[] newSeqs = new SequenceI[seqs.size()];
            for (int i = 0; i < seqs.size(); ++i) {
                newSeqs[i] = (SequenceI)seqs.elementAt(i);
            }
            if (newAlignment) {
                String newtitle = new String("Copied sequences");
                newtitle = this.getTitle().startsWith("Copied sequences") ? this.getTitle() : newtitle.concat("- from " + this.getTitle());
                AlignFrame af = new AlignFrame(new Alignment(newSeqs), this.viewport.applet, newtitle, false);
                if (copiedHiddenColumns != null) {
                    for (int i = 0; i < copiedHiddenColumns.size(); ++i) {
                        int[] region = (int[])copiedHiddenColumns.elementAt(i);
                        af.viewport.hideColumns(region[0], region[1]);
                    }
                }
                JalviewLite.addFrame(af, newtitle, this.DEFAULT_WIDTH, this.DEFAULT_HEIGHT);
            } else {
                this.addSequences(newSeqs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void addSequences(SequenceI[] seqs) {
        for (int i = 0; i < seqs.length; ++i) {
            this.viewport.alignment.addSequence(seqs[i]);
        }
        this.addHistoryItem(new EditCommand("Add sequences", 3, seqs, 0, this.viewport.alignment.getWidth(), this.viewport.alignment));
        this.viewport.setEndSeq(this.viewport.alignment.getHeight());
        this.viewport.alignment.getWidth();
        this.viewport.firePropertyChange("alignment", null, this.viewport.alignment.getSequences());
    }

    protected void cut_actionPerformed() {
        this.copy_actionPerformed();
        this.delete_actionPerformed();
    }

    protected void delete_actionPerformed() {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        if (sg == null) {
            return;
        }
        Vector<SequenceI> seqs = new Vector<SequenceI>();
        for (int i = 0; i < sg.getSize(); ++i) {
            SequenceI seq = sg.getSequenceAt(i);
            seqs.addElement(seq);
        }
        if (sg.getSize() == this.viewport.alignment.getHeight()) {
            this.viewport.getColumnSelection().removeElements(sg.getStartRes(), sg.getEndRes() + 1);
        }
        SequenceI[] cut = new SequenceI[seqs.size()];
        for (int i = 0; i < seqs.size(); ++i) {
            cut[i] = (SequenceI)seqs.elementAt(i);
        }
        this.addHistoryItem(new EditCommand("Cut Sequences", 2, cut, sg.getStartRes(), sg.getEndRes() - sg.getStartRes() + 1, this.viewport.alignment));
        this.viewport.setSelectionGroup(null);
        this.viewport.alignment.deleteGroup(sg);
        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
        if (this.viewport.getAlignment().getHeight() < 1) {
            this.setVisible(false);
        }
    }

    protected void deleteGroups_actionPerformed() {
        this.viewport.alignment.deleteAllGroups();
        this.viewport.sequenceColours = null;
        this.viewport.setSelectionGroup(null);
        this.alignPanel.paintAlignment(true);
    }

    public void selectAllSequenceMenuItem_actionPerformed() {
        SequenceGroup sg = new SequenceGroup();
        for (int i = 0; i < this.viewport.getAlignment().getSequences().size(); ++i) {
            sg.addSequence(this.viewport.getAlignment().getSequenceAt(i), false);
        }
        sg.setEndRes(this.viewport.alignment.getWidth() - 1);
        this.viewport.setSelectionGroup(sg);
        this.alignPanel.paintAlignment(true);
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
    }

    public void deselectAllSequenceMenuItem_actionPerformed() {
        if (this.viewport.cursorMode) {
            this.alignPanel.seqPanel.keyboardNo1 = null;
            this.alignPanel.seqPanel.keyboardNo2 = null;
        }
        this.viewport.setSelectionGroup(null);
        this.viewport.getColumnSelection().clear();
        this.viewport.setSelectionGroup(null);
        this.alignPanel.idPanel.idCanvas.searchResults = null;
        this.alignPanel.seqPanel.seqCanvas.highlightSearchResults(null);
        this.alignPanel.paintAlignment(true);
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
    }

    public void invertSequenceMenuItem_actionPerformed() {
        SequenceGroup sg = this.viewport.getSelectionGroup();
        for (int i = 0; i < this.viewport.getAlignment().getSequences().size(); ++i) {
            sg.addOrRemove(this.viewport.getAlignment().getSequenceAt(i), false);
        }
        PaintRefresher.Refresh(this.alignPanel, this.viewport.getSequenceSetId());
    }

    void trimAlignment(boolean trimLeft) {
        ColumnSelection colSel = this.viewport.getColumnSelection();
        if (colSel.size() > 0) {
            TrimRegionCommand trimRegion;
            int column = trimLeft ? colSel.getMin() : colSel.getMax();
            SequenceI[] seqs = this.viewport.getSelectionGroup() != null ? this.viewport.getSelectionGroup().getSequencesAsArray(this.viewport.hiddenRepSequences) : this.viewport.alignment.getSequencesArray();
            if (trimLeft) {
                trimRegion = new TrimRegionCommand("Remove Left", TrimRegionCommand.TRIM_LEFT, seqs, column, this.viewport.alignment, this.viewport.colSel, this.viewport.selectionGroup);
                this.viewport.setStartRes(0);
            } else {
                trimRegion = new TrimRegionCommand("Remove Right", TrimRegionCommand.TRIM_RIGHT, seqs, column, this.viewport.alignment, this.viewport.colSel, this.viewport.selectionGroup);
            }
            this.statusBar.setText("Removed " + trimRegion.getSize() + " columns.");
            this.addHistoryItem(trimRegion);
            Vector groups = this.viewport.alignment.getGroups();
            for (int i = 0; i < groups.size(); ++i) {
                SequenceGroup sg = (SequenceGroup)groups.elementAt(i);
                if ((!trimLeft || sg.adjustForRemoveLeft(column)) && (trimLeft || sg.adjustForRemoveRight(column))) continue;
                this.viewport.alignment.deleteGroup(sg);
            }
            this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
        }
    }

    public void removeGappedColumnMenuItem_actionPerformed() {
        SequenceI[] seqs;
        int start = 0;
        int end = this.viewport.alignment.getWidth() - 1;
        if (this.viewport.getSelectionGroup() != null) {
            seqs = this.viewport.getSelectionGroup().getSequencesAsArray(this.viewport.hiddenRepSequences);
            start = this.viewport.getSelectionGroup().getStartRes();
            end = this.viewport.getSelectionGroup().getEndRes();
        } else {
            seqs = this.viewport.alignment.getSequencesArray();
        }
        RemoveGapColCommand removeGapCols = new RemoveGapColCommand("Remove Gapped Columns", seqs, start, end, this.viewport.alignment);
        this.addHistoryItem(removeGapCols);
        this.statusBar.setText("Removed " + removeGapCols.getSize() + " empty columns.");
        SequenceI seq = this.viewport.alignment.getSequenceAt(0);
        int startRes = seq.findPosition(this.viewport.startRes);
        this.viewport.setStartRes(seq.findIndex(startRes) - 1);
        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
    }

    public void removeAllGapsMenuItem_actionPerformed() {
        SequenceI[] seqs;
        int start = 0;
        int end = this.viewport.alignment.getWidth() - 1;
        if (this.viewport.getSelectionGroup() != null) {
            seqs = this.viewport.getSelectionGroup().getSequencesAsArray(this.viewport.hiddenRepSequences);
            start = this.viewport.getSelectionGroup().getStartRes();
            end = this.viewport.getSelectionGroup().getEndRes();
        } else {
            seqs = this.viewport.alignment.getSequencesArray();
        }
        SequenceI seq = this.viewport.alignment.getSequenceAt(0);
        int startRes = seq.findPosition(this.viewport.startRes);
        this.addHistoryItem(new RemoveGapsCommand("Remove Gaps", seqs, start, end, this.viewport.alignment));
        this.viewport.setStartRes(seq.findIndex(startRes) - 1);
        this.viewport.firePropertyChange("alignment", null, this.viewport.getAlignment().getSequences());
    }

    public void findMenuItem_actionPerformed() {
        new Finder(this.alignPanel);
    }

    public AlignFrame newView(String viewtitle) {
        Alignment newal = this.viewport.hasHiddenRows ? new Alignment(this.viewport.getAlignment().getHiddenSequences().getFullAlignment().getSequencesArray()) : new Alignment(this.viewport.alignment.getSequencesArray());
        if (this.viewport.alignment.getAlignmentAnnotation() != null) {
            for (int i = 0; i < this.viewport.alignment.getAlignmentAnnotation().length; ++i) {
                if (this.viewport.alignment.getAlignmentAnnotation()[i].autoCalculated) continue;
                newal.addAnnotation(this.viewport.alignment.getAlignmentAnnotation()[i]);
            }
        }
        AlignFrame newaf = new AlignFrame(newal, this.viewport.applet, "", false);
        newaf.viewport.sequenceSetID = this.alignPanel.av.getSequenceSetId();
        PaintRefresher.Register(this.alignPanel, this.alignPanel.av.getSequenceSetId());
        PaintRefresher.Register(newaf.alignPanel, newaf.alignPanel.av.getSequenceSetId());
        PaintRefresher.Register(newaf.alignPanel.idPanel.idCanvas, newaf.alignPanel.av.getSequenceSetId());
        PaintRefresher.Register(newaf.alignPanel.seqPanel.seqCanvas, newaf.alignPanel.av.getSequenceSetId());
        Vector comps = (Vector)PaintRefresher.components.get(this.viewport.getSequenceSetId());
        int viewSize = -1;
        for (int i = 0; i < comps.size(); ++i) {
            if (!(comps.elementAt(i) instanceof AlignmentPanel)) continue;
            ++viewSize;
        }
        String title = new String(this.getTitle());
        if (viewtitle != null) {
            title = viewtitle + " ( " + title + ")";
        } else {
            if (title.indexOf("(View") > -1) {
                title = title.substring(0, title.indexOf("(View"));
            }
            title = title + "(View " + viewSize + ")";
        }
        newaf.setTitle(title.toString());
        newaf.viewport.historyList = this.viewport.historyList;
        newaf.viewport.redoList = this.viewport.redoList;
        return newaf;
    }

    public String[] getFeatureGroups() {
        FeatureRenderer fr = null;
        if (this.alignPanel != null && (fr = this.alignPanel.getFeatureRenderer()) != null) {
            return fr.getGroups();
        }
        return null;
    }

    public String[] getFeatureGroupsOfState(boolean visible) {
        FeatureRenderer fr = null;
        if (this.alignPanel != null && (fr = this.alignPanel.getFeatureRenderer()) != null) {
            return fr.getGroups(visible);
        }
        return null;
    }

    public void setFeatureGroupState(String[] groups, boolean state) {
        FeatureRenderer fr = null;
        this.sequenceFeatures.setState(true);
        this.viewport.showSequenceFeatures(true);
        if (this.alignPanel != null && (fr = this.alignPanel.getFeatureRenderer()) != null) {
            fr.setGroupState(groups, state);
            this.alignPanel.seqPanel.seqCanvas.repaint();
            if (this.alignPanel.overviewPanel != null) {
                this.alignPanel.overviewPanel.updateOverviewImage();
            }
        }
    }

    public void seqLimits_itemStateChanged() {
        this.viewport.setShowJVSuffix(this.seqLimits.getState());
        this.alignPanel.fontChanged();
        this.alignPanel.paintAlignment(true);
    }

    protected void colourTextMenuItem_actionPerformed() {
        this.viewport.setColourText(this.colourTextMenuItem.getState());
        this.alignPanel.paintAlignment(true);
    }

    protected void wrapMenuItem_actionPerformed() {
        this.viewport.setWrapAlignment(this.wrapMenuItem.getState());
        this.alignPanel.setWrapAlignment(this.wrapMenuItem.getState());
        this.scaleAbove.setEnabled(this.wrapMenuItem.getState());
        this.scaleLeft.setEnabled(this.wrapMenuItem.getState());
        this.scaleRight.setEnabled(this.wrapMenuItem.getState());
        this.alignPanel.paintAlignment(true);
    }

    public void overviewMenuItem_actionPerformed() {
        if (this.alignPanel.overviewPanel != null) {
            return;
        }
        Frame frame = new Frame();
        OverviewPanel overview = new OverviewPanel(this.alignPanel);
        frame.add(overview);
        JalviewLite.addFrame(frame, "Overview " + this.getTitle(), overview.getPreferredSize().width, overview.getPreferredSize().height + 50);
        frame.pack();
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AlignFrame.this.alignPanel.setOverviewPanel(null);
            }
        });
        this.alignPanel.setOverviewPanel(overview);
    }

    void changeColour(ColourSchemeI cs) {
        int threshold = 0;
        if (cs != null) {
            if (this.viewport.getAbovePIDThreshold()) {
                threshold = SliderPanel.setPIDSliderSource(this.alignPanel, cs, "Background");
                cs.setThreshold(threshold, this.viewport.getIgnoreGapsConsensus());
                this.viewport.setGlobalColourScheme(cs);
            } else {
                cs.setThreshold(0, this.viewport.getIgnoreGapsConsensus());
            }
            if (this.viewport.getConservationSelected()) {
                Alignment al = (Alignment)this.viewport.alignment;
                Conservation c = new Conservation("All", ResidueProperties.propHash, 3, al.getSequences(), 0, al.getWidth() - 1);
                c.calculate();
                c.verdict(false, this.viewport.ConsPercGaps);
                cs.setConservation(c);
                cs.setConservationInc(SliderPanel.setConservationSlider(this.alignPanel, cs, "Background"));
            } else {
                cs.setConservation(null);
            }
            cs.setConsensus(this.viewport.hconsensus);
        }
        this.viewport.setGlobalColourScheme(cs);
        if (this.viewport.getColourAppliesToAllGroups()) {
            Vector groups = this.viewport.alignment.getGroups();
            for (int i = 0; i < groups.size(); ++i) {
                SequenceGroup sg = (SequenceGroup)groups.elementAt(i);
                if (cs == null) {
                    sg.cs = null;
                    continue;
                }
                if (cs instanceof ClustalxColourScheme) {
                    sg.cs = new ClustalxColourScheme(sg.getSequences(this.viewport.hiddenRepSequences), sg.getWidth());
                } else {
                    try {
                        sg.cs = (ColourSchemeI)cs.getClass().newInstance();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        sg.cs = cs;
                    }
                }
                if (this.viewport.getAbovePIDThreshold() || cs instanceof PIDColourScheme || cs instanceof Blosum62ColourScheme) {
                    sg.cs.setThreshold(threshold, this.viewport.getIgnoreGapsConsensus());
                    sg.cs.setConsensus(AAFrequency.calculate(sg.getSequences(this.viewport.hiddenRepSequences), 0, sg.getWidth()));
                } else {
                    sg.cs.setThreshold(0, this.viewport.getIgnoreGapsConsensus());
                }
                if (this.viewport.getConservationSelected()) {
                    Conservation c = new Conservation("Group", ResidueProperties.propHash, 3, sg.getSequences(this.viewport.hiddenRepSequences), 0, this.viewport.alignment.getWidth() - 1);
                    c.calculate();
                    c.verdict(false, this.viewport.ConsPercGaps);
                    sg.cs.setConservation(c);
                    continue;
                }
                sg.cs.setConservation(null);
                sg.cs.setThreshold(0, this.viewport.getIgnoreGapsConsensus());
            }
        }
        if (this.alignPanel.getOverviewPanel() != null) {
            this.alignPanel.getOverviewPanel().updateOverviewImage();
        }
        StructureSelectionManager.getStructureSelectionManager().sequenceColoursChanged(this.alignPanel);
        this.alignPanel.paintAlignment(true);
    }

    protected void modifyPID_actionPerformed() {
        if (this.viewport.getAbovePIDThreshold() && this.viewport.globalColourScheme != null) {
            SliderPanel.setPIDSliderSource(this.alignPanel, this.viewport.getGlobalColourScheme(), "Background");
            SliderPanel.showPIDSlider();
        }
    }

    protected void modifyConservation_actionPerformed() {
        if (this.viewport.getConservationSelected() && this.viewport.globalColourScheme != null) {
            SliderPanel.setConservationSlider(this.alignPanel, this.viewport.globalColourScheme, "Background");
            SliderPanel.showConservationSlider();
        }
    }

    protected void conservationMenuItem_actionPerformed() {
        this.viewport.setConservationSelected(this.conservationMenuItem.getState());
        this.viewport.setAbovePIDThreshold(false);
        this.abovePIDThreshold.setState(false);
        this.changeColour(this.viewport.getGlobalColourScheme());
        this.modifyConservation_actionPerformed();
    }

    public void abovePIDThreshold_actionPerformed() {
        this.viewport.setAbovePIDThreshold(this.abovePIDThreshold.getState());
        this.conservationMenuItem.setState(false);
        this.viewport.setConservationSelected(false);
        this.changeColour(this.viewport.getGlobalColourScheme());
        this.modifyPID_actionPerformed();
    }

    public void sortPairwiseMenuItem_actionPerformed() {
        SequenceI[] oldOrder = this.viewport.getAlignment().getSequencesArray();
        AlignmentSorter.sortByPID(this.viewport.getAlignment(), this.viewport.getAlignment().getSequenceAt(0), null);
        this.addHistoryItem(new OrderCommand("Pairwise Sort", oldOrder, this.viewport.alignment));
        this.alignPanel.paintAlignment(true);
    }

    public void sortIDMenuItem_actionPerformed() {
        AlignmentSorter.sortByID(this.viewport.getAlignment());
        this.alignPanel.paintAlignment(true);
    }

    public void sortGroupMenuItem_actionPerformed() {
        AlignmentSorter.sortByGroup(this.viewport.getAlignment());
        this.alignPanel.paintAlignment(true);
    }

    public void removeRedundancyMenuItem_actionPerformed() {
        new RedundancyPanel(this.alignPanel);
    }

    public void pairwiseAlignmentMenuItem_actionPerformed() {
        if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() > 1) {
            Frame frame = new Frame();
            frame.add(new PairwiseAlignPanel(this.alignPanel));
            JalviewLite.addFrame(frame, "Pairwise Alignment", 600, 500);
        }
    }

    public void PCAMenuItem_actionPerformed() {
        if (!this.viewport.alignment.isAligned()) {
            int Width = this.viewport.getAlignment().getWidth();
            for (int i = 0; i < this.viewport.getAlignment().getSequences().size(); ++i) {
                SequenceI current = this.viewport.getAlignment().getSequenceAt(i);
                if (current.getLength() >= Width) continue;
                current.insertCharAt(Width - 1, this.viewport.getGapCharacter());
            }
            this.alignPanel.paintAlignment(true);
        }
        if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() < 4 && this.viewport.getSelectionGroup().getSize() > 0 || this.viewport.getAlignment().getHeight() < 4) {
            return;
        }
        try {
            new PCAPanel(this.viewport);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            // empty catch block
        }
    }

    public void averageDistanceTreeMenuItem_actionPerformed() {
        this.NewTreePanel("AV", "PID", "Average distance tree using PID");
    }

    public void neighbourTreeMenuItem_actionPerformed() {
        this.NewTreePanel("NJ", "PID", "Neighbour joining tree using PID");
    }

    protected void njTreeBlosumMenuItem_actionPerformed() {
        this.NewTreePanel("NJ", "BL", "Neighbour joining tree using BLOSUM62");
    }

    protected void avTreeBlosumMenuItem_actionPerformed() {
        this.NewTreePanel("AV", "BL", "Average distance tree using BLOSUM62");
    }

    void NewTreePanel(String type, String pwType, String title) {
        if (!this.viewport.alignment.isAligned()) {
            int Width = this.viewport.getAlignment().getWidth();
            for (int i = 0; i < this.viewport.getAlignment().getSequences().size(); ++i) {
                SequenceI current = this.viewport.getAlignment().getSequenceAt(i);
                if (current.getLength() >= Width) continue;
                current.insertCharAt(Width - 1, this.viewport.getGapCharacter());
            }
            this.alignPanel.paintAlignment(true);
        }
        if (this.viewport.getSelectionGroup() != null && this.viewport.getSelectionGroup().getSize() > 1 || this.viewport.getSelectionGroup() == null && this.viewport.alignment.getHeight() > 1) {
            TreePanel tp = new TreePanel(this.viewport, type, pwType);
            this.addTreeMenuItem(tp, title);
            JalviewLite.addFrame(tp, title, 600, 500);
        }
    }

    void loadTree_actionPerformed() {
        CutAndPasteTransfer cap = new CutAndPasteTransfer(true, this);
        cap.setText("Paste your Newick tree file here.");
        cap.setTreeImport();
        Frame frame = new Frame();
        frame.add(cap);
        JalviewLite.addFrame(frame, "Paste Newick file ", 400, 300);
    }

    public void loadTree(NewickFile tree, String treeFile) {
        TreePanel tp = new TreePanel(this.viewport, treeFile, "From File - ", tree);
        JalviewLite.addFrame(tp, treeFile, 600, 500);
        this.addTreeMenuItem(tp, treeFile);
    }

    void addTreeMenuItem(final TreePanel treePanel, String title) {
        final MenuItem item = new MenuItem(title);
        this.sortByTreeMenu.add(item);
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AlignmentSorter.sortByTree(AlignFrame.this.viewport.getAlignment(), treePanel.getTree());
                AlignFrame.this.alignPanel.paintAlignment(true);
            }
        });
        treePanel.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AlignFrame.this.sortByTreeMenu.remove(item);
            }
        });
    }

    protected void documentation_actionPerformed() {
        this.showURL("http://www.jalview.org/help.html", "HELP");
    }

    protected void about_actionPerformed() {
        String version = "test";
        URL url = this.getClass().getResource("/.build_properties");
        if (url != null) {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
                while ((line = reader.readLine()) != null) {
                    if (line.indexOf("VERSION") <= -1) continue;
                    version = line.substring(line.indexOf("=") + 1);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        Frame frame = new Frame();
        class AboutPanel
        extends Canvas {
            String version;

            public AboutPanel(String version) {
                this.version = version;
            }

            public void paint(Graphics g) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.getSize().width, this.getSize().height);
                g.setFont(new Font("Helvetica", 0, 12));
                FontMetrics fm = g.getFontMetrics();
                int fh = fm.getHeight();
                int y = 5;
                int x = 7;
                g.setColor(Color.black);
                g.setFont(new Font("Helvetica", 1, 14));
                g.drawString("JalviewLite - Release " + this.version, x, y += fh);
                g.setFont(new Font("Helvetica", 0, 12));
                y = (int)((double)y + (double)fh * 1.5);
                g.drawString("Authors:  Andrew Waterhouse, Jim Procter, Michele Clamp, James Cuff, Steve Searle,", x, y);
                g.drawString("David Martin & Geoff Barton.", x + 50, y += fh);
                g.drawString("Development managed by The Barton Group, University of Dundee, Scotland, UK.", x, y += fh);
                g.drawString("For help, see the FAQ at www.jalview.org and/or join the jalview-discuss@jalview.org mailing list", x, y += fh);
                g.drawString("If  you use Jalview, please cite:", x, y += fh + 8);
                g.drawString("Waterhouse, A.M., Procter, J.B., Martin, D.M.A, Clamp, M. and Barton, G. J. (2009)", x, y += fh);
                g.drawString("Jalview Version 2 - a multiple sequence alignment editor and analysis workbench", x, y += fh);
                g.drawString("Bioinformatics doi: 10.1093/bioinformatics/btp033", x, y += fh);
            }
        }
        frame.add(new AboutPanel(version));
        JalviewLite.addFrame(frame, "Jalview", 580, 220);
    }

    public void showURL(String url, String target) {
        if (this.viewport.applet == null) {
            System.out.println("Not running as applet - no browser available.");
        } else {
            try {
                if (url.indexOf(":") == -1) {
                    if (url.indexOf("/") == 0) {
                        String codebase = this.viewport.applet.getCodeBase().toString();
                        url = codebase.substring(0, codebase.length() - this.viewport.applet.getCodeBase().getFile().length()) + url;
                    } else {
                        url = this.viewport.applet.getCodeBase() + url;
                    }
                    System.out.println("Show url (prepended codebase): " + url);
                } else {
                    System.out.println("Show url: " + url);
                }
                this.viewport.applet.getAppletContext().showDocument(new URL(url), target);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void jbInit() throws Exception {
        this.setMenuBar(this.alignFrameMenuBar);
        for (int i = 0; i < AppletFormatAdapter.WRITEABLE_FORMATS.length; ++i) {
            MenuItem item = new MenuItem(AppletFormatAdapter.WRITEABLE_FORMATS[i]);
            item.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AlignFrame.this.outputText_actionPerformed(e);
                }
            });
            this.outputTextboxMenu.add(item);
        }
        this.closeMenuItem.addActionListener(this);
        this.loadApplication.addActionListener(this);
        this.loadTree.addActionListener(this);
        this.loadAnnotations.addActionListener(this);
        this.outputFeatures.addActionListener(this);
        this.outputAnnotations.addActionListener(this);
        this.selectAllSequenceMenuItem.addActionListener(this);
        this.deselectAllSequenceMenuItem.addActionListener(this);
        this.invertSequenceMenuItem.addActionListener(this);
        this.remove2LeftMenuItem.setLabel("Remove Left");
        this.remove2LeftMenuItem.addActionListener(this);
        this.remove2RightMenuItem.setLabel("Remove Right");
        this.remove2RightMenuItem.addActionListener(this);
        this.removeGappedColumnMenuItem.setLabel("Remove Empty Columns");
        this.removeGappedColumnMenuItem.addActionListener(this);
        this.removeAllGapsMenuItem.setLabel("Remove All Gaps");
        this.removeAllGapsMenuItem.addActionListener(this);
        this.viewBoxesMenuItem.setLabel("Boxes");
        this.viewBoxesMenuItem.setState(true);
        this.viewBoxesMenuItem.addItemListener(this);
        this.viewTextMenuItem.setLabel("Text");
        this.viewTextMenuItem.setState(true);
        this.viewTextMenuItem.addItemListener(this);
        this.sortPairwiseMenuItem.setLabel("by Pairwise Identity");
        this.sortPairwiseMenuItem.addActionListener(this);
        this.sortIDMenuItem.setLabel("by ID");
        this.sortIDMenuItem.addActionListener(this);
        this.sortGroupMenuItem.setLabel("by Group");
        this.sortGroupMenuItem.addActionListener(this);
        this.removeRedundancyMenuItem.setLabel("Remove Redundancy...");
        this.removeRedundancyMenuItem.addActionListener(this);
        this.pairwiseAlignmentMenuItem.setLabel("Pairwise Alignments...");
        this.pairwiseAlignmentMenuItem.addActionListener(this);
        this.PCAMenuItem.setLabel("Principal Component Analysis");
        this.PCAMenuItem.addActionListener(this);
        this.averageDistanceTreeMenuItem.setLabel("Average Distance Using % Identity");
        this.averageDistanceTreeMenuItem.addActionListener(this);
        this.neighbourTreeMenuItem.setLabel("Neighbour Joining Using % Identity");
        this.neighbourTreeMenuItem.addActionListener(this);
        this.statusBar.setBackground(Color.white);
        this.statusBar.setFont(new Font("Verdana", 0, 11));
        this.statusBar.setText("Status bar");
        this.outputTextboxMenu.setLabel("Output to Textbox");
        this.clustalColour.setLabel("Clustalx");
        this.clustalColour.addActionListener(this);
        this.zappoColour.setLabel("Zappo");
        this.zappoColour.addActionListener(this);
        this.taylorColour.setLabel("Taylor");
        this.taylorColour.addActionListener(this);
        this.hydrophobicityColour.setLabel("Hydrophobicity");
        this.hydrophobicityColour.addActionListener(this);
        this.helixColour.setLabel("Helix Propensity");
        this.helixColour.addActionListener(this);
        this.strandColour.setLabel("Strand Propensity");
        this.strandColour.addActionListener(this);
        this.turnColour.setLabel("Turn Propensity");
        this.turnColour.addActionListener(this);
        this.buriedColour.setLabel("Buried Index");
        this.buriedColour.addActionListener(this);
        this.userDefinedColour.setLabel("User Defined...");
        this.userDefinedColour.addActionListener(this);
        this.PIDColour.setLabel("Percentage Identity");
        this.PIDColour.addActionListener(this);
        this.BLOSUM62Colour.setLabel("BLOSUM62 Score");
        this.BLOSUM62Colour.addActionListener(this);
        this.avDistanceTreeBlosumMenuItem.setLabel("Average Distance Using BLOSUM62");
        this.avDistanceTreeBlosumMenuItem.addActionListener(this);
        this.njTreeBlosumMenuItem.setLabel("Neighbour Joining Using BLOSUM62");
        this.njTreeBlosumMenuItem.addActionListener(this);
        this.annotationPanelMenuItem.setLabel("Show Annotations");
        this.annotationPanelMenuItem.addItemListener(this);
        this.colourTextMenuItem.setLabel("Colour Text");
        this.colourTextMenuItem.addItemListener(this);
        this.alProperties.addActionListener(this);
        this.overviewMenuItem.setLabel("Overview Window");
        this.overviewMenuItem.addActionListener(this);
        this.undoMenuItem.setEnabled(false);
        this.undoMenuItem.setLabel("Undo");
        this.undoMenuItem.addActionListener(this);
        this.redoMenuItem.setEnabled(false);
        this.redoMenuItem.setLabel("Redo");
        this.redoMenuItem.addActionListener(this);
        this.conservationMenuItem.setLabel("by Conservation");
        this.conservationMenuItem.addItemListener(this);
        this.noColourmenuItem.setLabel("None");
        this.noColourmenuItem.addActionListener(this);
        this.wrapMenuItem.setLabel("Wrap");
        this.wrapMenuItem.addItemListener(this);
        this.renderGapsMenuItem.setLabel("Show Gaps");
        this.renderGapsMenuItem.setState(true);
        this.renderGapsMenuItem.addItemListener(this);
        this.findMenuItem.setLabel("Find...");
        this.findMenuItem.addActionListener(this);
        this.abovePIDThreshold.setLabel("Above Identity Threshold");
        this.abovePIDThreshold.addItemListener(this);
        this.nucleotideColour.setLabel("Nucleotide");
        this.nucleotideColour.addActionListener(this);
        this.deleteGroups.setLabel("Undefine Groups");
        this.deleteGroups.addActionListener(this);
        this.copy.setLabel("Copy");
        this.copy.addActionListener(this);
        this.cut.setLabel("Cut");
        this.cut.addActionListener(this);
        this.delete.setLabel("Delete");
        this.delete.addActionListener(this);
        this.pasteMenu.setLabel("Paste");
        this.pasteNew.setLabel("To New Alignment");
        this.pasteNew.addActionListener(this);
        this.pasteThis.setLabel("Add To This Alignment");
        this.pasteThis.addActionListener(this);
        this.applyToAllGroups.setLabel("Apply Colour To All Groups");
        this.applyToAllGroups.setState(true);
        this.applyToAllGroups.addItemListener(this);
        this.font.setLabel("Font...");
        this.font.addActionListener(this);
        this.scaleAbove.setLabel("Scale Above");
        this.scaleAbove.setState(true);
        this.scaleAbove.setEnabled(false);
        this.scaleAbove.addItemListener(this);
        this.scaleLeft.setEnabled(false);
        this.scaleLeft.setState(true);
        this.scaleLeft.setLabel("Scale Left");
        this.scaleLeft.addItemListener(this);
        this.scaleRight.setEnabled(false);
        this.scaleRight.setState(true);
        this.scaleRight.setLabel("Scale Right");
        this.scaleRight.addItemListener(this);
        this.modifyPID.setLabel("Modify Identity Threshold...");
        this.modifyPID.addActionListener(this);
        this.modifyConservation.setLabel("Modify Conservation Threshold...");
        this.modifyConservation.addActionListener(this);
        this.sortByTreeMenu.setLabel("By Tree Order");
        this.sort.setLabel("Sort");
        this.calculate.setLabel("Calculate Tree");
        this.autoCalculate.addItemListener(this);
        this.inputText.setLabel("Input from textbox");
        this.inputText.addActionListener(this);
        this.centreColumnLabelFlag.setLabel("Centre column labels");
        this.centreColumnLabelFlag.addItemListener(this);
        this.helpMenu.setLabel("Help");
        this.documentation.setLabel("Documentation");
        this.documentation.addActionListener(this);
        this.about.setLabel("About...");
        this.about.addActionListener(this);
        this.seqLimits.setState(true);
        this.seqLimits.setLabel("Show Sequence Limits");
        this.seqLimits.addItemListener(this);
        this.featureSettings.setLabel("Feature Settings...");
        this.featureSettings.addActionListener(this);
        this.sequenceFeatures.setLabel("Sequence Features");
        this.sequenceFeatures.addItemListener(this);
        this.sequenceFeatures.setState(false);
        this.annotationColour.setLabel("by Annotation...");
        this.annotationColour.addActionListener(this);
        this.invertSequenceMenuItem.setLabel("Invert Sequence Selection");
        this.invertColSel.setLabel("Invert Column Selection");
        this.menu1.setLabel("Show");
        this.showColumns.setLabel("All Columns ");
        this.showSeqs.setLabel("All Sequences");
        this.menu2.setLabel("Hide");
        this.hideColumns.setLabel("Selected Columns");
        this.hideSequences.setLabel("Selected Sequences");
        this.invertColSel.addActionListener(this);
        this.showColumns.addActionListener(this);
        this.showSeqs.addActionListener(this);
        this.hideColumns.addActionListener(this);
        this.hideSequences.addActionListener(this);
        this.formatMenu.setLabel("Format");
        this.selectMenu.setLabel("Select");
        this.newView.setLabel("New View");
        this.newView.addActionListener(this);
        this.alignFrameMenuBar.add(this.fileMenu);
        this.alignFrameMenuBar.add(this.editMenu);
        this.alignFrameMenuBar.add(this.selectMenu);
        this.alignFrameMenuBar.add(this.viewMenu);
        this.alignFrameMenuBar.add(this.formatMenu);
        this.alignFrameMenuBar.add(this.colourMenu);
        this.alignFrameMenuBar.add(this.calculateMenu);
        this.alignFrameMenuBar.add(this.helpMenu);
        this.fileMenu.add(this.inputText);
        this.fileMenu.add(this.loadTree);
        this.fileMenu.add(this.loadAnnotations);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.outputTextboxMenu);
        this.fileMenu.add(this.outputFeatures);
        this.fileMenu.add(this.outputAnnotations);
        if (this.jalviewServletURL != null) {
            this.fileMenu.add(this.loadApplication);
        }
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.closeMenuItem);
        this.editMenu.add(this.undoMenuItem);
        this.editMenu.add(this.redoMenuItem);
        this.editMenu.add(this.cut);
        this.editMenu.add(this.copy);
        this.editMenu.add(this.pasteMenu);
        this.editMenu.add(this.delete);
        this.editMenu.addSeparator();
        this.editMenu.add(this.remove2LeftMenuItem);
        this.editMenu.add(this.remove2RightMenuItem);
        this.editMenu.add(this.removeGappedColumnMenuItem);
        this.editMenu.add(this.removeAllGapsMenuItem);
        this.editMenu.add(this.removeRedundancyMenuItem);
        this.viewMenu.add(this.newView);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.menu1);
        this.viewMenu.add(this.menu2);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.annotationPanelMenuItem);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.sequenceFeatures);
        this.viewMenu.add(this.featureSettings);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.alProperties);
        this.viewMenu.addSeparator();
        this.viewMenu.add(this.overviewMenuItem);
        this.colourMenu.add(this.applyToAllGroups);
        this.colourMenu.addSeparator();
        this.colourMenu.add(this.noColourmenuItem);
        this.colourMenu.add(this.clustalColour);
        this.colourMenu.add(this.BLOSUM62Colour);
        this.colourMenu.add(this.PIDColour);
        this.colourMenu.add(this.zappoColour);
        this.colourMenu.add(this.taylorColour);
        this.colourMenu.add(this.hydrophobicityColour);
        this.colourMenu.add(this.helixColour);
        this.colourMenu.add(this.strandColour);
        this.colourMenu.add(this.turnColour);
        this.colourMenu.add(this.buriedColour);
        this.colourMenu.add(this.nucleotideColour);
        this.colourMenu.add(this.userDefinedColour);
        this.colourMenu.addSeparator();
        this.colourMenu.add(this.conservationMenuItem);
        this.colourMenu.add(this.modifyConservation);
        this.colourMenu.add(this.abovePIDThreshold);
        this.colourMenu.add(this.modifyPID);
        this.colourMenu.add(this.annotationColour);
        this.calculateMenu.add(this.sort);
        this.calculateMenu.add(this.calculate);
        this.calculateMenu.addSeparator();
        this.calculateMenu.add(this.pairwiseAlignmentMenuItem);
        this.calculateMenu.add(this.PCAMenuItem);
        this.calculateMenu.add(this.autoCalculate);
        this.add((Component)this.statusBar, "South");
        this.pasteMenu.add(this.pasteNew);
        this.pasteMenu.add(this.pasteThis);
        this.sort.add(this.sortIDMenuItem);
        this.sort.add(this.sortByTreeMenu);
        this.sort.add(this.sortGroupMenuItem);
        this.sort.add(this.sortPairwiseMenuItem);
        this.calculate.add(this.averageDistanceTreeMenuItem);
        this.calculate.add(this.neighbourTreeMenuItem);
        this.calculate.add(this.avDistanceTreeBlosumMenuItem);
        this.calculate.add(this.njTreeBlosumMenuItem);
        this.helpMenu.add(this.documentation);
        this.helpMenu.add(this.about);
        this.menu1.add(this.showColumns);
        this.menu1.add(this.showSeqs);
        this.menu2.add(this.hideColumns);
        this.menu2.add(this.hideSequences);
        this.formatMenu.add(this.font);
        this.formatMenu.add(this.seqLimits);
        this.formatMenu.add(this.wrapMenuItem);
        this.formatMenu.add(this.scaleAbove);
        this.formatMenu.add(this.scaleLeft);
        this.formatMenu.add(this.scaleRight);
        this.formatMenu.add(this.viewBoxesMenuItem);
        this.formatMenu.add(this.viewTextMenuItem);
        this.formatMenu.add(this.colourTextMenuItem);
        this.formatMenu.add(this.renderGapsMenuItem);
        this.formatMenu.add(this.centreColumnLabelFlag);
        this.selectMenu.add(this.findMenuItem);
        this.selectMenu.addSeparator();
        this.selectMenu.add(this.selectAllSequenceMenuItem);
        this.selectMenu.add(this.deselectAllSequenceMenuItem);
        this.selectMenu.add(this.invertSequenceMenuItem);
        this.selectMenu.add(this.invertColSel);
        this.selectMenu.add(this.deleteGroups);
    }

    public void createAlignFrameWindow(boolean reallyEmbedded, String title) {
        if (reallyEmbedded) {
            this.fileMenu.remove(this.closeMenuItem);
            this.fileMenu.remove(3);
            this.embeddedMenu = this.makeEmbeddedPopupMenu(this.alignFrameMenuBar, "Arial", 0, 10, false);
            this.viewport.applet.setLayout(new BorderLayout());
            this.viewport.applet.add((Component)this.embeddedMenu, "North");
            this.viewport.applet.add((Component)this.statusBar, "South");
            this.alignPanel.setSize(this.viewport.applet.getSize().width, this.viewport.applet.getSize().height - 2 - 2);
            this.viewport.applet.add((Component)this.alignPanel, "Center");
            this.viewport.applet.validate();
        } else {
            if (this.embedMenuIfNeeded(this.alignPanel)) {
                this.alignPanel.setSize(this.getSize().width, this.getSize().height - 2);
            }
            this.add((Component)this.statusBar, "South");
            this.add((Component)this.alignPanel, "Center");
            JalviewLite.addFrame(this, title, this.DEFAULT_WIDTH, this.DEFAULT_HEIGHT);
        }
    }
}

