/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.CutAndPasteTransfer;
import jalview.appletgui.EditNameDialog;
import jalview.appletgui.Tooltip;
import jalview.bin.JalviewLite;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.datamodel.SequenceI;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class AnnotationLabels
extends Panel
implements ActionListener,
MouseListener,
MouseMotionListener {
    Image image;
    boolean active = false;
    AlignmentPanel ap;
    AlignViewport av;
    boolean resizing = false;
    int oldY;
    int mouseX;
    static String ADDNEW = "Add New Row";
    static String EDITNAME = "Edit Label/Description";
    static String HIDE = "Hide This Row";
    static String SHOWALL = "Show All Hidden Rows";
    static String OUTPUT_TEXT = "Show Values In Textbox";
    static String COPYCONS_SEQ = "Copy Consensus Sequence";
    int scrollOffset = 0;
    int selectedRow = -1;
    Tooltip tooltip;

    public AnnotationLabels(AlignmentPanel ap) {
        this.ap = ap;
        this.av = ap.av;
        this.setLayout(null);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public AnnotationLabels(AlignViewport av) {
        this.av = av;
    }

    public void setScrollOffset(int y) {
        this.scrollOffset = y;
        this.repaint();
    }

    int getSelectedRow(int y) {
        int row = -1;
        AlignmentAnnotation[] aa = this.ap.av.alignment.getAlignmentAnnotation();
        if (aa == null) {
            return row;
        }
        int height = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (!aa[i].visible || y >= (height += aa[i].height)) continue;
            row = i;
            break;
        }
        return row;
    }

    public void actionPerformed(ActionEvent evt) {
        SequenceI cons;
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        if (evt.getActionCommand().equals(ADDNEW)) {
            AlignmentAnnotation newAnnotation = new AlignmentAnnotation("", null, new Annotation[this.ap.av.alignment.getWidth()]);
            if (!this.editLabelDescription(newAnnotation)) {
                return;
            }
            this.ap.av.alignment.addAnnotation(newAnnotation);
            this.ap.av.alignment.setAnnotationIndex(newAnnotation, 0);
        } else if (evt.getActionCommand().equals(EDITNAME)) {
            this.editLabelDescription(aa[this.selectedRow]);
        } else if (evt.getActionCommand().equals(HIDE)) {
            aa[this.selectedRow].visible = false;
        } else if (evt.getActionCommand().equals(SHOWALL)) {
            for (int i = 0; i < aa.length; ++i) {
                aa[i].visible = aa[i].annotations != null;
            }
        } else if (evt.getActionCommand().equals(OUTPUT_TEXT)) {
            CutAndPasteTransfer cap = new CutAndPasteTransfer(false, this.ap.alignFrame);
            Frame frame = new Frame();
            frame.add(cap);
            JalviewLite.addFrame(frame, this.ap.alignFrame.getTitle() + " - " + aa[this.selectedRow].label, 500, 100);
            cap.setText(aa[this.selectedRow].toString());
        } else if (evt.getActionCommand().equals(COPYCONS_SEQ) && (cons = this.av.getConsensusSeq()) != null) {
            this.copy_annotseqtoclipboard(cons);
        }
        this.ap.annotationPanel.adjustPanelHeight();
        this.setSize(this.getSize().width, this.ap.annotationPanel.getSize().height);
        this.ap.validate();
        this.ap.paintAlignment(true);
    }

    boolean editLabelDescription(AlignmentAnnotation annotation) {
        Checkbox padGaps = new Checkbox("Fill Empty Gaps With \"" + this.ap.av.getGapCharacter() + "\"", annotation.padGaps);
        EditNameDialog dialog = new EditNameDialog(annotation.label, annotation.description, "      Annotation Label", "Annotation Description", this.ap.alignFrame, "Edit Annotation Name / Description", 500, 180, false);
        Panel empty = new Panel(new FlowLayout());
        empty.add(padGaps);
        dialog.add(empty);
        dialog.pack();
        dialog.setVisible(true);
        if (dialog.accept) {
            annotation.label = dialog.getName();
            annotation.description = dialog.getDescription();
            annotation.setPadGaps(padGaps.getState(), this.av.getGapCharacter());
            this.repaint();
            return true;
        }
        return false;
    }

    public void mouseMoved(MouseEvent evt) {
        int row = this.getSelectedRow(evt.getY() - this.scrollOffset);
        if (row > -1) {
            if (this.tooltip == null) {
                this.tooltip = new Tooltip(this.ap.av.alignment.getAlignmentAnnotation()[row].getDescription(true), this);
            } else {
                this.tooltip.setTip(this.ap.av.alignment.getAlignmentAnnotation()[row].getDescription(true));
            }
        } else if (this.tooltip != null) {
            this.tooltip.setTip("");
        }
    }

    public void mouseDragged(MouseEvent evt) {
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    public void mousePressed(MouseEvent evt) {
        this.selectedRow = this.getSelectedRow(evt.getY() - this.scrollOffset);
        AlignmentAnnotation[] aa = this.ap.av.alignment.getAlignmentAnnotation();
        PopupMenu popup = new PopupMenu("Annotations");
        MenuItem item = new MenuItem(ADDNEW);
        item.addActionListener(this);
        popup.add(item);
        item = new MenuItem(EDITNAME);
        item.addActionListener(this);
        popup.add(item);
        item = new MenuItem(HIDE);
        item.addActionListener(this);
        popup.add(item);
        item = new MenuItem(SHOWALL);
        item.addActionListener(this);
        popup.add(item);
        this.add(popup);
        item = new MenuItem(OUTPUT_TEXT);
        item.addActionListener(this);
        popup.add(item);
        if (aa[this.selectedRow] == this.ap.av.consensus) {
            popup.addSeparator();
            final CheckboxMenuItem cbmi = new CheckboxMenuItem("Ignore Gaps In Consensus", this.ap.av.getIgnoreGapsConsensus());
            cbmi.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    AnnotationLabels.this.ap.av.setIgnoreGapsConsensus(cbmi.getState());
                    AnnotationLabels.this.ap.paintAlignment(true);
                }
            });
            popup.add(cbmi);
            item = new MenuItem(COPYCONS_SEQ);
            item.addActionListener(this);
            popup.add(item);
        }
        popup.show(this, evt.getX(), evt.getY());
    }

    protected void copy_annotseqtoclipboard(SequenceI sq) {
        if (sq == null || sq.getLength() < 1) {
            return;
        }
        AlignFrame.copiedSequences = new StringBuffer();
        AlignFrame.copiedSequences.append(sq.getName() + "\t" + sq.getStart() + "\t" + sq.getEnd() + "\t" + sq.getSequenceAsString() + "\n");
        if (this.av.hasHiddenColumns) {
            AlignFrame.copiedHiddenColumns = new Vector();
            for (int i = 0; i < this.av.getColumnSelection().getHiddenColumns().size(); ++i) {
                int[] region = (int[])this.av.getColumnSelection().getHiddenColumns().elementAt(i);
                AlignFrame.copiedHiddenColumns.addElement(new int[]{region[0], region[1]});
            }
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        int w = this.getSize().width;
        if (this.image == null || w != this.image.getWidth(this)) {
            this.image = this.createImage(w, this.ap.annotationPanel.getSize().height);
        }
        this.drawComponent(this.image.getGraphics(), w);
        g.drawImage(this.image, 0, 0, this);
    }

    public void drawComponent(Graphics g, int width) {
        g.setFont(this.av.getFont());
        FontMetrics fm = g.getFontMetrics(this.av.getFont());
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        g.translate(0, this.scrollOffset);
        g.setColor(Color.black);
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        int y = g.getFont().getSize();
        int x = 0;
        if (aa != null) {
            for (int i = 0; i < aa.length; ++i) {
                if (!aa[i].visible) continue;
                x = width - fm.stringWidth(aa[i].label) - 3;
                if (aa[i].graph > 0) {
                    y += aa[i].height / 3;
                }
                g.drawString(aa[i].label, x, y);
                if (aa[i].graph > 0) {
                    y += 2 * aa[i].height / 3;
                    continue;
                }
                y += aa[i].height;
            }
        }
    }
}

