/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.EditNameDialog;
import jalview.appletgui.UserDefinedColours;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Annotation;
import jalview.util.Platform;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class AnnotationPanel
extends Panel
implements AdjustmentListener,
ActionListener,
MouseListener,
MouseMotionListener {
    AlignViewport av;
    AlignmentPanel ap;
    int activeRow = -1;
    Vector activeRes;
    static String HELIX = "Helix";
    static String SHEET = "Sheet";
    static String LABEL = "Label";
    static String REMOVE = "Remove Annotation";
    static String COLOUR = "Colour";
    static Color HELIX_COLOUR = Color.red.darker();
    static Color SHEET_COLOUR = Color.green.darker().darker();
    Image image;
    Graphics gg;
    FontMetrics fm;
    int imgWidth = 0;
    boolean fastPaint = false;
    public static int GRAPH_HEIGHT = 40;
    boolean MAC = false;

    public AnnotationPanel(AlignmentPanel ap) {
        this.MAC = new Platform().isAMac();
        this.ap = ap;
        this.av = ap.av;
        this.setLayout(null);
        this.adjustPanelHeight();
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
    }

    public AnnotationPanel(AlignViewport av) {
        this.av = av;
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        this.ap.alabels.setScrollOffset(-evt.getValue());
    }

    public void actionPerformed(ActionEvent evt) {
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        Annotation[] anot = aa[this.activeRow].annotations;
        if (anot.length < this.av.getColumnSelection().getMax()) {
            Annotation[] temp = new Annotation[this.av.getColumnSelection().getMax() + 2];
            System.arraycopy(anot, 0, temp, 0, anot.length);
            aa[this.activeRow].annotations = anot = temp;
        }
        String label = "";
        if (this.av.colSel != null && this.av.colSel.size() > 0 && anot[this.av.colSel.getMin()] != null) {
            label = anot[this.av.getColumnSelection().getMin()].displayCharacter;
        }
        if (evt.getActionCommand().equals(REMOVE)) {
            for (int i = 0; i < this.av.getColumnSelection().size(); ++i) {
                anot[this.av.getColumnSelection().columnAt((int)i)] = null;
            }
        } else if (evt.getActionCommand().equals(LABEL)) {
            if ((label = this.enterLabel(label, "Enter Label")) == null) {
                return;
            }
            if (label.length() > 0 && !aa[this.activeRow].hasText) {
                aa[this.activeRow].hasText = true;
            }
            for (int i = 0; i < this.av.getColumnSelection().size(); ++i) {
                int index = this.av.getColumnSelection().columnAt(i);
                if (!this.av.colSel.isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation(label, "", ' ', 0.0f);
                }
                anot[index].displayCharacter = label;
            }
        } else if (evt.getActionCommand().equals(COLOUR)) {
            UserDefinedColours udc = new UserDefinedColours(this, Color.black, this.ap.alignFrame);
            Color col = udc.getColor();
            for (int i = 0; i < this.av.getColumnSelection().size(); ++i) {
                int index = this.av.getColumnSelection().columnAt(i);
                if (!this.av.colSel.isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation("", "", ' ', 0.0f);
                }
                anot[index].colour = col;
            }
        } else {
            char type = '\u0000';
            String symbol = "\u03b1";
            if (evt.getActionCommand().equals(HELIX)) {
                type = 'H';
            } else if (evt.getActionCommand().equals(SHEET)) {
                type = 'E';
                symbol = "\u03b2";
            }
            if (!aa[this.activeRow].hasIcons) {
                aa[this.activeRow].hasIcons = true;
            }
            if ((label = this.enterLabel(symbol, "Enter Label")) == null) {
                return;
            }
            if (label.length() > 0 && !aa[this.activeRow].hasText) {
                aa[this.activeRow].hasText = true;
            }
            for (int i = 0; i < this.av.getColumnSelection().size(); ++i) {
                int index = this.av.getColumnSelection().columnAt(i);
                if (!this.av.colSel.isVisible(index)) continue;
                if (anot[index] == null) {
                    anot[index] = new Annotation(label, "", type, 0.0f);
                }
                anot[index].secondaryStructure = type;
                anot[index].displayCharacter = label;
            }
        }
        this.adjustPanelHeight();
        this.repaint();
    }

    String enterLabel(String text, String label) {
        EditNameDialog dialog = new EditNameDialog(text, null, label, null, this.ap.alignFrame, "Enter Label", 400, 200, true);
        if (dialog.accept) {
            return dialog.getName();
        }
        return null;
    }

    public void mousePressed(MouseEvent evt) {
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        if (aa == null) {
            return;
        }
        int height = 0;
        this.activeRow = -1;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i].visible) {
                height += aa[i].height;
            }
            if (evt.getY() >= height) continue;
            if (!aa[i].editable) break;
            this.activeRow = i;
            break;
        }
        if ((evt.getModifiers() & 4) == 4 && this.activeRow != -1) {
            if (this.av.getColumnSelection() == null) {
                return;
            }
            PopupMenu pop = new PopupMenu("Structure type");
            MenuItem item = new MenuItem(HELIX);
            item.addActionListener(this);
            pop.add(item);
            item = new MenuItem(SHEET);
            item.addActionListener(this);
            pop.add(item);
            item = new MenuItem(LABEL);
            item.addActionListener(this);
            pop.add(item);
            item = new MenuItem(COLOUR);
            item.addActionListener(this);
            pop.add(item);
            item = new MenuItem(REMOVE);
            item.addActionListener(this);
            pop.add(item);
            this.ap.alignFrame.add(pop);
            pop.show(this, evt.getX(), evt.getY());
            return;
        }
        if (aa == null) {
            return;
        }
        this.ap.scalePanel.mousePressed(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        this.ap.scalePanel.mouseReleased(evt);
    }

    public void mouseClicked(MouseEvent evt) {
    }

    public void mouseDragged(MouseEvent evt) {
        this.ap.scalePanel.mouseDragged(evt);
    }

    public void mouseMoved(MouseEvent evt) {
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        if (aa == null) {
            return;
        }
        int row = -1;
        int height = 0;
        for (int i = 0; i < aa.length; ++i) {
            if (aa[i].visible) {
                height += aa[i].height;
            }
            if (evt.getY() >= height) continue;
            row = i;
            break;
        }
        int res = evt.getX() / this.av.getCharWidth() + this.av.getStartRes();
        if (this.av.hasHiddenColumns) {
            res = this.av.getColumnSelection().adjustForHiddenColumns(res);
        }
        if (row > -1 && res < aa[row].annotations.length && aa[row].annotations[res] != null) {
            StringBuffer text = new StringBuffer("Sequence position " + (res + 1));
            if (aa[row].annotations[res].description != null) {
                text.append("  " + aa[row].annotations[res].description);
            }
            this.ap.alignFrame.statusBar.setText(text.toString());
        }
    }

    public void mouseEntered(MouseEvent evt) {
        this.ap.scalePanel.mouseEntered(evt);
    }

    public void mouseExited(MouseEvent evt) {
        this.ap.scalePanel.mouseExited(evt);
    }

    public int adjustPanelHeight() {
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        int height = 0;
        if (aa != null) {
            for (int i = 0; i < aa.length; ++i) {
                if (!aa[i].visible) continue;
                aa[i].height = 0;
                if (aa[i].hasText) {
                    aa[i].height += this.av.charHeight;
                }
                if (aa[i].hasIcons) {
                    aa[i].height += 16;
                }
                if (aa[i].graph > 0) {
                    aa[i].height += aa[i].graphHeight;
                }
                if (aa[i].height == 0) {
                    aa[i].height = 20;
                }
                height += aa[i].height;
            }
        } else {
            height = 20;
        }
        this.setSize(this.getSize().width, height);
        this.repaint();
        return height;
    }

    public void addEditableColumn(int i) {
        if (this.activeRow == -1) {
            AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
            if (aa == null) {
                return;
            }
            for (int j = 0; j < aa.length; ++j) {
                if (!aa[j].editable) continue;
                this.activeRow = j;
                break;
            }
        }
        if (this.activeRes == null) {
            this.activeRes = new Vector();
            this.activeRes.addElement(String.valueOf(i));
            return;
        }
        this.activeRes.addElement(String.valueOf(i));
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.imgWidth = this.getSize().width;
        if (this.image == null || this.imgWidth != this.image.getWidth(this)) {
            this.image = this.createImage(this.imgWidth, this.ap.annotationPanel.getSize().height);
            this.gg = this.image.getGraphics();
            this.gg.setFont(this.av.getFont());
            this.fm = this.gg.getFontMetrics();
            this.fastPaint = false;
        }
        if (this.fastPaint) {
            g.drawImage(this.image, 0, 0, this);
            this.fastPaint = false;
            return;
        }
        this.gg.setColor(Color.white);
        this.gg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.drawComponent(this.gg, this.av.startRes, this.av.endRes + 1);
        g.drawImage(this.image, 0, 0, this);
    }

    public void fastPaint(int horizontal) {
        if (horizontal == 0 || this.av.alignment.getAlignmentAnnotation() == null || this.av.alignment.getAlignmentAnnotation().length < 1) {
            this.repaint();
            return;
        }
        this.gg.copyArea(0, 0, this.imgWidth, this.getSize().height, -horizontal * this.av.charWidth, 0);
        int sr = this.av.startRes;
        int er = this.av.endRes + 1;
        int transX = 0;
        if (horizontal > 0) {
            transX = (er - sr - horizontal) * this.av.charWidth;
            sr = er - horizontal;
        } else if (horizontal < 0) {
            er = sr - horizontal;
        }
        this.gg.translate(transX, 0);
        this.drawComponent(this.gg, sr, er);
        this.gg.translate(-transX, 0);
        this.fastPaint = true;
        this.repaint();
    }

    public void drawComponent(Graphics g, int startRes, int endRes) {
        g.setFont(this.av.getFont());
        g.setColor(Color.white);
        g.fillRect(0, 0, (endRes - startRes) * this.av.charWidth, this.getSize().height);
        if (this.fm == null) {
            this.fm = g.getFontMetrics();
        }
        if (this.av.alignment.getAlignmentAnnotation() == null || this.av.alignment.getAlignmentAnnotation().length < 1) {
            g.setColor(Color.white);
            g.fillRect(0, 0, this.getSize().width, this.getSize().height);
            g.setColor(Color.black);
            if (this.av.validCharWidth) {
                g.drawString("Alignment has no annotations", 20, 15);
            }
            return;
        }
        AlignmentAnnotation[] aa = this.av.alignment.getAlignmentAnnotation();
        int x = 0;
        int y = 0;
        int column = 0;
        int iconOffset = this.av.charHeight / 2;
        boolean validRes = false;
        boolean validEnd = false;
        boolean[] graphGroupDrawn = new boolean[aa.length];
        for (int i = 0; i < aa.length; ++i) {
            int x2;
            int x1;
            int sCol;
            AlignmentAnnotation row = aa[i];
            if (!row.visible) continue;
            int lastSS = 32;
            int lastSSX = 0;
            if (row.graph > 0) {
                if (row.graphGroup > -1 && graphGroupDrawn[row.graphGroup]) continue;
                y += row.height;
                if (row.hasText) {
                    y -= this.av.charHeight;
                }
            }
            iconOffset = row.hasText ? this.av.charHeight / 2 : 0;
            for (x = 0; x < endRes - startRes; ++x) {
                if (this.av.hasHiddenColumns) {
                    column = this.av.getColumnSelection().adjustForHiddenColumns(startRes + x);
                    if (column > row.annotations.length - 1) {
                        break;
                    }
                } else {
                    column = startRes + x;
                }
                validRes = row.annotations.length > column && row.annotations[column] != null;
                if (this.activeRow == i) {
                    g.setColor(Color.red);
                    if (this.av.getColumnSelection() != null) {
                        for (int n = 0; n < this.av.getColumnSelection().size(); ++n) {
                            int v = this.av.getColumnSelection().columnAt(n);
                            if (v != column) continue;
                            g.fillRect(x * this.av.charWidth, y, this.av.charWidth, this.av.charHeight);
                        }
                    }
                }
                if (this.av.validCharWidth && validRes && row.annotations[column].displayCharacter != null && row.annotations[column].displayCharacter.length() > 0) {
                    int charOffset;
                    int n = charOffset = this.av.getCentreColumnLabels() ? (this.av.charWidth - this.fm.charsWidth(row.annotations[column].displayCharacter.toCharArray(), 0, row.annotations[column].displayCharacter.length())) / 2 : (this.av.charWidth - this.fm.charWidth(row.annotations[column].displayCharacter.charAt(0))) / 2;
                    if (row.annotations[column].colour == null) {
                        g.setColor(Color.black);
                    } else {
                        g.setColor(row.annotations[column].colour);
                    }
                    if (column == 0 || row.graph > 0) {
                        g.drawString(row.annotations[column].displayCharacter, x * this.av.charWidth + charOffset, y + iconOffset + 3);
                    } else if (row.annotations[column - 1] == null || !row.annotations[column].displayCharacter.equals(row.annotations[column - 1].displayCharacter) || row.annotations[column].displayCharacter.length() < 2 && row.annotations[column].secondaryStructure == ' ') {
                        g.drawString(row.annotations[column].displayCharacter, x * this.av.charWidth + charOffset, y + iconOffset + 3);
                    }
                }
                if (row.hasIcons && (!validRes || row.annotations[column].secondaryStructure != lastSS)) {
                    switch (lastSS) {
                        case 72: {
                            g.setColor(HELIX_COLOUR);
                            if (this.MAC) {
                                g.fillRoundRect(lastSSX, y + 4 + iconOffset, x * this.av.charWidth - lastSSX, 7, 8, 8);
                                break;
                            }
                            sCol = lastSSX / this.av.charWidth + startRes;
                            x1 = lastSSX;
                            x2 = x * this.av.charWidth;
                            if (sCol == 0 || row.annotations[sCol - 1] == null || row.annotations[sCol - 1].secondaryStructure != 'H') {
                                g.fillArc(lastSSX, y + 4 + iconOffset, this.av.charWidth, 8, 90, 180);
                                x1 += this.av.charWidth / 2;
                            }
                            if (!validRes || row.annotations[column] == null || row.annotations[column].secondaryStructure != 'H') {
                                g.fillArc(x * this.av.charWidth - this.av.charWidth, y + 4 + iconOffset, this.av.charWidth, 8, 270, 180);
                                x2 -= this.av.charWidth / 2;
                            }
                            g.fillRect(x1, y + 4 + iconOffset, x2 - x1, 8);
                            break;
                        }
                        case 69: {
                            g.setColor(SHEET_COLOUR);
                            g.fillRect(lastSSX, y + 4 + iconOffset, x * this.av.charWidth - lastSSX - 4, 7);
                            g.fillPolygon(new int[]{x * this.av.charWidth - 4, x * this.av.charWidth - 4, x * this.av.charWidth}, new int[]{y + iconOffset, y + 14 + iconOffset, y + 8 + iconOffset}, 3);
                            break;
                        }
                        default: {
                            g.setColor(Color.gray);
                            g.fillRect(lastSSX, y + 6 + iconOffset, x * this.av.charWidth - lastSSX, 2);
                        }
                    }
                    lastSS = validRes ? (int)row.annotations[column].secondaryStructure : 32;
                    lastSSX = x * this.av.charWidth;
                }
                ++column;
            }
            if (column >= row.annotations.length) {
                column = row.annotations.length - 1;
                validEnd = false;
            } else {
                validEnd = true;
            }
            if (row.hasIcons) {
                switch (lastSS) {
                    case 72: {
                        g.setColor(HELIX_COLOUR);
                        if (this.MAC) {
                            g.fillRoundRect(lastSSX, y + 4 + iconOffset, x * this.av.charWidth - lastSSX, 7, 8, 8);
                            break;
                        }
                        sCol = lastSSX / this.av.charWidth + startRes;
                        x1 = lastSSX;
                        x2 = x * this.av.charWidth;
                        if (sCol == 0 || row.annotations[sCol - 1] == null || row.annotations[sCol - 1].secondaryStructure != 'H') {
                            g.fillArc(lastSSX, y + 4 + iconOffset, this.av.charWidth, 8, 90, 180);
                            x1 += this.av.charWidth / 2;
                        }
                        if (row.annotations[column] == null || row.annotations[column].secondaryStructure != 'H') {
                            g.fillArc(x * this.av.charWidth - this.av.charWidth, y + 4 + iconOffset, this.av.charWidth, 8, 270, 180);
                            x2 -= this.av.charWidth / 2;
                        }
                        g.fillRect(x1, y + 4 + iconOffset, x2 - x1, 8);
                        break;
                    }
                    case 69: {
                        g.setColor(SHEET_COLOUR);
                        if (!validEnd || row.annotations[endRes] == null || row.annotations[endRes].secondaryStructure != 'E') {
                            g.fillRect(lastSSX, y + 4 + iconOffset, x * this.av.charWidth - lastSSX - 4, 7);
                            g.fillPolygon(new int[]{x * this.av.charWidth - 4, x * this.av.charWidth - 4, x * this.av.charWidth}, new int[]{y + iconOffset, y + 14 + iconOffset, y + 7 + iconOffset}, 3);
                            break;
                        }
                        g.fillRect(lastSSX, y + 4 + iconOffset, x * this.av.charWidth - lastSSX, 7);
                        break;
                    }
                    default: {
                        g.setColor(Color.gray);
                        if (this.av.wrapAlignment && endRes != this.av.endRes) break;
                        g.fillRect(lastSSX, y + 6 + iconOffset, x * this.av.charWidth - lastSSX, 2);
                    }
                }
            }
            if (row.graph > 0) {
                if (row.graph == 2) {
                    if (row.graphGroup > -1 && !graphGroupDrawn[row.graphGroup]) {
                        int gg;
                        float groupmax = -999999.0f;
                        float groupmin = 9999999.0f;
                        for (gg = 0; gg < aa.length; ++gg) {
                            if (aa[gg].graphGroup != row.graphGroup) continue;
                            if (aa[gg] != row) {
                                aa[gg].visible = false;
                            }
                            if (aa[gg].graphMax > groupmax) {
                                groupmax = aa[gg].graphMax;
                            }
                            if (!(aa[gg].graphMin < groupmin)) continue;
                            groupmin = aa[gg].graphMin;
                        }
                        for (gg = 0; gg < aa.length; ++gg) {
                            if (aa[gg].graphGroup != row.graphGroup) continue;
                            this.drawLineGraph(g, aa[gg], startRes, endRes, y, groupmin, groupmax, row.graphHeight);
                        }
                        graphGroupDrawn[row.graphGroup] = true;
                    } else {
                        this.drawLineGraph(g, row, startRes, endRes, y, row.graphMin, row.graphMax, row.graphHeight);
                    }
                } else if (row.graph == 1) {
                    this.drawBarGraph(g, row, startRes, endRes, row.graphMin, row.graphMax, y);
                }
            }
            if (row.graph > 0 && row.hasText) {
                y += this.av.charHeight;
            }
            if (row.graph != 0) continue;
            y += aa[i].height;
        }
    }

    public void drawLineGraph(Graphics g, AlignmentAnnotation aa, int sRes, int eRes, int y, float min, float max, int graphHeight) {
        if (sRes > aa.annotations.length) {
            return;
        }
        int x = 0;
        if (eRes < this.av.endRes) {
            ++eRes;
        }
        eRes = Math.min(eRes, aa.annotations.length);
        int y1 = y;
        int y2 = y;
        float range = max - min;
        if (min < 0.0f) {
            y2 = y - (int)((0.0f - min / range) * (float)graphHeight);
        }
        g.setColor(Color.gray);
        g.drawLine(x - this.av.charWidth, y2, (eRes - sRes) * this.av.charWidth, y2);
        eRes = Math.min(eRes, aa.annotations.length);
        int aaMax = aa.annotations.length - 1;
        while (x < eRes - sRes) {
            int column = sRes + x;
            if (this.av.hasHiddenColumns) {
                column = this.av.getColumnSelection().adjustForHiddenColumns(column);
            }
            if (column > aaMax) break;
            if (aa.annotations[column] == null) {
                ++x;
                continue;
            }
            if (aa.annotations[column].colour == null) {
                g.setColor(Color.black);
            } else {
                g.setColor(aa.annotations[column].colour);
            }
            y1 = column == 0 || aa.annotations[column - 1] == null ? y - (int)((aa.annotations[column].value - min) / range * (float)graphHeight) : y - (int)((aa.annotations[column - 1].value - min) / range * (float)graphHeight);
            y2 = y - (int)((aa.annotations[column].value - min) / range * (float)graphHeight);
            g.drawLine(x * this.av.charWidth - this.av.charWidth / 2, y1, x * this.av.charWidth + this.av.charWidth / 2, y2);
            ++x;
        }
        if (aa.threshold != null) {
            g.setColor(aa.threshold.colour);
            y2 = (int)((float)y - (aa.threshold.value - min) / range * (float)graphHeight);
            g.drawLine(0, y2, (eRes - sRes) * this.av.charWidth, y2);
        }
    }

    public void drawBarGraph(Graphics g, AlignmentAnnotation aa, int sRes, int eRes, float min, float max, int y) {
        if (sRes > aa.annotations.length) {
            return;
        }
        eRes = Math.min(eRes, aa.annotations.length);
        int x = 0;
        int y1 = y;
        int y2 = y;
        float range = max - min;
        if (min < 0.0f) {
            y2 = y - (int)((0.0f - min / range) * (float)aa.graphHeight);
        }
        g.setColor(Color.gray);
        g.drawLine(x, y2, (eRes - sRes) * this.av.charWidth, y2);
        int aaMax = aa.annotations.length - 1;
        while (x < eRes - sRes) {
            int column = sRes + x;
            if (this.av.hasHiddenColumns) {
                column = this.av.getColumnSelection().adjustForHiddenColumns(column);
            }
            if (column > aaMax) break;
            if (aa.annotations[column] == null) {
                ++x;
                continue;
            }
            if (aa.annotations[column].colour == null) {
                g.setColor(Color.black);
            } else {
                g.setColor(aa.annotations[column].colour);
            }
            y1 = y - (int)((aa.annotations[column].value - min) / range * (float)aa.graphHeight);
            if (y1 - y2 > 0) {
                g.fillRect(x * this.av.charWidth, y2, this.av.charWidth, y1 - y2);
            } else {
                g.fillRect(x * this.av.charWidth, y1, this.av.charWidth, y2 - y1);
            }
            ++x;
        }
        if (aa.threshold != null) {
            g.setColor(aa.threshold.colour);
            y2 = (int)((float)y - (aa.threshold.value - min) / range * (float)aa.graphHeight);
            g.drawLine(0, y2, (eRes - sRes) * this.av.charWidth, y2);
        }
    }

    public void drawGraph(Graphics g, AlignmentAnnotation aa, int width, int y, int sRes, int eRes) {
        eRes = Math.min(eRes, aa.annotations.length);
        g.setColor(Color.white);
        g.fillRect(0, 0, width, y);
        g.setColor(new Color(0, 0, 180));
        int x = 0;
        for (int j = sRes; j < eRes; ++j) {
            if (aa.annotations[j].colour == null) {
                g.setColor(Color.black);
            } else {
                g.setColor(aa.annotations[j].colour);
            }
            int height = (int)(aa.annotations[j].value / aa.graphMax * (float)GRAPH_HEIGHT);
            if (height > y) {
                height = y;
            }
            g.fillRect(x, y - height, this.av.charWidth, height);
            x += this.av.charWidth;
        }
    }
}

