# Copyright (c) 2024, Manfred Moitzi
# License: MIT License
import pytest

from ezdxf.entities import LWPolyline
from ezdxf.math import BoundingBox
from ezdxf import bbox

POINTS = [
    (218969.6310157223, 112295.8227786999, 0.0, 0.0, 0.0),
    (218969.6310157223, 108455.6934995856, 0.0, 0.0, 0.0),
    (218969.6310145899, 108455.8221127223, 0.0, 0.0, 0.0),
    (218969.6310145899, 107355.6934995856, 0.0, 0.0, 0.0),
    (218969.6310145899, 107355.6934995856, 0.0, 0.0, 0.0),
    (218969.631013219, 105018.9770271163, 0.0, 0.0, -0.105069362517723),
    (226155.9223287149, 102073.9322948213, 0.0, 0.0, 0.0),
    (226679.8027970239, 102640.9121177326, 0.0, 0.0, 0.0),
    (226166.2477223321, 103115.4302806388, 0.0, 0.0, 0.0),
    (226709.1594593569, 103703.0070439484, 0.0, 0.0, 0.0),
    (227149.8281460448, 103295.8347999509, 0.0, 0.0, 0.0),
    (228720.5539262934, 104995.7833161484, 0.0, 0.0, 0.0),
    (228040.5130174204, 104995.7833161484, 0.0, 0.0, 0.0),
    (228040.5130174204, 105995.7831254135, 0.0, 0.0, 0.0),
    (228840.5221948667, 105995.7831254135, 0.0, 0.0, 0.0),
    (228840.5222903534, 109895.8227743711, 0.0, 0.0, 0.0),
    (228040.3895770951, 109895.8227743711, 0.0, 0.0, 0.0),
    (228040.5297859355, 112295.8227926101, 0.0, 0.0, 0.0),
]


def test_bbox_lwpolyline_with_const_width():
    e = LWPolyline()
    e.dxf.const_width = 100
    e.set_points(POINTS)
    extents = bbox.extents([e])
    assert extents.extmin.x > 218_700
    assert extents.extmin.y > 102_000
    assert extents.extmax.x < 230_000
    assert extents.extmax.y < 113_000


if __name__ == "__main__":
    pytest.main([__file__])
