/*******************************************************************
 * libfaxophone                                                    *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file isdn-convert.h
 * \brief audio conversation header
 */

#ifndef ISDN_CONVERT_H
#define ISDN_CONVERT_H

#include <faxophone/faxophone.h>
#include <string.h>
#include <math.h>

signed char linear16_2_law[65536];                // 16bit PCM, Mono, 8000 hz -> alaw
unsigned short law_2_linear16[256];               // alaw -> 16bit PCM, Mono, 8000 hz

void createTableBuffer( void );
double getLineLevelIn( void );
double getLineLevelOut( void );
void convertIsdnToAudio( struct sRecorder *psRecorder, unsigned char *pnInBuf, unsigned int nInBufLen, unsigned char *pnOutBuf, unsigned int *pnOutBufLen, short *pnRecBuf );
void convertAudioToIsdn( struct sCapiConnection *psConnection, unsigned char *pnInBuf, unsigned int nInBufLen, unsigned char *pnOutBuf, unsigned int *pnOutBufLen, short *pnRecBuf );
inline unsigned char bitinverse( unsigned char nChar );

#endif
