program ttoupper;

{$ifdef FPC}
  {$mode objfpc}
  {$H+}
  {$PACKENUM 1}
{$endif fpc} 

{$ifndef FPC}
  {$APPTYPE CONSOLE}    
{$endif}
  
uses     
  SysUtils,
  character;
    
{$ifndef FPC}
  type UnicodeChar = WideChar;   
{$endif} 

procedure DoError(ACode : Integer); overload;
begin
  WriteLn('Error #',ACode);
  Halt(Acode);
end;         
    
procedure DoError(ACode : Integer; ACodePoint : Integer); overload;
begin
  WriteLn('Error #',ACode,' ; CodePoint = ',IntToHex(ACodePoint,4));
  Halt(Acode);
end;          
    
procedure DoError(ACode : Integer; ACodePoint : UnicodeChar); overload;
begin
  WriteLn('Error #',ACode,' ; CodePoint = ',IntToHex(Ord(ACodePoint),4));
  Halt(Acode);
end;         

var
  e, i, j : Integer;
  uc : UnicodeChar;
begin  
  e := 1;
  for i := Ord('A') to Ord('Z') do begin
    uc := UnicodeChar(i);
    if (TCharacter.ToUpper(uc) <> uc) then
      DoError(e,i);
  end;

  Inc(e);
  for i := Ord('0') to Ord('9') do begin
    uc := UnicodeChar(i);
    if (TCharacter.ToUpper(uc) <> uc) then
      DoError(e,i);
  end;
  
  Inc(e);
  j := Ord('A');
  for i := Ord('a') to Ord('a') do begin
    uc := UnicodeChar(i);
    if (TCharacter.ToUpper(uc) <> UnicodeChar(j)) then
      DoError(e,i);
    Inc(j);
  end; 
  
  Inc(e);     
  for i := Low(Word) to High(Word) do begin
    uc := UnicodeChar(i); 
    if (TCharacter.GetUnicodeCategory(uc) = TUnicodeCategory.ucUppercaseLetter) then begin
      if (TCharacter.ToUpper(uc) <> uc) then
        DoError(e,uc);  
    end;
  end;

  WriteLn('ok');
end.

