##                                                        -*- Makefile -*-
## Copyright 2001  Alexandre Duret-Lutz <duret_g@epita.fr>
##
## This file is part of Heroes.
##
## Heroes is free software; you can redistribute it and/or modify it under
## the terms of the GNU General Public License version 2 as published by
## the Free Software Foundation.
##
## Heroes is distributed in the hope that it will be useful, but WITHOUT
## ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
## FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
## for more details.
##
## You should have received a copy of the GNU General Public License along
## with this program; if not, write to the Free Software Foundation, Inc.,
## 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
##

## These libraries are tagged as `EXTRA' because we don't want to build
## all of them everytime.  Only a subset of them (determined at
## configure time) will be built.  Practically, the requested libraries
## are simply listed in heroes_DEPENDENCIES.

EXTRA_DIST += \
  media/README

EXTRA_LIBRARIES += \
  media/libhmcommon.a \
  media/libhggivkm.a \
  media/libhgiij.a \
  media/libhmiks.a \
  media/libhsdlvkm.a \
  media/libhsdlj.a \
  media/libhsdls.a \
  media/libhallvkm.a \
  media/libhallj.a \
  media/libhdumvkm.a \
  media/libhdumj.a \
  media/libhdums.a

media_libhmcommon_a_SOURCES = \
  media/joystick.h \
  media/keyb.c \
  media/keyb.h \
  media/keyb_low.h \
  media/keysdef.h \
  media/keyvalues.h \
  media/video.c \
  media/video.h \
  media/video_low.h \
  media/strack.c \
  media/strack.h \
  media/sfx.c \
  media/sfx.h

media_libhggivkm_a_CFLAGS = \
  $(MORE_WARNINGS_CFLAGS) $(GGI_CFLAGS)
media_libhggivkm_a_SOURCES = \
  media/ggi/keyb.c \
  media/ggi/keyvalues.c \
  media/ggi/video.c
nodist_media_libhggivkm_a_SOURCES = \
  media/ggi/keysdef.c

media_libhgiij_a_CFLAGS = \
  $(MORE_WARNINGS_CFLAGS) $(GGI_CFLAGS) $(GII_CFLAGS)
media_libhgiij_a_SOURCES = \
  media/gii/joystick.c

media_libhmiks_a_CFLAGS = \
  $(MORE_WARNINGS_CFLAGS) $(LIBMIKMOD_CFLAGS)
media_libhmiks_a_SOURCES = \
  media/mikmod/strack.c \
  media/mikmod/sfx.c

media_libhsdlvkm_a_CFLAGS = \
  $(MORE_WARNINGS_CFLAGS) $(SDL_CFLAGS)
media_libhsdlvkm_a_SOURCES = \
  media/sdl/keyb.c \
  media/sdl/keyvalues.c \
  media/sdl/video.c
nodist_media_libhsdlvkm_a_SOURCES = \
  media/sdl/keysdef.c

media_libhsdlj_a_CFLAGS = \
  $(MORE_WARNINGS_CFLAGS) $(SDL_CFLAGS)
media_libhsdlj_a_SOURCES = \
  media/sdl/joystick.c

media_libhsdls_a_CFLAGS = \
  $(MORE_WARNINGS_CFLAGS) $(SDL_CFLAGS) $(SDL_MIXER_CFLAGS)
media_libhsdls_a_SOURCES = \
  media/sdl_mixer/strack.c \
  media/sdl_mixer/sfx.c

# Don't use $(MORE_WARNINGS_CFLAGS) with Allegro.  There are too many
# warnings in the Allegro header files!
media_libhallvkm_a_CFLAGS = \
  $(WARNINGS_CFLAGS) $(ALLEGRO_CFLAGS)
media_libhallvkm_a_SOURCES = \
  media/allegro/keyb.c \
  media/allegro/keyvalues.c \
  media/allegro/video.c
nodist_media_libhallvkm_a_SOURCES = \
  media/allegro/keysdef.c

# Don't use $(MORE_WARNINGS_CFLAGS) with Allegro.  There are too many
# warnings in the Allegro header files!
media_libhallj_a_CFLAGS = \
  $(WARNINGS_CFLAGS) $(ALLEGRO_CFLAGS)
media_libhallj_a_SOURCES = \
  media/allegro/joystick.c

media_libhdumvkm_a_SOURCES = \
  media/dummy/keyb.c \
  media/dummy/keysdef.c \
  media/dummy/keyvalues.c \
  media/dummy/video.c

media_libhdumj_a_SOURCES = \
  media/dummy/joystick.c

media_libhdums_a_SOURCES = \
  media/dummy/strack.c \
  media/dummy/sfx.c

DISTCLEANFILES += \
  media/allegro/keysdef.c \
  media/ggi/keysdef.c \
  media/sdl/keysdef.c

media/ggi/keysdef.c: media/ggi/.dirstamp
	if test "x$(GGI_KEYBOARD_H)" = x; then \
## If $(GGI_KEYBOARD_H) is empty we are not building Heroes for SDL.
## This file is probably built as a dependency of or rule like TAGS.
	  touch $@ ; \
	else \
## There is one reason the put the input file first.  There needs
## to be somthing after in case $(GGI_KEYBOARD_H) is empty, otherwise
## shells might complain about a syntax error.  Yep, that's tricky.
	  < $(GGI_KEYBOARD_H) $(AWK) ' \
BEGIN { print "/* Do not edit!\n" \
	      "   This file was generated by src/Makefile\n" \
	      "   from @GGI_KEYBOARD_H@ */\n" \
	      "#include \"system.h\"\n" \
	      "#include <ggi/ggi.h>\n" \
	      "#include \"keysdef.h\"\n" \
	      "const struct keynames_s keynames[] = {" } \
$$2 ~ /(GIIK_|GIIUC_)/ { \
	print "\t{ \""toupper(substr($$2,index($$2,"_")+1))"\",", $$2,"}," } \
END { print "\t{ 0, 0 }};\n" }' > $@ ; \
	fi

media/sdl/keysdef.c: media/sdl/.dirstamp
	if test "x$(SDL_KEYSYM_H)" = x; then \
## If $(SDL_KEYSYM_H) is empty we are not building Heroes for SDL.
## This file is probably built as a dependency of or rule like TAGS.
	  touch $@ ; \
	else \
## There is one reason the put the input file first.  There needs
## to be somthing after in case $(SDL_KEYSYM_H) is empty, otherwise
## shells might complain about a syntax error.  Yep, that's tricky.
	  < $(SDL_KEYSYM_H) $(AWK) ' \
BEGIN { print "/* Do not edit!\n" \
	      "   This file was generated by src/Makefile\n" \
	      "   from @SDL_KEYSYM_H@ */\n" \
	      "#include \"system.h\"\n" \
	      "#include <SDL.h>\n" \
	      "#include \"keysdef.h\"\n" \
	      "const struct keynames_s keynames[] = {" } \
$$1 ~ /SDLK_/ { \
	print "\t{ \""toupper(substr($$1,index($$1,"_")+1))"\",", $$1,"}," } \
END { print "\t{ 0, 0 }};\n" }' > $@ ; \
	fi

media/allegro/keysdef.c: media/allegro/.dirstamp
	if test "x$(ALLEGRO_H)" = x; then \
## If $(ALLEGRO_H) is empty we are not building Heroes for Allegro
## This file is probably built as a dependency of or rule like TAGS.
	  touch $@ ; \
	else \
## There is one reason the put the input file first.  There needs
## to be somthing after in case $(ALLOGRO_H) is empty, otherwise
## shells might complain about a syntax error.  Yep, that's tricky.
	  < $(ALLEGRO_H) $(AWK) ' \
BEGIN { print "/* Do not edit!\n" \
	      "   This file was generated by src/Makefile\n" \
	      "   from @ALLEGRO_H@ */\n" \
	      "#include \"system.h\"\n" \
	      "#include <allegro.h>\n" \
	      "#include \"keysdef.h\"\n" \
	      "const struct keynames_s keynames[] = {" } \
$$2 ~ /KEY_/ { \
	print "\t{ \""toupper(substr($$2,index($$2,"_")+1))"\",", $$2,"}," } \
END { print "\t{ 0, 0 }};\n" }' > $@ ; \
	fi
