/* player.c generated by valac 0.40.0.6-2c488, the Vala compiler
 * generated from player.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2013 Michael Catanzaro
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_PLAYER (player_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;



GType player_get_type (void) G_GNUC_CONST;
gchar* player_to_string (Player self);
Player player_from_char (gchar c);
Player player_flip_color (Player p);


gchar*
player_to_string (Player self)
{
	gchar* result = NULL;
	switch (self) {
		case PLAYER_LIGHT:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("L");
			result = _tmp0_;
			return result;
		}
		case PLAYER_DARK:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("D");
			result = _tmp1_;
			return result;
		}
		default:
		{
			gchar* _tmp2_;
			g_warn_if_fail (self == PLAYER_NONE);
			_tmp2_ = g_strdup (".");
			result = _tmp2_;
			return result;
		}
	}
}


Player
player_from_char (gchar c)
{
	Player result = 0;
	_vala_return_val_if_fail (((c == 'L') || (c == 'D')) || (c == '.'), "c == 'L' || c == 'D' || c == '.'", 0);
	switch (c) {
		case 'L':
		{
			result = PLAYER_LIGHT;
			return result;
		}
		case 'D':
		{
			result = PLAYER_DARK;
			return result;
		}
		case '.':
		{
			result = PLAYER_NONE;
			return result;
		}
		default:
		{
			g_warn_if_reached ();
			result = PLAYER_NONE;
			return result;
		}
	}
}


Player
player_flip_color (Player p)
{
	Player result = 0;
	Player _tmp0_ = 0;
	_vala_return_val_if_fail (p != PLAYER_NONE, "p != Player.NONE", 0);
	if (p == PLAYER_LIGHT) {
		_tmp0_ = PLAYER_DARK;
	} else {
		_tmp0_ = PLAYER_LIGHT;
	}
	result = _tmp0_;
	return result;
}


GType
player_get_type (void)
{
	static volatile gsize player_type_id__volatile = 0;
	if (g_once_init_enter (&player_type_id__volatile)) {
		static const GEnumValue values[] = {{PLAYER_NONE, "PLAYER_NONE", "none"}, {PLAYER_DARK, "PLAYER_DARK", "dark"}, {PLAYER_LIGHT, "PLAYER_LIGHT", "light"}, {0, NULL, NULL}};
		GType player_type_id;
		player_type_id = g_enum_register_static ("Player", values);
		g_once_init_leave (&player_type_id__volatile, player_type_id);
	}
	return player_type_id__volatile;
}



