/*
 * Decompiled with CFR 0.152.
 */
package jarinstaller.gui;

import jarinstaller.gui.FileUtil;
import jarinstaller.gui.INavigation;
import jarinstaller.gui.IReport;
import jarinstaller.gui.StepPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class UserToDoPanel
extends StepPanel
implements IReport {
    Hashtable gp;
    Vector files = null;
    Vector dirs = null;
    Vector resultfiles = null;
    Vector resultdirs = null;
    Vector actresults = null;
    JLabel lblInfo = new JLabel();
    JScrollPane text_pane = new JScrollPane();
    JTextArea text_area = new JTextArea();
    INavigation navigation;
    String destDir;
    String info;
    String jarinstallerdir;
    boolean insresult = false;
    String errmsg = "";
    FileUtil fu;
    Thread fuThread;
    Vector text;
    String donekey;

    public UserToDoPanel(Hashtable params) {
        this.gp = params;
        if (this.gp.containsKey("userfiles")) {
            this.files = (Vector)this.gp.get("userfiles");
        }
        if (this.gp.containsKey("userdirectories")) {
            this.dirs = (Vector)this.gp.get("userdirectories");
        }
        this.destDir = (String)this.gp.get("DESTINATIONDIR");
        this.jarinstallerdir = (String)this.gp.get("parameter.dir.jarinstaller");
        this.navigation = (INavigation)this.gp.get("navigation.frameid");
        this.initDataStore();
        try {
            this.createElements();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initDataStore() {
        if (this.gp.containsKey("parameter.option.install.filelist")) {
            this.resultfiles = (Vector)this.gp.get("parameter.option.install.filelist");
        } else {
            this.resultfiles = new Vector();
            this.gp.put("parameter.option.install.filelist", this.resultfiles);
        }
        if (this.gp.containsKey("parameter.option.install.dirlist")) {
            this.resultdirs = (Vector)this.gp.get("parameter.option.install.dirlist");
        } else {
            this.resultdirs = new Vector();
            this.gp.put("parameter.option.install.dirlist", this.resultdirs);
        }
    }

    public void createElements() throws Exception {
        this.setOpaque(false);
        this.lblInfo.setFont((Font)this.gp.get("gui.font.title"));
        this.lblInfo.setOpaque(false);
        this.text_pane.setPreferredSize(new Dimension(400, 150));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridbag = new GridBagConstraints();
        gridbag.gridx = 0;
        gridbag.gridy = 0;
        gridbag.gridwidth = 1;
        gridbag.gridheight = 1;
        gridbag.weightx = 0.0;
        gridbag.weighty = 0.0;
        gridbag.anchor = 17;
        gridbag.fill = 10;
        gridbag.insets = new Insets(0, 20, 0, 10);
        this.add((Component)this.lblInfo, gridbag);
        gridbag.gridx = 0;
        gridbag.gridy = 1;
        gridbag.gridwidth = 1;
        gridbag.gridheight = 1;
        gridbag.weightx = 1.0;
        gridbag.weighty = 0.0;
        gridbag.anchor = 17;
        gridbag.fill = 10;
        gridbag.insets = new Insets(5, 20, 0, 10);
        this.add((Component)this.text_pane, gridbag);
        this.text_area.setEditable(false);
        this.text_pane.getViewport().add((Component)this.text_area, null);
        this.text_area.setAutoscrolls(true);
        this.text = new Vector(200);
        this.guiRefresh();
    }

    public void guiRefresh() throws Exception {
        this.setBackground((Color)this.gp.get("gui.color.bgrnd"));
        this.setMaximumSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.setPreferredSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.setMinimumSize((Dimension)this.gp.get("gui.dimension.steppanel"));
        this.lblInfo.setForeground((Color)this.gp.get("gui.color.fgrnd"));
        this.text_area.setLineWrap(false);
        this.text_area.setForeground((Color)this.gp.get("gui.color.fgrnd"));
        this.write();
        this.text_area.setCaretPosition(0);
        this.validate();
    }

    private void write() {
        this.text_area.removeAll();
        this.text_area.setText("");
        if (this.text != null) {
            for (int i = 0; i < this.text.size(); ++i) {
                String st = (String)this.text.elementAt(i);
                this.text_area.append(st + "\n");
            }
        }
    }

    public boolean isActivate() {
        return this.donekey == null || !this.gp.containsKey(this.donekey);
    }

    public void setParams(Hashtable params) {
        this.info = (String)params.get("info");
        this.donekey = (String)params.get("done");
        this.lblInfo.setText(this.info);
        this.validate();
    }

    public boolean start(Hashtable start_params) {
        if (this.gp.containsKey("USERINSTALL") && !((Boolean)this.gp.get("USERINSTALL")).booleanValue()) {
            this.setResult(true, null, null);
            return true;
        }
        return this.exec();
    }

    private boolean exec() {
        try {
            this.insresult = false;
            this.fu = new FileUtil();
            this.fu.setDestdir(this.destDir);
            this.fu.setFiles(this.files);
            this.fu.setDirs(this.dirs);
            this.fu.setReport(this);
            this.fu.setResultfiles(this.resultfiles);
            this.fu.setResultdirs(this.resultdirs);
            this.fu.setParams(this.gp);
            this.fu.setUsertodo(true);
            this.fuThread = new Thread(this.fu);
            this.fuThread.start();
        }
        catch (Exception e) {
            this.errmsg = e.getMessage();
            this.navigation.fwd();
        }
        return this.insresult;
    }

    public boolean isFinisdhed(boolean stop) {
        if (stop) {
            if (this.fuThread.isAlive()) {
                this.fu.stop();
                while (!this.fu.isStopped()) {
                    this.sleep(2000L);
                }
                this.fuThread = null;
            }
            return true;
        }
        return true;
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Hashtable end() {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        result.put("parameter.option.install.ready", "");
        result.put("parameter.option.install.result", this.insresult);
        if (!this.insresult) {
            result.put("parameter.option.install.errmsg", this.errmsg);
        }
        this.gp.put(this.donekey, Boolean.TRUE);
        return result;
    }

    public void inFormStart(String msg, String info, long size) {
        this.text_area.append(msg + "\n");
        this.text.add(msg);
    }

    public void inFormEnd(String msg, String info, long size) {
    }

    public void setResult(boolean result, String msg, Hashtable data) {
        this.insresult = result;
        this.errmsg = msg;
        this.navigation.fwd();
    }
}

