#!/usr/bin/perl

$dir=$ARGV[0];

sub usage {
die "required argument: directory

symlink-dupes descends into the given directory, scans each file and 
replaces it with a (sym)link to another file with the same content.
You should run the \"symlinks\" command afterwards, to make the symlinks
relative and as short as possible. I recommend the \"-c -s -r\" options and executing multiple times.
"; };

&usage if(!defined($dir));

system("rm -rf debian/tmp");

$PWD = `pwd`;
chop($PWD);
$PWD = $PWD."/";

if($dir =~ /^[^\/]/ ) { $dir=$PWD.$dir; }; # make absolute path

open(find,"find `THEME.list` | /usr/bin/file -f - |");

FILE: while(<find>) {
print ".";
   /^([^:]+): (.*)/;
   $thefile = $1;
   $typ = $2;
   if($typ =~ /(symbolic link)|(fifo)|(directory)/) {
      next FILE;
   }

   ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
   $atime,$mtime,$ctime,$blksize,$blocks)
   = stat($thefile);

   
   die "warning: extra large image file: $thefile. Please convert to .jpg by using:
   convert -quality 85 $thefile ".substr($thefile, 0, -3)."jpg
      and fix the theme file by running
   perl -pe \"s/".
   substr($thefile,rindex($thefile, "/")+1,length($thefile)).
   "/".
   substr($thefile,rindex($thefile, "/")+1,-3).
   "jpg/\" -i ".
   substr($thefile, 0, rindex($thefile, "/"))."/*.theme
   The quality value may vary between 80 and 90, depending on the image.
   " if($size >= 150000);

   
   open(sumfd,"/usr/bin/md5sum \"".$thefile."\" |");
    $sum = <sumfd>;
   close(sumfd);
   if($sum =~ /^(\w+)\W+/) {
      $sum = $1;
   } else {
      print STDERR "Error while trying to examine $thefile, skipping.\n";
      next FILE;
   }
   $probe=$hash{$sum};
   if(!defined($probe)) {
      $hash{$sum}=$thefile; # file is new, feeding database
#      print "NEU: Summe: $sum, Datei: $thefile\n";
   }
   else {
#      unlink("$thefile") || die "Some trouble on unlinking, permissions?" ;
#      #link($probe,$thefile) || die "Error creating hard links - dumb filesystem?" ;
#      symlink($probe,$thefile) || die "Error creating links - dumb filesystem?" ;
#      print "L";
      print "ALT: Summe: $sum, Datei: $thefile\n"; 
      print "linking real file ".$probe." to ".$thefile."\n";
      if(!rename($thefile, $thefile.".orig")) {
         print STDERR "Problems renaming $thefile to $thefile.orig, skipping\n";
         next FILE;
      }
     if(! symlink($probe, $thefile)) {
        print STDERR "Problems linking ".&$val($probe)." to $thefile, skipping\n";
         if(rename($thefile.".orig", $thefile)) {
            print STDERR "Moved $thefile.orig back to $thefile.\n";
         }
         next FILE;
      }
      unlink($thefile.".orig");
   }

}
