//go:build linux && cgo && !agent

// Code generated by generate-database from the incus project - DO NOT EDIT.

package cluster

import (
	"context"
	"database/sql"
	"errors"
	"fmt"
)

var nodeID = RegisterStmt(`
SELECT nodes.id FROM nodes
  WHERE nodes.name = ?
`)

// GetNodeID return the ID of the node with the given key.
// generator: node ID
func GetNodeID(ctx context.Context, db tx, name string) (_ int64, _err error) {
	defer func() {
		_err = mapErr(_err, "Node")
	}()

	stmt, err := Stmt(db, nodeID)
	if err != nil {
		return -1, fmt.Errorf("Failed to get \"nodeID\" prepared statement: %w", err)
	}

	row := stmt.QueryRowContext(ctx, name)
	var id int64
	err = row.Scan(&id)
	if errors.Is(err, sql.ErrNoRows) {
		return -1, ErrNotFound
	}

	if err != nil {
		return -1, fmt.Errorf("Failed to get \"nodes\" ID: %w", err)
	}

	return id, nil
}
