/*
 * InspIRCd -- Internet Relay Chat Daemon
 *
 *   Copyright (C) 2014 Attila Molnar <attilamolnar@hush.com>
 *
 * This file is part of InspIRCd.  InspIRCd is free software: you can
 * redistribute it and/or modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation, version 2.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#pragma once

namespace Translate
{
	/** Generate a list of mode parameters suitable for FMODE/MODE from a Modes::ChangeList::List
	 * @param modes List of mode changes
	 * @return List of mode parameters built from the input. Does not include the modes themselves,
	 * only the parameters.
	 */
	std::string ModeChangeListToParams(const Modes::ChangeList::List& modes);
}
