/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class OptionsFrame
extends Frame
implements WindowListener,
ActionListener,
ItemListener {
    static String[] names = new String[]{"Encoding", "Compression level", "JPEG image quality", "Cursor shape updates", "Use CopyRect", "Restricted colors", "Mouse buttons 2 and 3", "View only", "Share desktop"};
    static String[][] values = new String[][]{{"Raw", "RRE", "CoRRE", "Hextile", "Zlib", "Tight"}, {"Default", "1", "2", "3", "4", "5", "6", "7", "8", "9"}, {"JPEG off", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"}, {"Enable", "Ignore", "Disable"}, {"Yes", "No"}, {"Full", "256", "64", "8", "4 (Grey)", "2 (B&W)"}, {"Normal", "Reversed"}, {"Yes", "No"}, {"Yes", "No"}};
    final int encodingIndex = 0;
    final int compressLevelIndex = 1;
    final int jpegQualityIndex = 2;
    final int cursorUpdatesIndex = 3;
    final int useCopyRectIndex = 4;
    final int eightBitColorsIndex = 5;
    final int mouseButtonIndex = 6;
    final int viewOnlyIndex = 7;
    final int shareDesktopIndex = 8;
    Label[] labels = new Label[names.length];
    Choice[] choices = new Choice[names.length];
    Button closeButton;
    VncViewer viewer;
    int[] encodings = new int[20];
    int nEncodings;
    int compressLevel;
    int jpegQuality;
    int eightBitColors;
    int oldEightBitColors;
    boolean requestCursorUpdates;
    boolean ignoreCursorUpdates;
    boolean reverseMouseButtons2And3;
    boolean shareDesktop;
    boolean viewOnly;

    OptionsFrame(VncViewer vncViewer) {
        super("Ultr@VNC Options");
        int n;
        this.viewer = vncViewer;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        int n2 = 0;
        while (n2 < names.length) {
            this.labels[n2] = new Label(names[n2]);
            gridBagConstraints.gridwidth = 1;
            gridBagLayout.setConstraints(this.labels[n2], gridBagConstraints);
            this.add(this.labels[n2]);
            this.choices[n2] = new Choice();
            gridBagConstraints.gridwidth = 0;
            gridBagLayout.setConstraints(this.choices[n2], gridBagConstraints);
            this.add(this.choices[n2]);
            this.choices[n2].addItemListener(this);
            n = 0;
            while (n < values[n2].length) {
                this.choices[n2].addItem(values[n2][n]);
                ++n;
            }
            ++n2;
        }
        this.closeButton = new Button("Close");
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.closeButton, gridBagConstraints);
        this.add(this.closeButton);
        this.closeButton.addActionListener(this);
        this.pack();
        this.addWindowListener(this);
        this.choices[0].select("Tight");
        this.choices[1].select("Default");
        this.choices[2].select("6");
        this.choices[3].select("Enable");
        this.choices[4].select("Yes");
        this.choices[5].select("64");
        this.choices[6].select("Normal");
        this.choices[7].select("No");
        this.choices[8].select("Yes");
        n = 0;
        while (n < names.length) {
            String string = this.viewer.readParameter(names[n], false);
            if (string != null) {
                int n3 = 0;
                while (n3 < values[n].length) {
                    if (string.equalsIgnoreCase(values[n][n3])) {
                        this.choices[n].select(n3);
                    }
                    ++n3;
                }
            }
            ++n;
        }
        this.setEncodings();
        this.setColorFormat();
        this.setOtherOptions();
    }

    void disableShareDesktop() {
        this.labels[8].setEnabled(false);
        this.choices[8].setEnabled(false);
    }

    void setEncodings() {
        this.nEncodings = 0;
        if (this.choices[4].getSelectedItem().equals("Yes")) {
            this.encodings[this.nEncodings++] = 1;
        }
        int n = 0;
        boolean bl = false;
        if (this.choices[0].getSelectedItem().equals("RRE")) {
            n = 2;
        } else if (this.choices[0].getSelectedItem().equals("CoRRE")) {
            n = 4;
        } else if (this.choices[0].getSelectedItem().equals("Hextile")) {
            n = 5;
        } else if (this.choices[0].getSelectedItem().equals("Zlib")) {
            n = 6;
            bl = true;
        } else if (this.choices[0].getSelectedItem().equals("Tight")) {
            n = 7;
            bl = true;
        }
        this.encodings[this.nEncodings++] = n;
        if (n != 5) {
            this.encodings[this.nEncodings++] = 5;
        }
        if (n != 7) {
            this.encodings[this.nEncodings++] = 7;
        }
        if (n != 6) {
            this.encodings[this.nEncodings++] = 6;
        }
        if (n != 4) {
            this.encodings[this.nEncodings++] = 4;
        }
        if (n != 2) {
            this.encodings[this.nEncodings++] = 2;
        }
        if (bl) {
            this.labels[1].setEnabled(true);
            this.choices[1].setEnabled(true);
            try {
                this.compressLevel = Integer.parseInt(this.choices[1].getSelectedItem());
            }
            catch (NumberFormatException numberFormatException) {
                this.compressLevel = -1;
            }
            if (this.compressLevel >= 1 && this.compressLevel <= 9) {
                this.encodings[this.nEncodings++] = -256 + this.compressLevel;
            } else {
                this.compressLevel = -1;
            }
        } else {
            this.labels[1].setEnabled(false);
            this.choices[1].setEnabled(false);
        }
        if (n == 7 && this.eightBitColors == 0) {
            this.labels[2].setEnabled(true);
            this.choices[2].setEnabled(true);
            try {
                this.jpegQuality = Integer.parseInt(this.choices[2].getSelectedItem());
            }
            catch (NumberFormatException numberFormatException) {
                this.jpegQuality = -1;
            }
            if (this.jpegQuality >= 0 && this.jpegQuality <= 9) {
                this.encodings[this.nEncodings++] = -32 + this.jpegQuality;
            } else {
                this.jpegQuality = -1;
            }
        } else {
            this.labels[2].setEnabled(false);
            this.choices[2].setEnabled(false);
        }
        boolean bl2 = this.requestCursorUpdates = !this.choices[3].getSelectedItem().equals("Disable");
        if (this.requestCursorUpdates) {
            this.encodings[this.nEncodings++] = -240;
            this.encodings[this.nEncodings++] = -239;
            this.ignoreCursorUpdates = this.choices[3].getSelectedItem().equals("Ignore");
            if (!this.ignoreCursorUpdates) {
                this.encodings[this.nEncodings++] = -232;
            }
        }
        this.encodings[this.nEncodings++] = -224;
        this.encodings[this.nEncodings++] = -223;
        this.viewer.setEncodings();
    }

    void setColorFormat() {
        if (this.choices[5].getSelectedItem().equals("Full")) {
            this.eightBitColors = 0;
        } else if (this.choices[5].getSelectedItem().equals("256")) {
            this.eightBitColors = 1;
        } else if (this.choices[5].getSelectedItem().equals("64")) {
            this.eightBitColors = 2;
        } else if (this.choices[5].getSelectedItem().equals("8")) {
            this.eightBitColors = 3;
        } else if (this.choices[5].getSelectedItem().equals("4 (Grey)")) {
            this.eightBitColors = 4;
        } else if (this.choices[5].getSelectedItem().equals("2 (B&W)")) {
            this.eightBitColors = 5;
        }
        boolean bl = this.eightBitColors == 0 && this.choices[0].getSelectedItem().equals("Tight");
        this.labels[2].setEnabled(bl);
        this.choices[2].setEnabled(bl);
    }

    void setOtherOptions() {
        this.reverseMouseButtons2And3 = this.choices[6].getSelectedItem().equals("Reversed");
        this.viewOnly = this.choices[7].getSelectedItem().equals("Yes");
        if (this.viewer.vc != null) {
            this.viewer.vc.enableInput(!this.viewOnly);
        }
        this.shareDesktop = this.choices[8].getSelectedItem().equals("Yes");
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.choices[0] || object == this.choices[1] || object == this.choices[2] || object == this.choices[3] || object == this.choices[4]) {
            this.setEncodings();
        } else if (object == this.choices[5]) {
            this.setColorFormat();
        } else if (object == this.choices[6] || object == this.choices[8] || object == this.choices[7]) {
            this.setOtherOptions();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.closeButton) {
            ((Component)this).setVisible(false);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }
}

