/*
 * jaZip for Linux (c) 1996  Jarrod A. Smith
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation.  No representations are made about the suitability of this
 * software for any purpose.  It is provided "as is" without express or 
 * implied warranty.
 */

#include <forms.h>
#include <mntent.h>
#include "jazip.h"

void file(FL_OBJECT *ob, long data)
{
	int	item;

	switch (item = fl_get_menu (ob)) {
		case FILE_EXIT:
			quit_it (ob, 1);
			break;
	}
	return;
}

void tools(FL_OBJECT *ob, long data)
{
	int	tool;

	switch (tool = fl_get_menu (ob)) {
		case TOOLS_INFO:
			iomega_info (ob, 1);
			break;
		case TOOLS_MOUNT:
			mount_it (ob, 1);
			break;
		case TOOLS_UMOUNT:
			umount_it (ob, 1);
			break;
		case TOOLS_EJECT:
			eject_it (ob, 1);
			break;
		case TOOLS_RO:
			ro_it (ob, 1);
			break;
		case TOOLS_RW:
			rw_it (ob, 1);
			break;
	}
	return;
}

void iomega_info(FL_OBJECT *ob, long data)
{
	int	rs;

	rs = is_mounted (dev);
	if (rs == 1) {
		sprintf (mesg, "Partition %s is mounted on %s as type %s",
		mnt_fsname, mnt_dir, mnt_type);
	} else if (rs == 0) {
		dostatus (dev);
	} else {
		sprintf (mesg, "unable to access %s", MOUNTED);
		show_mesg (ob, mesg);
		return;
	}
	show_mesg (ob, mesg);
}

void mount_it(FL_OBJECT *ob, long data)
{
	if ((is_mounted (dev)) != 0) {
		show_mesg (ob, mesg); 
		return;
	}
	z_mount (dev);
	show_mesg (ob, mesg);
	return;
}

void umount_it(FL_OBJECT *ob, long data)
{
	z_umount (dev);
	show_mesg( ob, mesg );
	return;
}

void eject_it(FL_OBJECT *ob, long data)
{
	if ((is_mounted (dev)) != 0) {
		umount_it(ob, 1);
		if ((is_mounted (dev)) != 0) return;
	}
	if (!z_eject (dev)) {
		show_mesg (ob, mesg);
		return;
	}
}

void ro_it(FL_OBJECT *ob, long data)
{
	if ((is_mounted (dev)) != 0) {
		show_mesg (ob, mesg); 
		return;
	}
	pmode (dev,2);
	show_mesg( ob, mesg );
	return;
}

void rw_it(FL_OBJECT *ob, long data)
{
	if ((is_mounted (dev)) != 0) {
		show_mesg (ob, mesg); 
		return;
	}
	pmode (dev,0);
	show_mesg( ob, mesg );
	return;
}

void quit_it(FL_OBJECT *ob, long data)
{
	exit(0);
}
