// ----------------------------------------------------------------------------
//
//  Copyright (C) 2010-2023 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __MAINWIN_H
#define	__MAINWIN_H


#include <clxclient.h>
#include "jclient.h"
#include "global.h"


class Mainwin : public A_thread, public X_window, public X_callback
{
public:

    Mainwin (X_rootwin *parent, X_resman *xres, int xp, int yp, Jclient *jclient);
    ~Mainwin (void);
    Mainwin (const Mainwin&);
    Mainwin& operator=(const Mainwin&);

    void stop (void) { _stop = true; }
    int process (void); 

private:

    enum { XSIZE = 400, YSIZE = 140 };
    enum { B_INP = 0, B_FIL = 8, B_DET = 24, B_DCF = 27, B_SLO = 28 };

    virtual void thr_main (void) {}

    void handle_time (void);
    void handle_stop (void);
    void handle_event (XEvent *);
    void handle_callb (int type, X_window *W, XEvent *E);
    void expose (XExposeEvent *E);
    void clmesg (XClientMessageEvent *E);
    void redraw (void);
    void set_input (int k);
    void set_filter (int k);
    void set_detect (int k);

    Atom            _atom;
    bool            _stop;
    X_resman       *_xres;
    Jclient        *_jclient;
    X_button       *_b_input [8];
    X_button       *_b_filter [16];
    X_button       *_b_detect [3];
    X_button       *_b_dcfilt;
    X_button       *_b_slower;
    X_textip       *_t_disp;
    int             _input;
    int             _filter;
    int             _detect;
};


#endif
