/*
 * Copyright (c) 2016 Vivid Solutions.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * and Eclipse Distribution License v. 1.0 which accompanies this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v20.html
 * and the Eclipse Distribution License is available at
 *
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */
package org.locationtech.jts.index.quadtree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.locationtech.jts.geom.Envelope;



/**
 * @version 1.7
 */
public class EnvelopeList
{
  List<Envelope> envList = new ArrayList<>();

  public EnvelopeList() {
  }

  public void add(Envelope env)
  {
    envList.add(env);
  }

  public List<Envelope> query(Envelope searchEnv)
  {
    List<Envelope> result = new ArrayList<>();
    for (Iterator i = envList.iterator(); i.hasNext(); ) {
      Envelope env = (Envelope) i.next();
      if (env.intersects(searchEnv))
        result.add(env);
    }
    return result;
  }


}
